/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util.tx;

import com.wm.data.IData;
import com.wm.util.JournalLogger;
import com.wm.util.coder.Codable;
import com.wm.util.tx.TXJob;

public class TXRmtJob
extends TXJob {
    public static final int TRXJOB0033 = 33;
    public static final int TRXJOB0034 = 34;
    public static final int TRXJOB0035 = 35;
    public static final int TRXJOB0036 = 36;
    public static final int TRXJOB0037 = 37;
    public static final int TRXJOB0038 = 38;
    private static String self = "TXRmtJob";
    private String rmtTid;
    private String followTid;
    private int retryLimit;
    private int retries;
    private String ifc;
    private String svc;
    private boolean oneWay;
    private Codable context;
    private transient boolean active;
    private boolean invoked = false;
    private Object syncObject = new Object();

    public TXRmtJob() {
    }

    public TXRmtJob(String tid, Codable context, long ttl) {
        super(tid, ttl);
        this.context = context;
        JournalLogger.logDebugPlus(3, 33, 63, this.getStatusMsg());
    }

    public Object getObjectToSync() {
        return this.syncObject;
    }

    public void setObjectToSync(Object o) {
        this.syncObject = o;
    }

    public boolean isInvoked() {
        return this.invoked;
    }

    public void setInvoked(boolean flag) {
        this.invoked = flag;
    }

    public void setRetryLimit(int limit) {
        this.retryLimit = limit;
        JournalLogger.logInfo(34, 63, self + " " + this.getStatusMsg());
    }

    public void setRmtTid(String tid) {
        this.rmtTid = tid;
    }

    public String getRmtTid() {
        return this.rmtTid;
    }

    public boolean needsRmtTid() {
        return this.rmtTid == null || this.rmtTid.length() == 0;
    }

    public void setFollowTid(String tid) {
        this.followTid = tid;
    }

    public String getFollowTid() {
        return this.followTid;
    }

    public String getIfc() {
        return this.ifc;
    }

    public String getSvc() {
        return this.svc;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    public Codable getContext() {
        return this.context;
    }

    public boolean isRetry() {
        return this.retries > 0;
    }

    public boolean exceedsRetries() {
        if (this.retryLimit > 0 && this.retries > this.retryLimit) {
            JournalLogger.logDebugPlus(3, 35, 63, this.getStatusMsg());
            return true;
        }
        return false;
    }

    public boolean isHeuristicFailure() {
        if (!this.isFailed()) {
            return false;
        }
        return !this.exceedsRetries() && this.timeUpdated - this.timeCreated <= this.ttl;
    }

    public void start(String ifc, String svc, IData data) {
        this.ifc = ifc;
        this.svc = svc;
        this.data = data;
        this.start();
    }

    public void restart() {
        this.status = 1;
        this.rmtTid = null;
        this.retries = 0;
        this.timeUpdated = this.timeCreated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 37, 63, this.getStatusMsg());
    }

    public void retryFailed() {
        ++this.retries;
        this.timeUpdated = System.currentTimeMillis();
        JournalLogger.logDebugPlus(3, 38, 63, this.getStatusMsg());
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{ TXRmtJob ").append(this.getStatusMsg());
        s.append(" rmtTid=").append(this.rmtTid);
        s.append(" followTid=").append(this.followTid);
        if (this.retryLimit > 0) {
            s.append(" retryLimit=").append(this.retryLimit);
        }
        s.append(" ").append(this.ifc).append("/").append(this.svc).append(" }");
        return s.toString();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String[] getValueKeys() {
        String[] s1 = super.getValueKeys();
        String[] s2 = new String[]{"retryLimit", "retries", "ifc", "svc", "context", "rmtTid", "followTid", "oneWay"};
        String[] s = new String[s1.length + s2.length];
        System.arraycopy(s1, 0, s, 0, s1.length);
        System.arraycopy(s2, 0, s, s1.length, s2.length);
        return s;
    }

    public Object getValue(String key) {
        if (key.equals("retryLimit")) {
            return new Integer(this.retryLimit);
        }
        if (key.equals("retries")) {
            return new Integer(this.retries);
        }
        if (key.equals("ifc")) {
            return this.ifc;
        }
        if (key.equals("svc")) {
            return this.svc;
        }
        if (key.equals("context")) {
            return this.context;
        }
        if (key.equals("rmtTid")) {
            return this.rmtTid;
        }
        if (key.equals("followTid")) {
            return this.followTid;
        }
        if (key.equals("oneWay")) {
            return this.oneWay ? "true" : "false";
        }
        if (key.equals("active")) {
            return this.active ? "true" : "false";
        }
        if (key.equals("invoked")) {
            return this.invoked ? "true" : "false";
        }
        return super.getValue(key);
    }

    public void setValue(String key, Object value) {
        if (key.equals("retryLimit")) {
            this.retryLimit = (Integer)value;
        } else if (key.equals("retries")) {
            this.retries = (Integer)value;
        } else if (key.equals("ifc")) {
            this.ifc = (String)value;
        } else if (key.equals("svc")) {
            this.svc = (String)value;
        } else if (key.equals("context")) {
            this.context = (Codable)value;
        } else if (key.equals("rmtTid")) {
            this.rmtTid = (String)value;
        } else if (key.equals("followTid")) {
            this.followTid = (String)value;
        } else if (key.equals("oneWay")) {
            String tmp = (String)value;
            this.oneWay = tmp != null && tmp.equalsIgnoreCase("true");
        } else if (key.equals("active")) {
            String tmp = (String)value;
            this.active = tmp != null && tmp.equalsIgnoreCase("true");
        } else if (key.equals("invoked")) {
            String tmp = (String)value;
            this.invoked = tmp != null && tmp.equalsIgnoreCase("true");
        } else {
            super.setValue(key, value);
        }
    }
}

