/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util.tx;

import com.wm.app.b2b.util.RepositoryManagerClientImpl;
import com.wm.app.b2b.util.tx.TXRmtJobMgr;
import com.wm.app.repov4.IRepoDirectory;
import com.wm.app.repov4.IRepository;
import com.wm.app.repov4.RepositoryConnFailedException;
import com.wm.app.repov4.RepositoryException;
import com.wm.app.repov4.RepositoryNoEntryException;
import com.wm.data.IData;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.RepositoryManager;
import com.wm.util.Values;
import com.wm.util.coder.XMLCoder;
import com.wm.util.resources.TXJobExceptionBundle;
import com.wm.util.tx.TXJob;
import com.wm.util.tx.TXJobException;
import com.wm.util.tx.TXJobStore;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TXRepoJobStore
extends TXJobStore {
    public static final int TRXJOB0027 = 27;
    public static final int TRXJOB0028 = 28;
    public static final int TRXJOB0029 = 29;
    public static final int TRXJOB0030 = 30;
    public static final int TRXJOB0031 = 31;
    public static final int TRXJOB0032 = 32;
    public static final int TRXJOB0033 = 33;
    private static final String GD_REPO_PREFIX = "WMGD";
    private static final String GDCTX = "B2BGD";
    private static final String self = "TXJobStore";
    private static final String storeName = "jobstore";
    private static final String KEY = "K";
    private static final String DATA = "D";
    private static final String LOCK = "L";
    Hashtable<String, Object> jobs;
    Vector<TXJob> waitList;
    private static final String FILE_EXTENSION = ".xtn";
    private static final String TMP_EXTENSION = ".xtt";
    private static final String BAK_EXTENSION = ".bak";
    private FilenameFilter ff = new JobFileFilter(".xtn");
    private String storePath;
    private boolean inCluster;
    private boolean syncWrites;
    private long lockTimeout;
    private long lockBreakTime;
    private long jobPendingWait;
    private String storeDir;

    public TXRepoJobStore() {
        String tmp = Config.getProperty("watt.tx.syncWrites");
        if (tmp != null && tmp.length() != 0) {
            this.syncWrites = new Boolean(tmp);
        }
        this.storeDir = Config.getProperty("jobs", "watt.tx.jobdir");
        this.inCluster = this.isConfigForCluster();
        if (this.inCluster) {
            tmp = Config.getProperty("100", "watt.server.tx.cluster.lockTimeoutMillis");
            try {
                this.lockTimeout = Long.parseLong(tmp);
            }
            catch (Exception e) {
                // empty catch block
            }
            tmp = Config.getProperty("120", "watt.server.tx.cluster.lockBreakSecs");
            try {
                this.lockBreakTime = Long.parseLong(tmp) * 1000L;
            }
            catch (Exception e) {
                // empty catch block
            }
            tmp = Config.getProperty("60", "watt.server.tx.cluster.jobPendingWait");
            try {
                this.jobPendingWait = Long.parseLong(tmp) * 1000L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init(String path) {
        this.storePath = path == null ? "jobs" : path;
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash >= 0) {
            this.storePath = this.storePath.substring(lastSlash + 1);
        }
    }

    private IRepository getRepoSession() throws RepositoryException {
        if (RepositoryManager.getCurrent() == null) {
            try {
                RepositoryManagerClientImpl mgr = new RepositoryManagerClientImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return RepositoryManager.getCurrent().getDefaultRepoLogon();
    }

    private IRepoDirectory getStoreDirectory(IRepository session) throws RepositoryException {
        IRepoDirectory store = null;
        IRepoDirectory root = session.getRootDirectory();
        store = !root.containsKey("SYSTEM/SERVER/WMGD" + this.storePath) ? root.createDirectories("SYSTEM/SERVER/WMGD" + this.storePath) : root.getDirectory("SYSTEM/SERVER/WMGD" + this.storePath);
        root.destroy();
        return store;
    }

    public Hashtable loadJobs() throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        try {
            String tid;
            this.jobs = new Hashtable();
            this.waitList = new Vector();
            if (!this.inCluster) {
                return this.jobs;
            }
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            Vector<String> dataKeys = new Vector<String>();
            String[] keys = store.getAllEntryKeys();
            for (int i = 0; i < keys.length; ++i) {
                tid = keys[i].substring(1);
                if (keys[i].startsWith(DATA)) {
                    if (this.jobs.containsKey(tid)) continue;
                    dataKeys.addElement(tid);
                    continue;
                }
                Values tmp = (Values)store.get(KEY + tid);
                if (tmp == null) continue;
                this.jobs.put(tid, tmp.get("TXJob"));
            }
            repoSession.commit();
            Enumeration tids = dataKeys.elements();
            while (tids.hasMoreElements()) {
                tid = (String)tids.nextElement();
                if (this.jobs.containsKey(tid)) continue;
                try {
                    store.delete(DATA + tid);
                    JournalLogger.logDebugPlus(3, 73, 63, tid);
                }
                catch (RepositoryException e) {
                    JournalLogger.log(9998, 63, (Object)e);
                }
            }
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (repoSession != null) {
                    repoSession.logoff();
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_OPEN_JOBSTORE, "", e);
        }
        return this.jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.inCluster) {
            this.jobs = null;
            Vector<TXJob> vector = this.waitList;
            synchronized (vector) {
                int size = this.waitList.size();
                for (int i = 0; i < size; ++i) {
                    TXJob job = this.waitList.elementAt(i);
                    if (job == null) continue;
                    TXJob tXJob = job;
                    synchronized (tXJob) {
                        job.notify();
                        continue;
                    }
                }
                return;
            }
        }
        Hashtable<String, Object> hashtable = this.jobs;
        synchronized (hashtable) {
            this.jobs.notifyAll();
        }
    }

    public boolean jobExists(String tid) throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return this.jobs.containsKey(tid);
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            boolean rc = store.containsKey(KEY + tid);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            return rc;
        }
        catch (RepositoryException e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(e);
        }
    }

    public boolean jobGone(String tid) {
        if (this.inCluster) {
            return false;
        }
        return !this.jobs.containsKey(tid);
    }

    public Object viewJob(String tid) {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return this.jobs.get(tid);
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            Values tmp = (Values)store.get(KEY + tid);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            if (tmp == null) {
                return null;
            }
            return tmp.get("TXJob");
        }
        catch (RepositoryException e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            return null;
        }
    }

    public Object getJobNoWait(String tid) throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return this.jobs.get(tid);
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            if (!store.containsKey(LOCK + tid)) {
                store.insert(LOCK + tid, (Object)this.ownerId);
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
                return null;
            }
            if (!store.containsKey(KEY + tid)) {
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
                return null;
            }
            Values tmp = (Values)store.get(KEY + tid);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            return tmp.get("TXJob");
        }
        catch (RepositoryException e) {
            try {
                repoSession.commit();
                store.destroy();
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(e);
        }
    }

    public void purgeStaleLocks(Values clusterHosts) {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (this.inCluster) {
            try {
                Enumeration en = this.jobKeys();
                repoSession = this.getRepoSession();
                store = this.getStoreDirectory(repoSession);
                while (en.hasMoreElements()) {
                    String tid = (String)en.nextElement();
                    Values v = null;
                    try {
                        v = (Values)store.get(LOCK + tid);
                    }
                    catch (RepositoryNoEntryException e) {
                        v = new Values();
                    }
                    String serverport = v.getString("ownerId");
                    String instance = v.getString("ownerInstance");
                    if (serverport != null) {
                        int index = serverport.indexOf(":");
                        String server = serverport.substring(0, index);
                        String port = serverport.substring(index + 1);
                        if (server == null || port == null) continue;
                        if (this.getOwner().equalsIgnoreCase(serverport)) {
                            if (this.ownerInstance.equalsIgnoreCase(instance)) continue;
                            store.delete(LOCK + tid);
                            continue;
                        }
                        if (clusterHosts.get(server) == null) {
                            store.delete(LOCK + tid);
                        }
                    }
                    repoSession.commit();
                }
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
            }
            catch (Exception e) {
                try {
                    store.destroy();
                    repoSession.logoff();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                e.printStackTrace();
                JournalLogger.logError(9998, 63, e);
            }
        }
    }

    public Object getJob(String tid) throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return this.jobs.get(tid);
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            if (!store.containsKey(KEY + tid)) {
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
                return null;
            }
            Values tmp = (Values)store.get(KEY + tid);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            return tmp.get("TXJob");
        }
        catch (RepositoryException e) {
            try {
                repoSession.commit();
                store.destroy();
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(e);
        }
    }

    public Object getJobIfMine(String tid) throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return this.jobs.get(tid);
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            String curOwner = this.jobOwner(repoSession, store, tid);
            if (curOwner == null) {
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
                return this.getJob(tid);
            }
            if (!curOwner.equals(this.getOwner())) {
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
                return null;
            }
            Values tmp = (Values)store.get(KEY + tid);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            return tmp.get("TXJob");
        }
        catch (RepositoryException e) {
            try {
                repoSession.commit();
                store.destroy();
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(e);
        }
    }

    public void releaseJob(String tid) throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return;
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
        }
        catch (Exception e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(TXJob job) throws TXJobException {
        block9: {
            try {
                if (!this.inCluster) {
                    Vector<TXJob> vector = this.waitList;
                    synchronized (vector) {
                        this.waitList.addElement(job);
                    }
                    job.wait();
                    break block9;
                }
                Hashtable<String, Object> hashtable = this.jobs;
                synchronized (hashtable) {
                    this.releaseJob(job.getTid());
                    this.jobs.wait(this.jobPendingWait);
                }
                job.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotify(TXJob job) throws TXJobException {
        job.notify();
        if (!this.inCluster) {
            Vector<TXJob> vector = this.waitList;
            synchronized (vector) {
                this.waitList.removeElement(job);
            }
            return;
        }
        Hashtable<String, Object> hashtable = this.jobs;
        synchronized (hashtable) {
            this.jobs.notifyAll();
            this.releaseJob(job.getTid());
        }
    }

    public boolean addJob(String tid, TXJob job) throws TXJobException {
        if (!this.inCluster) {
            if (this.jobs.containsKey(tid)) {
                return false;
            }
            this.jobs.put(tid, job);
        }
        this.updateJob(job);
        return true;
    }

    public IData getJobData(TXJob job) throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        IData data = job.getData();
        if (data != null) {
            return data;
        }
        Values v = null;
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            try {
                v = (Values)store.get(DATA + job.getTid());
            }
            catch (RepositoryNoEntryException e) {
                try {
                    repoSession.rollback();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_LOAD_NULL_DATA, "", e);
            }
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            data = v.getIData();
        }
        catch (RepositoryException e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_LOAD_DATA, "", e);
        }
        return data;
    }

    public boolean jobHasData(TXJob job) throws TXJobException {
        return this.getJobData(job) != null;
    }

    public void updateJob(TXJob job) throws TXJobException {
        this.updateJob(job, false);
    }

    public void updateJob(TXJob job, boolean retainLock) throws TXJobException {
        block24: {
            IRepository repoSession = null;
            IRepoDirectory store = null;
            String tid = job.getTid();
            try {
                Object[][] o = new Object[][]{{"TXJob", job}};
                Values hdr = new Values(o);
                repoSession = this.getRepoSession();
                store = this.getStoreDirectory(repoSession);
                while (true) {
                    try {
                        store.put(KEY + tid, (Object)hdr);
                        repoSession.commit();
                    }
                    catch (RepositoryConnFailedException rcfe) {
                        continue;
                    }
                    catch (RepositoryException re) {
                        try {
                            repoSession.rollback();
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        throw re;
                    }
                    break;
                }
                IData data = job.getData();
                if (data == null) break block24;
                while (true) {
                    try {
                        store.put(DATA + tid, (Object)Values.use(data));
                        repoSession.commit();
                    }
                    catch (RepositoryConnFailedException rcfe) {
                        continue;
                    }
                    catch (RepositoryException re) {
                        try {
                            repoSession.rollback();
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        throw re;
                    }
                    break;
                }
                job.resetData();
            }
            catch (RepositoryException e) {
                try {
                    repoSession.rollback();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_UPDATE, "", e);
            }
            finally {
                TXRmtJobMgr.debugLog("updateJob " + job.getStatus(), tid, 7);
                if (!this.inCluster || !retainLock) {
                    // empty if block
                }
                try {
                    repoSession.commit();
                    store.destroy();
                    repoSession.logoff();
                }
                catch (Exception ee) {}
            }
        }
    }

    public void removeJob(String tid) throws TXJobException {
        TXJob job;
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster && (job = (TXJob)this.jobs.remove(tid)) == null) {
            return;
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            if (store.containsKey(KEY + tid)) {
                store.delete(KEY + tid);
            }
            if (store.containsKey(DATA + tid)) {
                store.delete(DATA + tid);
            }
            if (this.inCluster && store.containsKey(LOCK + tid)) {
                store.delete(LOCK + tid);
            }
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
        }
        catch (RepositoryException e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_REMOVE_JOB, "", e);
        }
    }

    public Enumeration jobKeys() {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return this.jobs.keys();
        }
        String[] en = null;
        Vector<String> KeysOfJobs = new Vector<String>();
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            en = store.getAllEntryKeys();
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            for (int i = 0; i < en.length; ++i) {
                KeysOfJobs.addElement(en[i]);
            }
        }
        catch (RepositoryException re) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        return new JobKeys(KeysOfJobs.elements());
    }

    public boolean startSweep() throws TXJobException {
        boolean rc = false;
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return true;
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            store.put("Sweeper", (Object)this.ownerId);
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
            return true;
        }
        catch (RepositoryException e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(e);
        }
    }

    public void endSweep() throws TXJobException {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        if (!this.inCluster) {
            return;
        }
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            if (!this.haveSweepLock(repoSession, store)) {
                repoSession.commit();
                store.destroy();
                repoSession.logoff();
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_JOB_NOT_LOCKED, "");
            }
            try {
                store.delete("Sweeper");
                store.destroy();
                repoSession.commit();
                repoSession.logoff();
            }
            catch (RepositoryException e) {
                try {
                    repoSession.logoff();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_UNABLE_REMOVE_LOCK, "", e);
            }
        }
        catch (RepositoryException e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
            JournalLogger.logError(9998, 63, (Object)e);
            throw new TXJobException(e);
        }
    }

    private String jobOwner(IRepository repoSession, IRepoDirectory store, String tid) throws RepositoryException {
        Values tmp = null;
        try {
            tmp = (Values)store.get(LOCK + tid);
            repoSession.commit();
        }
        catch (RepositoryNoEntryException e) {
            // empty catch block
        }
        return tmp == null ? null : tmp.getString("ownerId");
    }

    private boolean haveSweepLock(IRepository repoSession, IRepoDirectory store) throws RepositoryException {
        Values tmp = (Values)store.get("Sweeper");
        if (tmp == null) {
            return false;
        }
        String jobOwner = tmp.getString("ownerId");
        return jobOwner != null && jobOwner.equals(this.getOwner());
    }

    private void dumpStore(IRepository repoSession, IRepoDirectory store, String msg) {
        System.out.println("DUMPING STORE (" + msg + ") =====>");
        try {
            String[] keys = store.getAllEntryKeys();
            repoSession.commit();
            for (int i = 0; i < keys.length; ++i) {
                System.out.println("*********Key=" + keys[i]);
            }
        }
        catch (RepositoryException re) {
            try {
                repoSession.rollback();
            }
            catch (Exception ee) {
                // empty catch block
            }
            System.out.println("DUMPING STORE failed =====>");
        }
    }

    private Hashtable loadFiles(File f, Hashtable jobs) throws Exception {
        XMLCoder coder = new XMLCoder(true);
        String[] list = f.list(this.ff);
        int extLen = FILE_EXTENSION.length();
        for (int i = 0; i < list.length; ++i) {
            String file = list[i];
            String tid = file.substring(0, file.length() - extLen);
            try {
                Values tmp = coder.readFromFile(this.jobFile(tid));
                jobs.put(tid, tmp.get("TXJob"));
            }
            catch (Throwable e) {
                JournalLogger.logError(27, 63, e);
                continue;
            }
            JournalLogger.logDebugPlus(3, 28, 63, tid);
        }
        return jobs;
    }

    private void updateJobFile(TXJob job) throws TXJobException {
        XMLCoder coder = new XMLCoder(true);
        Object[][] o = new Object[][]{{"TXJob", job}};
        Values data = new Values(o);
        String tid = job.getTid();
        File oldFile = this.jobFile(tid);
        File newFile = this.tmpJobFile(tid);
        File backupFile = this.backupJobFile(tid);
        boolean done = false;
        int tries = 0;
        while (!done) {
            try {
                if (newFile.exists()) {
                    newFile.delete();
                }
                coder.writeToFile(newFile, data);
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                boolean cleanBackup = false;
                if (oldFile.exists()) {
                    oldFile.renameTo(backupFile);
                    cleanBackup = true;
                }
                newFile.renameTo(oldFile);
                if (cleanBackup) {
                    backupFile.delete();
                }
                done = true;
                JournalLogger.logDebugPlus(3, 29, 63, job.getStatusMsg());
            }
            catch (OutOfMemoryError e) {
                if (tries > 30) {
                    throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_UPDATE, "", e);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException i) {
                    tries = 100;
                }
                ++tries;
            }
            catch (Throwable e) {
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_UPDATE, "", e);
            }
        }
    }

    private void removeJobFile(String tid) {
        try {
            File f = this.jobFile(tid);
            if (f.exists()) {
                f.delete();
                JournalLogger.logDebugPlus(3, 30, 63, tid);
            } else {
                JournalLogger.logDebugPlus(3, 31, 63, tid);
            }
        }
        catch (Throwable e) {
            JournalLogger.logDebugPlus(3, 32, 63, e);
            return;
        }
    }

    private File jobFile(String tid) {
        return new File(this.storePath + File.separator + tid + FILE_EXTENSION);
    }

    private File tmpJobFile(String tid) {
        return new File(this.storePath + File.separator + tid + TMP_EXTENSION);
    }

    private File backupJobFile(String tid) {
        return new File(this.storePath + File.separator + tid + BAK_EXTENSION);
    }

    public void updateJobForClean(TXJob job, boolean retainLock) throws TXJobException {
        this.updateJob(job, retainLock);
    }

    public void cleanup() {
        IRepository repoSession = null;
        IRepoDirectory store = null;
        Enumeration enumvar = this.jobKeys();
        try {
            repoSession = this.getRepoSession();
            store = this.getStoreDirectory(repoSession);
            while (enumvar.hasMoreElements()) {
                String key = (String)enumvar.nextElement();
                String tid = key.substring(1);
                if (!key.startsWith(DATA) || store.containsKey(KEY + tid)) continue;
                store.delete(key);
                JournalLogger.logDebugPlus(3, 73, 63, tid);
            }
            store.destroy();
            repoSession.commit();
            repoSession.logoff();
        }
        catch (Exception e) {
            try {
                repoSession.logoff();
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
    }

    private boolean isConfigForCluster() {
        Boolean bool = new Boolean(Config.getProperty("false", "watt.server.cluster.aware"));
        return bool;
    }

    public class JobKeys
    implements Enumeration {
        Enumeration keys;
        String next;

        public JobKeys(Enumeration keys) {
            this.keys = keys;
        }

        public boolean hasMoreElements() {
            if (this.next != null) {
                return true;
            }
            while (this.keys.hasMoreElements()) {
                String key = (String)this.keys.nextElement();
                String tid = key.substring(1);
                if (!key.startsWith(TXRepoJobStore.KEY)) continue;
                this.next = tid;
                break;
            }
            return this.next != null;
        }

        public Object nextElement() {
            String tmp = this.next;
            this.next = null;
            return tmp;
        }
    }

    class JobFileFilter
    implements FilenameFilter {
        String ext;

        JobFileFilter(String ext) {
            this.ext = ext;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }
}

