/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util.tx;

import com.wm.app.b2b.util.tx.TXJobIllegalArgumentException;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Trace;
import com.wm.util.resources.TXJobExceptionBundle;
import com.wm.util.tx.TXJobException;
import com.wm.util.xform.DateTimeDT;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class TXJobLog {
    public static final int TRXJOB0007 = 7;
    public static final int TRXJOB0008 = 8;
    public static final int TRXJOB0009 = 9;
    public static final int TRXJOB0089 = 89;
    public static final int TRXJOB0090 = 90;
    public static final int TRXJOB0091 = 91;
    public static final int TRXJOB0092 = 92;
    public static final int TRXJOB0093 = 93;
    public static final int TRXJOB0094 = 94;
    public static final int TRXJOB0095 = 95;
    public static final int TRXJOB0096 = 96;
    public static final int TRXJOB0097 = 97;
    public static final int TRXJOB0098 = 98;
    public static final int TRXJOB0099 = 99;
    public static final int TRXJOB0100 = 100;
    public static final int TRXJOB0101 = 101;
    public static final int TRXJOB0102 = 102;
    private static final String self = "TXJobLog";
    private String logPath;
    private TXLogType logType;
    private boolean userStream;
    private boolean userWriter;
    private boolean customStream;
    private String gDateFormat;
    private static final String nl = System.getProperty("line.separator");

    public TXJobLog(String logPath) throws TXJobException {
        this.gDateFormat = Config.getProperty(Trace.DEFAULT_DATE_FORMAT, "watt.server.dateStampFmt");
        this.logPath = logPath;
        if (logPath == null) {
            this.logPath = this.getClass().getName() + ".log";
        }
        try {
            this.setFile();
        }
        catch (Throwable e) {
            JournalLogger.logError(7, 63, e);
            new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_CREATE, "", e);
        }
    }

    public TXJobLog(OutputStream os) {
        if (os == null) {
            JournalLogger.logError(89, 63);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_NO_STREAM_SPECIFIED, "");
        }
        this.gDateFormat = Config.getProperty(Trace.DEFAULT_DATE_FORMAT, "watt.server.dateStampFmt");
        boolean bl = this.customStream = Config.getProperty("watt.server.key") == null;
        if (this.customStream) {
            JournalLogger.logDebugPlus(3, 8, 63);
        } else {
            JournalLogger.logDebugPlus(3, 9, 63);
        }
        this.logType = new TXLogStream(os);
        this.userStream = true;
    }

    public TXJobLog(Writer writer) {
        this.gDateFormat = Config.getProperty(Trace.DEFAULT_DATE_FORMAT, "watt.server.dateStampFmt");
        if (writer == null) {
            JournalLogger.logError(90, 63);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_NO_OUTPUT_WRITER, "");
        }
        boolean bl = this.customStream = Config.getProperty("watt.server.key") == null;
        if (this.customStream) {
            JournalLogger.logDebugPlus(3, 8, 63);
        } else {
            JournalLogger.logDebugPlus(3, 9, 63);
        }
        this.logType = new TXLogWriter(writer);
        this.userWriter = true;
    }

    public void reset(OutputStream os) throws TXJobException {
        if (os != null) {
            this.close();
            this.logType = new TXLogStream(os);
        } else {
            try {
                this.setFile();
            }
            catch (Throwable e) {
                JournalLogger.logError(91, 63);
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_RESET, "", e);
            }
        }
    }

    public void reset(Writer writer) throws TXJobException {
        if (writer != null) {
            this.close();
            this.logType = new TXLogWriter(writer);
        } else {
            try {
                this.setFile();
            }
            catch (Throwable e) {
                JournalLogger.logError(91, 63);
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_RESET, "", e);
            }
        }
    }

    public void resetFile(String logPath) throws TXJobException {
        if (this.userStream) {
            JournalLogger.logError(92, 63);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_USER_STREAM, "");
        }
        if (logPath == null) {
            JournalLogger.logError(93, 63);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_NO_PATH_SPECIFIED, "");
        }
        this.logPath = logPath;
        try {
            this.setFile();
        }
        catch (Throwable e) {
            JournalLogger.logError(94, 63, e);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_RESET_LOGFILE, "", e);
        }
    }

    private void setFile() throws Exception {
        try {
            this.close();
        }
        catch (Exception e) {
            JournalLogger.logWarning(95, 63);
        }
        String path = new File(this.logPath).getCanonicalPath();
        FileOutputStream fos = new FileOutputStream(path, true);
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter((OutputStream)fos, EncUtil.getLogFileEncoding());
        this.logType = new TXLogWriter(writer);
        JournalLogger.logDebugPlus(3, 96, 63, path);
    }

    public void setCustomStream(OutputStream os) throws TXJobException {
        if (os == null) {
            JournalLogger.logError(97, 63);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_NO_STREAM_SPECIFIED, "");
        }
        if (!this.customStream) {
            JournalLogger.logError(98, 63);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_NOT_CUSTOM_STREAM, "");
        }
        this.close();
        this.logType = new TXLogStream(os);
    }

    public void setCustomWriter(Writer writer) throws TXJobException {
        if (writer == null) {
            JournalLogger.logError(99, 63);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_NO_OUTPUT_WRITER, "");
        }
        if (!this.customStream) {
            JournalLogger.logError(100, 63);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_NOT_CUSTOM_WRITER, "");
        }
        this.close();
        this.logType = new TXLogWriter(writer);
    }

    public void write(String msg) throws TXJobException {
        StringBuffer buf = this.gDateFormat != null ? new StringBuffer(DateTimeDT.currentDate(this.gDateFormat, null)) : new StringBuffer(Long.toString(System.currentTimeMillis()));
        buf.append(" ").append(msg).append(nl);
        boolean done = false;
        int tries = 0;
        while (!done) {
            try {
                this.logType.write(buf.toString());
                done = true;
            }
            catch (OutOfMemoryError e) {
                if (tries > 30) {
                    JournalLogger.logError(94, 63, e);
                    throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_WRITE, "", e);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException i) {
                    tries = 100;
                }
                ++tries;
            }
            catch (Throwable e) {
                JournalLogger.logError(94, 63, e);
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_WRITE, "", e);
            }
        }
    }

    public void close() {
        if (this.logType == null) {
            return;
        }
        if (this.customStream && (this.userStream || this.userWriter)) {
            JournalLogger.logDebugPlus(3, 101, 63);
            return;
        }
        this.logType.close();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: TXJobStore (r | x)");
            System.exit(-1);
        }
        try {
            if (args[0].equals("r")) {
                File f = new File("main.log");
                f.delete();
                f = new File("reset.log");
                f.delete();
                f = new File("os1.log");
                f.delete();
                f = new File("os2.log");
                f.delete();
                f = new File("os3.log");
                f.delete();
                return;
            }
            TXJobLog log = new TXJobLog("main.log");
            log.write("Hello1 - main log");
            log.write("Hello2 - main log");
            log.resetFile("reset.log");
            log.write("Hello1 - reset log");
            log.write("Hello2 - reset log");
            log.close();
            FileOutputStream os = new FileOutputStream("os1.log");
            log = new TXJobLog(os);
            log.write("Hello1 - os1.log");
            log.write("Hello2 - os1.log");
            os = new FileOutputStream("os2.log");
            log.setCustomStream(os);
            log.write("Hello1 - os2.log");
            log.write("Hello2 - os2.log");
            log.close();
            os = new FileOutputStream("osw1.log");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, EncUtil.getLogEncoding());
            log.setCustomWriter(osw);
            log.write("Hello1 - osw1.log");
            log.write("Hello2 - osw1.log");
            log.close();
            OutputStreamWriter tosw = new OutputStreamWriter((OutputStream)new FileOutputStream("osw2.log"), EncUtil.getLogEncoding());
            PrintWriter out = new PrintWriter(new BufferedWriter(tosw));
            log.setCustomWriter(out);
            log.write("Hello1 - osw2.log");
            log.write("Hello2 - osw2.log");
            log.close();
            Config.setProperty("watt.server.key", "a");
            os = new FileOutputStream("os3.log");
            log = new TXJobLog(os);
            log.write("Howdy1 - os3.log");
            os.write(nl.getBytes());
            log.write("Howdy2 - os3.log");
            os.write(nl.getBytes());
            try {
                log.setCustomStream(os);
            }
            catch (TXJobException e) {
                System.out.println("Expected error = " + e.getMessage());
            }
            log.close();
            os = null;
            try {
                log.setCustomStream(os);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Expected error = " + e.getMessage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private class TXLogStream
    implements TXLogType {
        private OutputStream oStream;

        public TXLogStream(OutputStream stream) {
            this.oStream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String msg) throws IOException {
            OutputStream outputStream = this.oStream;
            synchronized (outputStream) {
                this.oStream.write(EncUtil.getLogBytes(msg));
                this.oStream.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.oStream == null) {
                return;
            }
            try {
                OutputStream outputStream = this.oStream;
                synchronized (outputStream) {
                    this.oStream.close();
                    this.oStream = null;
                }
                JournalLogger.logDebugPlus(3, 102, 63);
            }
            catch (Exception e) {
                JournalLogger.logError(94, 63, e);
            }
        }
    }

    private class TXLogWriter
    implements TXLogType {
        private Writer writer;

        public TXLogWriter(Writer writer) {
            this.writer = writer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String msg) throws IOException {
            Writer writer = this.writer;
            synchronized (writer) {
                this.writer.write(msg.toCharArray(), 0, msg.length());
                this.writer.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.writer == null) {
                return;
            }
            try {
                Writer writer = this.writer;
                synchronized (writer) {
                    this.writer.close();
                    this.writer = null;
                }
                JournalLogger.logDebugPlus(3, 102, 63);
            }
            catch (Exception e) {
                JournalLogger.logError(94, 63, e);
            }
        }
    }

    private static interface TXLogType {
        public void write(String var1) throws IOException;

        public void close();
    }
}

