/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class VersionInfo {
    private Hashtable devInfo = new Hashtable();
    private Hashtable serverInfo = new Hashtable();
    int startIndex = 0;
    private int devVersion;
    private int serverVersion;
    static final ResourceBundle bundle = ResourceBundle.getBundle("com.wm.app.b2b.util.resources.B2BClientResourceBundle");
    static final String DEV_TITLE = bundle.getString("OlderServer") + "\n\n";
    static final String SVR_TITLE = bundle.getString("NewerServer") + "\n\n";
    static final String[] DEV_FEATURE_LIST = new String[]{"", "  - " + bundle.getString("CreateTransformers") + "\n" + "  - " + bundle.getString("StepIntoFlowoperations") + "\n" + "  - " + bundle.getString("TraceIntoFlowoperations") + "\n" + "  - " + bundle.getString("SetBreakpoints") + "\n" + "  - " + bundle.getString("DisableFlowoperations") + "\n" + "  - " + bundle.getString("ChangePasswords") + "\n" + "  - " + bundle.getString("CreateSchemas") + "\n" + "  - " + bundle.getString("ManagePackages") + "\n" + "  - " + bundle.getString("SaveandRestorePipelinevalues") + "\n" + "  - " + bundle.getString("SetService-specificAuditLevels") + "\n" + "  - " + bundle.getString("ViewtheCallStack") + "\n", "  - " + bundle.getString("ReferenceContentTypesinSchemas") + "\n", "  - " + bundle.getString("SaveLayoutofFlowDiagrams") + "\n", "", "", "", "  - " + bundle.getString("Locking") + "\n" + "  - " + bundle.getString("webservices") + "\n" + "  - " + bundle.getString("wsdl") + "\n" + "  - " + bundle.getString("SchemaDetails") + "\n" + "  - " + bundle.getString("ViewPropertyConstraints") + "\n", "", "", "", "  - " + bundle.getString("ServiceRetry") + "\n" + "  - " + bundle.getString("AdapterServiceSignature") + "\n"};
    static final String[] SERVER_FEATURE_LIST = new String[]{"", "", "  - " + bundle.getString("ReferenceContentTypesinSchemas") + "\n", "  - " + bundle.getString("UseFlowDiagramView") + "\n", "  - " + bundle.getString("ManageServiceandRecordDependencies") + "\n" + "  - " + bundle.getString("ReceiveNotificationofServerShutdown") + "\n" + "  - " + bundle.getString("DisableTransformersandMapConditions") + "\n" + "  - " + bundle.getString("SetBreakpointsonTransformers") + "\n" + "  - " + bundle.getString("ViewPipelineorRecordasHTML") + "\n" + "  - " + bundle.getString("ModifyPipelineDuringTraceorStep") + "\n" + "  - " + bundle.getString("SetEventsinEventManager") + "\n", "", "", "  - " + bundle.getString("Locking") + "\n" + "  - " + bundle.getString("webservices") + "\n" + "  - " + bundle.getString("wsdl") + "\n" + "  - " + bundle.getString("MultipleServers") + "\n" + "  - " + bundle.getString("SchemaDetails") + "\n" + "  - " + bundle.getString("ViewPropertyConstraints") + "\n\n" + bundle.getString("LockWarning") + "\n", "", "", "", "  - " + bundle.getString("ServiceRetry") + "\n" + "  - " + bundle.getString("AdapterServiceSignature") + "\n"};
    static final HashMap serverVersionsDeveloperIsCompatibleWith = new HashMap();
    static final HashMap developerVersionsServerIsCompatibleWith = new HashMap();

    public VersionInfo(int dev, int server) {
        this.setDevVersion(dev);
        this.setServerVersion(server);
        this.storeFeatureList();
    }

    public String getFeatureInfo() {
        String msg = "";
        int i = 0;
        if (this.getDevVersion() > this.getServerVersion()) {
            if (this.isCompatible(this.getDevVersion(), this.getServerVersion())) {
                for (i = this.getServerVersion() + 1; i <= this.getDevVersion(); ++i) {
                    Object featureInfo = this.getDevInfo().get(String.valueOf(i));
                    msg = msg + featureInfo != null ? (String)featureInfo : "";
                }
                if (msg != null && msg.length() > 0 && msg.indexOf(DEV_TITLE) < 0) {
                    msg = DEV_TITLE + msg;
                }
            } else {
                msg = this.getVersionsIncompatibleMsg();
            }
        } else if (this.isCompatible(this.getDevVersion(), this.getServerVersion())) {
            for (i = this.getDevVersion() + 1; i <= this.getServerVersion(); ++i) {
                Object featureInfo = this.getServerInfo().get(String.valueOf(i));
                msg = msg + featureInfo != null ? (String)featureInfo : "";
            }
            if (msg != null && msg.length() > 0 && msg.indexOf(SVR_TITLE) < 0) {
                msg = SVR_TITLE + msg;
            }
        } else {
            msg = this.getVersionsIncompatibleMsg();
        }
        return msg;
    }

    public String getVersionsIncompatibleMsg() {
        return bundle.getString("BackwardsCompatiblityNotSupported");
    }

    public boolean versionsCompatible() {
        return this.isCompatible(this.getDevVersion(), this.getServerVersion());
    }

    private boolean isCompatible(int devVersion, int serverVersion) {
        boolean isCompatible;
        block4: {
            block6: {
                block5: {
                    isCompatible = false;
                    if (devVersion != serverVersion) break block5;
                    isCompatible = true;
                    break block4;
                }
                if (devVersion <= serverVersion) break block6;
                int[] compatibleServerVersions = this.getCompatibleServerVersions(devVersion);
                for (int i = 0; i < compatibleServerVersions.length; ++i) {
                    int compatibleServerVersion = compatibleServerVersions[i];
                    if (compatibleServerVersion != serverVersion) continue;
                    isCompatible = true;
                    break block4;
                }
                break block4;
            }
            if (serverVersion <= devVersion) break block4;
            int[] compatibleDevVersions = this.getCompatibleDevVersions(serverVersion);
            if (compatibleDevVersions == null) {
                isCompatible = false;
            } else {
                for (int i = 0; i < compatibleDevVersions.length; ++i) {
                    int compatibleDevVersion = compatibleDevVersions[i];
                    if (compatibleDevVersion != devVersion) continue;
                    isCompatible = true;
                    break;
                }
            }
        }
        return isCompatible;
    }

    private int[] getCompatibleDevVersions(int serverVersion) {
        return (int[])developerVersionsServerIsCompatibleWith.get(Integer.toString(serverVersion));
    }

    private int[] getCompatibleServerVersions(int developerVersion) {
        return (int[])serverVersionsDeveloperIsCompatibleWith.get(Integer.toString(developerVersion));
    }

    private void storeFeatureList() {
        int serverFeaturesLength;
        int devFeaturesLength;
        int devVersion = this.getDevVersion();
        int allFeaturesUpTo = devVersion > (devFeaturesLength = DEV_FEATURE_LIST.length - 1) ? devFeaturesLength : devVersion;
        for (int i = this.startIndex; i <= allFeaturesUpTo; ++i) {
            this.getDevInfo().put(String.valueOf(i), DEV_FEATURE_LIST[i]);
        }
        int serverVersion = this.getServerVersion();
        allFeaturesUpTo = serverVersion > (serverFeaturesLength = SERVER_FEATURE_LIST.length - 1) ? serverFeaturesLength : serverVersion;
        for (int j = this.startIndex; j <= allFeaturesUpTo; ++j) {
            this.getServerInfo().put(String.valueOf(j), SERVER_FEATURE_LIST[j]);
        }
    }

    private Hashtable getDevInfo() {
        return this.devInfo;
    }

    private Hashtable getServerInfo() {
        return this.serverInfo;
    }

    public int getDevVersion() {
        return this.devVersion;
    }

    private void setDevVersion(int devVersion) {
        this.devVersion = devVersion;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    private void setServerVersion(int serverVersion) {
        this.serverVersion = serverVersion;
    }

    static {
        serverVersionsDeveloperIsCompatibleWith.put("10", new int[]{10});
        serverVersionsDeveloperIsCompatibleWith.put("11", new int[]{10, 11});
        serverVersionsDeveloperIsCompatibleWith.put("12", new int[]{12});
        developerVersionsServerIsCompatibleWith.put("10", new int[]{10});
        developerVersionsServerIsCompatibleWith.put("11", new int[]{10, 11});
        developerVersionsServerIsCompatibleWith.put("12", new int[]{12});
    }
}

