/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;

public class Text {
    static final String nl = System.getProperty("line.separator");

    public static void main(String[] args) {
        String utext = "this is not indented" + nl + "also not indented" + nl + "" + nl + "\tone last line" + nl;
        String itext = "\t\tthis is indented" + nl + "\t\talso indented" + nl + "" + nl + "\t\t\tone last line" + nl;
        System.err.println(Text.unindent(itext));
        System.err.println(Text.indent(utext));
    }

    static int calcWhiteSpace(int pad, String line) {
        int lpad = pad;
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            lpad = i;
            break;
        }
        return Math.min(pad, lpad);
    }

    public static String indent(String body) {
        return Text.indent(body, "\t\t");
    }

    public static String indent(String body, String prefix) {
        try {
            String line;
            int plen = body.length();
            BufferedReader in = new BufferedReader(new StringReader(body));
            Vector<String> tmp = new Vector<String>(1);
            while ((line = in.readLine()) != null) {
                plen = Text.calcWhiteSpace(plen, line);
                tmp.addElement(line);
            }
            StringBuffer sb = new StringBuffer();
            int tSize = tmp.size();
            if (plen <= 0) {
                for (int i = 0; i < tSize; ++i) {
                    sb.append(prefix + tmp.elementAt(i) + nl);
                }
            } else {
                for (int i = 0; i < tSize; ++i) {
                    sb.append(tmp.elementAt(i) + nl);
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return body;
        }
    }

    static String calcBeginWhite(String current, String line) {
        if (line == null || line.length() == 0) {
            return current;
        }
        if (current != null && line.indexOf(current) == 0) {
            return current;
        }
        String ws = null;
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            ws = line.substring(0, i);
            break;
        }
        if (current == null || ws != null && current.startsWith(ws)) {
            return ws;
        }
        return "";
    }

    public static String unindent(String body) {
        try {
            String line;
            String ws = null;
            BufferedReader in = new BufferedReader(new StringReader(body));
            Vector<String> tmp = new Vector<String>(1);
            while ((line = in.readLine()) != null) {
                ws = Text.calcBeginWhite(ws, line);
                tmp.addElement(line);
            }
            int wslen = ws != null ? ws.length() : 0;
            StringBuffer method = new StringBuffer();
            int tSize = tmp.size();
            for (int i = 0; i < tSize; ++i) {
                line = (String)tmp.elementAt(i);
                if (line.length() >= wslen) {
                    method.append(((String)tmp.elementAt(i)).substring(wslen) + nl);
                    continue;
                }
                method.append(line + nl);
            }
            return method.toString();
        }
        catch (Exception e) {
            return body;
        }
    }
}

