/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.data.ValuesEmulator;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class SupportInfo {
    private IData gSettings;
    static final String LINE_SEP = "\n";
    static final String PATH_SEP = System.getProperty("path.separator");
    static String KEY_PATH_SEP;
    static String KEY_CLASSPATH;
    static String KEY_PLUGINS;
    static String KEY_JAVA_CLASSPATH;
    static final String TAB = " ";
    static final int TABLENGTH = 1;
    static ResourceBundle gResource;

    public void getAppBundle(Locale locale) {
        try {
            gResource = ResourceBundle.getBundle("com.wm.app.b2b.util.resources.SupportInfoBundle", locale);
            KEY_PATH_SEP = gResource.getString("KeyPathSeparator");
            KEY_CLASSPATH = gResource.getString("KeyClasspath");
            KEY_PLUGINS = gResource.getString("KeyLoadedPlugIns");
            KEY_JAVA_CLASSPATH = gResource.getString("KeyJavaClasspath");
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
    }

    public SupportInfo(IData appSettings) {
        this(appSettings, Locale.getDefault());
    }

    public SupportInfo(IData appSettings, Locale locale) {
        this.getAppBundle(locale);
        this.gSettings = appSettings;
        this.addSystemSettings();
    }

    public SupportInfo() {
        this(IDataFactory.create());
    }

    public void addSystemSettings() {
        String[] args = new String[]{System.getProperty("java.version"), System.getProperty("java.class.version")};
        String javaVersion = MessageFormat.format(gResource.getString("JavaVersion"), args);
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyJavaVersion"), (Object)javaVersion);
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyJavaVendor"), (Object)System.getProperty("java.vendor"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyJavaHome"), (Object)System.getProperty("java.home"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyJavaClasspath"), (Object)System.getProperty("java.class.path"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyOS"), (Object)System.getProperty("os.name"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyOSPlatform"), (Object)System.getProperty("os.arch"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyOSVersion"), (Object)System.getProperty("os.version"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyCurrentUser"), (Object)System.getProperty("user.name"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyWorkingDir"), (Object)System.getProperty("user.dir"));
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyPathSeparator"), (Object)System.getProperty("path.separator"));
        Locale aLocale = Locale.getDefault();
        ValuesEmulator.put(this.gSettings, gResource.getString("KeyLocale"), (Object)aLocale);
    }

    public IData getValues() {
        return this.gSettings;
    }

    public String toString(StringBuffer propertiesBuffer) {
        int maxKeyLen = this.getLongestKeyLength();
        Enumeration e = ValuesEmulator.keys(this.gSettings);
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (SupportInfo.equals(key, KEY_PATH_SEP)) continue;
            this.addLine(key, maxKeyLen, propertiesBuffer);
        }
        return propertiesBuffer.toString();
    }

    public int getLongestKeyLength() {
        int maxKeyLen = 0;
        Enumeration e = ValuesEmulator.keys(this.gSettings);
        while (e.hasMoreElements()) {
            int keyLength = ((String)e.nextElement()).length();
            if (keyLength <= maxKeyLen) continue;
            maxKeyLen = keyLength;
        }
        return maxKeyLen;
    }

    private void addLine(String key, int maxKeyLen, StringBuffer buffer) {
        String indentation = SupportInfo.indent(maxKeyLen - key.length());
        buffer.append(indentation);
        buffer.append(key + ":");
        buffer.append(TAB);
        if (SupportInfo.equals(key, KEY_PLUGINS)) {
            String[] pluginNames = ValuesEmulator.getStringArray(this.gSettings, key);
            if (pluginNames != null && pluginNames.length > 0) {
                String value = null;
                for (int i = 0; i < pluginNames.length; ++i) {
                    value = pluginNames[i];
                    buffer.append(value);
                    if (i >= pluginNames.length - 1) continue;
                    buffer.append(LINE_SEP + SupportInfo.indent(maxKeyLen + 1 + 1));
                }
            }
        } else {
            boolean isAClasspath;
            String value = ValuesEmulator.getString(this.gSettings, key);
            boolean bl = isAClasspath = key.indexOf(KEY_CLASSPATH) != -1 || key.indexOf(KEY_JAVA_CLASSPATH) != -1;
            if (isAClasspath) {
                value = SupportInfo.insertIndentedLineBreak(value, PATH_SEP, LINE_SEP + SupportInfo.indent(maxKeyLen + 1 + 1));
                value = value.substring(0, value.lastIndexOf(LINE_SEP + SupportInfo.indent(maxKeyLen + 1 + 1)));
            }
            buffer.append(value);
        }
        buffer.append(LINE_SEP);
    }

    public static String indent(int indentation) {
        StringBuffer spaceString = new StringBuffer();
        for (int i = 0; i < indentation; ++i) {
            spaceString.append(TAB);
        }
        return spaceString.toString();
    }

    public static String insertIndentedLineBreak(String str, String delimiter, String replace) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken() + replace);
        }
        return buffer.toString();
    }

    public static final boolean equals(String s1, String s2) {
        return SupportInfo.compare(s1, s2) == 0;
    }

    public static final int compare(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        Collator coll = Collator.getInstance();
        coll.setDecomposition(0);
        return coll.compare(s1, s2);
    }
}

