/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class StringMap {
    Random r = new Random();
    int base;
    int length;

    public StringMap() {
        this(true);
    }

    public StringMap(boolean mode) {
        if (mode) {
            this.base = 65;
            this.length = 35;
        } else {
            this.base = 32;
            this.length = 94;
        }
    }

    public String unmangle(String string) {
        if (string == null || string.length() != 25) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[25];
        for (int count = 24; count > 0; --count) {
            char last = string.charAt(count);
            buf[count] = (char)this.unroll(last, string.charAt(count - 1));
        }
        int len = buf[10] - this.base;
        for (int i = 11; i < 11 + len; ++i) {
            sb.append(buf[i]);
        }
        return sb.toString();
    }

    public String mangle(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] buf = new char[25];
        int next = 0;
        int count = 0;
        int last = this.nextChar();
        for (int i = 0; i < 10; ++i) {
            last = this.roll(last);
            buf[count++] = (char)last;
        }
        int len = string.length();
        if (len > 14) {
            len = 14;
        }
        last = this.roll(last, len + this.base);
        buf[count++] = (char)last;
        for (int i = 0; i < len; ++i) {
            last = this.roll(last, string.charAt(i));
            buf[count++] = (char)last;
        }
        while (count < 25) {
            next = this.nextChar();
            last = this.roll(last, next);
            buf[count++] = (char)last;
        }
        return new String(buf);
    }

    private int nextChar() {
        return (int)(Math.abs(this.r.nextFloat()) * (float)this.length + (float)this.base);
    }

    private int roll(int last) {
        return this.roll(last, this.nextChar());
    }

    private int roll(int last, int key) {
        int next = last + key - this.base;
        if (next > this.base + this.length) {
            next -= this.length;
        }
        return next;
    }

    private int unroll(int last, int key) {
        int next = last - key + this.base;
        if (next < this.base) {
            next += this.length;
        }
        return next;
    }

    private String split(String bit, String code) {
        if (bit == null || code == null) {
            return null;
        }
        if (bit.length() != code.length()) {
            return null;
        }
        boolean last = false;
        char[] key = new char[bit.length()];
        for (int i = 0; i < key.length; ++i) {
            key[i] = (char)this.unroll(code.charAt(i), bit.charAt(i));
        }
        return new String(key);
    }

    public String extract(String key) {
        return this.unflatten(this.decode(this.unfixnum(this.merge(key))));
    }

    public boolean isDemo(String code) {
        return code != null && code.length() > 0 && code.charAt(0) == 'd';
    }

    public Date getDate(String code) {
        if (code != null && code.length() == 5) {
            Calendar c = Calendar.getInstance();
            c.set(1900 + code.charAt(4), code.charAt(3), code.charAt(2), 23, 59, 59);
            return c.getTime();
        }
        return null;
    }

    public boolean isValid(char root, String code) {
        if (code == null || code.length() < 5) {
            return false;
        }
        char cmpRoot = code.charAt(0);
        if (this.isDemo(code)) {
            Date now = new Date();
            Date exp = this.getDate(code);
            if (exp.getTime() > now.getTime()) {
                return true;
            }
        } else {
            if (code.charAt(0) != root) {
                return false;
            }
            if (code.charAt(0) == 't') {
                if (code.charAt(1) == 'k') {
                    return this.matchLocalHost(code);
                }
                if (code.charAt(1) == '2') {
                    return this.getCustID(code) != 0;
                }
            } else {
                if (code.charAt(0) == 's' || code.charAt(0) == 'b' || code.charAt(0) == 'e') {
                    return this.matchLocalHost(code);
                }
                if (code.substring(0, 3).equals("rt2")) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchLocalHost(String code) {
        try {
            int i;
            byte[] h = this.getIP(code);
            byte[] b = InetAddress.getLocalHost().getAddress();
            if (b.length != h.length) {
                return false;
            }
            boolean bad = false;
            for (i = 0; i < b.length; ++i) {
                if (b[i] == h[i]) continue;
                bad = true;
            }
            if (!bad) {
                return true;
            }
            for (i = b.length; i > 0; --i) {
                if (b[i - 1] == h[h.length - i]) continue;
                return false;
            }
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private byte[] getIP(String code) {
        if (code != null && code.length() == 6) {
            byte[] b = new byte[]{(byte)code.charAt(2), (byte)code.charAt(3), (byte)code.charAt(4), (byte)code.charAt(5)};
            return b;
        }
        return null;
    }

    public int getCustID(String code) {
        if (code != null && code.length() == 7) {
            char x2 = code.charAt(2);
            char x1 = code.charAt(3);
            char x0 = code.charAt(6);
            if (x2 != x0) {
                return 0;
            }
            return x2 << 8 | x1;
        }
        return 0;
    }

    public int getSeqID(String code) {
        if (code != null && code.length() == 7) {
            char x2 = code.charAt(4);
            char x1 = code.charAt(5);
            return x2 << 8 | x1;
        }
        return 0;
    }

    public String merge(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char crc = '\u0001';
        block4: for (int i = 0; i < key.length(); ++i) {
            switch (i % 6) {
                case 4: {
                    crc = this.fixchar(crc % 35 + 65);
                    if (crc == key.charAt(i)) continue block4;
                    return null;
                }
                case 5: {
                    if (key.charAt(i) == ' ') continue block4;
                    return null;
                }
                default: {
                    crc += key.charAt(i);
                    sb.append(key.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public String unflatten(String key) {
        if (key == null) {
            return null;
        }
        char[] oldkey = new char[key.length() / 2];
        for (int i = 0; i < oldkey.length; ++i) {
            oldkey[i] = (char)((key.charAt(i * 2) - 65) * 16 + (key.charAt(i * 2 + 1) - 65));
        }
        return new String(oldkey);
    }

    private char fixchar(int in) {
        if (in > 90) {
            return (char)(in - 43);
        }
        return (char)in;
    }

    private char unfixchar(int in) {
        if (in < 65) {
            return (char)(in + 43);
        }
        return (char)in;
    }

    public String unfixnum(String key) {
        if (key == null) {
            return null;
        }
        char[] newkey = new char[key.length()];
        for (int i = 0; i < newkey.length; ++i) {
            newkey[i] = this.unfixchar(key.charAt(i));
        }
        return new String(newkey);
    }

    public String decode(String code) {
        if (code == null) {
            return null;
        }
        String bits = code.substring(0, code.length() / 2);
        return this.split(bits, code.substring(code.length() / 2));
    }

    public String split(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int crc = 1;
        for (int i = 0; i < key.length(); ++i) {
            sb.append(key.charAt(i));
            crc += key.charAt(i);
            if (i % 4 != 3) continue;
            crc = this.fixchar(crc % 35 + 65);
            sb.append((char)crc);
            sb.append(' ');
        }
        return sb.toString();
    }

    public String flatten(String key) {
        if (key == null) {
            return null;
        }
        char[] newkey = new char[key.length() * 2];
        for (int i = 0; i < key.length(); ++i) {
            newkey[i * 2] = (char)(key.charAt(i) / 16 + 65);
            newkey[i * 2 + 1] = (char)(key.charAt(i) % 16 + 65);
        }
        return new String(newkey);
    }

    public String fixnum(String key) {
        if (key == null) {
            return null;
        }
        char[] newkey = new char[key.length()];
        for (int i = 0; i < newkey.length; ++i) {
            newkey[i] = this.fixchar(key.charAt(i));
        }
        return new String(newkey);
    }

    public String encode(String key) {
        if (key == null) {
            return null;
        }
        String bits = this.randomString(key.length());
        return bits + this.combine(bits, key);
    }

    public String randomString(int strlen) {
        char[] c = new char[strlen];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (char)this.nextChar();
        }
        return new String(c);
    }

    public String combine(String bit, String key) {
        if (bit == null || key == null) {
            return null;
        }
        if (bit.length() != key.length()) {
            return null;
        }
        boolean last = false;
        char[] code = new char[bit.length()];
        for (int i = 0; i < code.length; ++i) {
            code[i] = (char)this.roll(bit.charAt(i), key.charAt(i));
        }
        return new String(code);
    }
}

