/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.data.IData;
import com.wm.lang.ns.NSName;
import com.wm.util.JournalLogger;
import com.wm.util.StringMatcher;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.coder.XMLCoder;
import java.io.File;
import java.util.Vector;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RuleSet
implements ValuesCodable {
    public static final int CORSVC0020 = 20;
    public static final int CORSVC0021 = 21;
    public static final int RULESET_1 = 4;
    public static final int RULESET_2 = 5;
    public static final int RULESET_3 = 6;
    private Rule[] allRules;
    private Rule[] reqRules;
    private Rule[] rspRules;

    public RuleSet() {
        this.allRules = new Rule[0];
        this.reqRules = new Rule[0];
        this.rspRules = new Rule[0];
    }

    public RuleSet(Rule[] rules) {
        this.allRules = rules;
        this.setReqRspRules(rules.length);
    }

    private void setReqRspRules(int cnt) {
        Vector<Rule> before = new Vector<Rule>();
        Vector<Rule> after = new Vector<Rule>();
        for (int i = 0; i < cnt; ++i) {
            if (this.allRules[i].hasBeforeAction()) {
                before.addElement(this.allRules[i]);
            }
            if (!this.allRules[i].hasAfterAction()) continue;
            after.addElement(this.allRules[i]);
        }
        this.reqRules = new Rule[before.size()];
        this.rspRules = new Rule[after.size()];
        before.copyInto(this.reqRules);
        after.copyInto(this.rspRules);
    }

    public Rule[] matchReq(Values in, boolean trace) {
        return this.match(in, this.reqRules, trace);
    }

    public Rule[] matchRsp(Values in, boolean trace) {
        return this.match(in, this.rspRules, trace);
    }

    private Rule[] match(Values in, Rule[] rules, boolean trace) {
        Vector<Rule> v = new Vector<Rule>();
        for (int i = 0; i < rules.length; ++i) {
            if (!rules[i].match(in, trace)) continue;
            v.addElement(rules[i]);
        }
        Object[] triggers = new Rule[v.size()];
        v.copyInto(triggers);
        return triggers;
    }

    public Values getValues() {
        Values out = new Values();
        for (int i = 0; i < this.allRules.length; ++i) {
            out.put(this.allRules[i].getValues());
        }
        return out;
    }

    public void setValues(Values values) {
        int cnt = values.size();
        this.allRules = new Rule[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.allRules[i] = new Rule();
            this.allRules[i].setValues(Values.use((IData)values.get(i)));
        }
        this.setReqRspRules(cnt);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("rs.txt");
        XMLCoder coder = new XMLCoder(true);
        coder.writeToFile(f, RuleSet.getTestData().getValues());
        RuleSet rs = new RuleSet();
        rs.setValues(coder.readFromFile(f));
        Object[][] o = new Object[][]{{"reqUrl", "http://www.aol.com"}, {"rspUrl", "http://www.compusa.com"}, {"a1", "another banner year"}, {"a2", "http://www.aol.com/123456/index.html"}};
        Values v = new Values(o);
        RuleSet.display("Request action triggers:", rs.matchReq(v, true));
        RuleSet.display("Response action triggers:", rs.matchRsp(v, true));
    }

    public static RuleSet getTestData() {
        Match[] reqConds1 = new Match[]{new Match("reqUrl", "http*")};
        Match[] reqConds2 = new Match[]{new Match("a2", "*123467*")};
        Match[] reqConds3 = new Match[]{new Match("a1", "% % year"), new Match("reqUrl", "http*")};
        Match[] rspConds1 = new Match[]{new Match("a1", "*banner*")};
        Match[] rspConds2 = new Match[]{new Match("a2", "?ttp://www.aol.com/*/index.html")};
        Match[] rspConds3 = new Match[]{new Match("rspUrl", "*amazon*")};
        Rule[] rules = new Rule[]{new Rule(NSName.create("tst:svc1"), null, reqConds1, "req1"), new Rule(NSName.create("tst:svc2"), null, reqConds2, "req2"), new Rule(NSName.create("tst:svc3"), null, reqConds3, "req3"), new Rule(null, NSName.create("tst:svc1"), rspConds1, "rsp1"), new Rule(null, NSName.create("tst:svc2"), rspConds2, "rsp2"), new Rule(null, NSName.create("tst:svc3"), rspConds3, "rsp3")};
        return new RuleSet(rules);
    }

    private static void display(String msg, Rule[] actions) {
        System.out.println(msg);
        for (int i = 0; i < actions.length; ++i) {
            NSName before = actions[i].getBeforeAction();
            NSName after = actions[i].getAfterAction();
            System.out.println("BeforeAction=" + (before == null ? "" : before.getValue()) + " AfterAction=" + (after == null ? "" : after.getValue()));
        }
        System.out.println();
    }

    public static class Match
    implements ValuesCodable {
        private transient boolean isRegex;
        private transient StringMatcher sMatcher;
        private transient PatternCompiler rCompiler;
        private transient PatternMatcher rMatcher;
        private transient Pattern rPattern;
        private transient PatternMatcherInput rInput;
        private String attrName;
        private String pattern;
        public static final String KEY_MATCH_NAME = "Name";
        public static final String KEY_MATCH_PATTERN = "Pattern";

        public Match() {
        }

        public Match(String attrName, String pattern) {
            this.attrName = attrName;
            this.pattern = pattern;
            this.setMatcher();
        }

        private void setMatcher() {
            if (this.pattern != null && this.pattern.length() > 0 && this.pattern.charAt(0) == '/') {
                try {
                    this.isRegex = true;
                    this.rCompiler = new Perl5Compiler();
                    this.rPattern = this.rCompiler.compile(this.pattern.substring(1, this.pattern.length() - 1));
                    this.rMatcher = new Perl5Matcher();
                }
                catch (Exception e) {
                    JournalLogger.logDebug(20, 62, e);
                    this.isRegex = false;
                }
            }
            if (!this.isRegex) {
                this.sMatcher = new StringMatcher(this.pattern);
            }
        }

        public String getAttrName() {
            return this.attrName;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean match(Values in, boolean trace) {
            boolean res = false;
            String s = in.getString(this.attrName);
            if (s == null) {
                if (trace) {
                    JournalLogger.logCritical(4, 60, this.attrName);
                }
                return false;
            }
            if (this.isRegex) {
                try {
                    PatternMatcherInput rInput = new PatternMatcherInput(s);
                    res = this.rMatcher.contains(rInput, this.rPattern);
                }
                catch (Exception e) {
                    JournalLogger.logDebug(21, 62, e);
                    return false;
                }
            } else {
                res = this.sMatcher.match(s);
            }
            if (trace) {
                Object[] attr = new String[]{this.attrName, s, this.pattern};
                if (res) {
                    JournalLogger.logInfo(5, 60, attr);
                } else {
                    JournalLogger.logInfo(6, 60, attr);
                }
            }
            return res;
        }

        public Values getValues() {
            Values out = new Values();
            out.put(KEY_MATCH_NAME, this.attrName);
            out.put(KEY_MATCH_PATTERN, this.pattern);
            return out;
        }

        public void setValues(Values values) {
            this.attrName = values.getString(KEY_MATCH_NAME);
            this.pattern = values.getString(KEY_MATCH_PATTERN);
            this.setMatcher();
        }
    }

    public static class Rule
    implements ValuesCodable {
        private NSName beforeAction;
        private NSName afterAction;
        private Match[] conditions;
        private String name;
        public static final String KEY_RULE_CONDITIONS = "Conditions";
        public static final String KEY_RULE_BEFORE_ACTION = "BeforeAction";
        public static final String KEY_RULE_AFTER_ACTION = "AfterAction";
        public static final String KEY_RULE_NAME = "Name";
        public static final String KEY_RULE_URL_MATCH = "URL";
        private static final String URL_MATCH_NAME = "reqUrl";
        private static final String URL_MATCH_DEFAULT_PAT = "*";

        public Rule() {
        }

        public Rule(NSName beforeAction, NSName afterAction, Match[] conditions, String name) {
            this.beforeAction = beforeAction;
            this.afterAction = afterAction;
            this.conditions = conditions;
            this.name = name;
        }

        public NSName getBeforeAction() {
            return this.beforeAction;
        }

        public NSName getAfterAction() {
            return this.afterAction;
        }

        public boolean hasBeforeAction() {
            return this.beforeAction != null;
        }

        public boolean hasAfterAction() {
            return this.afterAction != null;
        }

        public String getName() {
            return this.name;
        }

        public boolean match(Values in, boolean trace) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (this.conditions[i].match(in, trace)) continue;
                return false;
            }
            return true;
        }

        public Values getValues() {
            Values out = new Values();
            out.put(KEY_RULE_BEFORE_ACTION, this.beforeAction == null ? "" : this.beforeAction.getValue());
            out.put(KEY_RULE_AFTER_ACTION, this.afterAction == null ? "" : this.afterAction.getValue());
            out.put(KEY_RULE_NAME, this.name);
            int urlIdx = -1;
            int condCnt = this.conditions.length;
            for (int i = 0; i < condCnt; ++i) {
                if (!this.conditions[i].getAttrName().equals(URL_MATCH_NAME)) continue;
                urlIdx = i;
                out.put(KEY_RULE_URL_MATCH, this.conditions[i].getPattern());
                break;
            }
            Values[] condVals = null;
            if (urlIdx < 0) {
                condVals = new Values[condCnt];
                out.put(KEY_RULE_URL_MATCH, URL_MATCH_DEFAULT_PAT);
            } else {
                condVals = new Values[condCnt - 1];
            }
            out.put(KEY_RULE_CONDITIONS, condVals);
            int j = 0;
            for (int i = 0; i < condCnt; ++i) {
                if (i == urlIdx) continue;
                condVals[j++] = this.conditions[i].getValues();
            }
            return out;
        }

        public void setValues(Values values) {
            this.beforeAction = NSName.create(values.getString(KEY_RULE_BEFORE_ACTION));
            this.afterAction = NSName.create(values.getString(KEY_RULE_AFTER_ACTION));
            this.name = values.getString(KEY_RULE_NAME);
            Values[] condVals = values.getValuesArray(KEY_RULE_CONDITIONS);
            int condCnt = condVals.length;
            String urlMatch = values.getString(KEY_RULE_URL_MATCH);
            int offset = 0;
            if (urlMatch != null) {
                this.conditions = new Match[condCnt + 1];
                this.conditions[0] = new Match(URL_MATCH_NAME, urlMatch);
                offset = 1;
            } else {
                this.conditions = new Match[condCnt];
            }
            for (int i = 0; i < condCnt; ++i) {
                this.conditions[i + offset] = new Match();
                this.conditions[i + offset].setValues(condVals[i]);
            }
        }
    }
}

