/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.repov4.IRepoDirectory;
import com.wm.app.repov4.IRepository;
import com.wm.app.repov4.RepositoryException;
import com.wm.app.repov4.RepositoryNoEntryException;
import com.wm.util.RepositoryManager;
import java.io.IOException;
import java.util.Enumeration;

public class RepoStorageService {
    IRepository repoSession;
    private IRepoDirectory directory;
    private IRepoDirectory root;
    private String path;

    public RepoStorageService(RepoStorageService service, String path) throws RepositoryException {
        this.repoSession = service.repoSession;
        this.init(path);
    }

    public RepoStorageService(String path) throws RepositoryException {
        this.repoSession = RepositoryManager.getCurrent().getDefaultRepoLogon();
        this.init(path);
    }

    private void init(String p) throws RepositoryException {
        try {
            this.root = this.repoSession.getRootDirectory();
            this.path = "SYSTEM/SERVER/" + p;
            this.directory = this.root.containsKey(this.path) ? this.root.getDirectory(this.path) : this.root.createDirectories(this.path);
            this.repoSession.commit();
        }
        catch (RepositoryException e) {
            try {
                if (this.repoSession != null) {
                    this.repoSession.rollback();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            throw e;
        }
    }

    public synchronized Object get(String key) throws RepositoryException {
        return this.directory.get(key);
    }

    public void put(String key, Object value) throws RepositoryException {
        try {
            this.directory.update(key, value);
        }
        catch (RepositoryNoEntryException e) {
            this.directory.insert(key, value);
        }
    }

    public boolean add(String key, Object value) throws RepositoryException {
        if (this.directory.containsKey(key)) {
            return false;
        }
        this.directory.insert(key, value);
        return true;
    }

    public void deleteDirectory() throws RepositoryException {
        this.root.delete(this.path);
    }

    public boolean delete(String key) throws RepositoryException {
        if (!this.directory.containsKey(key)) {
            return false;
        }
        this.directory.delete(key);
        return true;
    }

    public boolean update(String key, Object value) throws RepositoryException {
        if (!this.directory.containsKey(key)) {
            return false;
        }
        this.directory.update(key, value);
        return true;
    }

    public boolean containsKey(String key) throws RepositoryException {
        return this.directory.containsKey(key);
    }

    public Enumeration keys() throws RepositoryException {
        return this.directory.keys();
    }

    public void commit() throws RepositoryException {
        this.repoSession.commit();
    }

    public void rollback() throws RepositoryException {
        this.repoSession.rollback();
    }

    public void rollback(boolean silent) {
        try {
            this.rollback();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            if (this.root != null) {
                this.root.destroy();
            }
            if (this.directory != null) {
                this.directory.destroy();
            }
            if (this.repoSession != null) {
                this.repoSession.logoff();
            }
            this.root = null;
            this.directory = null;
            this.repoSession = null;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

