/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.ClientException;
import com.wm.app.b2b.util.QueryBindField;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.lang.xml.Node;
import com.wm.lang.xql.TreeExpression;
import com.wm.util.JournalLogger;
import com.wm.util.Name;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Vector;

public class QueryDocument
implements ValuesCodable {
    public static final int CORSVC0016 = 16;
    public static final int CORSVC0017 = 17;
    Vector fields;
    Values nsDecls;

    private QueryDocument(IData val) {
        this.setIData(val);
    }

    public static QueryDocument create(Values val) {
        if (val == null) {
            return null;
        }
        return new QueryDocument(val);
    }

    public static QueryDocument create(IData val) {
        if (val == null) {
            return null;
        }
        return new QueryDocument(val);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"fields", this.fields}, {"nsDecls", this.nsDecls}};
        return new Values(o);
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        this.fields = QueryDocument.createFields(val.get("fields"));
        this.nsDecls = QueryDocument.createNsDecls(val.get("nsDecls"), "queryXMLNode");
    }

    public void setIData(IData val) {
        if (val == null) {
            return;
        }
        IDataCursor id = val.getCursor();
        this.fields = null;
        if (id.first("fields")) {
            this.fields = QueryDocument.createFields(id.getValue());
        }
        this.nsDecls = null;
        if (id.first("nsDecls")) {
            this.nsDecls = QueryDocument.createNsDecls(id.getValue(), "queryXMLNode");
        }
        id.destroy();
    }

    static Vector createFields(Object o) {
        Vector<QueryBindField> fields = null;
        if (o instanceof Vector) {
            fields = (Vector<QueryBindField>)o;
            int fSize = fields.size();
            for (int i = 0; i < fSize; ++i) {
                fields.setElementAt(QueryBindField.create((Values)fields.elementAt(i)), i);
            }
        } else if (o instanceof IData[]) {
            IData[] v = (IData[])o;
            fields = new Vector<QueryBindField>();
            for (int i = 0; i < v.length; ++i) {
                fields.addElement(QueryBindField.create(v[i]));
            }
        } else if (o != null) {
            JournalLogger.logDebug(16, 62, o.toString());
        }
        return fields;
    }

    public static Values createNsDecls(Object o, String caller) {
        Values nsDecls = new Values();
        if (o instanceof Vector) {
            Vector vec = (Vector)o;
            int vSize = vec.size();
            for (int i = 0; i < vSize; ++i) {
                Values val = (Values)vec.elementAt(i);
                nsDecls.put((String)val.get("prefix"), Name.create((String)val.get("uri")));
            }
        } else if (o instanceof Values) {
            Values nsdeclList = (Values)o;
            Enumeration keys = nsdeclList.keys();
            while (keys.hasMoreElements()) {
                Name nextval;
                String nextkey = (String)keys.nextElement();
                Object value = nsdeclList.get(nextkey);
                if (value instanceof Name) {
                    nextval = (Name)nsdeclList.get(nextkey);
                } else if (value instanceof String) {
                    nextval = Name.create((String)nsdeclList.get(nextkey));
                } else {
                    JournalLogger.logDebug(17, 62, caller, "" + nsdeclList.get(nextkey));
                    continue;
                }
                nsDecls.put(nextkey, nextval);
            }
        } else if (o instanceof Values[]) {
            Values[] v = (Values[])o;
            for (int i = 0; i < v.length; ++i) {
                nsDecls.put((String)v[i].get("prefix"), Name.create((String)v[i].get("uri")));
            }
        } else if (o instanceof String[][]) {
            String[][] sa = (String[][])o;
            for (int i = 0; i < sa.length; ++i) {
                if (sa[0].length <= 1 || sa[i][0] == null || sa[i][1] == null) continue;
                nsDecls.put(sa[i][0], Name.create(sa[i][1]));
            }
        } else if (o instanceof IData) {
            IData nsdeclList = (IData)o;
            IDataCursor idc = nsdeclList.getCursor();
            while (idc.next()) {
                Name nextval;
                String nextkey = idc.getKey();
                Object value = idc.getValue();
                if (value instanceof Name) {
                    nextval = (Name)idc.getValue();
                } else if (value instanceof String) {
                    nextval = Name.create((String)idc.getValue());
                } else {
                    JournalLogger.logDebug(17, 62, caller, "" + idc.getValue());
                    continue;
                }
                nsDecls.put(nextkey, nextval);
            }
        } else if (o instanceof IData[]) {
            IData[] v = (IData[])o;
            for (int i = 0; i < v.length; ++i) {
                nsDecls.put((String)ValuesEmulator.get(v[i], "prefix"), Name.create((String)ValuesEmulator.get(v[i], "uri")));
            }
        } else if (o instanceof String[][]) {
            String[][] sa = (String[][])o;
            for (int i = 0; i < sa.length; ++i) {
                if (sa[0].length <= 1 || sa[i][0] == null || sa[i][1] == null) continue;
                nsDecls.put(sa[i][0], Name.create(sa[i][1]));
            }
        } else if (o != null) {
            JournalLogger.logDebug(17, 62, caller, o.toString());
        }
        return nsDecls;
    }

    public void bindFieldsFromPipe(Values pipe) throws Exception {
        this.bindFieldsFromPipe((IData)pipe);
    }

    public void bindFieldsFromPipe(IData pipe) throws Exception {
        if (pipe == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_1, "");
        }
        if (this.fields != null) {
            int fSize = this.fields.size();
            IDataCursor id = pipe.getCursor();
            for (int i = 0; i < fSize; ++i) {
                QueryBindField f = (QueryBindField)this.fields.elementAt(i);
                if (f == null) {
                    Object[] args = new Object[]{new Integer(i), new Integer(this.fields.size())};
                    throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_2, "", args);
                }
                if (f.fieldName == null) {
                    throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_3, "", i);
                }
                Object result = QueryDocument.bindFieldFromPipe(pipe, f, this.nsDecls);
                IDataUtil.put(id, f.fieldName, result);
            }
            id.destroy();
        }
    }

    private static Object bindFieldFromPipe(IData pipe, QueryBindField field, Values nsDecls) throws Exception {
        Object node;
        Object pipeVal = ValuesEmulator.get(pipe, "node");
        if (pipeVal == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.NODE_PARAM_NULL, "", field.fieldName);
        }
        if (!(pipeVal instanceof Node) && !(pipeVal instanceof IData)) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.NODE_PARAM_WRONG_TYPE, "");
        }
        Object result = node = pipeVal;
        return QueryDocument.bindField(node, field, nsDecls, result);
    }

    private static Object bindField(Object node, QueryBindField field, Values nsDecls, Object parentResult) throws Exception {
        Object result;
        if (field.fieldType == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.RESULT_FIELD_NULL, "", field.fieldName);
        }
        if (field.queryType == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERY_FIELD_NULL, "", field.fieldName);
        }
        if (field.query == null || field.query.length() == 0) {
            if (field.fields != null) {
                return QueryDocument.executeChildren(field.fields, nsDecls, parentResult);
            }
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERY_FIELD_NULL, "", field.fieldName);
        }
        TreeExpression query = TreeExpression.create(field.queryType, field.query, nsDecls);
        int dim = 0;
        if (field.fieldType.indexOf("[][]") > 0) {
            dim = 2;
        } else if (field.fieldType.indexOf("[]") > 0) {
            dim = 1;
        }
        if (field.fieldType.startsWith("Record")) {
            switch (dim) {
                case 2: {
                    result = query.getNodeTable(node);
                    break;
                }
                case 1: {
                    if (node instanceof Node) {
                        result = query.getNodeArray(node);
                        break;
                    }
                    result = query.getIDataArray(node);
                    break;
                }
                default: {
                    result = node instanceof Node ? query.getNode(node) : query.getIData(node);
                }
            }
            if (result != null && field.fields != null) {
                result = QueryDocument.executeChildren(field.fields, nsDecls, result);
            }
        } else if (field.fieldType.startsWith("Object")) {
            switch (dim) {
                case 1: 
                case 2: {
                    result = query.getNodeArray(node);
                    break;
                }
                default: {
                    result = query.getNode(node);
                    break;
                }
            }
        } else {
            switch (dim) {
                case 2: {
                    result = query.getStringTable(node);
                    break;
                }
                case 1: {
                    result = query.getStringArray(node);
                    break;
                }
                default: {
                    result = query.getString(node);
                }
            }
        }
        if (field.onnull == -1 && result == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_8, "", field.fieldName);
        }
        if (field.onnull == 1 && result != null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_9, "", field.fieldName);
        }
        return result;
    }

    private static Object executeChildren(IData[] children, Values nsDecls, Object result) throws Exception {
        Vector v = QueryDocument.createFields(children);
        if (result instanceof Node[]) {
            Node[] n = (Node[])result;
            IData[] newres = new IData[n.length];
            for (int j = 0; j < newres.length; ++j) {
                newres[j] = IDataFactory.create();
                if (n[j] == null) continue;
                int vSize = v.size();
                for (int i = 0; i < vSize; ++i) {
                    QueryBindField qb = (QueryBindField)v.elementAt(i);
                    ValuesEmulator.put(newres[j], qb.fieldName, QueryDocument.bindField(n[j], qb, nsDecls, result));
                }
            }
            result = newres;
        } else if (result instanceof Node) {
            IData newres = IDataFactory.create();
            int vSize = v.size();
            for (int i = 0; i < vSize; ++i) {
                QueryBindField qb = (QueryBindField)v.elementAt(i);
                ValuesEmulator.put(newres, qb.fieldName, QueryDocument.bindField((Node)result, qb, nsDecls, result));
            }
            result = newres;
        } else if (result instanceof IData[]) {
            IData[] id = result;
            IData[] newres = new IData[id.length];
            for (int j = 0; j < newres.length; ++j) {
                newres[j] = IDataFactory.create();
                if (id[j] == null) continue;
                int vSize = v.size();
                for (int i = 0; i < vSize; ++i) {
                    QueryBindField qb = (QueryBindField)v.elementAt(i);
                    ValuesEmulator.put(newres[j], qb.fieldName, QueryDocument.bindField(id[j], qb, nsDecls, result));
                }
            }
            result = newres;
        } else if (result instanceof IData) {
            IData newres = IDataFactory.create();
            int vSize = v.size();
            for (int i = 0; i < vSize; ++i) {
                QueryBindField qb = (QueryBindField)v.elementAt(i);
                ValuesEmulator.put(newres, qb.fieldName, QueryDocument.bindField(result, qb, nsDecls, result));
            }
            result = newres;
        }
        return result;
    }

    private static void dumpResult(QueryBindField qbf, Object node, Object result) {
        System.out.println("QueryDocument field:'" + qbf.fieldName + "' query:'" + qbf.query + "' node:'" + node + "'");
        if (result instanceof String) {
            System.out.println("  QueryDocument String result:'" + (String)result + "'");
        } else if (result instanceof String[]) {
            String[] strArray = (String[])result;
            for (int iCtr = 0; iCtr < strArray.length; ++iCtr) {
                System.out.println("  QueryDocument String[] result[" + iCtr + "]:'" + strArray[iCtr] + "'");
            }
        } else if (result instanceof Node) {
            Node nodeResult = (Node)result;
            System.out.println("  QueryDocument Node result:" + nodeResult.getPosition());
        } else if (result instanceof Node[]) {
            Node[] nodeArray = (Node[])result;
            for (int jCtr = 0; jCtr < nodeArray.length; ++jCtr) {
                System.out.println("  QueryDocument Node[] result:" + nodeArray[jCtr].getPosition());
            }
        } else if (result == null) {
            System.out.println("  QueryDocument result: null");
        } else {
            System.out.println("  QueryDocument other type result:'" + result + "'");
        }
    }
}

