/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.ClientException;
import com.wm.app.b2b.util.QueryBindField;
import com.wm.app.b2b.util.QueryDocument;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.ValuesEmulator;
import com.wm.lang.xml.Node;
import com.wm.lang.xql.TreeExpression;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.LocalizedException;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Vector;

public class QueryDocWithIdentity
implements ValuesCodable {
    public static final int CORSVC0014 = 14;
    public static final int CORSVC0015 = 15;
    Vector identities;
    Vector fields;
    Values nsDecls;
    List identitiesInOrder;

    private QueryDocWithIdentity(IData val) {
        this.setIData(val);
    }

    public static QueryDocWithIdentity create(Values val) {
        if (val == null) {
            return null;
        }
        return new QueryDocWithIdentity(val);
    }

    public static QueryDocWithIdentity create(IData val) {
        if (val == null) {
            return null;
        }
        return new QueryDocWithIdentity(val);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"fields", this.fields}, {"nsDecls", this.nsDecls}};
        return new Values(o);
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        this.fields = QueryDocWithIdentity.createFields(val.get("fields"));
        this.nsDecls = QueryDocument.createNsDecls(val.get("nsDecls"), "QueryDocWithIdentity");
    }

    private void setIData(IData val) {
        if (val == null) {
            return;
        }
        IDataCursor id = val.getCursor();
        this.fields = null;
        if (id.first("fields")) {
            this.fields = QueryDocWithIdentity.createFields(id.getValue());
        }
        this.nsDecls = null;
        if (id.first("nsDecls")) {
            this.nsDecls = QueryDocument.createNsDecls(id.getValue(), "QueryDocWithIdentity");
        }
        id.destroy();
    }

    public Values[] updateFields(Values[] pipeFields) {
        if (pipeFields == null) {
            return null;
        }
        for (int iCtr = 0; iCtr < pipeFields.length; ++iCtr) {
            this.updateField(pipeFields[iCtr]);
        }
        return pipeFields;
    }

    private IData[] updateFields(IData[] pipeFields) {
        if (pipeFields == null) {
            return null;
        }
        for (int iCtr = 0; iCtr < pipeFields.length; ++iCtr) {
            this.updateField(pipeFields[iCtr]);
        }
        return pipeFields;
    }

    private void updateField(IData pipeField) {
        IData[] children;
        QueryBindField qbf = this.findField(this.fields, ValuesEmulator.getString(pipeField, "name"));
        if (qbf == null) {
            return;
        }
        if (qbf.fieldType != null && qbf.fieldType.length() > 0) {
            ValuesEmulator.put(pipeField, "resultType", (Object)qbf.fieldType);
        }
        if ((children = (IData[])ValuesEmulator.get(pipeField, "fields")) != null) {
            this.updateFields(children);
        }
    }

    private QueryBindField findField(Vector fieldVec, String fieldName) {
        QueryBindField qbf = null;
        int fSize = fieldVec.size();
        for (int iCtr = 0; iCtr < fSize; ++iCtr) {
            qbf = (QueryBindField)fieldVec.elementAt(iCtr);
            if (!qbf.fieldName.equalsIgnoreCase(fieldName)) continue;
            return qbf;
        }
        if (qbf.fields != null) {
            if (qbf.children == null) {
                return null;
            }
            return this.findField(qbf.children, fieldName);
        }
        return null;
    }

    static Vector createFields(Object o) {
        Vector<QueryBindField> fields = null;
        if (o instanceof Vector) {
            fields = (Vector<QueryBindField>)o;
            int fSize = fields.size();
            for (int i = 0; i < fSize; ++i) {
                fields.setElementAt(QueryBindField.create((IData)fields.elementAt(i)), i);
            }
        } else if (o instanceof IData[]) {
            IData[] v = (IData[])o;
            fields = new Vector<QueryBindField>();
            for (int i = 0; i < v.length; ++i) {
                fields.addElement(QueryBindField.create(v[i]));
            }
        } else if (o != null) {
            JournalLogger.logDebug(14, 62, o.toString());
        }
        return fields;
    }

    public void bindFieldsFromPipe(Values pipe, Values target) throws Exception {
        this.bindFieldsFromPipe((IData)pipe, (IData)target);
    }

    public void bindFieldsFromPipe(IData pipe, IData target) throws Exception {
        if (pipe == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_PIPE_NULL, "");
        }
        this.identities = new Vector();
        this.identitiesInOrder = new List();
        if (this.fields != null) {
            int fSize = this.fields.size();
            for (int i = 0; i < fSize; ++i) {
                QueryBindField f = (QueryBindField)this.fields.elementAt(i);
                if (f == null) {
                    Object[] args = new Object[]{new Integer(i), new Integer(fSize)};
                    throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_FIELD_NULL, "", args);
                }
                if (f.fieldName == null) {
                    throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_FIELD_NULL, "", i);
                }
                ValuesEmulator.put(target, f.fieldName, this.bindFieldFromPipe(pipe, target, f, this.nsDecls));
            }
        }
    }

    public String[] getIdentities() {
        String[] identArray = new String[this.identities.size()];
        for (int iCtr = 0; iCtr < identArray.length; ++iCtr) {
            identArray[iCtr] = (String)this.identities.elementAt(iCtr);
        }
        return identArray;
    }

    public List getIdentitiesInOrder() {
        return this.identitiesInOrder;
    }

    private Object bindFieldFromPipe(IData pipe, IData target, QueryBindField field, Values nsDecls) throws Exception {
        Object pipeVal = ValuesEmulator.get(pipe, "node");
        if (pipeVal == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_REF_NODE_NULL, "", field.fieldName);
        }
        if (!(pipeVal instanceof Node) && !(pipeVal instanceof IData)) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_NODE_PARAM_BAD, "");
        }
        Object result = pipeVal;
        return this.bindField(pipeVal, field, nsDecls, result);
    }

    private Object bindField(Object node, QueryBindField field, Values nsDecls, Object result) throws Exception {
        int iCtr;
        if (field.queryType == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_TYPE_NULL, "", field.fieldName);
        }
        if (field.query == null || field.query.length() == 0) {
            if (field.fields != null) {
                field.children = QueryDocWithIdentity.createFields(field.fields);
                if (field.children == null) {
                    return null;
                }
                return this.executeChildren(field.children, result);
            }
            return null;
        }
        TreeExpression query = TreeExpression.create(field.queryType, field.query, nsDecls);
        if (field.fieldType != null && field.fieldType.length() > 0) {
            int dim = 0;
            if (field.fieldType.indexOf("[][]") > 0) {
                dim = 2;
            } else if (field.fieldType.indexOf("[]") > 0) {
                dim = 1;
            }
            if (field.fieldType.startsWith("Record")) {
                switch (dim) {
                    case 2: {
                        result = query.getNodeTableWithIdentities(node);
                        break;
                    }
                    case 1: {
                        if (node instanceof Node) {
                            result = query.getNodeArrayWithIdentities(node);
                            break;
                        }
                        result = query.getIDataArrayWithIdentities(node);
                        break;
                    }
                    default: {
                        result = node instanceof Node ? query.getNodeWithIdentities(node) : query.getIDataWithIdentities(node);
                    }
                }
                this.identitiesInOrder.addElement(query.getIdentities());
                if (result != null && field.fields != null) {
                    field.children = QueryDocWithIdentity.createFields(field.fields);
                    if (field.children == null) {
                        return null;
                    }
                    result = this.executeChildren(field.children, result);
                }
            } else if (field.fieldType.startsWith("Object")) {
                switch (dim) {
                    case 1: 
                    case 2: {
                        result = query.getObjectArrayWithIdentities(node);
                        break;
                    }
                    default: {
                        result = query.getObjectWithIdentities(node);
                    }
                }
                this.identitiesInOrder.addElement(query.getIdentities());
            } else {
                switch (dim) {
                    case 2: {
                        result = query.getStringTableWithIdentities(node);
                        break;
                    }
                    case 1: {
                        result = query.getStringArrayWithIdentities(node);
                        break;
                    }
                    default: {
                        result = query.getStringWithIdentities(node);
                    }
                }
            }
        } else {
            result = query.getBestResultsWithIdentities(node);
            field.fieldType = query.getBestResultType();
        }
        Object ident = query.getIdentities();
        if (ident instanceof String) {
            this.identities.addElement(ident);
        } else if (ident instanceof String[]) {
            String[] identArray = (String[])ident;
            for (iCtr = 0; iCtr < identArray.length; ++iCtr) {
                if (identArray[iCtr] == null) continue;
                this.identities.addElement(identArray[iCtr]);
            }
        } else if (ident instanceof String[][]) {
            String[][] identTable = (String[][])ident;
            for (iCtr = 0; iCtr < identTable.length; ++iCtr) {
                for (int jCtr = 0; jCtr < identTable[0].length; ++jCtr) {
                    if (identTable[iCtr][jCtr] == null) continue;
                    this.identities.addElement(identTable[iCtr][jCtr]);
                }
            }
        } else if (ident != null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.QUERYDOC_IDENT_UNK_TYPE, "");
        }
        return result;
    }

    private Object executeChildren(Vector v, Object result) throws Exception {
        if (result instanceof Node[]) {
            Node[] n = (Node[])result;
            Values[] newres = new Values[n.length];
            for (int j = 0; j < newres.length; ++j) {
                newres[j] = new Values();
                if (n[j] == null) continue;
                int vSize = v.size();
                for (int i = 0; i < vSize; ++i) {
                    QueryBindField qb = (QueryBindField)v.elementAt(i);
                    newres[j].put(qb.fieldName, this.bindField(n[j], qb, this.nsDecls, result));
                }
            }
            result = newres;
        } else if (result instanceof Node) {
            Values newres = new Values();
            int vSize = v.size();
            for (int i = 0; i < vSize; ++i) {
                QueryBindField qb = (QueryBindField)v.elementAt(i);
                newres.put(qb.fieldName, this.bindField((Node)result, qb, this.nsDecls, result));
            }
            result = newres;
        } else if (result instanceof IData[]) {
            IData[] n = result;
            Values[] newres = new Values[n.length];
            for (int j = 0; j < newres.length; ++j) {
                newres[j] = new Values();
                if (n[j] == null) continue;
                int vSize = v.size();
                for (int i = 0; i < vSize; ++i) {
                    QueryBindField qb = (QueryBindField)v.elementAt(i);
                    newres[j].put(qb.fieldName, this.bindField(n[j], qb, this.nsDecls, result));
                }
            }
            result = newres;
        } else if (result instanceof IData) {
            Values newres = new Values();
            int vSize = v.size();
            for (int i = 0; i < vSize; ++i) {
                QueryBindField qb = (QueryBindField)v.elementAt(i);
                newres.put(qb.fieldName, this.bindField(result, qb, this.nsDecls, result));
            }
            result = newres;
        }
        return result;
    }

    private static void dumpResult(QueryBindField qbf, Object node, Object result) {
        System.out.println("QueryDocWithIdentity field:'" + qbf.fieldName + "' query:'" + qbf.query + "' node:" + node + " resultType:" + qbf.fieldType);
        if (result instanceof String) {
            System.out.println("  QueryDocWithIdentity String result:'" + (String)result + "'");
        } else if (result instanceof String[]) {
            String[] strArray = (String[])result;
            for (int iCtr = 0; iCtr < strArray.length; ++iCtr) {
                System.out.println("  QueryDocWithIdentity String[] result[" + iCtr + "]:'" + strArray[iCtr] + "'");
            }
        } else if (result instanceof String[][]) {
            String[][] strTable = (String[][])result;
            for (int iCtr = 0; iCtr < strTable.length; ++iCtr) {
                for (int jCtr = 0; jCtr < strTable[0].length; ++jCtr) {
                    System.out.println("  QueryDocWithIdentity String[][] result[" + iCtr + "][" + jCtr + "]:'" + strTable[iCtr][jCtr] + "'");
                }
            }
        } else if (result instanceof Node) {
            Node nodeResult = (Node)result;
            System.out.println("  QueryDocWithIdentity Node result:" + nodeResult.getPosition());
        } else if (result instanceof Node[]) {
            Node[] nodeArray = (Node[])result;
            for (int jCtr = 0; jCtr < nodeArray.length; ++jCtr) {
                System.out.println("  QueryDocWithIdentity Node[] result:" + nodeArray[jCtr].getPosition());
            }
        } else if (result instanceof IData) {
            IData nodeResult = (IData)result;
            System.out.println("  QueryDocWithIdentity IData result:" + nodeResult);
        } else if (result instanceof IData[]) {
            IData[] nodeArray = (IData[])result;
            for (int jCtr = 0; jCtr < nodeArray.length; ++jCtr) {
                System.out.println("  QueryDocWithIdentity IData[] result:" + nodeArray[jCtr]);
            }
        } else if (result == null) {
            System.out.println("  QueryDocWithIdentity result: null");
        } else if (result instanceof IData) {
            System.out.println("  QueryDocWithIdentity IData type result:" + result);
        } else if (result instanceof IData[]) {
            IData[] resValArray = (IData[])result;
            for (int jCtr = 0; jCtr < resValArray.length; ++jCtr) {
                System.out.println("  QueryDocWithIdentity IData[" + jCtr + "] type result:" + resValArray[jCtr]);
            }
        } else {
            System.out.println("  QueryDocWithIdentity other type result:" + result);
        }
    }
}

