/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.KeyInfo;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.util.ExtBitSet;
import com.wm.util.LocalizedException;
import java.util.Calendar;
import java.util.Date;

public class PackageKeyInfo
extends KeyInfo {
    protected int cust_id = -1;
    protected int seq_id = -1;
    protected int type = NO_KEY;
    protected int licenses = 2;
    protected Date expires;
    protected String pkgName;
    protected String keyString;

    public String toString() {
        return "key: " + this.cust_id + ", " + this.seq_id + ", " + this.type + ", " + this.licenses + ", " + this.expires + "," + this.pkgName;
    }

    public boolean isPackage() {
        return (this.type & PACKAGE) > 0;
    }

    public boolean hasExpired() {
        return this.expires == null || new Date().after(this.expires);
    }

    public Date getExpireDate() {
        return this.expires;
    }

    public String getKeyString() {
        return this.keyString;
    }

    public String getPackageName() {
        return this.pkgName;
    }

    public PackageKeyInfo(String key) throws Exception {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (key == null || key.length() < 12) {
            this.cust_id = -1;
            this.seq_id = -1;
            this.type = NO_KEY;
            this.licenses = 2;
            this.expires = null;
            this.pkgName = null;
        }
        this.keyString = key;
        try {
            byte[] b = this.getKeyBytes2(key);
            if (b == null) {
                throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.KEYINFO_INVALID_KEY, "");
            }
            byte[] c = new byte[2];
            byte[] s = new byte[2];
            byte[] t = new byte[2];
            byte[] l = new byte[2];
            byte[] d = new byte[3];
            System.arraycopy(b, 0, c, 0, 2);
            System.arraycopy(b, 2, s, 0, 2);
            System.arraycopy(b, 4, t, 0, 2);
            System.arraycopy(b, 6, l, 0, 2);
            System.arraycopy(b, 8, d, 0, 3);
            this.cust_id = PackageKeyInfo.byteToInt2(c);
            this.seq_id = PackageKeyInfo.byteToInt2(s);
            this.type = PackageKeyInfo.byteToInt2(t);
            this.licenses = PackageKeyInfo.byteToInt2(l);
            short year = d[2];
            if (year < 0) {
                year = (short)(year + 256);
            }
            Calendar cal = Calendar.getInstance();
            cal.set(year + 1900, d[1], d[0], 0, 0, 0);
            this.expires = cal.getTime();
        }
        catch (Exception e) {
            this.cust_id = -1;
            this.seq_id = -1;
            this.type = NO_KEY;
            this.licenses = 2;
            this.expires = null;
        }
    }

    private byte[] getKeyBytes2(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        key = key.toUpperCase();
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == ' ') continue;
            sb.append(key.charAt(i));
        }
        key = PackageKeyInfo.byteUnMap(sb.toString().getBytes());
        if (key.length() < 26) {
            return null;
        }
        byte[] rbs = key.substring(0, 4).getBytes();
        byte[] kbs = key.substring(4, 22).getBytes();
        byte[] cbs = key.substring(22, 26).getBytes();
        byte[] pbs = key.substring(28, key.length()).getBytes();
        ExtBitSet nrbs = new ExtBitSet(rbs, 5, 8);
        ExtBitSet nkbs = new ExtBitSet(kbs, 5, 8);
        nkbs.xor(nrbs);
        byte[] kbytes = nkbs.getBytes(8);
        ExtBitSet pkbs = new ExtBitSet(pbs, 5, 8);
        pkbs.xor(nrbs);
        this.pkgName = new String(pkbs.getBytes(8));
        ExtBitSet ncbs = new ExtBitSet(cbs, 5, 8);
        int cksum = PackageKeyInfo.byteToInt2(ncbs.getBytes(8));
        if (cksum != PackageKeyInfo.checksum(kbytes) && cksum != PackageKeyInfo.checksum2(kbytes)) {
            return null;
        }
        return kbytes;
    }
}

