/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.ClientException;
import com.wm.app.b2b.util.QueryDocument;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.NodeCriterion;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.Values;
import com.wm.util.coder.RemoteReferenceCodable;
import java.util.Hashtable;

public class NodeIterator
implements RemoteReferenceCodable {
    static NodeCriterion[] defaultCriteria;
    com.wm.lang.xml.NodeIterator iterator;
    Hashtable uriToPrefix;
    IData result = IDataFactory.create();
    IDataCursor cresult = this.result.getCursor();

    public NodeIterator(IData pipeline) throws Exception {
        NodeCriterion[] criteria;
        Values nsDecls;
        IDataCursor idc = pipeline.getCursor();
        Object nodeObj = null;
        if (idc.first("node")) {
            nodeObj = idc.getValue();
        }
        if (nodeObj == null) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.NODE_MISSING_PARAM, "", "node");
        }
        if (!(nodeObj instanceof Node)) {
            throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.NODE_MISSING_PARAM, "", "node");
        }
        Node node = (Node)nodeObj;
        Object nsd = null;
        if (idc.first("nsDecls")) {
            nsd = idc.getValue();
        }
        if ((nsDecls = QueryDocument.createNsDecls(nsd, "getNodeIterator")).size() != 0) {
            this.uriToPrefix = new Hashtable();
            String[] keys = nsDecls.getValueKeys();
            for (int i = 0; i < keys.length; ++i) {
                this.uriToPrefix.put(nsDecls.get(keys[i]), keys[i]);
            }
        }
        String[] patterns = null;
        if (idc.first("criteria")) {
            patterns = (String[])idc.getValue();
        }
        if (patterns == null) {
            if (defaultCriteria == null) {
                NodeCriterion defaultCriterion = new NodeCriterion("*:*", null);
                defaultCriteria = new NodeCriterion[1];
                NodeIterator.defaultCriteria[0] = defaultCriterion;
            }
            criteria = defaultCriteria;
        } else {
            criteria = new NodeCriterion[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                criteria[i] = new NodeCriterion(patterns[i], nsDecls);
            }
        }
        String movingWindowStr = null;
        if (idc.first("movingWindow")) {
            movingWindowStr = (String)idc.getValue();
        }
        idc.destroy();
        boolean movingWindow = false;
        if (movingWindowStr != null && movingWindowStr.equalsIgnoreCase("true")) {
            movingWindow = true;
        }
        this.iterator = new com.wm.lang.xml.NodeIterator(node, criteria, movingWindow);
    }

    public IData getNextResult() throws WMDocumentException {
        Node node = this.iterator.getNextNode();
        if (node == null) {
            return null;
        }
        Name uri = node.getNamespaceUri();
        String prefix = null;
        if (uri != null) {
            if (this.uriToPrefix != null) {
                prefix = (String)this.uriToPrefix.get(uri);
            }
            if (prefix == null) {
                prefix = node.getNamespacePrefix() == null ? null : node.getNamespacePrefix().toString();
            }
        }
        String name = node.getLocalNameWm().toString();
        if (prefix != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(prefix);
            sb.append(':');
            sb.append(name);
            name = sb.toString();
        }
        if (this.cresult.first("name")) {
            this.cresult.setValue(name);
        } else {
            this.cresult.last();
            this.cresult.insertAfter("name", name);
        }
        if (this.cresult.first("node")) {
            this.cresult.setValue(node);
        } else {
            this.cresult.last();
            this.cresult.insertAfter("node", node);
        }
        return this.result;
    }

    public String getValue() {
        return "com.wm.app.b2b.util.NodeIterator:" + Integer.toString(this.hashCode());
    }

    public void setValue(String val) {
    }
}

