/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.Text;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSignature;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import java.util.Vector;

public class MethodInfo
implements ValuesCodable,
Sortable {
    String name;
    String body;
    String[] imports;
    NSSignature sig;
    String spec;
    boolean encoded;
    boolean decode = false;
    boolean encodeUtf8;
    String subtype;
    String sigtype;
    boolean stateless;
    public static final String KEY_NAME = "name";
    public static final String KEY_BODY = "body";
    public static final String KEY_IMPORTS = "imports";
    public static final String KEY_SIGNATURE = "sig";
    public static final String KEY_SPECIFICATION = "spec";
    public static final String KEY_SUBTYPE = "subtype";
    public static final String KEY_SIGTYPE = "sigtype";
    public static final String KEY_STATELESS = "stateless";
    public static final String KEY_ENCODEUTF8 = "encodeutf8";

    public MethodInfo(String body, String[] imports) {
        this(null, body, imports);
    }

    public MethodInfo(String name, String body, String[] imports) {
        this.name = name;
        this.body = body;
        this.imports = imports;
        this.encoded = true;
        this.encodeUtf8 = false;
    }

    public MethodInfo(Values val) {
        this(val, true);
    }

    public MethodInfo(Values val, boolean encoded) {
        this.encoded = encoded;
        this.setValues(val);
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.body;
    }

    public String[] getImports() {
        return this.imports;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public boolean isEncodeUtf8() {
        return this.encodeUtf8;
    }

    public NSSignature getSignature() {
        return this.sig;
    }

    public String getSpecification() {
        return this.spec;
    }

    public String getServiceSubtype() {
        return this.subtype;
    }

    public String getServiceSigtype() {
        return this.sigtype;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String body) {
        this.body = body;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }

    public void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    public void setDecodeUnicode(boolean decode) {
        this.decode = decode;
    }

    public void setEncodeUtf8(boolean encodeUtf8) {
        this.encodeUtf8 = encodeUtf8;
    }

    public void setSignature(NSSignature sig) {
        this.sig = sig;
    }

    public void setSpecification(String spec) {
        this.spec = spec;
    }

    public void setServiceSubtype(String subtype) {
        this.subtype = subtype;
    }

    public void setServiceSigtype(String sigtype) {
        this.sigtype = sigtype;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public int compare(Sortable compare, boolean reverse, int which) {
        if (compare == null || !(compare instanceof MethodInfo) || this.name == null) {
            return 0;
        }
        if (((MethodInfo)compare).name == null) {
            return 0;
        }
        int ret = this.name.compareTo(((MethodInfo)compare).name);
        if (reverse) {
            ret = 0 - ret;
        }
        return ret;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_NAME, this.name}, {KEY_SIGNATURE, this.encodeSig(this.sig)}, {KEY_SPECIFICATION, this.spec}, {KEY_SUBTYPE, this.subtype}, {KEY_SIGTYPE, this.sigtype}, {KEY_ENCODEUTF8, this.encodeUtf8 ? "true" : "false"}};
        Values v = new Values(o);
        if (this.body != null) {
            this.body = !this.decode ? EncUtil.encodeUnicode(this.body) : EncUtil.decodeUnicode(this.body);
        }
        if (this.encoded) {
            if (this.encodeUtf8) {
                v.put(KEY_BODY, Base64.encodeUTF8(this.body));
            } else {
                v.put(KEY_BODY, Base64.encode(this.body));
            }
        } else {
            v.put(KEY_BODY, this.body);
        }
        return v;
    }

    String[] encodeSig(NSSignature sig) {
        if (sig == null) {
            return null;
        }
        Vector v = new Vector();
        this.encodeField(v, sig.getInput(), -1, true);
        this.encodeField(v, sig.getOutput(), -1, false);
        if (v.size() == 0) {
            return null;
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    void encodeField(Vector v, NSField field, int depth, boolean in) {
        NSField[] f;
        if (field == null) {
            return;
        }
        if (field.getName() != null && depth >= 0) {
            v.addElement(field.getSigString(in, depth));
        }
        if (field instanceof NSRecord && (f = ((NSRecord)field).getFieldNodes()) != null) {
            for (int i = 0; i < f.length; ++i) {
                this.encodeField(v, f[i], depth + 1, in);
            }
        }
    }

    public void setValues(Values val) {
        if (val == null) {
            this.encoded = true;
            return;
        }
        this.name = val.getString(KEY_NAME);
        this.encodeUtf8 = val.getBoolean(KEY_ENCODEUTF8);
        this.body = this.encoded ? (this.encodeUtf8 ? Base64.decodeUTF8(val.getString(KEY_BODY)) : Base64.decode(val.getString(KEY_BODY))) : val.getString(KEY_BODY);
        this.imports = (String[])val.get(KEY_IMPORTS);
        this.subtype = val.getString(KEY_SUBTYPE);
        this.sigtype = val.getString(KEY_SIGTYPE);
        String stStr = val.getString(KEY_STATELESS);
        this.stateless = stStr != null && stStr.equalsIgnoreCase("yes");
        this.encoded = true;
    }

    public void padBody() {
        this.body = Text.indent(this.body);
    }
}

