/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.ClientException;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.util.EncUtil;
import com.wm.util.ExtBitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;

public class KeyInfo {
    public static int NO_KEY = 0;
    public static int SERVER_B2B = 1;
    public static int TOOLKIT = 2;
    public static int TOOLKIT_PRO = 4;
    public static int PARTNER = 8;
    public static int BEEFCAKE = 16;
    public static int TN_SERVER = 32;
    public static int OEM = 64;
    public static int UNUSED3 = 128;
    public static int PACKAGE = 256;
    public static final int TN_UNLIMITED = -1;
    public static final int IS_UNLIMITED = 0;
    protected static Random rand = new Random();
    protected static final byte[] cmap = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 56, 74, 75, 76, 77, 57, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 49, 50, 51, 52, 53, 54, 55};
    protected static int cust_id = -1;
    protected static int seq_id = -1;
    protected static int type = NO_KEY;
    protected static int licenses = 2;
    protected static Date expires;
    protected static int tnLicenses;

    public static int getCustID() {
        return cust_id;
    }

    public static int getSeqID() {
        return seq_id;
    }

    public static int getType() {
        return type;
    }

    public static int getLicenses() {
        return licenses == 0 ? Integer.MAX_VALUE : licenses;
    }

    public static int getTNLicenses() {
        return tnLicenses;
    }

    public static Date getExpires() {
        return expires;
    }

    public static boolean isPartner() {
        return KeyInfo.isType(PARTNER);
    }

    public static boolean isServer() {
        return KeyInfo.isType(SERVER_B2B);
    }

    public static boolean isBeefcake() {
        return KeyInfo.isType(BEEFCAKE);
    }

    public static boolean isTNServer() {
        return KeyInfo.isType(TN_SERVER);
    }

    public static boolean isTNPartner() {
        return KeyInfo.isType(TN_SERVER & PARTNER);
    }

    public static boolean isOEMVersion() {
        return KeyInfo.isType(OEM);
    }

    public static boolean isType(int t) {
        return (type & t) > 0;
    }

    public static boolean isExpired() {
        return expires == null || new Date().after(expires);
    }

    public static boolean willExpire() {
        Calendar c = Calendar.getInstance(TimeZone.getDefault(), Locale.US);
        c.add(2, 1);
        return expires == null || c.after(expires);
    }

    public static String getString() {
        String keyInfo = "key: " + cust_id + ", " + seq_id + ", " + type + ", " + (licenses == 0 ? "unlimited" : Integer.toString(licenses)) + ", " + expires;
        if (KeyInfo.isType(TN_SERVER) && KeyInfo.isType(PARTNER)) {
            keyInfo = keyInfo + "\n\tTN Partner :" + (tnLicenses == -1 ? "unlimited" : Integer.toString(tnLicenses));
        } else if (KeyInfo.isType(TN_SERVER)) {
            keyInfo = keyInfo + "\n\tTN Server :" + (tnLicenses == -1 ? "unlimited" : Integer.toString(tnLicenses));
        }
        return keyInfo;
    }

    public static void setKey(String key) {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (key == null || key.length() < 12) {
            cust_id = -1;
            seq_id = -1;
            type = NO_KEY;
            licenses = 2;
            expires = null;
        }
        try {
            short year;
            byte[] b = KeyInfo.getKeyBytes(key);
            if (b == null) {
                throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.KEYINFO_INVALID_KEY, "");
            }
            byte[] c = new byte[2];
            byte[] s = new byte[2];
            byte[] t = new byte[2];
            byte[] l = new byte[2];
            byte[] d = new byte[3];
            System.arraycopy(b, 0, c, 0, 2);
            System.arraycopy(b, 2, s, 0, 2);
            System.arraycopy(b, 4, t, 0, 2);
            System.arraycopy(b, 6, l, 0, 2);
            System.arraycopy(b, 8, d, 0, 3);
            cust_id = KeyInfo.byteToInt2(c);
            seq_id = KeyInfo.byteToInt2(s);
            type = KeyInfo.byteToInt2(t);
            licenses = KeyInfo.byteToInt2(l);
            if (KeyInfo.isType(TN_SERVER)) {
                KeyInfo.computeTNLicenses(d);
            }
            if ((year = (short)d[2]) < 0) {
                year = (short)(year + 256);
            }
            Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.US);
            cal.set(year + 1900, d[1], d[0], 0, 0, 0);
            expires = cal.getTime();
        }
        catch (Exception e) {
            cust_id = -1;
            seq_id = -1;
            type = NO_KEY;
            licenses = 2;
            expires = null;
        }
    }

    protected static void computeTNLicenses(byte[] b) {
        byte day;
        if ((b[0] & 2) == 2) {
            tnLicenses = -1;
        } else {
            byte nibble = (byte)((b[0] & 0xC0) >> 6);
            int multiplier = 1;
            if (nibble == 1) {
                multiplier = 10;
            } else if (nibble == 2) {
                multiplier = 100;
            } else if (nibble == 3) {
                multiplier = 1000;
            }
            int number = (b[0] & 0x3F) >>> 2;
            tnLicenses = number * multiplier;
        }
        byte month = (byte)(b[1] & 0xF);
        b[0] = day = (byte)((b[1] & 0xF0) >> 4 | (b[0] & 1) << 4);
        b[1] = month;
    }

    protected static int checksum(byte[] b) {
        int ck = 0;
        for (int i = 0; i < b.length; ++i) {
            ck = ck * b[i] + 1;
        }
        return ck & 0xFFFF;
    }

    protected static int checksum2(byte[] b) {
        int ck = 13;
        for (int i = 0; i < b.length; ++i) {
            ck = ck * ck * b[i] * b[i] * 13 + 11;
        }
        return ck & 0xFFFF;
    }

    protected static int byteToInt2(byte[] b) {
        if (b == null || b.length != 2) {
            return -1;
        }
        return b[0] & 0xFF | (b[1] & 0xFF) << 8;
    }

    protected static byte[] getKeyBytes(String key) {
        if (key == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        key = key.toUpperCase();
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == ' ') continue;
            sb.append(key.charAt(i));
        }
        key = KeyInfo.byteUnMap(EncUtil.getNetBytes(sb.toString()));
        if (key.length() < 26) {
            return null;
        }
        byte[] rbs = EncUtil.getNetBytes(key.substring(0, 4));
        byte[] kbs = EncUtil.getNetBytes(key.substring(4, 22));
        byte[] cbs = EncUtil.getNetBytes(key.substring(22, 26));
        ExtBitSet nrbs = new ExtBitSet(rbs, 5, 8);
        ExtBitSet nkbs = new ExtBitSet(kbs, 5, 8);
        nkbs.xor(nrbs);
        byte[] kbytes = nkbs.getBytes(8);
        ExtBitSet ncbs = new ExtBitSet(cbs, 5, 8);
        int cksum = KeyInfo.byteToInt2(ncbs.getBytes(8));
        if (cksum != KeyInfo.checksum(kbytes) && cksum != KeyInfo.checksum2(kbytes)) {
            return null;
        }
        return kbytes;
    }

    protected static String byteUnMap(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length);
        for (int i = 0; i < b.length; ++i) {
            int j;
            for (j = 0; j < cmap.length && b[i] != cmap[j]; ++j) {
            }
            if (j == cmap.length) continue;
            sb.append((char)j);
        }
        return sb.toString();
    }

    static {
        tnLicenses = 0;
    }
}

