/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.data.IData;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.JournalLogger;
import com.wm.util.Name;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class GetDocAsTable
implements ValuesCodable {
    public static final int CORSVC0007 = 7;
    Node root;
    Vector list;
    String[][] table;
    Values nsdeclList;
    int index;
    Hashtable uriList;
    public static final String DOCUMENTNODE = "1";
    public static final String ELEMENTNODE = "2";
    public static final String TEXTNODE = "3";
    public static final String CDATANODE = "4";
    public static final String PINODE = "5";
    public static final String COMMENTNODE = "6";
    public static final String SOURCENODE = "7";
    public static final String ATTRIBUTENODE = "14";
    public static final String PROXYNODE = "16";
    public static final String REGIONNODE = "32";
    public static final String COMMENT_NAME = "Comment";

    private String nodeTypeToString(int type) {
        String ret;
        switch (type) {
            case 1: {
                ret = ELEMENTNODE;
                break;
            }
            case 9: {
                ret = DOCUMENTNODE;
                break;
            }
            case 3: {
                ret = TEXTNODE;
                break;
            }
            case 4: {
                ret = CDATANODE;
                break;
            }
            case 7: {
                ret = PINODE;
                break;
            }
            case 8: {
                ret = COMMENTNODE;
                break;
            }
            default: {
                JournalLogger.logDebug(7, 62, new Integer(type));
                ret = "";
            }
        }
        return ret;
    }

    public GetDocAsTable(IData root) throws WMDocumentException {
        this.list = new Vector();
        int lSize = this.list.size();
        this.table = new String[lSize][6];
        for (int i = 0; i < lSize; ++i) {
            ODPair od = (ODPair)this.list.elementAt(i);
            Object o = od.o;
            if (o instanceof IData) {
                // empty if block
            }
            this.table[i][0] = "key";
            this.table[i][1] = this.nodeTypeToString(1);
            this.table[i][2] = Integer.toString(od.d);
            this.table[i][3] = "value";
            this.table[i][4] = od.position;
            this.table[i][5] = null;
        }
        this.uriList = null;
    }

    public GetDocAsTable(Node el) throws WMDocumentException {
        this.root = el;
        this.list = new Vector();
        Document doc = el.getDocument();
        this.nsdeclList = doc.getNamespaces();
        this.uriList = GetDocAsTable.makeURIList(this.nsdeclList);
        this.addNodes(el, 0);
        int lSize = this.list.size();
        this.table = new String[lSize][6];
        for (int i = 0; i < lSize; ++i) {
            String prefix;
            ODPair od = (ODPair)this.list.elementAt(i);
            Object o = od.o;
            if (o instanceof Attribute) {
                Attribute a = (Attribute)o;
                prefix = od.nsprefix;
                this.table[i][0] = prefix != null ? prefix + ":" + a.getLocalNameWm().toString() : a.getLocalNameWm().toString();
                this.table[i][1] = ATTRIBUTENODE;
                this.table[i][2] = Integer.toString(od.d);
                this.table[i][3] = a.getValue();
                this.table[i][4] = od.position;
                this.table[i][5] = od.nsprefix;
                continue;
            }
            Node e = (Node)o;
            prefix = od.nsprefix;
            short type = e.getNodeType();
            if (type == 8) {
                this.table[i][0] = COMMENT_NAME;
            } else if (type == 7) {
                this.table[i][0] = e.getPITarget().toString();
            } else if (prefix != null) {
                this.table[i][0] = prefix + ":" + e.getLocalNameWm().toString();
            } else if (e.getLocalNameWm() != null) {
                this.table[i][0] = e.getLocalNameWm().toString();
            }
            this.table[i][1] = this.nodeTypeToString(e.getNodeType());
            this.table[i][2] = Integer.toString(od.d);
            try {
                short type2 = e.getNodeType();
                this.table[i][3] = type2 == 7 ? e.getPIData() : (type2 == 8 ? e.getComment() : e.getTextOfChildren());
            }
            catch (WMDocumentException we) {
                this.table[i][3] = "";
            }
            this.table[i][4] = od.position;
            this.table[i][5] = od.nsprefix;
        }
    }

    Node getNode(int idx) {
        Object o = this.list.elementAt(idx);
        if (o instanceof Node) {
            return (Node)o;
        }
        return null;
    }

    void addNodes(Node el, int depth) throws WMDocumentException {
        if (el == null || el.getNodeType() == 3 || el.isFalseNode()) {
            return;
        }
        String prefixstring = null;
        if (el.getNamespaceUri() != null) {
            prefixstring = (String)this.uriList.get(el.getNamespaceUri().toString());
        }
        if (prefixstring == null && el.getNamespacePrefix() != null) {
            prefixstring = el.getNamespacePrefix().toString();
        }
        int position = el.getPosition();
        this.list.addElement(new ODPair(el, depth, prefixstring, position));
        for (Attribute attr = el.getFirstAttribute(); attr != null; attr = attr.getNext()) {
            String prefstring = null;
            if (attr.getNamespaceUri() != null) {
                prefstring = (String)this.uriList.get(attr.getNamespaceUri().toString());
            }
            if (prefstring == null && attr.getNamespacePrefix() != null) {
                prefstring = attr.getNamespacePrefix().toString();
            }
            this.list.addElement(new ODPair(attr, depth + 1, prefstring, position));
        }
        Node child = el.getFirstChildWm();
        while (child != null) {
            this.addNodes(child, depth + 1);
            child = el.getNextSiblingOfChild(child);
        }
    }

    public Values getValues() {
        Values v = new Values();
        String systemID = "";
        String publicID = "";
        if (this.root != null) {
            try {
                systemID = this.root.getDocument().getSystemId();
                publicID = this.root.getDocument().getPublicId();
            }
            catch (WMDocumentException x) {
                // empty catch block
            }
        }
        v.put("systemID", systemID);
        v.put("publicID", publicID);
        String[][] o = this.getNSDecls();
        v.put("nsDecls", o);
        v.put("nodes", this.table);
        return v;
    }

    String[][] getNSDecls() {
        String[][] nsstrings = new String[][]{{""}};
        if (this.nsdeclList == null || this.nsdeclList.size() == 0) {
            return nsstrings;
        }
        nsstrings = new String[this.nsdeclList.size()][2];
        Enumeration keys = this.nsdeclList.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String nextkey = (String)keys.nextElement();
            Name value = (Name)this.nsdeclList.get(nextkey);
            nsstrings[i][0] = nextkey;
            nsstrings[i][1] = value.toString();
            ++i;
        }
        return nsstrings;
    }

    private static Hashtable makeURIList(Values nsdeclList) {
        Hashtable<String, String> uriList = new Hashtable<String, String>();
        if (nsdeclList != null) {
            Enumeration keys = nsdeclList.keys();
            while (keys.hasMoreElements()) {
                String nextkey = (String)keys.nextElement();
                String value = ((Name)nsdeclList.get(nextkey)).toString();
                uriList.put(value, nextkey);
            }
        }
        return uriList;
    }

    public void setValues(Values v) {
    }

    class ODPair {
        Object o;
        int d;
        String nsprefix;
        String position;

        ODPair(Object o, int d, String prefix, int position) {
            this.o = o;
            this.d = d;
            this.nsprefix = prefix;
            this.position = Integer.toString(position);
        }
    }
}

