/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.ClientException;
import com.wm.app.b2b.util.GenerateQueryString;
import com.wm.app.b2b.util.QueryBindField;
import com.wm.app.b2b.util.QueryDocWithIdentity;
import com.wm.app.b2b.util.QueryDocument;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.LocalizedException;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Vector;

public class GenerateQueryStrings
implements ValuesCodable {
    public static final int CORSVC0001 = 1;
    public static final int CORSVC0004 = 4;
    public static final int CORSVC0005 = 5;
    public static final int CORSVC0006 = 6;
    public static final boolean DEBUG = true;
    Vector fields;
    Values nsDecls;
    Vector nodeIDs;
    String attribute;
    String queryType;
    boolean textQuery;
    public static final String GQS_NODE = "node";
    public static final String GQS_NODEIDS = "identities";
    public static final String GQS_FIELDS = "fields";
    public static final String GQS_NSDECLS = "nsDecls";
    public static final String GQS_ATTRIBUTE = "attribute";
    public static final String GQS_QUERYTYPE = "queryType";

    private GenerateQueryStrings(Values val) {
        this.setValues(val);
    }

    public static GenerateQueryStrings create(Values val) {
        if (val == null) {
            return null;
        }
        return new GenerateQueryStrings(val);
    }

    private GenerateQueryStrings(IData val) {
        this.setIData(val);
    }

    public static GenerateQueryStrings create(IData val) {
        if (val == null) {
            return null;
        }
        return new GenerateQueryStrings(val);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{GQS_FIELDS, this.fields}, {GQS_NSDECLS, this.nsDecls}, {GQS_ATTRIBUTE, this.attribute}, {GQS_QUERYTYPE, this.queryType}, {GQS_NODEIDS, this.nodeIDs}, {"textQuery", this.textQuery ? "true" : "false"}};
        return new Values(o);
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        this.attribute = val.getString(GQS_ATTRIBUTE);
        this.queryType = val.getString(GQS_QUERYTYPE);
        this.fields = GenerateQueryStrings.createFields(val.get(GQS_FIELDS));
        this.createNodeIDs(val.get(GQS_NODEIDS));
        this.nsDecls = QueryDocument.createNsDecls(val.get(GQS_NSDECLS), "GenerateQueryStrings");
        String nok = val.getString("textQuery");
        this.textQuery = nok == null || !nok.equalsIgnoreCase("false");
    }

    public void setIData(IData val) {
        if (val == null) {
            return;
        }
        IDataCursor id = val.getCursor();
        this.attribute = IDataUtil.getString(id, GQS_ATTRIBUTE);
        this.queryType = IDataUtil.getString(id, GQS_QUERYTYPE);
        this.fields = GenerateQueryStrings.createFields(IDataUtil.get(id, GQS_FIELDS));
        this.createNodeIDs(IDataUtil.get(id, GQS_NODEIDS));
        this.nsDecls = QueryDocument.createNsDecls(IDataUtil.get(id, GQS_NSDECLS), "GenerateQueryStrings");
        String nok = IDataUtil.getString(id, "textQuery");
        this.textQuery = nok == null || !nok.equalsIgnoreCase("false");
        id.destroy();
    }

    static Vector createFields(Object o) {
        Vector<QueryBindField> fields = null;
        if (o instanceof Vector) {
            fields = (Vector<QueryBindField>)o;
            int fSize = fields.size();
            for (int i = 0; i < fSize; ++i) {
                fields.setElementAt(QueryBindField.create((Values)fields.elementAt(i)), i);
            }
        } else if (o instanceof Values[]) {
            Values[] v = (Values[])o;
            fields = new Vector<QueryBindField>();
            for (int i = 0; i < v.length; ++i) {
                fields.addElement(QueryBindField.create(v[i]));
            }
        } else if (o instanceof IData[]) {
            IData[] v = (IData[])o;
            fields = new Vector();
            for (int i = 0; i < v.length; ++i) {
                fields.addElement(QueryBindField.create(v[i]));
            }
        } else if (o != null) {
            JournalLogger.logDebug(4, 62, o.toString());
        }
        return fields;
    }

    void createNodeIDs(Object o) {
        if (o instanceof Vector) {
            this.nodeIDs = (Vector)o;
        } else if (o instanceof Object[]) {
            Object[] v = (Object[])o;
            this.nodeIDs = new Vector();
            for (int i = 0; i < v.length; ++i) {
                this.nodeIDs.addElement(v[i]);
            }
        } else if (o instanceof String) {
            String v = (String)o;
            this.nodeIDs = new Vector();
            this.nodeIDs.addElement(v);
        } else if (o != null) {
            JournalLogger.logDebug(5, 62, o.toString());
        }
    }

    public String[] getQueryStrings(IData pipe) throws Exception {
        Values results = new Values();
        if (this.queryType == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_TYPE_PARAM_NULL, "");
        }
        if (this.nodeIDs == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_IDENTITY_PARAM_NULL, "");
        }
        IDataCursor ic = pipe.getCursor();
        Object data = IDataUtil.get(ic, GQS_NODE);
        if (data == null) {
            ic.destroy();
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_NODE_NULL, "");
        }
        IDataUtil.put(ic, GQS_NSDECLS, this.nsDecls);
        ic.destroy();
        QueryDocWithIdentity bind = QueryDocWithIdentity.create(pipe);
        Node node = null;
        if (!(data instanceof Node)) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_IDATA_NOT_SUP, "");
        }
        node = (Node)data;
        if (bind != null) {
            bind.bindFieldsFromPipe(pipe, (IData)results);
            List identList = bind.getIdentitiesInOrder();
            Node[] correctNodes = this.getCorrectNodes(node, identList.size() > 0 ? identList.lastElement() : null);
            int size = this.nodeIDs.size();
            String[] queries = new String[size];
            Enumeration enumNodeIDs = this.nodeIDs.elements();
            for (int iCtr = 0; iCtr < size; ++iCtr) {
                Object nodeID = enumNodeIDs.nextElement();
                GenerateQueryString gqs = new GenerateQueryString(correctNodes[iCtr], this.queryType, nodeID, this.attribute, this.textQuery, this.nsDecls);
                queries[iCtr] = gqs.execute();
                JournalLogger.logDebug(9999, 62, "GenerateQueryStrings nodeID[" + iCtr + "]:" + nodeID + " parentNodeID:" + correctNodes[iCtr].getPosition() + " queryType:" + this.queryType + " attribute:'" + this.attribute + "' query:'" + queries[iCtr] + "'");
            }
            return queries;
        }
        JournalLogger.logDebug(6, 62);
        throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_BIND_FAILED, "");
    }

    private Node[] getCorrectNodes(Node node, Object identObject) throws Exception {
        Vector<Object> identities = new Vector<Object>();
        if (identObject instanceof String) {
            identities.addElement(identObject);
            JournalLogger.logDebug(9999, 62, "GenerateQueryStrings.getCorrectNodes identities:" + identObject);
        } else if (identObject instanceof String[]) {
            String[] identArray = (String[])identObject;
            for (int iCtr = 0; iCtr < identArray.length; ++iCtr) {
                if (identArray[iCtr] == null) continue;
                identities.addElement(identArray[iCtr]);
                JournalLogger.logDebug(9999, 62, "GenerateQueryStrings.getCorrectNodes identities[" + iCtr + "]:" + identArray[iCtr]);
            }
        } else if (identObject != null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_IDENTITY_UNK_TYPE, "", identObject.toString());
        }
        JournalLogger.logDebug(9999, 62, "GenerateQueryStrings.getCorrectNodes size:'" + this.nodeIDs.size() + "'");
        Node[] nodes = new Node[this.nodeIDs.size()];
        Enumeration enumNodeIDs = this.nodeIDs.elements();
        List nodePath = new List();
        int nSize = this.nodeIDs.size();
        for (int iCtr = 0; iCtr < nSize; ++iCtr) {
            if (identObject == null) {
                nodes[iCtr] = node;
                continue;
            }
            String pos = (String)enumNodeIDs.nextElement();
            int nodeId = Integer.parseInt(pos);
            Node childNode = GenerateQueryStrings.getNodePath(node, nodeId, nodePath);
            JournalLogger.logDebug(9999, 62, "GenerateQueryStrings.getCorrectNodes got childNode:'" + childNode + "'");
            Enumeration parentIndex = nodePath.elements();
            Node parentNode = null;
            boolean found = false;
            while (parentIndex.hasMoreElements()) {
                parentNode = (Node)parentIndex.nextElement();
                Integer iPos = new Integer(parentNode.getPosition());
                if (!identities.contains(iPos.toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new ClientException(ClientExceptionBundle.class, ClientExceptionBundle.GEN_QUERY_UNK_NODE_ID, "", nodeId);
            }
            JournalLogger.log(9999, 62, "GenerateQueryStrings.getCorrectNodes found[" + iCtr + "] parent:" + parentNode.getPosition());
            nodes[iCtr] = parentNode;
        }
        return nodes;
    }

    public static Node getNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        if (node.getPosition() == nodeId) {
            return node;
        }
        Node child = node.getFirstRealChild();
        while (child != null) {
            Node lookAhead = node.getNextRealSiblingOfChild(child);
            while (lookAhead != null && nodeId >= lookAhead.getPosition()) {
                child = lookAhead;
                lookAhead = node.getNextRealSiblingOfChild(lookAhead);
            }
            Node subTree = GenerateQueryStrings.getNodePath(child, nodeId, path);
            if (subTree != null) {
                path.addElement(child);
                return subTree;
            }
            child = lookAhead;
        }
        return null;
    }
}

