/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.QueryDocument;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.widl.WattException;
import com.wm.lang.xml.Node;
import com.wm.lang.xql.TreeExpression;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class GenerateQueryString
implements ValuesCodable {
    public static final int CORSVC0003 = 3;
    Object nodeID;
    String queryType;
    String attribute;
    Object node;
    boolean textQuery;
    Values nsDecls;
    static final String KEY_NODE = "node";
    static final String KEY_NODE_ID = "nodeID";
    static final String KEY_QUERY_TYPE = "queryType";
    static final String GQS_ATTRIBUTE = "attribute";
    static final String GQS_NSDECLS = "nsDecls";

    public static GenerateQueryString create(IData vals) {
        if (vals == null) {
            return null;
        }
        return new GenerateQueryString(vals);
    }

    public static GenerateQueryString create(Values vals) {
        if (vals == null) {
            return null;
        }
        return new GenerateQueryString(vals);
    }

    private GenerateQueryString(Values vals) {
        this.setValues(vals);
    }

    private GenerateQueryString(IData vals) {
        this.setIData(vals);
    }

    public GenerateQueryString(Object node, String queryType, Object nodeID, String attribute, boolean textQuery) {
        this.node = node;
        this.queryType = queryType;
        this.nodeID = nodeID;
        this.attribute = attribute;
        this.textQuery = textQuery;
        this.nsDecls = null;
    }

    public GenerateQueryString(Object node, String queryType, Object nodeID, String attribute, boolean textQuery, Values nsDecls) {
        this.node = node;
        this.queryType = queryType;
        this.nodeID = nodeID;
        this.attribute = attribute;
        this.textQuery = textQuery;
        this.nsDecls = nsDecls;
    }

    public Object getNodeID() {
        return this.nodeID;
    }

    public Object getNode() {
        return this.node;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Values getNsDecls() {
        return this.nsDecls;
    }

    public String execute() throws WattException {
        String ret = this.node instanceof Node && this.nodeID instanceof String ? TreeExpression.generateQueryString(this.queryType, this.node, new Integer((String)this.nodeID), this.attribute, this.textQuery, this.nsDecls) : TreeExpression.generateQueryString(this.queryType, this.node, this.nodeID, this.attribute, this.textQuery, this.nsDecls);
        return ret;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_NODE, this.node}, {KEY_NODE_ID, this.nodeID}, {GQS_NSDECLS, this.nsDecls}, {KEY_QUERY_TYPE, this.queryType}, {GQS_ATTRIBUTE, this.attribute}, {"textQuery", this.textQuery ? "true" : "false"}};
        return new Values(o);
    }

    public void setValues(Values vals) {
        if (vals == null) {
            return;
        }
        try {
            this.nodeID = vals.get(KEY_NODE_ID);
        }
        catch (Exception nfe) {
            JournalLogger.log(3, 62, nfe.getMessage(), (Object)vals.getString(KEY_NODE_ID));
            return;
        }
        this.node = vals.get(KEY_NODE);
        this.queryType = vals.getString(KEY_QUERY_TYPE);
        this.nsDecls = QueryDocument.createNsDecls(vals.get(GQS_NSDECLS), "GenerateQueryString");
        this.attribute = vals.getString(GQS_ATTRIBUTE);
        String nok = vals.getString("textQuery");
        this.textQuery = nok == null || !nok.equalsIgnoreCase("false");
    }

    public void setIData(IData vals) {
        if (vals == null) {
            return;
        }
        IDataCursor id = vals.getCursor();
        this.nodeID = IDataUtil.get(id, KEY_NODE_ID);
        this.node = IDataUtil.get(id, KEY_NODE);
        this.queryType = IDataUtil.getString(id, KEY_QUERY_TYPE);
        this.nsDecls = QueryDocument.createNsDecls(IDataUtil.get(id, GQS_NSDECLS), "GenerateQueryString");
        this.attribute = IDataUtil.getString(id, GQS_ATTRIBUTE);
        String nok = IDataUtil.getString(id, "textQuery");
        this.textQuery = nok == null || !nok.equalsIgnoreCase("false");
        id.destroy();
    }
}

