/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.util.EncUtil;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class GenUtil {
    public static void getRecInputs(ValuesCodable vc) {
        Values v = vc.getValues();
        GenUtil.getInputs(v);
        vc.setValues(v);
    }

    public static void getInputs(IData i) {
        try {
            BufferedReader is = new BufferedReader(new InputStreamReader(System.in, EncUtil.getFileEncoding()));
            PrintWriter os = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, EncUtil.getFileEncoding()));
            IDataCursor idc = i.getCursor();
            os.println("** Please enter the required input parameters **\n");
            idc.first();
            while (idc.next()) {
                String key = idc.getKey();
                Object o = idc.getValue();
                os.print(key + " = ");
                os.flush();
                if (o instanceof String) {
                    idc.setValue(is.readLine());
                    continue;
                }
                String[] sa = (String[])o;
                sa[0] = is.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getInputs(Values v) {
        try {
            BufferedReader is = new BufferedReader(new InputStreamReader(System.in, EncUtil.getFileEncoding()));
            PrintWriter os = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, EncUtil.getFileEncoding()));
            os.println("** Please enter the required Input parameters **\n");
            Enumeration keys = v.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object o = v.get(key);
                os.print(key + " = ");
                os.flush();
                if (o instanceof String) {
                    v.put(key, is.readLine());
                    continue;
                }
                String[] sa = (String[])o;
                sa[0] = is.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printRec(ValuesCodable vc, String name) {
        GenUtil.print(0, "DOCUMENT \"" + name + "\"");
        GenUtil.printValues(vc.getValues(), 0, 0);
    }

    public static void printRec(IData i, String name) {
        GenUtil.print(0, "DOCUMENT \"" + name + "\"");
        GenUtil.printIData(i, 0, 0);
    }

    private static void printIData(IData i, int pad, int num) {
        IDataCursor idc = i.getCursor();
        if (!idc.first()) {
            return;
        }
        do {
            String key = idc.getKey();
            GenUtil.printObject(idc.getValue(), key, pad, num);
        } while (idc.next());
    }

    private static void printValues(Values v, int pad, int num) {
        Enumeration keys = v.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            GenUtil.printObject(v.get(key), key, pad, 0);
        }
    }

    private static void printObject(Object o, String key, int pad, int num) {
        if (o == null) {
            GenUtil.print(pad, key + " = null");
        } else if (o instanceof String) {
            GenUtil.print(pad, key + (num > 0 ? "[" + (num - 1) + "] " : " ") + "= " + (String)o);
        } else if (o instanceof Values) {
            GenUtil.print(pad, key + " ==> DOCUMENT" + (num > 0 ? "[" + (num - 1) + "]" : ""));
            GenUtil.printValues((Values)o, pad + 1, 0);
        } else if (o instanceof IData) {
            GenUtil.print(pad, key + " ==> DOCUMENT" + (num > 0 ? "[" + (num - 1) + "]" : ""));
            GenUtil.printIData((IData)o, pad + 1, 0);
        } else if (o instanceof Object[]) {
            GenUtil.print(pad, key + " ==> " + (num > 0 ? "[" + (num - 1) + "]" : "") + "[]");
            Object[] oa = (Object[])o;
            int cnt = oa.length;
            for (int i = 0; i < cnt; ++i) {
                GenUtil.printObject(oa[i], key + (num > 0 ? "[" + (num - 1) + "]" : ""), pad + 1, i + 1);
            }
        } else if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            StringBuffer b = new StringBuffer();
            if (o.getClass().getComponentType().getName().equals("byte")) {
                byte[] byteArray = (byte[])o;
                for (int j = 0; j < length; ++j) {
                    b.append(byteArray[j]);
                    b.append(' ');
                }
            } else {
                for (int j = 0; j < length; ++j) {
                    b.append(Array.get(o, j));
                    b.append(' ');
                }
            }
            GenUtil.print(pad, key + (num > 0 ? "[" + (num - 1) + "] " : " ") + "= " + b);
        } else {
            GenUtil.print(pad, key + (num > 0 ? "[" + (num - 1) + "] " : " ") + "= " + o);
        }
    }

    private static void print(int pad, String msg) {
        System.out.println(GenUtil.getPadding(pad) + msg);
    }

    private static String getPadding(int depth) {
        String s = "";
        for (int i = 0; i < depth; ++i) {
            s = s + "\t";
        }
        return s;
    }

    public static void main(String[] args) {
        String[] sa = new String[]{"sa1", "sa2", "sa3"};
        String[][] st = new String[][]{{"st00", "st01"}, {"st10", "st11"}};
        Object[][] o1 = new Object[][]{{"key1", "val1"}, {"key2", "val2"}};
        Values v1 = new Values(o1);
        Object[][] on = new Object[][]{{"nkey1", "nval1"}, {"nkey2", "nval2"}};
        Values vn = new Values(on);
        Object[][] o2 = new Object[][]{{"k1", "v1"}, {"k2", "v2"}, {"k3", vn}};
        Values v2 = new Values(o2);
        Values[] va = new Values[]{v1, v2};
        Object[][] o = new Object[][]{{"str", "AString"}, {"sa", sa}, {"st", st}, {"val", v1}, {"nest", v2}, {"va", va}};
        Values v = new Values(o);
        System.out.println("Dumping test record:\n");
        GenUtil.printValues(v, 0, 0);
        System.out.println();
        GenUtil.getInputs(v);
        System.out.println();
        System.out.println("Dumping modified test record:\n");
        GenUtil.printValues(v, 0, 0);
    }
}

