/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.QueryBindRegion;
import com.wm.app.b2b.util.QueryDocument;
import com.wm.app.b2b.util.resources.ClientExceptionBundle;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xql.TreeExpression;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedException;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Vector;

public class CreateRegions
implements ValuesCodable {
    public static final int CORSVC0001 = 1;
    public static final int CORSVC0002 = 2;
    Vector regions;
    Values nsDecls;

    private CreateRegions(IData val) {
        this.setIData(val);
    }

    public static CreateRegions create(IData val) {
        if (val == null) {
            return null;
        }
        return new CreateRegions(val);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"nsDecls", this.nsDecls}, {"regions", this.regions}};
        return new Values(o);
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        this.nsDecls = QueryDocument.createNsDecls(val.get("nsDecls"), "createRegions");
        this.createRegions(val.get("regions"));
    }

    public void setIData(IData val) {
        if (val == null) {
            return;
        }
        IDataCursor id = val.getCursor();
        Object o = null;
        if (id.first("nsDecls")) {
            o = id.getValue();
        }
        this.nsDecls = QueryDocument.createNsDecls(o, "createRegions");
        o = null;
        if (id.first("regions")) {
            o = id.getValue();
        }
        this.createRegions(o);
    }

    void createRegions(Object o) {
        if (o instanceof Vector) {
            this.regions = (Vector)o;
            int rSize = this.regions.size();
            for (int i = 0; i < rSize; ++i) {
                this.regions.setElementAt(QueryBindRegion.create((Values)this.regions.elementAt(i)), i);
            }
        } else if (o instanceof IData[]) {
            Values[] v = (Values[])o;
            this.regions = new Vector();
            for (int i = 0; i < v.length; ++i) {
                this.regions.addElement(QueryBindRegion.create(v[i]));
            }
        } else if (o != null) {
            JournalLogger.logDebug(2, 62);
        }
    }

    public void bindRegionsFromPipe(IData pipe) throws Exception {
        if (pipe == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_1, "", "");
        }
        if (this.regions != null) {
            int rSize = this.regions.size();
            IDataCursor id = pipe.getCursor();
            for (int i = 0; i < rSize; ++i) {
                QueryBindRegion f = (QueryBindRegion)this.regions.elementAt(i);
                if (f == null) {
                    Object[] args = new Object[]{"" + i, "" + this.regions.size()};
                    throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_2, "", args);
                }
                if (f.name == null) {
                    Object[] args = new Object[]{"" + i};
                    throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_3, "", args);
                }
                IDataUtil.put(id, f.name, CreateRegions.bindRegionFromPipe(pipe, f, this.nsDecls));
            }
            id.destroy();
        }
    }

    static Object bindRegionFromPipe(IData pipe, QueryBindRegion field, Values nsDecls) throws Exception {
        Object pipeVal = ValuesEmulator.get(pipe, "node");
        if (pipeVal == null) {
            Object[] args = new Object[]{field.name};
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_4, "", args);
        }
        if (!(pipeVal instanceof Node)) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGIONS_BIND_FROM_PIPE_5, "", "");
        }
        Node node = (Node)pipeVal;
        return CreateRegions.bindRegion(node, field, nsDecls);
    }

    static Object bindRegion(Node node, QueryBindRegion field, Values nsDecls) throws Exception {
        Object[] args = new Object[]{field.name};
        if (node == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_5, "", args);
        }
        if (field.startQueryType == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_1, "", args);
        }
        if (field.startQuery == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_2, "", args);
        }
        if (field.endQueryType == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_3, "", args);
        }
        if (field.endQuery == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_4, "", args);
        }
        TreeExpression query = TreeExpression.create(field.startQueryType, field.startQuery, nsDecls);
        Node startResult = query.getNode(node);
        if (field.onnull == -1 && startResult == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_6, "", args);
        }
        if (startResult == null) {
            return null;
        }
        query = TreeExpression.create(field.endQueryType, field.endQuery, nsDecls);
        Node endResult = query.getNode(node);
        if (field.onnull == -1 && endResult == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_7, "", args);
        }
        if (endResult == null) {
            return null;
        }
        Document doc = node.getDocument();
        Node region = doc.getRegionNode(startResult, field.startInclude, endResult, field.endInclude);
        if (field.onnull == -1 && region == null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_8, "", args);
        }
        if (field.onnull == 1 && region != null) {
            throw new LocalizedException(ClientExceptionBundle.class, ClientExceptionBundle.CREATE_REGION_BIND_REGION_8, "", args);
        }
        return region;
    }
}

