/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util;

import com.wm.app.b2b.util.MethodInfo;
import com.wm.app.b2b.util.Text;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class ClassInfo
implements ValuesCodable {
    String cName;
    String shared;
    String pkgName;
    String extend;
    String[] impls;
    String[] imports;
    MethodInfo[] methods;
    boolean encoded;
    boolean decode = false;
    boolean encodeUtf8;

    public ClassInfo(String cName, String pkgName, String[] imports, String extend, String[] impls, String shared, MethodInfo[] methods) {
        this.cName = cName;
        this.shared = shared;
        this.pkgName = pkgName;
        this.extend = extend;
        this.impls = impls;
        this.imports = imports;
        this.methods = methods;
        this.encoded = true;
        this.encodeUtf8 = false;
    }

    public ClassInfo(Values val) {
        this(val, true);
    }

    public ClassInfo(Values val, boolean encoded) {
        this.encoded = encoded;
        this.setValues(val);
    }

    public String getName() {
        return this.cName;
    }

    public String getShared() {
        return this.shared;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getExtend() {
        return this.extend;
    }

    public String[] getImpls() {
        return this.impls;
    }

    public String[] getImports() {
        return this.imports;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public boolean isEncodeUtf8() {
        return this.encodeUtf8;
    }

    public void setEncoded(boolean enc) {
        this.encoded = enc;
    }

    public void setDecodeUnicode(boolean decode) {
        this.decode = decode;
    }

    public void setEncodeUtf8(boolean b) {
        this.encodeUtf8 = b;
    }

    public void padShared() {
        this.shared = Text.indent(this.shared, "\t");
    }

    public Values getNodeValues() {
        String sh = this.encoded ? (this.encodeUtf8 ? Base64.encodeUTF8(this.shared) : Base64.encode(this.shared)) : this.shared;
        if (sh == null && this.shared != null) {
            sh = "";
        }
        Object[][] o = new Object[][]{{"shared", sh}, {"encodeutf8", this.encodeUtf8 ? "true" : "false"}, {"extends", this.extend}, {"implements", this.impls}, {"imports", this.imports}};
        this.encoded = true;
        return new Values(o);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"class", this.cName}, {"package", this.pkgName}, {"extends", this.extend}, {"implements", this.impls}, {"imports", this.imports}, {"methods", this.methods}, {"encodeutf8", this.encodeUtf8 ? "true" : "false"}};
        Values v = new Values(o);
        if (this.shared != null) {
            this.shared = !this.decode ? EncUtil.encodeUnicode(this.shared) : EncUtil.decodeUnicode(this.shared);
        }
        if (this.encoded) {
            if (this.encodeUtf8) {
                v.put("shared", Base64.encodeUTF8(this.shared));
            } else {
                v.put("shared", Base64.encode(this.shared));
            }
        } else {
            v.put("shared", this.shared);
        }
        return v;
    }

    public void setValues(Values val) {
        if (val == null) {
            this.encoded = true;
            return;
        }
        this.cName = val.getString("class");
        String sh = val.getString("shared");
        this.encodeUtf8 = val.getBoolean("encodeutf8");
        this.shared = this.encoded ? (this.encodeUtf8 ? Base64.decodeUTF8(sh) : Base64.decode(sh)) : sh;
        this.pkgName = val.getString("package");
        this.extend = val.getString("extends");
        this.impls = (String[])val.get("implements");
        this.imports = (String[])val.get("imports");
        Object[] o = (Object[])val.get("methods");
        if (o instanceof Values[]) {
            Values[] m = (Values[])o;
            if (m != null) {
                this.methods = new MethodInfo[m.length];
                for (int i = 0; i < m.length; ++i) {
                    this.methods[i] = new MethodInfo(m[i]);
                    this.methods[i].setEncodeUtf8(true);
                }
            }
        } else {
            this.methods = (MethodInfo[])o;
        }
        this.encoded = true;
    }
}

