/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client.ns;

import com.wm.app.b2b.client.CachedNSNodeListener;
import com.wm.app.b2b.client.ns.NSNodeStub;
import com.wm.app.b2b.client.ns.NSQuery;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class NodeCache {
    private static final String[] nsNamesOfPersistentNSNodes = new String[]{"pub.schema.w3c.april_2000:structures", "pub.schema.w3c.april_2000:datatypes", "pub.schema.w3c.sep_2000:structures", "pub.schema.w3c.sep_2000:datatypes", "pub.schema.w3c.oct_2000:structures", "pub.schema.w3c.oct_2000:datatypes", "pub.schema.w3c:xml", "pub.schema.w3c:structures", "pub.schema.w3c:datatypes"};
    private static NodeCache instance;
    private static Set persistentNodes;
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int INITIAL_MAP_SIZE = 513;
    private Map nodes = Collections.synchronizedMap(new HashMap(513));
    private int cacheSize = 100;
    private List cacheStack = Collections.synchronizedList(new ArrayList(100));
    private Map nsNodesAndListeners = Collections.synchronizedMap(new HashMap(513));

    NodeCache() {
    }

    public static NodeCache getInstance() {
        return instance;
    }

    void clearCache() {
        this.nodes.clear();
        this.cacheStack.clear();
        this.nsNodesAndListeners.clear();
    }

    void cacheNode(ServerAndNameKey aKey, NSNode node) {
        if (this.shouldLog()) {
            System.out.println("cacheNode: " + aKey);
            System.out.println("cacheLimit: " + this.cacheSize);
            System.out.println("cacheSize: " + this.cacheStack.size());
            this.printCache();
        }
        this.nodes.put(aKey, node);
        node.register();
        this.touchNode(node);
        if (this.cacheStack.size() > this.cacheSize) {
            int numExtraNodes = this.cacheStack.size() - this.cacheSize;
            int numExtraNodesUncached = 0;
            for (int i = this.cacheStack.size() - 1; numExtraNodesUncached < numExtraNodes && i >= 1; --i) {
                boolean nodeUncached = this.stubNodeAt(i);
                if (!nodeUncached) continue;
                ++numExtraNodesUncached;
            }
        }
        if (this.shouldLog()) {
            this.printCache();
        }
    }

    NSNode get(ServerAndNameKey aKey) {
        return (NSNode)this.nodes.get(aKey);
    }

    void uncacheAndUnregisterNode(ServerAndNameKey aKey, NSNode anNSNode) {
        this.uncacheNode(aKey);
        anNSNode.unregister();
    }

    void registerNSNodeListener(Object listener, NSNode node) {
        Vector existingVector;
        if (node instanceof NSInterface) {
            return;
        }
        Object existingListeners = this.nsNodesAndListeners.get(node);
        if (existingListeners == null) {
            Vector<Object> newVector = new Vector<Object>();
            newVector.addElement(listener);
            this.nsNodesAndListeners.put(node, newVector);
        } else if (existingListeners instanceof Vector && !(existingVector = (Vector)existingListeners).contains(listener)) {
            existingVector.addElement(listener);
        }
    }

    void unregisterNSNodeListener(Object listener, NSNode node) {
        Object existingListeners = this.nsNodesAndListeners.get(node);
        if (existingListeners == null) {
            return;
        }
        if (existingListeners instanceof Vector) {
            Vector existingVector = (Vector)existingListeners;
            existingVector.removeElement(listener);
            if (existingVector.isEmpty()) {
                this.nsNodesAndListeners.remove(node);
            }
        }
    }

    void setCacheSize(int newSize) {
        this.cacheSize = newSize;
        int currentCacheSize = this.cacheStack.size();
        if (currentCacheSize > this.cacheSize) {
            for (int i = currentCacheSize - 1; i > 0 && this.cacheStack.size() > newSize; --i) {
                this.stubNodeAt(i);
            }
        }
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    void sweepCache(String packageName) {
        int size = this.cacheStack.size();
        String currentPackageName = null;
        NSPackage currentPackage = null;
        for (int i = size - 1; i >= 0; --i) {
            currentPackage = ((NSNode)this.cacheStack.get(i)).getPackage();
            if (currentPackage == null || !(currentPackageName = currentPackage.getName()).equals(packageName)) continue;
            this.stubNodeAt(i);
        }
    }

    void sweepCache() {
        if (this.shouldLog()) {
            System.out.println("sweepCache started");
            System.out.println("cacheSize = " + this.cacheStack.size());
            System.out.println("nsNodesAndListeners size = " + this.nsNodesAndListeners.size());
        }
        int size = this.cacheStack.size();
        for (int i = size - 1; i >= 0; --i) {
            this.stubNodeAt(i);
        }
        if (this.shouldLog()) {
            System.out.println("sweepCache ended");
            System.out.println("cacheSize = " + this.cacheStack.size());
            System.out.println("nsNodesAndListeners size = " + this.nsNodesAndListeners.size());
        }
    }

    void touchNode(NSNode node) {
        if (node instanceof NSInterface) {
            return;
        }
        NSName nodeName = node.getNSName();
        if (persistentNodes.contains(nodeName)) {
            return;
        }
        if (this.cacheStack.contains(node)) {
            this.cacheStack.remove(node);
        }
        this.cacheStack.add(0, node);
    }

    void uncacheNode(ServerAndNameKey aKey) {
        NSNode node = (NSNode)this.nodes.remove(aKey);
        this.cacheStack.remove(node);
    }

    private static void initPersistentNodes() {
        if (persistentNodes != null) {
            return;
        }
        persistentNodes = new HashSet();
        for (int i = 0; i < nsNamesOfPersistentNSNodes.length; ++i) {
            String nsNameString = nsNamesOfPersistentNSNodes[i];
            NSName nsName = NSName.create(nsNameString);
            persistentNodes.add(nsName);
        }
    }

    private void printCache() {
        if (!this.shouldLog()) {
            return;
        }
        System.out.println("<cache>");
        for (int i = 0; i < this.cacheStack.size(); ++i) {
            NSNode node = (NSNode)this.cacheStack.get(i);
            System.out.println("cache[" + i + "]: " + node.getNSName());
        }
        System.out.println("</cache>");
    }

    private boolean stubNodeAt(int i) {
        Object nodeToStub = this.cacheStack.get(i);
        if (!(nodeToStub instanceof NSNode)) {
            return false;
        }
        return this.stubNode((NSNode)nodeToStub);
    }

    boolean stubNode(NSNode node) {
        this.log("stubNode: " + node.getNSName());
        Object object = this.nsNodesAndListeners.get(node);
        NSName name = node.getNSName();
        if (object == null) {
            this.uncacheNode(this.getKeyFor(node));
            this.log("no listeners, removing " + name + " from cache anyways.");
            return true;
        }
        if (!(object instanceof Vector)) {
            return false;
        }
        NSNodeStub stub = this.createNSNodeStub(node, name);
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            CachedNSNodeListener listener = (CachedNSNodeListener)enumeration.nextElement();
            this.log("listener = " + object);
            if (!listener.isOKToReplaceNode()) {
                this.log("listener vetoed stub of " + name);
                return false;
            }
            listener.replaceNode(stub);
        }
        this.uncacheNode(this.getKeyFor(node));
        this.nsNodesAndListeners.remove(node);
        this.log("node successfully stubbed: " + name);
        return true;
    }

    private NSNodeStub createNSNodeStub(NSNode aNode, NSName aName) {
        NSPackage nsPackage = aNode.getPackage();
        NSType type = aNode.getNodeTypeObj();
        NSNodeStub stub = null;
        if (!type.equals(NSService.TYPE)) {
            stub = new NSNodeStub(nsPackage, aName, type);
        } else {
            NSService service = (NSService)aNode;
            stub = new NSNodeStub(nsPackage, aName, type, service.getServiceType());
        }
        return stub;
    }

    private ServerAndNameKey getKeyFor(NSNode aNode) {
        for (Map.Entry entry : this.nodes.entrySet()) {
            if (aNode != entry.getValue()) continue;
            return (ServerAndNameKey)entry.getKey();
        }
        return null;
    }

    private void log(String aString) {
        if (!this.shouldLog()) {
            return;
        }
        System.out.println(aString);
    }

    private boolean shouldLog() {
        return Boolean.getBoolean("client.log.caching");
    }

    public void flushNodesAssociatedWithPackage(String packageName) {
        int size = this.cacheStack.size();
        String currentPackageName = null;
        NSPackage currentPackage = null;
        for (int i = size - 1; i >= 0; --i) {
            Object node;
            currentPackage = ((NSNode)this.cacheStack.get(i)).getPackage();
            if (currentPackage == null || !(currentPackageName = currentPackage.getName()).equals(packageName) || !((node = this.cacheStack.get(i)) instanceof NSNode)) continue;
            this.uncacheNode(this.getKeyFor((NSNode)node));
        }
    }

    static {
        NodeCache.initPersistentNodes();
        instance = new NodeCache();
    }

    static class ServerAndNameKey {
        private NSQuery server;
        private NSName name;

        public ServerAndNameKey(NSQuery aServer, NSName aName) {
            this.server = aServer;
            this.name = aName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ServerAndNameKey)) {
                return false;
            }
            ServerAndNameKey serverAndNameKey = (ServerAndNameKey)o;
            if (!this.name.equals(serverAndNameKey.name)) {
                return false;
            }
            return this.server.equals(serverAndNameKey.server);
        }

        public int hashCode() {
            int result = this.server.hashCode();
            result = 29 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

