/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client.ns;

import com.wm.app.b2b.client.ns.NSNodeStub;
import com.wm.app.b2b.client.ns.NSRecordStub;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSServiceType;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.NamespaceFilter;

public class NSTypeFilter
implements NamespaceFilter {
    public static final int MODE_ALLOW_ALL = -1;
    public static final int MODE_SAVE_NODE = 0;
    public static final int MODE_ALLOW_FOLDERS = 2;
    public static final int MODE_SAVE_FOLDER = 3;
    public static final int MODE_ALLOW_PACKAGES = 9;
    public static final int MODE_ALLOW_SERVICES = 4;
    public static final int MODE_ALLOW_PACKAGES_DOCUMENT_TYPES = 5;
    public static final int MODE_ALLOW_JAVASERVICES = 6;
    public static final int MODE_ALLOW_FLOWSERVICES = 7;
    public static final int MODE_ALLOW_SPECSERVICES = 8;
    public static final int MODE_ALLOW_SCHEMAS = 10;
    public static final int MODE_ALLOW_FLOWSERVICES_AND_DOCUMENTTYPES = 11;
    public static final int MODE_OPEN_SVC_REC = 12;
    public static final int MODE_ALLOW_PUBLISHABLEDOCUMENTTYPES = 13;
    public static final int MODE_ALLOW_FLATFILE_DOCUMENTTYPES = 14;
    public static final int MODE_ALLOW_PUBLISHABLEDOCUMENTTYPES_DISABLED = 15;
    public static final int MODE_ALLOW_WEB_SERVICE_DISCRIPTORS = 16;
    private static final String FLAT_FILE_SCHEMA_TYPE_DESCRIPTION = "Flat File Schema";
    private int filterMode = -1;

    public NSTypeFilter(int mode) {
        this.setFilterMode(mode);
    }

    public int getFilterMode() {
        return this.filterMode;
    }

    public static NamespaceFilter create(int mode) {
        return new NSTypeFilter(mode);
    }

    static boolean isNSPackage(Object node) {
        return node instanceof NSPackage;
    }

    static boolean isFolder(Object node) {
        if (!(node instanceof NSNode)) {
            return false;
        }
        NSNode nsNode = (NSNode)node;
        NSType nodeType = nsNode.getNodeTypeObj();
        return nodeType.equals(NSInterface.TYPE);
    }

    static boolean isFlatFileSchema(Object node) {
        NSNode nsNode = (NSNode)node;
        NSType nodeType = nsNode.getNodeTypeObj();
        return nodeType.getType().equals(FLAT_FILE_SCHEMA_TYPE_DESCRIPTION);
    }

    static boolean isNSService(Object node) {
        if (!(node instanceof NSNode)) {
            return false;
        }
        NSNode nsNode = (NSNode)node;
        NSType nodeType = nsNode.getNodeTypeObj();
        return nodeType.equals(NSService.TYPE);
    }

    static NSServiceType getType(NSNode node) {
        if (node instanceof NSService) {
            NSService service = (NSService)node;
            return service.getServiceType();
        }
        if (node instanceof NSNodeStub) {
            NSNodeStub service = (NSNodeStub)node;
            return service.getServiceType();
        }
        return null;
    }

    public boolean isIncluded(Object node) {
        switch (this.getFilterMode()) {
            case -1: {
                return true;
            }
            case 9: {
                return NSTypeFilter.isNSPackage(node);
            }
            case 2: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node);
            }
            case 5: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || NSTypeFilter.isNSRecord(node);
            }
            case 6: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || this.isJavaService(node);
            }
            case 7: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || this.isFlowService(node);
            }
            case 11: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || this.isFlowService(node) || NSTypeFilter.isNSRecord(node);
            }
            case 8: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || this.isSpecService(node);
            }
            case 14: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || NSTypeFilter.isFlatFileSchema(node);
            }
            case 4: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || NSTypeFilter.isNSService(node) && !this.isSpecService(node);
            }
            case 12: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || NSTypeFilter.isNSService(node) || NSTypeFilter.isNSRecord(node);
            }
            case 10: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || NSTypeFilter.isNSSchema(node);
            }
            case 13: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || this.isPublishableNSRecord(node);
            }
            case 16: {
                return NSTypeFilter.isNSPackage(node) || NSTypeFilter.isFolder(node) || this.isWebServiceDescriptor(node);
            }
        }
        return true;
    }

    boolean isWebServiceDescriptor(Object node) {
        if (!(node instanceof NSNode)) {
            return false;
        }
        NSNode nsNode = (NSNode)node;
        NSType nodeType = nsNode.getNodeTypeObj();
        return nodeType.equals(NSWSDescriptor.TYPE);
    }

    boolean isPublishableNSRecord(Object node) {
        if (!NSTypeFilter.isNSRecord(node)) {
            return false;
        }
        if (node instanceof NSRecordStub) {
            return ((NSRecordStub)node).isPublishableRecord();
        }
        return ((NSRecord)node).isPublishable();
    }

    boolean isJavaService(Object node) {
        if (!NSTypeFilter.isNSService(node)) {
            return false;
        }
        NSServiceType serviceType = NSTypeFilter.getType((NSNode)node);
        return serviceType.isJavaService();
    }

    boolean isFlowService(Object node) {
        if (!NSTypeFilter.isNSService(node)) {
            return false;
        }
        NSServiceType serviceType = NSTypeFilter.getType((NSNode)node);
        return serviceType.isFlowService();
    }

    boolean isSpecService(Object node) {
        if (!NSTypeFilter.isNSService(node)) {
            return false;
        }
        NSServiceType serviceType = NSTypeFilter.getType((NSNode)node);
        return serviceType.isSpecService();
    }

    static boolean isNSSchema(Object node) {
        if (!(node instanceof NSNode)) {
            return false;
        }
        NSNode nsNode = (NSNode)node;
        NSType nodeType = nsNode.getNodeTypeObj();
        return nodeType.equals(NSSchema.TYPE);
    }

    static boolean isNSRecord(Object node) {
        if (!(node instanceof NSNode)) {
            return false;
        }
        NSNode nsNode = (NSNode)node;
        NSType nodeType = nsNode.getNodeTypeObj();
        return nodeType.equals(NSRecord.TYPE);
    }

    public void setFilterMode(int filterMode) {
        this.filterMode = filterMode;
    }
}

