/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client.ns;

import com.wm.app.b2b.client.Context;
import com.wm.app.b2b.client.HttpClient;
import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.ns.ClientBrokerTrigger;
import com.wm.app.b2b.client.ns.ClientFlowService;
import com.wm.app.b2b.client.ns.ClientInterface;
import com.wm.app.b2b.client.ns.ClientJMSTrigger;
import com.wm.app.b2b.client.ns.ClientRecord;
import com.wm.app.b2b.client.ns.ClientService;
import com.wm.app.b2b.client.ns.ContextWrapper;
import com.wm.app.b2b.client.ns.NSNodeFactory;
import com.wm.app.b2b.client.ns.NSNodeStub;
import com.wm.app.b2b.client.ns.NSRecordStub;
import com.wm.app.b2b.client.ns.NSRuntimeException;
import com.wm.app.b2b.client.ns.NSTriggerStub;
import com.wm.app.b2b.client.ns.NSWSDescriptorStub;
import com.wm.app.b2b.client.ns.NodeCache;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.lang.ns.EventDescription;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSServiceType;
import com.wm.lang.ns.NSTrigger;
import com.wm.lang.ns.NSTriggerType;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.util.Values;
import com.wm.util.sort.QuickSort;
import com.wm.util.sort.Sortable;
import java.util.Hashtable;

public class NSQuery
extends Namespace {
    private ContextWrapper context;
    private Hashtable packagesCache = new Hashtable(11);
    NSInterface root = ClientInterface.create(this, null);
    final NSName svcGetNode = NSName.create("wm.server.ns:getNode");
    final NSName svcGetNodes = NSName.create("wm.server.ns:getNodes");
    final NSName svcGetNodeList = NSName.create("wm.server.ns:getNodeList");
    final NSName svcGetRegistry = NSName.create("wm.server.schema:getRegistry");
    final String REGISTRY = "registry";

    public NSQuery(HttpClient ctx) {
        this.context = new ContextWrapper(ctx);
    }

    public NSQuery(WmConnection ctx) {
        this.context = new ContextWrapper(ctx);
    }

    public NSQuery(Context ctx) {
        this.context = new ContextWrapper(ctx);
    }

    public void clearCache() {
        this.getNodeCache().clearCache();
        this.getPackagesCache().clear();
        this.root = ClientInterface.create(this, null);
    }

    public void setContext(WmConnection ctx) {
        this.context.setContext(ctx);
    }

    public void setContext(HttpClient ctx) {
        this.context.setContext(ctx);
    }

    private Values invoke1(NSName svc, String name, Object val) {
        return this.context.invoke(svc, name, val);
    }

    Values[] invoke2(NSName svc, String name, Object val, String outName) {
        Values out = this.context.invoke(svc, name, val);
        return (Values[])out.get(outName);
    }

    Values[] invoke3(NSName svc, Values in, String outName) {
        Values out = this.context.invoke(svc, in);
        return (Values[])out.get(outName);
    }

    public String getIntName(NSName parent) {
        if (parent == null) {
            return null;
        }
        return parent.getInterfaceName().toString();
    }

    public void refreshSchemaRegistry() {
        IData data;
        Values result = this.context.invoke(this.svcGetRegistry.getFullName(), null, IDataFactory.create(0));
        IDataCursor cr = result.getCursor();
        if (cr.first("registry") && (data = (IData)cr.getValue()) != null) {
            SchemaRegistry.setIData(data);
        }
    }

    public NSNode[] serverGetNodes(NSName parent, NSPackage pkg, NSType[] filter) {
        Values[] node;
        String pkgName;
        Values in = new Values();
        in.put("interface", this.getIntName(parent));
        if (pkg != null && (pkgName = pkg.getName()) != null && pkgName.length() > 0) {
            in.put("package", pkgName);
        }
        if (filter != null) {
            in.put("filter", filter);
        }
        if ((node = this.invoke3(this.svcGetNodes, in, "nodes")) == null) {
            return null;
        }
        ClientInterface parentInterface = (ClientInterface)this.getNode(parent);
        NSNode[] ret = new NSNode[node.length];
        for (int i = 0; i < node.length; ++i) {
            Values nodeValues = node[i];
            NSName nm = NSName.create(nodeValues.getString("node_nsName"));
            ret[i] = this.getNodeCache().get(this.createKey(nm));
            if (ret[i] == null) {
                ret[i] = this.createNSNode(nodeValues, pkg, null);
                if (ret[i] != null) {
                    this.getNodeCache().cacheNode(this.createKey(nm), ret[i]);
                }
            }
            parentInterface.insertNode(ret[i]);
        }
        return ret;
    }

    private NodeCache.ServerAndNameKey createKey(NSName aName) {
        return new NodeCache.ServerAndNameKey(this, aName);
    }

    public NSNode[] serverGetNodeStubs(NSName parent, NSPackage pkg, NSType[] filter) {
        Values[] node;
        String pkgName;
        Values in = new Values();
        in.put("interface", this.getIntName(parent));
        if (pkg != null && (pkgName = pkg.getName()) != null && pkgName.length() > 0) {
            in.put("package", pkgName);
        }
        if (filter != null) {
            in.put("filter", filter);
        }
        if ((node = this.invoke3(this.svcGetNodeList, in, "nodeList")) == null) {
            return null;
        }
        this.getNode(parent);
        NSNode[] ret = new NSNode[node.length];
        for (int i = 0; i < node.length; ++i) {
            NSNodeStub stub;
            Values nodeValues = node[i];
            NSName name = NSName.create(nodeValues.getString("node_nsName"));
            NSType type = NSType.create(nodeValues.getString("node_type"));
            if (type.equals(NSService.TYPE)) {
                NSServiceType svcType = NSServiceType.create(nodeValues);
                stub = new NSNodeStub(pkg, name, type, svcType);
            } else if (type.equals(NSRecord.TYPE)) {
                stub = new NSRecordStub(pkg, name, type);
                Object o = nodeValues.get("eventDescription");
                EventDescription ed = o != null ? EventDescription.create((Values)o) : null;
                ((NSRecordStub)stub).setEventDescription(ed);
                Boolean notificationFlag = (Boolean)nodeValues.get("NotificationDocument");
                ((NSRecordStub)stub).setNotificationRecordFlag(notificationFlag);
            } else if (type.equals(NSTrigger.TYPE)) {
                NSTriggerType triggerType = NSTriggerType.create(nodeValues);
                stub = new NSTriggerStub(pkg, name, type, triggerType, nodeValues);
            } else {
                stub = type.equals(NSWSDescriptor.TYPE) ? new NSWSDescriptorStub(pkg, name, type, nodeValues) : new NSNodeStub(pkg, name, type);
            }
            Integer lockStatusInteger = (Integer)nodeValues.get("LOCK_STATUS");
            if (lockStatusInteger != null) {
                int lockType;
                stub.gLockState = lockType = lockStatusInteger.intValue();
            }
            ret[i] = stub;
        }
        return ret;
    }

    public void stubNode(NSNode node) {
        this.getNodeCache().stubNode(node);
    }

    public NSNode createNSNode(Values nodeValues, NSPackage nsPackage, Values out) {
        NSNode node;
        String nodeType = nodeValues.getString("node_type");
        NSType type = null;
        if (nodeType.equals("service")) {
            String serviceType = nodeValues.getString("svc_type");
            String serviceSubType = nodeValues.getString("svc_subtype");
            type = NSServiceType.create(serviceType, serviceSubType);
        } else if (nodeType.equals("webMethods/trigger")) {
            String triggerType = nodeValues.getString("trigger_type");
            type = NSTriggerType.create(triggerType);
        } else {
            type = NSType.create(nodeType);
        }
        Integer lockStatusInteger = null;
        if (out != null) {
            lockStatusInteger = (Integer)out.get("LOCK_STATUS");
        }
        if ((node = NSNodeFactory.getInstance().create(type, (Namespace)this, nodeValues, this.context)) instanceof NSInterface && nsPackage != null) {
            node.setPackage(nsPackage);
        }
        if (lockStatusInteger != null) {
            int lockType;
            node.gLockState = lockType = lockStatusInteger.intValue();
        }
        return node;
    }

    public NSNode serverGetNode(NSName nsName) {
        NSNode existingNode = this.getNodeCache().get(this.createKey(nsName));
        if (existingNode != null) {
            return existingNode;
        }
        NSNode node = null;
        try {
            Values out = this.invoke1(this.svcGetNode, "name", nsName.toString());
            Values nodeValues = (Values)out.get("node");
            if (nodeValues == null || nodeValues.isEmpty()) {
                return null;
            }
            node = this.createNSNode(nodeValues, null, out);
            this.getNodeCache().cacheNode(this.createKey(nsName), node);
        }
        catch (NSRuntimeException nsr) {
            return null;
        }
        return node;
    }

    public NSPackage[] serverGetPackages() {
        Values out = Values.use(this.context.invoke("wm.server.ns:getEnabledPackages", null, null));
        Values[] pkgsDataFromServer = (Values[])out.get("packages");
        NSPackage[] allNSPackages = new NSPackage[pkgsDataFromServer.length];
        for (int i = 0; i < allNSPackages.length; ++i) {
            String pkgNameFromServer = pkgsDataFromServer[i].getString("pkg_name");
            Object cachedPackage = this.getPackagesCache().get(pkgNameFromServer);
            if (cachedPackage == null) {
                allNSPackages[i] = new Package(pkgsDataFromServer[i]);
                this.getPackagesCache().put(allNSPackages[i].getName(), allNSPackages[i]);
                continue;
            }
            allNSPackages[i] = (NSPackage)cachedPackage;
        }
        return allNSPackages;
    }

    public NSNode[] getNodes(NSInterface ifc, NSPackage pkg, NSType[] filter) {
        Sortable[] node = this.serverGetNodes(ifc.getNSName(), pkg, filter);
        return (NSNode[])QuickSort.sort(node);
    }

    public NSNode[] getNodeStubs(NSInterface ifc, NSPackage pkg, NSType[] filter) {
        Sortable[] node = this.serverGetNodeStubs(ifc.getNSName(), pkg, filter);
        NSNode[] newNodes = (NSNode[])QuickSort.sort(node);
        return newNodes;
    }

    public NSInterface getRootNode() {
        return this.root;
    }

    public NSNode getNode(NSName name) {
        if (name == null) {
            return this.root;
        }
        NSNode cachedNode = this.getCachedNode(name);
        if (cachedNode != null) {
            return cachedNode;
        }
        return this.serverGetNode(name);
    }

    private NSNode getCachedNode(NSName name) {
        NSNode cachedNode = this.getNodeCache().get(this.createKey(name));
        return cachedNode;
    }

    public IData getNodes(NSName[] names) {
        if (names == null) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public void putNode(NSNode node) {
        this.putNode(node, false);
    }

    public void putNode(NSNode node, boolean unlock) {
        this.getNodeCache().uncacheAndUnregisterNode(this.createKey(node.getNSName()), node);
        Values in = node.getValues();
        if (unlock) {
            in.put("UNLOCK_REQUIRED", "true");
        }
        this.context.invoke("wm.server.ns:putNode", null, in.getIData());
        this.getNodeCache().cacheNode(this.createKey(node.getNSName()), node);
    }

    public IData makeNode(NSNode node) {
        Values in = node.getValues();
        in.put("LOCK_REQUIRED", "true");
        Values out = Values.use(this.context.invoke("wm.server.ns:makeNode", null, in.getIData()));
        this.getNodeCache().cacheNode(this.createKey(node.getNSName()), node);
        return out;
    }

    public IData makeNodes(IData nodesData) {
        Values out = Values.use(this.context.invoke("wm.server.nsimpl:makeNodes", null, nodesData));
        return out;
    }

    public boolean nodeExists(NSName name) {
        String serviceName = "wm.server.ns:nodeExists";
        Object[][] o = new Object[][]{{"service", name}};
        Values out = Values.use(this.context.invoke(serviceName, null, new Values(o).getIData()));
        String status = out.getString("status");
        return status != null && status.equals("true");
    }

    public IData nodeExists(NSName[] nsnames) {
        throw new UnsupportedOperationException();
    }

    public void deleteNode(NSNode node) {
        this.deleteNode(node, false);
    }

    public void deleteNode(NSNode node, boolean shouldCascade) {
        NSName name = node.getNSName();
        Object[][] o = new Object[][]{{"node_nsName", name}, {"node_pkg", node.getPackage().getName()}};
        IData input = IDataFactory.create(o);
        if (ClientRecord.isPublishableRecord(node)) {
            IDataCursor cursor = input.getCursor();
            cursor.last();
            cursor.insertAfter("isCascaded", new Boolean(shouldCascade));
            cursor.destroy();
        }
        this.context.invoke("wm.server.ns:deleteNode", null, input);
        this.getNodeCache().uncacheAndUnregisterNode(this.createKey(name), node);
    }

    public IData deleteNodes(IData input) {
        return this.context.invoke("wm.server.nsimpl:deleteNodes", null, input);
    }

    public void copyNode(NSNode oldNSNode, NSPackage newNSPackage, NSName newNSName) {
        this.copyNode(oldNSNode, newNSPackage, newNSName, false);
    }

    public IData copyNode(NSNode oldNSNode, NSPackage newNSPackage, NSName newNSName, boolean shouldCascade) {
        Object[][] o = new Object[][]{{"source", oldNSNode.getNSName()}, {"targetpkg", newNSPackage.getName()}, {"target", newNSName}};
        IData input = IDataFactory.create(o);
        if (ClientRecord.isPublishableRecord(oldNSNode)) {
            IDataCursor cursor = input.getCursor();
            cursor.last();
            cursor.insertAfter("isCascaded", new Boolean(shouldCascade));
            cursor.destroy();
        }
        Values output = this.context.invoke("wm.server.ns:copyNode", null, input);
        return output;
    }

    public IData copyNodes(IData input) {
        return this.context.invoke("wm.server.nsimpl:copyNodes", null, input);
    }

    public void moveNode(NSNode oldNSNode, NSPackage newNSPackage, NSName newNSName, boolean preserveLockState) {
        NSName oldNSName = oldNSNode.getNSName();
        Object[][] o = new Object[][]{{"source", oldNSName}, {"targetpkg", newNSPackage.getName()}, {"target", newNSName}, {"preserveLockState", String.valueOf(preserveLockState)}};
        this.context.invoke("wm.server.ns:moveNode", null, new Values(o).getIData());
        this.getNodeCache().uncacheAndUnregisterNode(this.createKey(oldNSName), oldNSNode);
    }

    public IData moveNodes(IData input) {
        Values out = Values.use(this.context.invoke("wm.server.ns.dependency:moveNodes", null, input));
        return out;
    }

    public byte[] exportNode(NSNode node) {
        NSName name = node.getNSName();
        Object[][] o = new Object[][]{{"nodename", name}, {"pkgname", node.getPackage().getName()}};
        String serviceName = "wm.server.ns:exportNode";
        Values out = Values.use(this.context.invoke(serviceName, null, new Values(o).getIData()));
        return (byte[])out.get("zipdata");
    }

    public byte[] exportPackage(NSPackage nsPackage) {
        String name = nsPackage.getName();
        Object[][] o = new Object[][]{{"pkgname", name}};
        String serviceName = "wm.server.ns:exportPackage";
        Values out = Values.use(this.context.invoke(serviceName, null, new Values(o).getIData()));
        return (byte[])out.get("zipdata");
    }

    public boolean registerRecord(NSRecord record) throws NSException {
        return false;
    }

    public boolean registerSchema(NSSchema schema) throws NSException {
        return false;
    }

    public NSService createService(NSPackage pkg, NSName name, NSServiceType stype) {
        if (stype.isFlowService()) {
            return ClientFlowService.create(this, pkg, name, this.context);
        }
        if (stype.isJavaService() || stype.isSpecService()) {
            return ClientService.create(this, pkg, name, stype, this.context);
        }
        return null;
    }

    public NSWSDescriptor createWSD(NSPackage pkg, NSName name) {
        IData data = IDataFactory.create();
        IDataCursor cursor = data.getCursor();
        cursor.insertAfter("node_nsName", name);
        cursor.insertAfter("node_pkg", pkg);
        cursor.insertAfter("node_type", NSWSDescriptor.TYPE);
        cursor.destroy();
        return NSWSDescriptor.create((Namespace)this, data);
    }

    public NSTrigger createTrigger(NSPackage pkg, NSName name) throws ServiceException {
        return this.createTrigger(pkg, name, NSTriggerType.create("broker-trigger"));
    }

    public NSTrigger createTrigger(NSPackage pkg, NSName name, NSTriggerType triggerType) throws ServiceException {
        IData data = IDataFactory.create();
        IDataCursor cursor = data.getCursor();
        cursor.insertAfter("node_nsName", name);
        cursor.insertAfter("node_pkg", pkg);
        cursor.insertAfter("node_type", NSTrigger.TYPE);
        cursor.insertAfter("trigger_type", triggerType);
        cursor.insertAfter("trigger", IDataFactory.create());
        cursor.destroy();
        if (triggerType.isJMSTrigger()) {
            return ClientJMSTrigger.create(this, data);
        }
        return ClientBrokerTrigger.create(this, data);
    }

    public NSInterface createInterface(NSPackage pkg, NSName name) {
        return ClientInterface.create((Namespace)this, pkg, name);
    }

    public NSPackage[] getAllPackages() {
        Sortable[] pkgs = this.serverGetPackages();
        return (NSPackage[])QuickSort.sort(pkgs);
    }

    public NSPackage getPackage(String name) {
        if (name == null) {
            return null;
        }
        if (this.getPackagesCache().size() == 0) {
            this.getAllPackages();
        }
        return (NSPackage)this.getPackagesCache().get(name);
    }

    public void clearPackageCache() {
        this.getPackagesCache().clear();
    }

    public NSPackage createPackage(String name) {
        return null;
    }

    public void deletePackage(NSPackage pkg) {
        this.getPackagesCache().remove(pkg.getName());
    }

    public void registerNSNodeListener(Object listener, NSNode node) {
        this.getNodeCache().registerNSNodeListener(listener, node);
    }

    public void unregisterNSNodeListener(Object listener, NSNode node) {
        this.getNodeCache().unregisterNSNodeListener(listener, node);
    }

    public void unregisterNSNodesListeners(Object[] listeners, NSNode[] nodes) throws ServiceException {
        if (listeners == null || nodes == null || listeners.length != nodes.length) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            Object listener = listeners[i];
            this.getNodeCache().unregisterNSNodeListener(listener, nodes[i]);
        }
    }

    public void setCacheSize(int newSize) {
        this.getNodeCache().setCacheSize(newSize);
    }

    public int getCacheSize() {
        return this.getNodeCache().getCacheSize();
    }

    public void sweepCache(String packageName) {
        this.getNodeCache().sweepCache(packageName);
    }

    public void sweepCache() {
        this.getNodeCache().sweepCache();
    }

    public void touchNode(NSNode node) {
        this.getNodeCache().touchNode(node);
    }

    public NSNode refreshNode(NSNode node) {
        NSName nsName = node.getNSName();
        this.getNodeCache().uncacheAndUnregisterNode(this.createKey(nsName), node);
        return this.getNode(nsName);
    }

    public void uncacheNode(NSName name) {
        this.getNodeCache().uncacheNode(this.createKey(name));
    }

    private NodeCache getNodeCache() {
        return NodeCache.getInstance();
    }

    public void flushCachedNodesAssociatedWithPackage(String pkgName) {
        this.getNodeCache().flushNodesAssociatedWithPackage(pkgName);
    }

    public void flushCachedNodesAssociatedWithPackage(NSPackage nsPackage) {
        this.getNodeCache().flushNodesAssociatedWithPackage(nsPackage.getName());
    }

    Hashtable getPackagesCache() {
        return this.packagesCache;
    }

    void setPackagesCache(Hashtable packagesCache) {
        this.packagesCache = packagesCache;
    }

    class Package
    extends NSPackage {
        Package(Values values) {
            super(values);
        }
    }
}

