/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client.ns;

import com.wm.app.b2b.client.ns.ContextWrapper;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSServiceType;
import com.wm.lang.ns.NSTriggerType;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.util.Values;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class NSNodeFactory {
    private static NSNodeFactory instance = null;
    private Map nsTypesAndNSNodes = new HashMap();
    private String defaultNSNode = null;
    private String defaultNSService = null;
    private ClassLoader classLoader = this.getClass().getClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSNodeFactory getInstance() {
        if (instance != null) return instance;
        Class<NSNodeFactory> clazz = NSNodeFactory.class;
        synchronized (NSNodeFactory.class) {
            if (instance != null) return instance;
            instance = new NSNodeFactory();
            instance.registerDefaultNSNodes();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void registerDefaultNSNodes() {
        this.register(NSInterface.TYPE, "com.wm.app.b2b.client.ns.ClientInterface");
        this.register(NSServiceType.create("AdapterService", "unknown"), "com.wm.app.b2b.client.ns.ClientPlugInService");
        this.register(NSServiceType.create("AdapterService", "default"), "com.wm.app.b2b.client.ns.ClientPlugInService");
        this.register(NSServiceType.create("flow", "default"), "com.wm.app.b2b.client.ns.LazyClientFlowService");
        this.register(NSServiceType.create("flow", "webservice"), "com.wm.app.b2b.client.ns.LazyClientFlowService");
        this.register(NSServiceType.create("flow", "unknown"), "com.wm.app.b2b.client.ns.LazyClientFlowService");
        this.registerDefaultService("com.wm.app.b2b.client.ns.ClientService");
        this.register(NSRecord.TYPE, "com.wm.app.b2b.client.ns.ClientRecord");
        this.register(NSSchema.TYPE, "com.wm.app.b2b.client.ns.ClientSchema");
        this.register(NSTriggerType.create("broker-trigger"), "com.wm.app.b2b.client.ns.ClientBrokerTrigger");
        this.register(NSTriggerType.create("jms-trigger"), "com.wm.app.b2b.client.ns.ClientJMSTrigger");
        this.register(NSWSDescriptor.TYPE, "com.wm.app.b2b.client.ns.ClientWebServiceDescriptor");
        this.registerDefault("com.wm.app.b2b.client.ns.ClientPlugInNode");
    }

    private NSNodeFactory() {
    }

    public void registerClassLoader(ClassLoader aClassLoader) {
        this.classLoader = aClassLoader;
    }

    public boolean register(NSType nodeType, String nsNodeClassName) {
        this.nsTypesAndNSNodes.put(nodeType.getValue(), nsNodeClassName);
        return true;
    }

    public void registerDefault(String anNSNodeClassName) {
        this.defaultNSNode = anNSNodeClassName;
    }

    public void registerDefaultService(String anNSNodeClassName) {
        this.defaultNSService = anNSNodeClassName;
    }

    public NSNode create(NSType nsType, Namespace aNamespace, Values aValues, ContextWrapper aContextWrapper) {
        if (nsType == null) {
            System.out.println("ASSERT in NSNodeFactory.create(): NSType is null.");
            return null;
        }
        String className = null;
        className = this.nsTypesAndNSNodes.containsKey(nsType.getValue()) ? (String)this.nsTypesAndNSNodes.get(nsType.getValue()) : (nsType instanceof NSServiceType ? this.defaultNSService : this.defaultNSNode);
        return this.create(className, aNamespace, aValues, aContextWrapper);
    }

    private NSNode create(String nsNodeClassName, Namespace aNamespace, Values aValues, ContextWrapper aContextWrapper) {
        if (nsNodeClassName == null) {
            System.out.println("ASSERT in NSNodeFactory.create(): nsNodeClassName is null.");
            return null;
        }
        try {
            Class<?> nsNodeClass = this.classLoader.loadClass(nsNodeClassName);
            Class[] parameterTypes = new Class[]{Namespace.class, Values.class, ContextWrapper.class};
            Method factoryMethod = nsNodeClass.getDeclaredMethod("create", parameterTypes);
            Object[] parameters = new Object[]{aNamespace, aValues, aContextWrapper};
            return (NSNode)factoryMethod.invoke(null, parameters);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

