/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client.ns;

import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.ns.ContextWrapper;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowRoot;
import com.wm.lang.flow.FlowState;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.Namespace;
import com.wm.util.Values;

class FState
extends FlowState {
    static final NSName svcStartFlow = NSName.create("wm.server.flow:startFlow");
    static final NSName svcStepFlow = NSName.create("wm.server.flow:stepFlow");
    static final NSName svcEndFlow = NSName.create("wm.server.flow:endFlow");
    static final NSName svcStartFlowInto = NSName.create("wm.server.flow:startFlowInto");
    static final NSName svcStepInputMap = NSName.create("wm.server.flow:stepInputMap");
    static final NSName svcStepOutputMap = NSName.create("wm.server.flow:stepOutputMap");
    static final NSName svcSetPipeline = NSName.create("wm.server.flow:setPipeline");
    static final NSName svcSingleStepMap = NSName.create("wm.server.flow:singleStepMap");
    static final NSName svcSingleStepInput = NSName.create("wm.server.flow:singleStepInput");
    static final NSName svcSingleStepOutput = NSName.create("wm.server.flow:singleStepOutput");
    static final NSName svcGetMapErrors = NSName.create("wm.server.flow:getMapErrors");
    static final NSName svcUpdatePipeline = NSName.create("wm.server.flow:updatePipeline");
    NSName svc;
    String oid;
    FlowRoot root;
    ContextWrapper context;

    FState(NSName svc, FlowRoot root, Namespace ns, Values pipe, ContextWrapper context) {
        this(svc, root, ns, pipe, null, context);
    }

    FState(NSName svc, FlowRoot root, Namespace ns, Values pipe, FlowState parentFlowState, ContextWrapper context) {
        super(root, ns, pipe);
        this.setIncremental(true);
        this.svc = svc;
        this.root = root;
        this.setParent(parentFlowState);
        this.context = context;
    }

    private final Values invoke1(NSName svc, String name, Object val) {
        return this.context.invoke(svc, name, val);
    }

    public boolean isConnected() {
        return this.oid != null;
    }

    public FlowElement invoke() {
        return this.invokeNext();
    }

    private FlowElement invokeNext() {
        try {
            if (this.oid == null) {
                this.connectToServer();
                if (this.oid != null) {
                    return this.invokeNext();
                }
            } else {
                Values out = null;
                out = this.invoke1(svcStepFlow, "$oid", this.oid);
                Values error = out.getValues("$flowerror");
                if (error != null) {
                    this.throwIfError(error);
                }
                String node = out.getString("$current");
                Values pipeline = out.getValues("$pipeline");
                this.setPipeline(pipeline.getIData());
                FlowElement fe = this.root.getNode(node);
                return fe;
            }
            return null;
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    private void connectToServer() throws ServiceException {
        FlowState parentFlow = this.getParent();
        if (parentFlow == null) {
            Object[][] o = new Object[][]{{"$service", this.svc}, {"$pipeline", this.getPipeline()}};
            this.oid = Values.use(this.context.invoke(svcStartFlow.getFullName(), null, new Values(o))).getString("$oid");
        } else {
            Object[][] o = new Object[][]{{"$service", this.svc}, {"$pipeline", this.getPipeline()}, {"$oid", ((FState)parentFlow).getOID()}};
            this.oid = Values.use(this.context.invoke(svcStartFlowInto.getFullName(), null, new Values(o))).getString("$oid");
        }
    }

    public void invokeInputMap() {
        try {
            Values error;
            Values out = null;
            if (this.oid == null) {
                this.connectToServer();
                if (this.oid != null) {
                    this.invokeInputMap();
                }
            }
            if ((error = (out = this.invoke1(svcStepInputMap, "$oid", this.oid)).getValues("$flowerror")) != null) {
                this.throwIfError(error);
            }
            this.setPipeline(out.getValues("$pipeline").getIData());
            return;
        }
        catch (Exception e) {
            this.setError(e);
            return;
        }
    }

    public FlowElement invokeOutputMap() {
        try {
            Values out = null;
            out = this.invoke1(svcStepOutputMap, "$oid", this.oid);
            Values error = out.getValues("$flowerror");
            if (error != null) {
                this.throwIfError(error);
            }
            String node = out.getString("$current");
            this.setPipeline(out.getValues("$pipeline").getIData());
            FlowElement fe = this.root.getNode(node);
            return fe;
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public String[] getFlowMapErrors() {
        try {
            if (this.oid == null) {
                this.connectToServer();
                if (this.oid != null) {
                    return this.getFlowMapErrors();
                }
            } else {
                Values out = null;
                out = this.invoke1(svcGetMapErrors, "$oid", this.oid);
                String[] errors = (String[])out.get("$maperrors");
                return errors;
            }
            return new String[0];
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public FlowElement invokeNextMap() {
        try {
            if (this.oid == null) {
                this.connectToServer();
                if (this.oid != null) {
                    return this.invokeNextMap();
                }
            } else {
                Values out = null;
                out = this.invoke1(svcSingleStepMap, "$oid", this.oid);
                Values error = out.getValues("$flowerror");
                if (error != null) {
                    this.throwIfError(error);
                }
                Object currentPath = out.get("$current");
                Values pipeline = out.getValues("$pipeline");
                this.setPipeline(pipeline.getIData());
                this.setLastMapStep(Boolean.valueOf(out.getString("$isLastNode")));
                FlowElement fe = null;
                if (currentPath instanceof String) {
                    fe = this.root.getNode((String)currentPath);
                } else {
                    String[] node = (String[])currentPath;
                    if (node != null) {
                        fe = this.root.getNode(node[0]);
                        if (node.length > 1 && fe instanceof FlowMapInvoke) {
                            fe = ((FlowMapInvoke)fe).getOutputNode(node[1]);
                        }
                    }
                }
                return fe;
            }
            return null;
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public IData invokeCurrentInputMap() {
        try {
            Values error;
            Values out = null;
            if (this.oid == null) {
                this.connectToServer();
                if (this.oid != null) {
                    return this.invokeCurrentInputMap();
                }
            }
            if ((error = (out = this.invoke1(svcSingleStepInput, "$oid", this.oid)).getValues("$flowerror")) != null) {
                this.throwIfError(error);
            }
            Values pipelet = (Values)out.get("$pipelet");
            return pipelet.getIData();
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public FlowElement invokeCurrentOutputMap() {
        try {
            Values out = null;
            out = this.invoke1(svcSingleStepOutput, "$oid", this.oid);
            Values error = out.getValues("$flowerror");
            if (error != null) {
                this.throwIfError(error);
            }
            Object currentPath = out.get("$current");
            FlowElement fe = null;
            if (currentPath instanceof String) {
                fe = this.root.getNode((String)currentPath);
            } else {
                String[] node = (String[])currentPath;
                fe = this.root.getNode(node[0]);
                if (node.length > 1 && fe instanceof FlowMapInvoke) {
                    fe = ((FlowMapInvoke)fe).getOutputNode(node[1]);
                }
            }
            return fe;
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public void setServerPipeline(IData in) {
        try {
            Values parms = new Values();
            parms.put("$pipeline", Values.use(in));
            parms.put("$oid", this.oid);
            Values values = Values.use(this.context.invoke(svcSetPipeline.getFullName(), null, parms.getIData()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateServerPipeline(String operation, String path, Object updateObj) {
        try {
            Values parms = new Values();
            parms.put("$pipelinePath", path);
            parms.put("$oid", this.oid);
            parms.put("$pipelineUpdateObject", updateObj);
            parms.put("$pipelineUpdate", operation);
            Values out = Values.use(this.context.invoke(svcUpdatePipeline.getFullName(), null, parms.getIData()));
            Values pipeline = out.getValues("$pipeline");
            this.setPipeline(pipeline.getIData());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getOID() {
        return this.oid;
    }

    public void throwIfError(Values data) throws ServiceException {
        this.throwIfError(data.getIData());
    }

    public void throwIfError(IData data) throws ServiceException {
        if (data == null) {
            return;
        }
        IDataCursor dc = data.getCursor();
        if (dc.first("$errorInfo")) {
            throw new ServiceException(Values.use(data));
        }
        if (!dc.first("$errorType")) {
            return;
        }
        String errorType = (String)dc.getValue();
        dc.delete();
        dc.first("$error");
        String error = (String)dc.getValue();
        dc.delete();
        dc.first("$localizedError");
        String locError = (String)dc.getValue();
        dc.delete();
        dc.first("$errorDump");
        String dump = (String)dc.getValue();
        dc.delete();
        dc.first("$redirected");
        String redir = (String)dc.getValue();
        dc.delete();
        throw new ServiceException(error, locError, errorType, dump, redir);
    }
}

