/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client.ns;

import com.wm.app.b2b.client.Context;
import com.wm.app.b2b.client.HttpClient;
import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.ns.NSRuntimeException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.lang.ns.NSName;
import com.wm.util.Values;
import java.util.Properties;

public class ContextWrapper {
    Context gOldContext;
    WmConnection gContext;
    HttpClient gCntx;
    boolean gUseOldContext = false;
    boolean gUseNewContext = false;

    public ContextWrapper(Context context) {
        this.gOldContext = context;
        this.gUseOldContext = true;
    }

    public ContextWrapper(WmConnection context) {
        this.gContext = context;
    }

    public ContextWrapper(HttpClient context) {
        this.gCntx = context;
        this.gUseNewContext = true;
    }

    public void setContext(WmConnection ctx) {
        this.gContext = ctx;
        this.gUseOldContext = false;
    }

    public void setContext(HttpClient ctx) {
        this.gCntx = ctx;
        this.gUseOldContext = false;
        this.gUseNewContext = true;
    }

    public Values invoke(String serviceName, Properties prop, IData input) {
        Values output = null;
        try {
            if (this.gUseOldContext) {
                NSName nsName = NSName.create(serviceName);
                output = this.gOldContext.invoke(nsName, Values.use(input));
            } else if (this.gUseNewContext) {
                NSName nsName = NSName.create(serviceName);
                output = Values.use(this.gCntx.sendReceive(serviceName, prop, input));
            } else {
                output = Values.use(this.gContext.sendReceive(serviceName, prop, input));
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new NSRuntimeException(e);
        }
        return output;
    }

    public Values invoke(NSName service, IData input) {
        return this.invoke(service.getFullName(), null, input);
    }

    public Values invoke(NSName service, String name, Object val) {
        String serviceName = service.getFullName();
        IData input = IDataFactory.create();
        IDataCursor cursor = input.getCursor();
        cursor.first();
        cursor.insertAfter(name, val);
        return this.invoke(serviceName, null, input);
    }
}

