/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.app.b2b.client.AccessException;
import com.wm.app.b2b.client.BaseContext;
import com.wm.app.b2b.client.DeliveryException;
import com.wm.app.b2b.client.InvalidRequestException;
import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.TXException;
import com.wm.app.b2b.client.resources.DeliveryExceptionBundle;
import com.wm.app.b2b.client.resources.InvalidRequestExceptionBundle;
import com.wm.app.b2b.client.resources.ServiceExceptionBundle;
import com.wm.app.b2b.util.tx.TXRmtJobMgr;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.ValuesEmulator;
import com.wm.util.Base64;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.ProxySettings;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.Codable;
import com.wm.util.coder.Coder;
import com.wm.util.coder.IDataCoder;
import com.wm.util.coder.RPCBinCoder2;
import com.wm.util.resources.TXJobExceptionBundle;
import com.wm.util.tx.TXJobException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Locale;

public class TContext
extends BaseContext
implements Codable,
IDataPortable {
    public static final int TCNTXT0001 = 1;
    public static final int TCNTXT0002 = 2;
    public static final int TCNTXT0003 = 3;
    public static final int TCNTXT0004 = 4;
    public static final int TCNTXT0005 = 5;
    public static final int TCNTXT0006 = 6;
    public static final int TCNTXT0007 = 7;
    public static final int TCNTXT0008 = 8;
    public static final int TCNTXT0009 = 9;
    public static final int TCNTXT0010 = 10;
    public static final int TCNTXT0011 = 11;
    public static final int TCNTXT0012 = 12;
    public static final int TCNTXT0013 = 13;
    private static TXRmtJobMgr jobMgr;
    private static boolean auditLog;
    private static ServiceException NotAvailableException;
    private static String JobExceptionName;
    static Values MailErrMsg;
    static String mailto;
    static boolean sentMail;
    static String logfile;
    static OutputStream logstream;
    static Writer logwriter;
    static String jobdir;
    protected String keyPath;
    protected String[] certPaths;

    public static void init() throws ServiceException {
        TContext.init(null, null, null, null, false);
    }

    public static void init(String jobdir, String logfile) throws ServiceException {
        TContext.init(jobdir, logfile, null, null, false);
    }

    public static void init(String jobdir) throws ServiceException {
        TContext.init(jobdir, null, null, null, true);
    }

    public static void init(String jobdir, OutputStream logstream) throws ServiceException {
        TContext.init(jobdir, null, logstream, null, false);
    }

    public static void init(String jobdir, Writer logwriter) throws ServiceException {
        TContext.init(jobdir, null, null, logwriter, false);
    }

    private static void init(String jobdir, String logfile, OutputStream logstream, Writer logwriter, boolean audit) throws ServiceException {
        auditLog = audit;
        try {
            boolean isDisabled;
            String s = Config.getProperty("watt.tx.disabled");
            if (s != null && s.length() != 0 && (isDisabled = new Boolean(s).booleanValue())) {
                return;
            }
            String jobdirProp = Config.getProperty("watt.tx.jobdir");
            String logfileProp = Config.getProperty("watt.tx.logfile");
            if (jobdirProp != null) {
                TContext.jobdir = jobdirProp;
            } else {
                TContext.jobdir = jobdir;
                Config.setProperty("watt.tx.jobdir", jobdir);
            }
            if (auditLog) {
                jobMgr = TXRmtJobMgr.init(auditLog);
            }
            if (logstream == null && logwriter == null && !auditLog) {
                if (logfileProp != null) {
                    TContext.logfile = logfileProp;
                } else {
                    TContext.logfile = logfile;
                    Config.setProperty("watt.tx.logfile", logfile);
                }
                jobMgr = TXRmtJobMgr.init(logstream);
            }
            if (logstream != null) {
                TContext.logstream = logstream;
                jobMgr = TXRmtJobMgr.init(logstream);
            } else if (logwriter != null) {
                TContext.logwriter = logwriter;
                jobMgr = TXRmtJobMgr.init(logwriter);
            }
            if (logfileProp == null) {
                Config.setProperty("watt.tx.logfile", null);
            }
            if (jobdirProp == null) {
                Config.setProperty("watt.tx.jobdir", null);
            }
            mailto = Config.getProperty("watt.server.txMail");
            sentMail = false;
        }
        catch (TXJobException e) {
            JournalLogger.logError(1, 37, e);
            throw new DeliveryException(e.toString());
        }
    }

    public static void shutdown() {
        TContext.shutdown(false);
    }

    public static void shutdown(boolean force) {
        try {
            TXRmtJobMgr.shutdown(force);
        }
        catch (TXJobException e) {
            JournalLogger.logError(2, 37, e);
        }
    }

    public static void resetJobMgr() throws ServiceException {
        TContext.resetJobMgr(null, null, null, null);
    }

    public static void resetJobMgr(String jobdir, String logfile) throws ServiceException {
        TContext.resetJobMgr(jobdir, logfile, null, null);
    }

    public static void resetJobMgr(String jobdir, String logfile, OutputStream logstream) throws ServiceException {
        TContext.resetJobMgr(jobdir, logfile, logstream, null);
    }

    public static void resetJobMgr(String jobdir, String logfile, Writer logwriter) throws ServiceException {
        TContext.resetJobMgr(jobdir, null, null, logwriter);
    }

    private static void resetJobMgr(String jobdir, String logfile, OutputStream logstream, Writer logwriter) throws ServiceException {
        try {
            if (jobMgr != null && jobMgr.enabled()) {
                JournalLogger.logCritical(3, 37);
                throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_UNABLE_RESET_JOBMGR_ENABLED, "");
            }
            TXRmtJobMgr.shutdown(true);
            TContext.init(jobdir, logfile, logstream, logwriter, auditLog);
            JournalLogger.logInfo(4, 37);
        }
        catch (TXJobException e) {
            JournalLogger.logError(5, 37, e);
            throw new ServiceException(e);
        }
    }

    public static void resetLogFile() throws ServiceException {
        TContext.resetLogFile(null);
    }

    public static void resetLogFile(String logfile) throws ServiceException {
        try {
            TContext.checkEnabled(jobMgr);
            jobMgr.resetLogFile(logfile);
        }
        catch (TXJobException e) {
            JournalLogger.logError(6, 37, e);
            throw new ServiceException(e);
        }
    }

    public static void resetLogStream(OutputStream logstream) throws ServiceException {
        try {
            TContext.checkEnabled(jobMgr);
            jobMgr.resetLogStream(logstream);
        }
        catch (TXJobException e) {
            JournalLogger.logError(7, 37, e);
            throw new ServiceException(e);
        }
    }

    public static void resetLogWriter(Writer logwriter) throws ServiceException {
        try {
            TContext.checkEnabled(jobMgr);
            jobMgr.resetLogWriter(logwriter);
        }
        catch (TXJobException e) {
            JournalLogger.logError(7, 37, e);
            throw new ServiceException(e);
        }
    }

    public TContext(Values context) {
        super(context);
    }

    public TContext() {
        super(1);
    }

    public void connect(String server, String user, String pass) throws ServiceException {
        this.checkEnabled();
        if (server == null) {
            throw new InvalidRequestException(InvalidRequestExceptionBundle.class, InvalidRequestExceptionBundle.INVALID_SEVER_SETTING, "");
        }
        if (this.connected) {
            throw new InvalidRequestException(InvalidRequestExceptionBundle.class, InvalidRequestExceptionBundle.ALREADY_CONNECTED, "");
        }
        if (user != null && user.length() > 0) {
            this.basicAuth = Base64.encode(Strings.cat(user, ":", pass));
        }
        this.server = server;
        jobMgr.access();
        this.lock();
        this.connected = true;
        this.unlock();
        this.gNumHosts = -1;
        this.setClusterServers();
    }

    public void connect(String server, byte[] certificate) throws ServiceException {
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_NOT_IMPL, "");
    }

    public void connect(String server, String certificate) throws ServiceException {
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_NOT_IMPL, "");
    }

    public void disconnect() {
        if (this.connected) {
            this.cleanupSession();
        }
        if (jobMgr != null) {
            jobMgr.release();
        }
    }

    public String startTx() throws ServiceException {
        return this.startTx(null, 0L, 0);
    }

    public String startTx(long ttl) throws ServiceException {
        return this.startTx(null, ttl, 0);
    }

    public String startTx(long ttl, int retries) throws ServiceException {
        return this.startTx(null, ttl, retries);
    }

    public String startTx(String followTid) throws ServiceException {
        return this.startTx(followTid, 0L, 0);
    }

    public String startTx(String followTid, long ttl) throws ServiceException {
        return this.startTx(followTid, ttl, 0);
    }

    public String startTx(String followTid, long ttl, int retries) throws ServiceException {
        this.checkEnabled();
        this.checkConnection();
        this.setClusterServers();
        try {
            return jobMgr.startJob(this.cloneCodable(), followTid, ttl, retries);
        }
        catch (TXJobException e) {
            JournalLogger.logError(8, 37, e);
            throw new DeliveryException(e);
        }
    }

    public Values invokeTx(String tid, String ifc, String svc, Values data) throws ServiceException {
        this.checkEnabled();
        this.submitTx(tid, ifc, svc, data);
        return this.retrieveTx(tid, true);
    }

    public IData invokeTx(String tid, String ifc, String svc, IData data) throws ServiceException {
        this.checkEnabled();
        this.submitTx(tid, ifc, svc, data);
        return this.retrieveIDTx(tid, true);
    }

    public void submitTx(String tid, String ifc, String svc, Values data) throws ServiceException {
        IData id = null;
        if (data != null) {
            id = data.getIData();
        }
        this.submitTx(tid, ifc, svc, id);
    }

    public void submitTx(String tid, String ifc, String svc, IData data) throws ServiceException {
        this.checkEnabled();
        try {
            jobMgr.executeJob(tid, ifc, svc, data);
        }
        catch (TXJobException e) {
            throw new DeliveryException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e);
        }
    }

    public void sendTx(String tid, String ifc, String svc, Values data) throws ServiceException {
        IData id = null;
        if (data != null) {
            id = data.getIData();
        }
        this.sendTx(tid, ifc, svc, id);
    }

    public void sendTx(String tid, String ifc, String svc, IData data) throws ServiceException {
        this.checkEnabled();
        try {
            jobMgr.sendJob(tid, ifc, svc, data);
        }
        catch (TXJobException e) {
            throw new DeliveryException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e);
        }
    }

    public Values retrieveTx(String tid) throws ServiceException {
        return this.retrieveTx(tid, true);
    }

    public IData retrieveIDTx(String tid) throws ServiceException {
        return this.retrieveIDTx(tid, true);
    }

    public Values retrieveTx(String tid, boolean block) throws ServiceException {
        IData res = this.retrieveIDTx(tid, block);
        if (res == null || res instanceof Values) {
            return (Values)res;
        }
        return Values.use(res);
    }

    public IData retrieveIDTx(String tid, boolean block) throws ServiceException {
        this.checkEnabled();
        try {
            IData data = jobMgr.retrieveJob(tid, block);
            TContext.throwIfError(data);
            return data;
        }
        catch (TXJobException e) {
            if (this.getTxStatusVal(tid) == 3) {
                throw new TXException(e);
            }
            throw new DeliveryException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e);
        }
    }

    public void endTx(String tid) throws ServiceException {
        this.checkEnabled();
        try {
            jobMgr.endJob(tid);
        }
        catch (TXJobException e) {
            throw new DeliveryException(e);
        }
    }

    public void restartTx(String tid) throws ServiceException {
        this.checkEnabled();
        try {
            jobMgr.restartJob(tid);
        }
        catch (TXJobException e) {
            JournalLogger.logError(9, 37, e);
            throw new DeliveryException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e);
        }
    }

    public Enumeration getTxIds() throws ServiceException {
        this.checkEnabled();
        return jobMgr.getJobIds();
    }

    public String getTxStatus(String tid) throws ServiceException {
        this.checkEnabled();
        return jobMgr.getJobStatus(tid);
    }

    public int getTxStatusVal(String tid) throws ServiceException {
        this.checkEnabled();
        return jobMgr.getJobStatusVal(tid);
    }

    public Values getTxData(String tid) throws ServiceException {
        IData res = this.getTxIData(tid);
        if (res == null || res instanceof Values) {
            return (Values)res;
        }
        return Values.use(res);
    }

    public IData getTxIData(String tid) throws ServiceException {
        this.checkEnabled();
        return jobMgr.getJobData(tid);
    }

    public String getRemoteTxId(String tid) throws ServiceException {
        this.checkEnabled();
        return jobMgr.getRmtTid(tid);
    }

    public String getChainedTxId(String tid) throws ServiceException {
        this.checkEnabled();
        return jobMgr.getChainedWait(tid);
    }

    public Values invokeJob(String ifc, String svc, Values data) throws ServiceException, TXJobException {
        IData res;
        IData id = null;
        if (data != null) {
            id = data.getIData();
        }
        if ((res = this.invokeJob(ifc, svc, id)) == null || res instanceof Values) {
            return (Values)res;
        }
        return Values.use(res);
    }

    public IData invokeJob(String ifc, String svc, IData data) throws ServiceException, TXJobException {
        IData result = null;
        URLConnection uc = null;
        if (this.gNumHosts < 0 && !ifc.equals("wm.server") && !svc.equals("getServerNodes")) {
            this.setClusterServers();
        }
        Coder valCoder = null;
        IDataCoder idataCoder = null;
        Object coder = this.getCoder();
        if (coder instanceof Coder) {
            valCoder = (Coder)coder;
        } else {
            idataCoder = (IDataCoder)coder;
        }
        if (!handlerSet) {
            this.loadWmHandler();
        }
        try {
            uc = this.getURLConnection(ifc, svc);
            if (this.basicAuth != null && this.fixedUri == null) {
                uc.setRequestProperty("Authorization", Strings.cat("Basic ", this.basicAuth));
            }
            if (valCoder != null) {
                uc.setRequestProperty("Content-type", valCoder.getContentType());
                valCoder.encode(uc.getOutputStream(), Values.use(data));
            } else {
                uc.setRequestProperty("Content-type", idataCoder.getContentType());
                idataCoder.encode(uc.getOutputStream(), data);
            }
            if (this.locale != null) {
                uc.setRequestProperty("Accept-Language", this.locale);
            } else {
                uc.setRequestProperty("Accept-Language", Locale.getDefault().toString());
            }
            InputStream is = uc.getInputStream();
            result = valCoder != null ? valCoder.decode(is) : idataCoder.decode(is);
            if (result == null && this.isClusteredEnv()) {
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_SERVER_UNREACHABLE, "");
            }
            if (result == null) {
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_SERVER_UNREACHABLE, "", true);
            }
            is.close();
        }
        catch (FileNotFoundException e) {
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_SERVER_UNREACHABLE, "", true);
        }
        catch (EOFException e) {
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_SERVER_UNREACHABLE, "", true);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("Invalid Session") >= 0) {
                this.cleanupSession();
                throw new AccessException(e);
            }
            if (msg != null && msg.indexOf("Authorization Required") >= 0) {
                throw new AccessException(e);
            }
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_INVOKE_ERROR, "", (Throwable)e, true);
        }
        catch (RuntimeException re) {
            boolean broken = this.isPipeBroken(ifc, svc);
            if (this.isClusteredEnv() && broken) {
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_SERVER_UNREACHABLE, "");
            }
            if (broken) {
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_SERVER_UNREACHABLE, "", true);
            }
            throw re;
        }
        this.checkJobError(result);
        if (uc instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)uc;
            huc.disconnect();
        }
        return result;
    }

    public Values clusterInvokeJob(String ifc, String svc, Values data) throws ServiceException, TXJobException {
        IData res;
        IData id = null;
        if (data != null) {
            id = data.getIData();
        }
        if ((res = this.clusterInvokeJob(ifc, svc, id)) == null || res instanceof Values) {
            return (Values)res;
        }
        return Values.use(res);
    }

    public IData clusterInvokeJob(String ifc, String svc, IData data) throws ServiceException, TXJobException {
        if (this.isClusteredEnv() && this.gAllowRedir != 0) {
            try {
                return this.clusterInvoke(this.getServers(), 6, ifc, svc, data);
            }
            catch (TXJobException txje) {
                throw txje;
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Exception e) {
                throw new TXJobException(e);
            }
        }
        return this.invokeJob(ifc, svc, data);
    }

    private void checkJobError(Values data) throws ServiceException, TXJobException {
        if (data == null) {
            return;
        }
        this.checkJobError(data.getIData());
    }

    private void checkJobError(IData data) throws ServiceException, TXJobException {
        if (data == null) {
            return;
        }
        IDataCursor ic = data.getCursor();
        IData errorInfo = null;
        if (ic.first("$errorInfo")) {
            errorInfo = (IData)ic.getValue();
        }
        String errorType = null;
        if (ic.first("$errorType")) {
            errorType = ic.getValue().toString();
        }
        if (errorInfo == null && errorType == null) {
            ic.destroy();
            return;
        }
        String error = null;
        String locError = null;
        String redirServer = null;
        if (errorInfo == null) {
            error = ValuesEmulator.getString(data, "$error");
            locError = ValuesEmulator.getString(data, "$localizedError");
            redirServer = ValuesEmulator.getString(data, "$redirected");
        } else {
            IDataCursor ie = errorInfo.getCursor();
            if (ic.first("$error")) {
                error = ic.getValue().toString();
            }
            if (ic.first("$localizedError")) {
                locError = ic.getValue().toString();
            }
            if (ic.first("$redirected")) {
                redirServer = ic.getValue().toString();
            }
            ie.destroy();
        }
        ic.destroy();
        if (error.indexOf("BAC.0006.0023") != -1) {
            throw new TXJobException(error, true);
        }
        if (errorType.equals(JobExceptionName)) {
            throw new TXJobException(error, true);
        }
        throw new ServiceException(error, locError, errorType, null, redirServer);
    }

    protected void clusterCleanupConnection() {
        this.disconnect();
    }

    protected void clusterDisconnect() {
        this.disconnect();
    }

    protected int clusterConnect(String newServer, byte[] certAuth, String basicAuth, String sessionID) {
        int result = 1;
        this.basicAuth = basicAuth;
        try {
            this.connect(newServer, null, null);
        }
        catch (ServiceException e) {
            result = 2;
        }
        catch (Exception e) {
            result = 2;
        }
        return result;
    }

    protected Values clusterSvcInvoke(String ifc, String svc, Values in) throws Exception {
        IData res;
        IData id = null;
        if (in != null) {
            id = in.getIData();
        }
        if ((res = this.clusterSvcInvoke(ifc, svc, id)) == null || res instanceof Values) {
            return (Values)res;
        }
        return Values.use(res);
    }

    protected IData clusterSvcInvoke(String ifc, String svc, IData in) throws Exception {
        IData result;
        try {
            result = this.invokeJob(ifc, svc, in);
        }
        catch (TXJobException e) {
            result = IDataFactory.create(2);
            if (e.getMessage() == null) {
                throw e;
            }
            String exactError = e.toString().toLowerCase();
            if (exactError.indexOf("server unreachable") != -1 || exactError.indexOf("connection reset") != -1 || exactError.indexOf("connection closed") != -1 || exactError.indexOf("java.net.connectionexception") != -1 || exactError.indexOf("java.net.socketexception") != -1 || exactError.indexOf("connection refused") != -1) {
                ValuesEmulator.put(result, "cmresult", (Object)Integer.toString(3));
            }
            throw e;
        }
        catch (ServiceException e) {
            if (e.getMessage() == null) {
                throw e;
            }
            String exactError = e.toString();
            result = IDataFactory.create(2);
            if (exactError.indexOf("Redirected") != -1) {
                String redirSrv = e.getRedir();
                if (redirSrv == null) {
                    ValuesEmulator.put(result, "cmresult", (Object)Integer.toString(3));
                } else {
                    ValuesEmulator.put(result, "cmresult", (Object)Integer.toString(4));
                    ValuesEmulator.put(result, "cmresultStr", (Object)redirSrv);
                }
            }
            throw e;
        }
        return result;
    }

    protected void clusterAbort() throws Exception {
        throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_SERVER_UNREACHABLE, "", true);
    }

    private void setClusterServers() {
        String s;
        if (this.gNumHosts >= 0) {
            return;
        }
        Values out = null;
        Values in = new Values();
        double serverVersion = 2.0;
        this.setRpc2Ver(4);
        for (int j = 0; j < 2; ++j) {
            try {
                out = this.invokeJob("wm.server", "getServerNodes", in);
                this.setServers(out.getValues("$members"));
                break;
            }
            catch (TXJobException e) {
                if (j == 0 && this.gRetryServer != null) {
                    String temp = this.gRetryServer;
                    this.gRetryServer = this.server;
                    this.server = temp;
                    continue;
                }
                return;
            }
            catch (ServiceException e) {
                this.setServers(null);
                return;
            }
            catch (Exception e) {
                JournalLogger.logError(10, 37, e);
                return;
            }
        }
        if ((s = out.getString("$version")) != null) {
            try {
                serverVersion = Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = out.getString("$rpc2ver")) != null) {
            int i;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                i = -1;
            }
            this.setRpc2Ver(i);
        } else if (serverVersion == 3.0) {
            this.setRpc2Ver(6);
        }
        if (serverVersion >= 3.5 && this.rpc_type == 1) {
            this.rpc_type = 3;
        } else if (serverVersion < 3.5 && this.rpc_type == 3) {
            this.rpc_type = 1;
        }
        if (serverVersion >= 4.0) {
            this.setBinVer(2);
        } else {
            this.setBinVer(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnabled() throws ServiceException {
        try {
            if (jobMgr == null) {
                TContext tContext = this;
                synchronized (tContext) {
                    jobMgr = TXRmtJobMgr.get();
                }
            }
            TContext.checkEnabled(jobMgr);
        }
        catch (TXJobException e) {
            JournalLogger.logError(11, 37, e);
            throw new DeliveryException(e);
        }
    }

    private static void checkEnabled(TXRmtJobMgr jobMgr) throws TXJobException, DeliveryException {
        if (jobMgr == null || !jobMgr.enabled()) {
            TContext.checkMail();
            JournalLogger.logError(12, 37);
            throw new DeliveryException(DeliveryExceptionBundle.class, DeliveryExceptionBundle.GD_DISABLED, "");
        }
    }

    public void dumpJobs() throws ServiceException {
        Enumeration ids = this.getTxIds();
        while (ids.hasMoreElements()) {
            String tid = (String)ids.nextElement();
            System.out.println("Status for tid=" + tid + " (" + this.getTxStatus(tid) + ")");
        }
    }

    private static void checkMail() {
        if (sentMail || mailto == null) {
            return;
        }
        TContext.sendMail("Transaction Manager (Outbound Jobs) Disabled", "Please examine and correct error(s) in the outbound logfile and then execute the 'wm.server.tx:resetOutbound' service.");
        sentMail = true;
    }

    private static boolean sendMail(String subject, String body) {
        if (mailto == null) {
            return false;
        }
        try {
            Class<?> svrClass = Class.forName("com.wm.app.b2b.server.Server");
            Class<?> strClass = Class.forName("java.lang.String");
            Class[] sig = new Class[]{strClass, strClass, strClass, strClass};
            Method sndMethod = svrClass.getMethod("sendMail", sig);
            String mailFrom = "TContext";
            try {
                mailFrom = "TContext@" + Config.getLocalHost().getHostName();
            }
            catch (Exception e) {
                JournalLogger.logError(9, 14);
            }
            Object[] args = new Object[]{mailto, mailFrom, subject, body};
            sndMethod.invoke(null, args);
            JournalLogger.logDebugPlus(3, 13, 37, mailto, subject);
        }
        catch (Exception e) {
            JournalLogger.logDebugPlus(3, 13, 37, e);
        }
        return true;
    }

    protected void finalize() throws Throwable {
        if (jobMgr != null) {
            jobMgr.release();
        }
    }

    private TContext cloneCodable() {
        TContext tc = new TContext();
        tc.rpc_type = this.rpc_type;
        tc.secure = this.secure;
        tc.connected = this.connected;
        tc.gAllowRedir = this.gAllowRedir;
        tc.gNumHosts = this.gNumHosts;
        tc.rpc2Ver = this.rpc2Ver;
        tc.binVer = this.binVer;
        tc.gMaxTries = this.gMaxTries;
        tc.server = this.server != null ? new String(this.server) : null;
        tc.basicAuth = this.basicAuth != null ? new String(this.basicAuth) : null;
        tc.fixedUri = this.fixedUri != null ? new String(this.fixedUri) : null;
        tc.keyPath = this.keyPath;
        tc.certPaths = this.certPaths;
        Values val = this.getServers();
        if (val != null) {
            tc.setServers((Values)val.clone());
        }
        return tc;
    }

    public String[] getValueKeys() {
        String[] s = new String[]{"server", "basicAuth", "proxy", "secure", "connected", "rpcType", "fixedUri", "rpc2Ver", "gAllowRedir", "gNumHosts", "gMaxTries", "gServers", "gRetryServer", "key", "certChain", "binVer"};
        return s;
    }

    public Object getValue(String key) {
        if (key.equals("server")) {
            return this.server;
        }
        if (key.equals("gRetryServer")) {
            return this.gRetryServer;
        }
        if (key.equals("basicAuth")) {
            return this.basicAuth;
        }
        if (key.equals("proxy")) {
            String proxy = (String)System.getProperties().get("watt.net.proxyHost");
            String proxyUser = (String)System.getProperties().get("watt.net.proxyUser");
            String proxyAuth = null;
            if (proxyUser != null && proxyUser.length() > 0) {
                String proxyPass = ProxySettings.getHttpProxyPass() != null ? ProxySettings.getHttpProxyPass().toString() : "";
                proxyAuth = Base64.encode(Strings.cat(proxyUser, ":", proxyPass));
            }
            Object[][] o = new Object[][]{{"proxy", proxy != null && proxy.length() > 0 ? Strings.cat(proxy, ":", System.getProperty("watt.net.proxyPort")) : null}, {"proxyAuth", proxyAuth}};
            return new Values(o);
        }
        if (key.equals("secure")) {
            return this.secure ? "1" : "0";
        }
        if (key.equals("connected")) {
            return this.connected ? "1" : "0";
        }
        if (key.equals("rpcType")) {
            switch (this.rpc_type) {
                case 3: {
                    return new Integer(3);
                }
                case 2: {
                    return new Integer(2);
                }
            }
            return new Integer(1);
        }
        if (key.equals("fixedUri")) {
            return this.fixedUri;
        }
        if (key.equals("rpc2Ver")) {
            return Integer.toString(this.rpc2Ver);
        }
        if (key.equals("binVer")) {
            return Integer.toString(this.binVer);
        }
        if (key.equals("gAllowRedir")) {
            return Integer.toString(this.gAllowRedir);
        }
        if (key.equals("gNumHosts")) {
            return Integer.toString(this.gNumHosts);
        }
        if (key.equals("gMaxTries")) {
            return Integer.toString(this.gMaxTries);
        }
        if (key.equals("gServers")) {
            if (this.gServers == null) {
                return null;
            }
            try {
                RPCBinCoder2 rpc = new RPCBinCoder2();
                byte[] encoded = rpc.encodeToBytes(this.gServers);
                return encoded;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (key.equals("key")) {
            return this.keyPath;
        }
        if (key.equals("certChain")) {
            return this.certPaths;
        }
        return null;
    }

    public void setValue(String key, Object value) {
        if (key.equals("server")) {
            this.server = (String)value;
        } else if (key.equals("gRetryServer")) {
            this.gRetryServer = (String)value;
        } else if (key.equals("basicAuth")) {
            this.basicAuth = (String)value;
        } else if (key.equals("proxy")) {
            Values p = (Values)value;
            String proxy = (String)p.get("proxy");
            if (proxy != null) {
                String pa = (String)p.get("proxyAuth");
                String proxyAuth = Base64.decode(pa);
                this.setProxy(proxy, this.getUser(proxyAuth), this.getPass(proxyAuth));
            }
        } else if (key.equals("secure")) {
            this.setSecure(((String)value).equals("1"));
        } else if (key.equals("connected")) {
            this.lock();
            this.connected = ((String)value).equals("1");
            this.unlock();
        } else if (key.equals("rpcType")) {
            this.setRPCType((Integer)value);
        } else if (key.equals("fixedUri")) {
            this.setFixedUri((String)value);
        } else if (key.equals("rpc2Ver")) {
            try {
                this.setRpc2Ver(Integer.parseInt((String)value));
            }
            catch (Exception e) {
                this.setRpc2Ver(-1);
            }
        } else if (key.equals("binVer")) {
            try {
                this.setBinVer(Integer.parseInt((String)value));
            }
            catch (Exception e) {
                this.setBinVer(1);
            }
        } else if (key.equals("gAllowRedir")) {
            try {
                this.gAllowRedir = Integer.parseInt((String)value);
            }
            catch (Exception e) {}
        } else if (key.equals("gNumHosts")) {
            try {
                this.gNumHosts = Integer.parseInt((String)value);
            }
            catch (Exception e) {}
        } else if (key.equals("gMaxTries")) {
            try {
                this.gMaxTries = Integer.parseInt((String)value);
            }
            catch (Exception e) {}
        } else if (key.equals("gServers")) {
            try {
                if (value != null && value instanceof byte[]) {
                    RPCBinCoder2 rpc = new RPCBinCoder2();
                    Values v = rpc.decodeFromBytes((byte[])value);
                    this.setServers(v);
                }
            }
            catch (Exception exception) {}
        } else if (key.equals("key")) {
            this.keyPath = (String)value;
        } else if (key.equals("certChain")) {
            this.certPaths = (String[])value;
        }
    }

    protected void setValues(Values values) {
        String[] keys = this.getValueKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.setValue(keys[i], values.get(keys[i]));
        }
    }

    protected Values getValues() {
        Values val = new Values();
        String[] keys = this.getValueKeys();
        for (int i = 0; i < keys.length; ++i) {
            val.put(keys[i], this.getValue(keys[i]));
        }
        return val;
    }

    public IData getAsData() {
        return this.getValues().getIData();
    }

    public void setFromData(IData data) {
        this.setValues(Values.use(data));
    }

    private String getUser(String userPass) {
        if (userPass == null || userPass.length() == 0) {
            return null;
        }
        int pos = userPass.indexOf(58);
        if (pos < 0) {
            return userPass;
        }
        return userPass.substring(0, pos);
    }

    private String getPass(String userPass) {
        if (userPass == null) {
            return "";
        }
        int pos = userPass.indexOf(58);
        if (pos < 0 || pos == userPass.length() - 1) {
            return "";
        }
        try {
            return userPass.substring(pos + 1);
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    public void setSSLCertificates(String keyPath, String[] certPaths) throws CertificateException, IOException, InvalidKeyException {
        this.keyPath = keyPath;
        this.certPaths = certPaths;
        super.setSSLCertificates(keyPath, certPaths);
    }

    public void updateCredentials() throws ServiceException {
        try {
            this.setSSLCertificates(this.keyPath, this.certPaths);
        }
        catch (CertificateException ce) {
            throw new ServiceException(ce);
        }
        catch (IOException ioe) {
            throw new ServiceException(ioe);
        }
        catch (InvalidKeyException ike) {
            throw new ServiceException(ike);
        }
    }

    static {
        auditLog = false;
        NotAvailableException = new InvalidRequestException(InvalidRequestExceptionBundle.class, InvalidRequestExceptionBundle.METHOD_NOT_SUPPORTED, "");
        JobExceptionName = new TXJobException("dummy").getClass().getName();
        MailErrMsg = new Values();
        MailErrMsg.put("Error", "No administrator configured");
    }
}

