/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.app.b2b.client.TContext;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.util.Debug;
import com.wm.util.Values;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TCTest
extends Thread {
    TContext tc;
    static final String TID = "tid";
    static String lastTid;
    static String ifc;
    static String svc;
    static Values data;
    public static String PS1;

    public TCTest(TContext tc) {
        this.tc = tc;
    }

    public void run() {
        try {
            TCTest.doWork(this.tc);
        }
        catch (Exception e) {
            System.setErr(System.out);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void printUsage() {
        System.out.println("usage: TCTest [-[i]] | [ start | chain <tid> | end <tid> | ");
        System.out.println("\tinvoke <tid> | submit <tid> | send <tid> |");
        System.out.println("\tretrieve <tid> [block] | restart <tid> | dump | data | ");
        System.out.println("\tstatus <tid> | rmtid <tid> | followid <tid> | ");
        System.out.println("\tresetLog <logfile> | resetMgr <joblog> <logfile> | ");
        System.out.println("\tset <ifc> <svc> | data <key> <val> | auto ]");
        System.out.println("\t[ -debug <level> ]");
        System.out.println();
        System.out.println("In interactive mode, 'tid' uses last entered tid value");
        System.out.println();
        System.out.println("       -\t\t\tTake input from stdin");
        System.out.println("       -i\t\t\tInteractive mode");
        System.out.println();
        System.out.println("       set\t<ifc> <svc>\tset service to invoke");
        System.out.println("       data\t<key> <val>\tadd data to inputs; no args reset inputs");
        System.out.println("       start\t<ttl>\t\tcreate a transaction with optional time-to-live");
        System.out.println("\t\t\t\tand return a new tid");
        System.out.println("       chain\t<tid> <ttl>\tcreate a chained transaction with a");
        System.out.println("\t\t\t\ttime-to-live and return a new tid");
        System.out.println("       end\t<tid>\t\tcleanup/delete transaction");
        System.out.println("       invoke\t<tid>\t\tperform synchronous service invocation");
        System.out.println("       submit\t<tid>\t\tperform asynchronous service invocation");
        System.out.println("       retrieve\t<tid> <block>\tperform asynchronous data retrieval,");
        System.out.println("\t\t\t\toptionally block");
        System.out.println("       send\t<tid>\t\tperform asynchronous one-way service invocation");
        System.out.println("       restart\t<tid>\t\trestart an expired/failed transaction");
        System.out.println("       rmtid\t<tid>\t\tget remote transaction id");
        System.out.println("       followid\t<tid>\t\tget follow transaction id");
        System.out.println("       dump\t\t\tlist all existing transactions");
        System.out.println("       status\t<tid>\t\tdisplay transaction status");
        System.out.println("       resetLog\t<file>\t\treset log file");
        System.out.println("       resetMgr\t<jobdir><logfile>\treset job mgr");
        System.out.println();
        System.out.println("       auto\t\t\tautomatic threaded test");
        System.out.println();
        System.out.println("       -debug\t<level>\t\tSpecify debug level");
    }

    public static void threadTest(TContext tc) throws Exception {
        TCTest w = new TCTest(tc);
        TCTest w1 = new TCTest(tc);
        TCTest w2 = new TCTest(tc);
        w.start();
        w1.start();
        w2.start();
        TCTest.doWork(tc);
        w.join();
        w1.join();
        w2.join();
    }

    public static void doWork(TContext tc) throws Exception {
        String[] tids;
        String tid = null;
        Values in = null;
        Values out = null;
        tc.dumpJobs();
        tid = tc.startTx(3L);
        out = tc.invokeTx(tid, "wm.server", "ping", new Values());
        System.out.println("out=" + out.toString());
        tc.endTx(tid);
        tid = tc.startTx(3L);
        in = new Values();
        in.put("nsName", "pub.remote:invokeTX");
        out = tc.invokeTx(tid, "wm.server.ns", "isNameValid", in);
        System.out.println("OUT======" + out.toString());
        tc.endTx(tid);
        IData id = IDataFactory.create();
        IDataCursor idc = id.getCursor();
        idc.insertAfter("key", "v1");
        idc.insertAfter("other", "vo");
        idc.insertAfter("key", "v2");
        idc.insertAfter("$xmldata", "<invoice><item>tutu</item><user>elliot</user></invoice>");
        idc.destroy();
        tid = tc.startTx(3L);
        IData od = tc.invokeTx(tid, "pub.web", "documentToRecord", id);
        System.out.println("Result IData=> " + od);
        tc.endTx(tid);
        tid = tc.startTx(3L);
        System.out.println("Fire-and-forget tid=" + tid);
        tc.sendTx(tid, "wm.server", "ping", new Values());
        String tid1 = tc.startTx(3L);
        String tid2 = tc.startTx(4L);
        String tid3 = tc.startTx(5L);
        String tid4 = tc.startTx(6L);
        System.out.println("Started 4 jobs");
        tc.dumpJobs();
        tc.submitTx(tid1, "wm.server", "ping", new Values());
        tc.submitTx(tid2, "wm.server", "ping", new Values());
        tc.submitTx(tid3, "wm.server", "ping", new Values());
        tc.submitTx(tid4, "wm.server", "ping", new Values());
        System.out.println("Submitted 4 jobs");
        tc.dumpJobs();
        out = tc.retrieveTx(tid2, true);
        System.out.println("out=" + out.toString());
        out = tc.retrieveTx(tid4, true);
        System.out.println("out=" + out.toString());
        out = tc.retrieveTx(tid1, true);
        System.out.println("out=" + out.toString());
        tc.endTx(tid2);
        tc.endTx(tid4);
        tc.endTx(tid1);
        System.out.println("Retrieved/Ended 3 jobs");
        tc.dumpJobs();
        while ((out = tc.retrieveTx(tid3, false)) == null) {
        }
        System.out.println("out=" + out.toString());
        tc.endTx(tid3);
        System.out.println("Retrieved/Ended 1 job");
        tc.dumpJobs();
        tids = new String[]{tc.startTx(3L), tc.startTx(tids[0], 4L), tc.startTx(tids[1], 5L)};
        System.out.println("Started 3 chained jobs:");
        System.out.println(tids[0] + ": chained wait (" + tc.getChainedTxId(tids[0]) + ")");
        System.out.println(tids[1] + ": chained wait (" + tc.getChainedTxId(tids[1]) + ")");
        System.out.println(tids[2] + ": chained wait (" + tc.getChainedTxId(tids[2]) + ")");
        System.out.println("Submit third job");
        tc.submitTx(tids[2], "wm.server", "ping", new Values());
        System.out.println(tids[0] + ": chained wait (" + tc.getChainedTxId(tids[0]) + ")");
        System.out.println(tids[1] + ": chained wait (" + tc.getChainedTxId(tids[1]) + ")");
        System.out.println(tids[2] + ": chained wait (" + tc.getChainedTxId(tids[2]) + ")");
        System.out.println("Invoke first job: " + tc.invokeTx(tids[0], "wm.server", "ping", new Values()));
        System.out.println(tids[0] + ": chained wait (" + tc.getChainedTxId(tids[0]) + ")");
        System.out.println(tids[1] + ": chained wait (" + tc.getChainedTxId(tids[1]) + ")");
        System.out.println(tids[2] + ": chained wait (" + tc.getChainedTxId(tids[2]) + ")");
        System.out.println("Try to retrieve third job:" + tc.retrieveTx(tids[2], false));
        System.out.println("Invoke second job:" + tc.invokeTx(tids[1], "wm.server", "ping", new Values()));
        System.out.println(tids[0] + ": chained wait (" + tc.getChainedTxId(tids[0]) + ")");
        System.out.println(tids[1] + ": chained wait (" + tc.getChainedTxId(tids[1]) + ")");
        System.out.println(tids[2] + ": chained wait (" + tc.getChainedTxId(tids[2]) + ")");
        System.out.println("Retrieve third job:" + tc.retrieveTx(tids[2]));
        tc.endTx(tids[0]);
        tc.endTx(tids[1]);
        tc.endTx(tids[2]);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            TCTest.printUsage();
            System.exit(-1);
        }
        boolean useStdin = args[0].startsWith("-");
        if (!args[0].equals("-i")) {
            PS1 = null;
        }
        Debug.setLevel(0);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-debug")) continue;
            Debug.setLevel(Integer.parseInt(args[i + 1]));
        }
        String arg0 = args[0];
        String arg1 = null;
        if (args.length > 1) {
            arg1 = args[1];
        }
        String arg2 = null;
        if (args.length > 2) {
            arg2 = args[2];
        }
        TContext tc = null;
        try {
            TContext.init("./jobs", "./tx.log");
            tc = new TContext();
            tc.connect("localhost:5555", "Administrator", "manage");
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            System.exit(-1);
        }
        if (useStdin) {
            String cmd = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            if (PS1 != null) {
                TCTest.printUsage();
                System.out.print(PS1);
            }
            cmd = in.readLine();
            while (cmd != null && !cmd.equalsIgnoreCase("quit")) {
                StringTokenizer st = new StringTokenizer(cmd);
                arg0 = st.hasMoreTokens() ? st.nextToken() : null;
                arg1 = st.hasMoreTokens() ? st.nextToken() : null;
                arg2 = st.hasMoreTokens() ? st.nextToken() : null;
                if (arg0 != null) {
                    if (!arg0.equals("start") && arg1 != null) {
                        if (arg1.equals(TID) && lastTid != null) {
                            arg1 = lastTid;
                        } else {
                            lastTid = arg1;
                        }
                    }
                    TCTest.perform(tc, arg0, arg1, arg2);
                }
                if (PS1 != null) {
                    System.out.print(PS1);
                }
                cmd = in.readLine();
            }
        } else {
            TCTest.perform(tc, arg0, arg1, arg2);
        }
        try {
            tc.disconnect();
            TContext.shutdown();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            System.exit(-1);
        }
    }

    public static void perform(TContext tc, String arg0, String arg1, String arg2) {
        String tid = null;
        Object in = null;
        Values out = null;
        try {
            if (arg0.equals("invoke")) {
                out = tc.invokeTx(arg1, ifc, svc, data);
                System.out.println("out=" + out.toString());
            } else if (arg0.equals("start")) {
                if (arg1 == null) {
                    arg1 = "5";
                }
                lastTid = tid = tc.startTx(new Integer(arg1).intValue(), 2);
                System.out.println("Started tid=" + tid + " with ttl of " + arg1 + " minutes");
            } else if (arg0.equals("chain")) {
                if (arg1 == null) {
                    System.out.println("Must supply a tid");
                } else {
                    if (arg2 == null) {
                        arg2 = "5";
                    }
                    lastTid = tid = tc.startTx(arg1, new Integer(arg2).intValue(), 2);
                    System.out.println("Started chained tid=" + tid + " with ttl of " + arg1 + " minutes to follow tid=" + arg1);
                }
            } else if (arg0.equals("set")) {
                ifc = arg1;
                svc = arg2;
            } else if (arg0.equals("data")) {
                if (arg1 == null) {
                    data = new Values();
                } else {
                    data.put(arg1, arg2);
                }
            } else if (arg0.equals("end")) {
                tc.endTx(arg1);
            } else if (arg0.equals("restart")) {
                tc.restartTx(arg1);
            } else if (arg0.equals("dump")) {
                tc.dumpJobs();
            } else if (arg0.equals("send")) {
                tc.sendTx(arg1, ifc, svc, data);
            } else if (arg0.equals("submit")) {
                tc.submitTx(arg1, ifc, svc, data);
            } else if (arg0.equals("retrieve")) {
                boolean b = arg2 != null;
                out = tc.retrieveTx(arg1, b);
                if (out == null) {
                    System.out.println("No data returned");
                } else {
                    System.out.println("out=" + out.toString());
                }
            } else if (arg0.equals("status")) {
                System.out.println(tc.getTxStatus(arg1) + " (" + tc.getTxStatusVal(arg1) + ")");
            } else if (arg0.equals("data")) {
                System.out.println(tc.getTxData(arg1));
            } else if (arg0.equals("rmtid")) {
                String id = tc.getRemoteTxId(arg1);
                if (id == null) {
                    System.out.println("No rmt id");
                } else {
                    System.out.println("Rmt tid=" + id);
                }
            } else if (arg0.equals("followid")) {
                String id = tc.getChainedTxId(arg1);
                if (id == null) {
                    System.out.println("No follow id");
                } else {
                    System.out.println("Follow tid=" + id);
                }
            } else if (arg0.equals("resetLog")) {
                TContext.resetLogFile(arg1);
            } else if (arg0.equals("resetMgr")) {
                TContext.shutdown(true);
                TContext.resetJobMgr(arg1, arg2);
            } else if (arg0.equals("auto")) {
                TCTest.threadTest(tc);
            } else {
                TCTest.printUsage();
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    static {
        ifc = "pub.web";
        svc = "documentToRecord";
        data = new Values();
        data.put("msg", "howdy");
        data.put("talisman", "666");
        data.put("$xmldata", "<invoice><item>tutu</item><user>elliot</user></invoice>");
        PS1 = "> ";
    }
}

