/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.ns.NSException;
import com.wm.util.Values;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ServiceException
extends NSException {
    static final boolean debug = false;
    String service;
    String user;
    Date time;
    String message;
    String localizedMessage;
    String errType;
    String errDump;
    String redirServer;
    String msgId;
    IData[] callstack;
    String nestedmessage;
    String nestedlocalizedMessage;
    String nestederrType;
    String nestederrDump;
    String nestedredirServer;
    String nestedservice;
    String nesteduser;
    Date nestedtime;
    IData[] nestedcallstack;
    Values errorInfo;

    public ServiceException() {
    }

    public ServiceException(Throwable t) {
        super(t);
        this.message = t.getMessage();
        this.errType = t.getClass().getName();
        this.redirServer = null;
    }

    public ServiceException(String s) {
        this(s, (String)null);
    }

    public ServiceException(String s, String eType) {
        super(s);
        this.message = s;
        this.errType = eType;
        this.redirServer = null;
    }

    public ServiceException(String s, String eType, String eDump) {
        this(s, eType);
        this.errDump = eDump;
        this.redirServer = null;
    }

    public ServiceException(String s, String eType, String eDump, String redirServer) {
        this(s, eType, eDump);
        this.redirServer = redirServer;
    }

    public ServiceException(String s, String locS, String eType, String eDump, String redirServer) {
        this(s, eType, eDump);
        this.localizedMessage = locS;
        this.redirServer = redirServer;
    }

    public ServiceException(Values in) {
        this.errorInfo = (Values)in.get("$errorInfo");
        if (this.errorInfo != null) {
            IDataCursor ic = this.errorInfo.getCursor();
            this.message = ic.first("$error") ? (String)ic.getValue() : null;
            this.service = ic.first("$service") ? (String)ic.getValue() : null;
            this.user = ic.first("$user") ? (String)ic.getValue() : null;
            this.time = ic.first("$time") ? (Date)ic.getValue() : null;
            this.localizedMessage = ic.first("$localizedError") ? (String)ic.getValue() : null;
            this.errType = ic.first("$errorType") ? (String)ic.getValue() : null;
            this.errDump = ic.first("$errorDump") ? (String)ic.getValue() : null;
            this.redirServer = ic.first("$redirected") ? (String)ic.getValue() : null;
            if (ic.first("$details")) {
                super.setErrorDetails((IData)ic.getValue());
            }
            this.callstack = ic.first("$callStack") ? this.getCallStackToIDataArray(ic.getValue()) : null;
            this.msgId = ic.first("$errorMsgId") ? this.errorInfo.getString("$errorMsgId") : null;
            if (ic.first("$errorInfo")) {
                IData nestedInfo = (IData)ic.getValue();
                IDataCursor inc = nestedInfo.getCursor();
                this.nestedmessage = inc.first("$error") ? (String)inc.getValue() : null;
                this.nestedlocalizedMessage = inc.first("$localizedError") ? (String)inc.getValue() : null;
                this.nestederrType = inc.first("$errorType") ? (String)inc.getValue() : null;
                this.nestederrDump = inc.first("$errorDump") ? (String)inc.getValue() : null;
                this.nestedredirServer = inc.first("$redirected") ? (String)inc.getValue() : null;
                this.nestedservice = inc.first("$service") ? (String)inc.getValue() : null;
                this.nesteduser = inc.first("$user") ? (String)inc.getValue() : null;
                this.nestedtime = inc.first("$time") ? (Date)inc.getValue() : null;
                this.nestedcallstack = inc.first("$callStack") ? this.getCallStackToIDataArray(ic.getValue()) : null;
                inc.destroy();
            } else {
                this.nestedredirServer = null;
                this.nestederrDump = null;
                this.nestederrType = null;
                this.nestedlocalizedMessage = null;
                this.nestedmessage = null;
                this.nestedcallstack = null;
            }
            ic.destroy();
        } else {
            this.message = in.getString("$error");
            this.localizedMessage = in.getString("$localizedError");
            this.errType = in.getString("$errorType");
            this.errDump = in.getString("$errorDump");
            this.redirServer = in.getString("$redirected");
        }
    }

    private IData[] getCallStackToIDataArray(Object val) {
        if (val instanceof IData[]) {
            return (IData[])val;
        }
        if (val instanceof Vector) {
            Vector errorStack = (Vector)val;
            int count = errorStack.size();
            IData[] eStack = new IData[count];
            Enumeration e = errorStack.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                eStack[i] = (IData)e.nextElement();
                ++i;
            }
            return eStack;
        }
        return null;
    }

    public ServiceException(Class bundleClass, String bundleKey, String sourceId, String parameter) {
        super(bundleClass, bundleKey, sourceId, parameter);
    }

    public ServiceException(Class bundleClass, String bundleKey, String sourceId) {
        super(bundleClass, bundleKey, sourceId);
    }

    public ServiceException(Class bundleClass, String bundleKey, String sourceId, Object[] subs) {
        super(bundleClass, bundleKey, sourceId, subs);
    }

    public void reThrow() throws Exception {
        if (this.errType == null) {
            throw this;
        }
        try {
            Class<?> eclass = Class.forName(this.errType);
            Class[] clist = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> econst = eclass.getConstructor(clist);
            String[] args = new String[]{this.message};
            throw (Exception)econst.newInstance(args);
        }
        catch (Throwable t) {
            throw this;
        }
    }

    public Exception getOriginalException() {
        if (this.errType == null) {
            return this;
        }
        try {
            String[] args;
            Constructor<?> econst;
            if (this.errType.endsWith("ServiceException")) {
                this.errType = "com.wm.app.b2b.client.ServiceException";
                Class<?> eclass = Class.forName(this.errType);
                Class[] clist = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                econst = eclass.getConstructor(clist);
            } else {
                Class[] clist = new Class[]{Class.forName("java.lang.String")};
                Class<?> eclass = Class.forName(this.errType);
                econst = eclass.getConstructor(clist);
            }
            if (this.errType.endsWith("ServiceException")) {
                args = new String[]{this.message, this.localizedMessage, "com.wm.app.b2b.server.ServiceException", this.errDump, this.redirServer};
            } else {
                if (this.errType.endsWith("BasisRuntimeException")) {
                    return this;
                }
                if (this.localizedMessage != null && this.localizedMessage.length() != 0) {
                    this.message = this.localizedMessage;
                }
                args = new String[]{this.message};
            }
            return (Exception)econst.newInstance(args);
        }
        catch (Throwable t) {
            return this;
        }
    }

    public String getMessage() {
        if (this.message == null) {
            return super.getMessage();
        }
        return this.message;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getLocalizedMessage() {
        if (this.localizedMessage == null) {
            return super.getLocalizedMessage();
        }
        return this.localizedMessage;
    }

    public String getErrorType() {
        if (this.errType == null) {
            return this.getClass().getName().toString();
        }
        return this.errType;
    }

    public String getRedir() {
        return this.redirServer;
    }

    public String getErrorDump() {
        return this.errDump;
    }

    public String getUser() {
        return this.user;
    }

    public String getService() {
        return this.service;
    }

    public Date getTime() {
        return this.time;
    }

    public IData[] getCallstack() {
        return this.callstack;
    }

    public String getNestedMessage() {
        return this.nestedmessage;
    }

    public String getNestedLocalizedMessage() {
        return this.nestedlocalizedMessage;
    }

    public String getNestedErrorType() {
        return this.nestederrType;
    }

    public String getNestedRedir() {
        return this.nestedredirServer;
    }

    public String getNestedErrorDump() {
        return this.nestederrDump;
    }

    public String getNestedUser() {
        return this.nesteduser;
    }

    public String getNestedService() {
        return this.nestedservice;
    }

    public Date getNestedTime() {
        return this.nestedtime;
    }

    public IData[] getNestedCallstack() {
        return this.nestedcallstack;
    }

    public String toString() {
        if (this.errType != null) {
            return this.errType + ": " + this.message;
        }
        return super.toString();
    }

    public String toLocalizedString() {
        if (this.errType != null) {
            return this.errType + ": " + this.localizedMessage;
        }
        return super.toString();
    }

    public Values getErrorInfo() {
        return this.errorInfo;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        if (this.errDump != null) {
            s.print(this.errDump);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.errDump != null) {
            s.write(this.errDump);
        } else {
            super.printStackTrace(s);
        }
    }
}

