/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.app.b2b.client.Context;
import com.wm.app.b2b.client.HttpClient;
import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.ns.NSQuery;
import com.wm.app.b2b.client.ns.NSRuntimeException;
import com.wm.data.IData;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.driver.comm.b2b.WmConnectionParms;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSServiceType;
import com.wm.lang.ns.NSTrigger;
import com.wm.lang.ns.NSTriggerType;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.util.Values;
import java.util.Properties;

public class Query {
    NSQuery nsQuery;
    double serverVersion;

    public Query(WmConnection ctx) {
        this.nsQuery = new NSQuery(ctx);
        try {
            WmConnectionParms parms = ctx.getConnectionParms();
            String sVersion = parms.getArg("$version", "3.6");
            if (sVersion != null) {
                this.serverVersion = Double.valueOf(sVersion);
            }
            if (this.serverVersion >= 3.5) {
                this.refreshSchemaRegistry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Query(HttpClient ctx) {
        this.nsQuery = new NSQuery(ctx);
        try {
            Properties parms = ctx.getConnectionParms();
            String sVersion = parms.getProperty("$version", "3.6");
            if (sVersion != null) {
                this.serverVersion = Double.valueOf(sVersion);
            }
            if (this.serverVersion >= 3.5) {
                this.refreshSchemaRegistry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Query() {
    }

    public Query(Context ctx) {
        this.nsQuery = new NSQuery(ctx);
        try {
            if (ctx.getServerVersion() >= 3.5) {
                this.refreshSchemaRegistry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContext(WmConnection ctx) {
        this.nsQuery.setContext(ctx);
    }

    public void setContext(HttpClient ctx) {
        this.nsQuery.setContext(ctx);
    }

    public Namespace getNamespace() {
        return this.nsQuery;
    }

    public NSInterface getRootNode() throws ServiceException {
        try {
            return this.nsQuery.getRootNode();
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSNode createNSNode(Values nodeValues, NSPackage nsPackage, Values out) throws ServiceException {
        try {
            return this.nsQuery.createNSNode(nodeValues, nsPackage, out);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData makeNode(NSNode node) throws ServiceException {
        try {
            return this.nsQuery.makeNode(node);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData makeNodes(IData nodesData) throws ServiceException {
        try {
            return this.nsQuery.makeNodes(nodesData);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public boolean nodeExists(NSName name) throws ServiceException {
        try {
            return this.nsQuery.nodeExists(name);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData nodeExists(NSName[] names) throws ServiceException {
        try {
            return this.nsQuery.nodeExists(names);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSNode getNode(NSName name) throws ServiceException {
        try {
            return this.nsQuery.getNode(name);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void putNode(NSNode node, boolean unlock) throws ServiceException {
        try {
            this.nsQuery.putNode(node, unlock);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void deleteNode(NSNode node) throws ServiceException {
        try {
            this.nsQuery.deleteNode(node);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void deleteNode(NSNode node, boolean shouldCascade) throws ServiceException {
        try {
            this.nsQuery.deleteNode(node, shouldCascade);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData deleteNodes(IData input) throws ServiceException {
        try {
            return this.nsQuery.deleteNodes(input);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void copyNode(NSNode oldNSNode, NSPackage newNSPackage, NSName newNSName) throws ServiceException {
        try {
            this.nsQuery.copyNode(oldNSNode, newNSPackage, newNSName);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData copyNode(NSNode oldNSNode, NSPackage newNSPackage, NSName newNSName, boolean shouldCascade) throws ServiceException {
        try {
            return this.nsQuery.copyNode(oldNSNode, newNSPackage, newNSName, shouldCascade);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData copyNodes(IData input) throws ServiceException {
        try {
            return this.nsQuery.copyNodes(input);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void moveNode(NSNode oldNSNode, NSPackage newNSPackage, NSName newNSName, boolean preserveLockState) throws ServiceException {
        try {
            this.nsQuery.moveNode(oldNSNode, newNSPackage, newNSName, preserveLockState);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public IData moveNodes(IData input) throws ServiceException {
        try {
            return this.nsQuery.moveNodes(input);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public byte[] exportNode(NSNode node) throws ServiceException {
        try {
            return this.nsQuery.exportNode(node);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public byte[] exportPackage(NSPackage nsPackage) throws ServiceException {
        try {
            return this.nsQuery.exportPackage(nsPackage);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSService createService(NSPackage pkg, NSName name, NSServiceType type) throws ServiceException {
        try {
            return this.nsQuery.createService(pkg, name, type);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSTrigger createTrigger(NSPackage pkg, NSName name) throws ServiceException {
        return this.createTrigger(pkg, name, NSTriggerType.create("broker-trigger"));
    }

    public NSTrigger createTrigger(NSPackage pkg, NSName name, NSTriggerType triggerType) throws ServiceException {
        try {
            return this.nsQuery.createTrigger(pkg, name, triggerType);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSWSDescriptor createWSD(NSPackage pkg, NSName name) throws ServiceException {
        try {
            return this.nsQuery.createWSD(pkg, name);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSInterface createInterface(NSPackage pkg, NSName name) {
        return this.nsQuery.createInterface(pkg, name);
    }

    public NSPackage createPackage(String name) throws ServiceException {
        try {
            return this.nsQuery.createPackage(name);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSPackage getPackage(String name) throws ServiceException {
        try {
            return this.nsQuery.getPackage(name);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSPackage[] getAllPackages() throws ServiceException {
        try {
            return this.nsQuery.getAllPackages();
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSNode[] getNodes(NSPackage pkg) throws ServiceException {
        try {
            return this.getRootNode().getNodes(pkg, null);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSNode[] getNodes(NSInterface ifc, NSPackage pkg, NSType[] filter) throws ServiceException {
        try {
            return this.nsQuery.getNodes(ifc, pkg, filter);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public NSNode[] getNodeStubs(NSInterface ifc, NSPackage pkg, NSType[] filter) throws ServiceException {
        try {
            return this.nsQuery.getNodeStubs(ifc, pkg, filter);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void registerNSNodeListener(Object listener, NSNode node) throws ServiceException {
        try {
            this.nsQuery.registerNSNodeListener(listener, node);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void unregisterNSNodesListeners(Object[] listeners, NSNode[] nodes) throws ServiceException {
        try {
            this.nsQuery.unregisterNSNodesListeners(listeners, nodes);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void unregisterNSNodeListener(Object listener, NSNode node) throws ServiceException {
        try {
            this.nsQuery.unregisterNSNodeListener(listener, node);
        }
        catch (NSRuntimeException e) {
            throw e.se;
        }
    }

    public void setCacheSize(int newSize) {
        this.nsQuery.setCacheSize(newSize);
    }

    public int getCacheSize() {
        return this.nsQuery.getCacheSize();
    }

    public void sweepCache(String packageName) {
        this.nsQuery.sweepCache(packageName);
    }

    public void sweepCache() {
        this.nsQuery.sweepCache();
    }

    public void clearCache() {
        this.nsQuery.clearCache();
    }

    public void clearPackageCache() {
        this.nsQuery.clearPackageCache();
    }

    public void refreshSchemaRegistry() {
        this.nsQuery.refreshSchemaRegistry();
    }

    public void touchNode(NSNode node) {
        this.nsQuery.touchNode(node);
    }

    public NSNode refreshNode(NSNode node) {
        return this.nsQuery.refreshNode(node);
    }

    public void uncacheNode(NSName name) {
        this.nsQuery.uncacheNode(name);
    }
}

