/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.driver.comm.b2b.WmSecurityContext;
import com.wm.g11n.util.iContext;
import com.wm.g11n.util.rfc3066bis;
import com.wm.security.TrustManager;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.util.Locale;
import java.util.Properties;

public class HttpClientParms {
    public static final int TRANSPORT_HTTP = 1;
    public static final boolean log = false;
    String secondaryURL;
    int defPort = 5555;
    protected String url;
    protected Properties mainArgs;
    String locale = iContext.getDefault().toString();
    protected Properties linkParms;
    protected boolean isSecure = false;
    protected boolean useSession = false;
    protected WmSecurityContext secCtx;
    protected int transportType = 1;

    public HttpClientParms(String url, Properties connectionProperties) {
        this.url = url;
        this.mainArgs = connectionProperties;
    }

    public void setProxy(String host, String user, String pass) {
        if (host == null || host.length() == 0) {
            System.getProperties().put("watt.net.proxyHost", "");
            System.getProperties().put("watt.net.proxyPort", "");
            System.getProperties().put("watt.net.proxyUser", "");
            System.getProperties().put("watt.net.proxyPass", "");
        } else {
            System.getProperties().put("watt.net.proxyHost", this.getHost(host));
            System.getProperties().put("watt.net.proxyPort", this.getPort(host, "80"));
            if (user != null) {
                System.getProperties().put("watt.net.proxyUser", user);
            }
            if (pass != null) {
                System.getProperties().put("watt.net.proxyPass", pass);
            }
        }
    }

    public void setSecureProxy(String host, String user, String pass) {
        if (host == null || host.length() == 0) {
            System.getProperties().remove("watt.net.secureProxyHost");
            System.getProperties().remove("watt.net.secureProxyPort");
            System.getProperties().remove("watt.net.secureProxyUser");
            System.getProperties().remove("watt.net.secureProxyPass");
        } else {
            System.getProperties().put("watt.net.secureProxyHost", this.getHost(host));
            System.getProperties().put("watt.net.secureProxyPort", this.getPort(host, "80"));
            if (user != null) {
                System.getProperties().put("watt.net.secureProxyUser", user);
            }
            if (pass != null) {
                System.getProperties().put("watt.net.secureProxyPass", pass);
            }
        }
    }

    public Properties getConnectionParameters() {
        if (this.linkParms == null) {
            if (this.mainArgs == null) {
                this.mainArgs = new Properties();
            }
            if (this.secondaryURL != null) {
                this.mainArgs.put("SecondaryServer", this.secondaryURL);
            }
            this.mainArgs.put("secure", this.isSecure ? "true" : "false");
            this.mainArgs.put("locale", this.locale);
            this.linkParms = new Properties();
            this.linkParms.put("url", this.url);
            this.linkParms.put("securityContext", this.secCtx);
            this.linkParms.put("mainArgs", this.mainArgs);
        }
        return this.linkParms;
    }

    public void setUserCredentials(String userName, String password) {
        if (this.secCtx == null) {
            this.secCtx = new WmSecurityContext(userName, password);
        } else {
            this.secCtx.setBasicCredentials(userName, password);
        }
    }

    public void setUserCredentials(String privKey, String[] certChain) throws CertificateException, IOException, InvalidKeyException {
        Object kac = TrustManager.loadKeyAndChain(privKey, certChain);
        if (kac == null) {
            throw new InvalidKeyException("Invalid key chain specified");
        }
        TrustManager.setKeyAndChain(kac);
        if (this.secCtx == null) {
            this.secCtx = new WmSecurityContext(kac);
        } else {
            this.secCtx.setSSLCredentials(kac);
        }
    }

    public void setEndPoint(String url) {
        this.url = url;
    }

    public void setSecondaryEndPoint(String url) {
        this.secondaryURL = url;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = "";
        }
        this.locale = new iContext(locale).toString();
    }

    public void setLocale(String locale) {
        if (locale == null) {
            return;
        }
        if (rfc3066bis.isValid((String)locale)) {
            this.locale = locale;
        }
    }

    public String getURL() {
        return this.url;
    }

    protected String getHost(String hostport) {
        if (hostport == null || hostport.length() == 0) {
            return null;
        }
        int pos = hostport.indexOf(58);
        if (pos < 0) {
            return hostport;
        }
        return hostport.substring(0, pos);
    }

    protected String getPort(String hostport, String defPort) {
        if (hostport == null) {
            return "";
        }
        int pos = hostport.indexOf(58);
        if (pos < 0 || pos == hostport.length() - 1) {
            return defPort;
        }
        try {
            return hostport.substring(pos + 1);
        }
        catch (NumberFormatException e) {
            return defPort;
        }
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public boolean getUseSession() {
        return this.useSession;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public int getTransportType() {
        return this.transportType;
    }
}

