/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.app.b2b.client.ServiceException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.driver.comm.b2b.InvokeMessage;
import com.wm.driver.comm.b2b.WmCommException;
import com.wm.driver.comm.b2b.WmMessage;
import com.wm.driver.comm.b2b.WmSecurityContext;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILinkListener;
import com.wm.io.comm.IMessageHandler;
import com.wm.net.HttpURLConnection;
import com.wm.net.Net504Exception;
import com.wm.security.TrustManager;
import com.wm.util.Base64;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.text.UUID;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class HttpClient {
    protected static final String INIT_CMD = "wm.server:connect";
    protected static final String SERVER_VERSION_KEY = "$version";
    protected static final String RPC_VERSION_KEY = "$rpc2ver";
    protected HttpClientConnectionPool pool = new HttpClientConnectionPool();
    protected Properties linkParms;
    private String sessionId;
    private boolean needPing;
    private Pinger pinger;
    private Hashtable handleMsg;
    protected String host;
    protected int port;
    protected String basicAuth;
    protected Object sslCredentials;
    protected boolean isSecure = false;
    protected String locale;
    protected boolean isConnected;
    protected boolean isValid = true;
    protected ILinkListener linkListener;
    protected int keepAliveTimeout = 60000;
    private boolean db = false;
    static final boolean log = false;

    public HttpClient(Properties connectionInfo) throws CommException {
        this.init(connectionInfo);
        this.connect();
        this.isConnected = true;
        this.pinger = new Pinger(120000L);
        this.pinger.start();
        this.pool.sweep.start();
    }

    private void init(Properties connectionInfo) throws CommException {
        try {
            this.linkParms = connectionInfo;
            this.handleMsg = new Hashtable(11);
            WmSecurityContext ctx = (WmSecurityContext)this.linkParms.get("securityContext");
            if (ctx != null) {
                String user = ctx.getUser();
                String pass = ctx.getPassword();
                this.basicAuth = user != null && user.length() > 0 ? (pass != null ? Base64.encode(Strings.cat(user, ":", pass), false) : Base64.encode(Strings.cat(user, ":"), false)) : null;
                this.sslCredentials = ctx.getSSLCredentials();
                if (this.sslCredentials != null) {
                    TrustManager.setKeyAndChain(this.sslCredentials);
                }
            }
            Properties linkArgs = (Properties)this.linkParms.get("mainArgs");
            this.isSecure = new Boolean((String)linkArgs.get("secure"));
            this.locale = (String)linkArgs.get("locale");
            if (this.locale == null) {
                this.locale = Locale.getDefault().toString();
            }
            this.parseLink((String)this.linkParms.get("url"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connect() throws CommException {
        String uuid = UUID.generate();
        WmMessage requestMsg = InvokeMessage.createMessage(uuid, INIT_CMD, null, null, 3, null);
        WmMessage replyMsg = null;
        replyMsg = this.transportMsg(requestMsg);
        CommException e = replyMsg.getError();
        if (e != null) {
            throw e;
        }
        this.setEndPointInfo(replyMsg.getData());
    }

    /*
     * Exception decompiling
     */
    private WmMessage transportMsg(WmMessage msg, HttpClientConnection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 3[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WmMessage transportMsg(WmMessage msg) {
        Object savedCredentials = TrustManager.getKeyAndChain();
        if (this.sslCredentials != null) {
            TrustManager.setKeyAndChain(this.sslCredentials);
        }
        HttpClientConnection conn = null;
        WmMessage result = null;
        try {
            conn = this.pool.getOnceUseConnection();
            InputStream ipStream = null;
            HttpClientConnection httpClientConnection = conn;
            synchronized (httpClientConnection) {
                OutputStream opStream = null;
                IDataBinCoder idataCoder = new IDataBinCoder();
                opStream = conn.getOutputStream();
                idataCoder.encode(opStream, msg.getIData());
                ipStream = conn.getInputStream();
                IData returnData = idataCoder.decode(ipStream);
                if (returnData == null) {
                    throw new Exception("Transport Error: Unable to connect, incompatible remote endpoint");
                }
                result = WmMessage.createMessage(returnData);
                conn.setSessionId();
                if (!this.isValid && this.linkListener != null) {
                    this.linkListener.linkReconnect();
                }
                this.isValid = true;
                WmMessage.checkForError(result);
            }
        }
        catch (Net504Exception n504e) {
            if (this.linkListener != null) {
                this.linkListener.linkError(new CommException(n504e));
            }
        }
        catch (IOException ioe) {
            this.isValid = false;
            int code = 200;
            String errMsg = "";
            CommException e = null;
            if (conn != null) {
                code = conn.getResponseCode();
                errMsg = conn.getResponseMessage();
            }
            if (code == 401 || code == 403 || code == 500) {
                e = new CommException(errMsg);
            } else {
                errMsg = ioe.getMessage();
                if (errMsg != null) {
                    if (errMsg.indexOf("Invalid Session") < 0 && errMsg.indexOf("Authorization Required") < 0 && this.linkListener != null && this.isConnected) {
                        this.linkListener.linkDown();
                    }
                } else if (this.linkListener != null && this.isConnected) {
                    this.linkListener.linkDown();
                }
                e = new CommException(ioe);
            }
            result = WmMessage.createCorelatedMessage(msg, null);
            result.setError(e);
        }
        catch (Throwable ioe) {
            this.isValid = false;
            CommException e = new CommException(ioe);
            result = WmMessage.createCorelatedMessage(msg, null);
            result.setError(e);
        }
        finally {
            TrustManager.setKeyAndChain(savedCredentials);
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    public Properties getConnectionParms() {
        return this.linkParms;
    }

    public void setLinkListener(ILinkListener cl) {
        this.linkListener = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(String cmd, IMessageHandler handler) {
        HttpClient httpClient = this;
        synchronized (httpClient) {
            if (handler != null) {
                this.handleMsg.put(cmd, handler);
            } else {
                this.handleMsg.remove(cmd);
            }
        }
    }

    public void sendOnly(final String cmd, final Properties prop, final IData data) throws ServiceException {
        Thread th = new Thread(new Runnable(){

            public void run() {
                try {
                    String uuid = UUID.generate();
                    WmMessage requestMsg = WmMessage.createMessage(uuid, cmd, null, data, 3, prop);
                    WmMessage replyMsg = null;
                    replyMsg = HttpClient.this.transportMsg(requestMsg);
                    CommException e = replyMsg.getError();
                    IMessageHandler uuidrh = (IMessageHandler)HttpClient.this.handleMsg.get(cmd);
                    if (uuidrh != null) {
                        uuidrh.handleMessage(null, replyMsg);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        th.setDaemon(true);
        th.start();
    }

    public IData sendReceive(String cmd, Properties prop, IData data) throws ServiceException {
        ServiceException se = null;
        HttpClientConnection conn = null;
        try {
            String uuid = UUID.generate();
            WmMessage requestMsg = WmMessage.createMessage(uuid, cmd, null, data, 3, prop);
            WmMessage replyMsg = null;
            conn = this.pool.getPooledConnection();
            replyMsg = this.transportMsg(requestMsg, conn);
            CommException e = replyMsg.getError();
            if (e != null) {
                throw e;
            }
            return replyMsg.getData();
        }
        catch (WmCommException wmce) {
            IData encodedError = wmce.getEncodedError();
            se = encodedError != null ? new ServiceException(Values.use(encodedError)) : new ServiceException(wmce);
            throw se;
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getMessage(), t.getClass().getName(), sw.toString(), null);
            } else {
                se = new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            e.printStackTrace();
            se = new ServiceException(e);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            if (this.isConnected) {
                HttpClientConnection conn = this.pool.getOnceUseConnection();
                String uuid = UUID.generate();
                WmMessage requestMsg = InvokeMessage.createMessage(uuid, "wm.server:disconnect", null, null, 3, null);
                WmMessage replyMsg = null;
                replyMsg = this.transportMsg(requestMsg, conn);
                conn.disconnect();
                this.isConnected = false;
                if (this.pinger != null) {
                    this.pinger.interrupt();
                }
                this.setNeedPing(false);
                this.pinger = null;
                this.basicAuth = null;
                this.sslCredentials = null;
                this.sessionId = null;
                this.host = null;
                this.handleMsg.clear();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.pool.close();
            this.pool = null;
        }
    }

    private void parseLink(String url) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(url, ":");
        int count = st.countTokens() - 2;
        if (count < 0) {
            throw new MalformedURLException("not enough fields");
        }
        this.host = st.nextToken();
        try {
            this.port = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException("incorrect port number");
        }
    }

    private URL createURL() throws MalformedURLException {
        URL url = new URL(Strings.cat(this.isSecure ? "https://" : "http://", this.host, ":", String.valueOf(this.port), "/wm-message"));
        return url;
    }

    private synchronized void setNeedPing(boolean ping) {
        this.needPing = ping;
    }

    private void setEndPointInfo(IData endPointData) {
        if (endPointData == null) {
            return;
        }
        Properties linkProps = (Properties)this.linkParms.get("mainArgs");
        if (linkProps != null) {
            IDataCursor cr = endPointData.getCursor();
            if (cr.first(SERVER_VERSION_KEY)) {
                linkProps.put(SERVER_VERSION_KEY, cr.getValue());
            }
            if (cr.first(RPC_VERSION_KEY)) {
                linkProps.put(RPC_VERSION_KEY, cr.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pingServer() {
        if (!this.needPing) {
            return;
        }
        try {
            String uuid = UUID.generate();
            WmMessage requestMsg = InvokeMessage.createMessage(uuid, "wm.server:ping", null, null, 3, null);
            WmMessage replyMsg = null;
            replyMsg = this.transportMsg(requestMsg);
            if (replyMsg.getError() == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            JournalLogger.logWarning(9, 36, e);
        }
        this.setNeedPing(true);
    }

    private void writeLog(String message) {
        try {
            FileWriter fw = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss.SSS ");
            fw = new FileWriter("./logs/client.log", true);
            fw.write(new StringBuffer().append("\n").append(Thread.currentThread().hashCode()).append(formatter.format(new Date())).append("::").append(message).toString());
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class HttpClientConnectionPool {
        HttpClientConnection conn;
        Sweeper sweep = null;
        LinkedList connList = new LinkedList();
        Object obj = new Object();
        int inUse = 0;

        HttpClientConnectionPool() {
            this.sweep = new Sweeper(60000L);
        }

        HttpClientConnection getOnceUseConnection() throws IOException {
            HttpClientConnection onceUseConn = new HttpClientConnection();
            return onceUseConn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            HttpClientConnection con = null;
            LinkedList linkedList = this.connList;
            synchronized (linkedList) {
                while (this.connList.size() != 0) {
                    con = (HttpClientConnection)this.connList.removeFirst();
                    con.disconnect();
                }
            }
            if (this.sweep != null) {
                this.sweep.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpClientConnection getPooledConnection() throws IOException {
            Object object;
            HttpClientConnection conn1;
            block21: {
                conn1 = null;
                boolean size = false;
                object = this.connList;
                synchronized (object) {
                    if (this.connList.size() == 0 && this.inUse >= 5) {
                        try {
                            this.connList.wait();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                object = this.connList;
                synchronized (object) {
                    if (this.connList.size() != 0) {
                        conn1 = (HttpClientConnection)this.connList.removeLast();
                    } else if (this.inUse < 5) {
                        break block21;
                    }
                }
                object = conn1;
                synchronized (object) {
                    conn1.lastUsed = System.currentTimeMillis();
                    LinkedList linkedList = this.connList;
                    synchronized (linkedList) {
                        ++this.inUse;
                    }
                    return conn1;
                }
            }
            conn1 = new HttpClientConnection();
            conn1.lastUsed = System.currentTimeMillis();
            object = this.connList;
            synchronized (object) {
                ++this.inUse;
            }
            return conn1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void putPooledConnection(HttpClientConnection conn) {
            LinkedList linkedList = this.connList;
            synchronized (linkedList) {
                --this.inUse;
                if (conn != null) {
                    this.connList.add(conn);
                }
                this.connList.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sweepPooledConnection() {
            LinkedList linkedList = this.connList;
            synchronized (linkedList) {
                HttpClientConnection conn = null;
                for (int size = this.connList.size(); size != 0; --size) {
                    conn = (HttpClientConnection)this.connList.getFirst();
                    if (System.currentTimeMillis() - conn.lastUsed <= (long)HttpClient.this.keepAliveTimeout) continue;
                    this.connList.remove(conn);
                    conn.disconnect();
                }
            }
        }

        class Sweeper
        extends Thread {
            long timeout;

            Sweeper(long timeout) {
                super("HttpClient.HttpClientConnectionPool:Sweeper");
                this.timeout = timeout;
            }

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(this.timeout);
                        HttpClientConnectionPool.this.sweepPooledConnection();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    class HttpClientConnection {
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in;
        long lastUsed = 0L;
        IDataBinCoder idataCoder = new IDataBinCoder();

        HttpClientConnection() throws IOException {
            Values context = new Values();
            context.put("timeout", new Integer(0));
            this.conn = HttpURLConnection.getHttpURLConnection(HttpClient.this.createURL(), context);
            this.conn.setDoOutput(true);
            if (HttpClient.this.basicAuth != null) {
                this.conn.setRequestProperty("Authorization", Strings.cat("Basic ", HttpClient.this.basicAuth));
            }
            if (HttpClient.this.sessionId != null) {
                this.conn.setRequestProperty("Cookie", Strings.cat("ssnid=", HttpClient.this.sessionId));
            }
            this.conn.setRequestProperty("Content-Type", this.idataCoder.getContentType());
            this.conn.setRequestProperty("Accept-Language", HttpClient.this.locale);
            this.out = this.getOutputStream();
        }

        OutputStream getOutputStream() throws IOException {
            if (this.out != null) {
                return this.out;
            }
            return this.conn.getOutputStream();
        }

        InputStream getInputStream() throws IOException {
            this.in = this.conn.getInputStream();
            return this.in;
        }

        int getResponseCode() {
            return this.conn.getResponseCode();
        }

        String getResponseMessage() {
            return this.conn.getResponseMessage();
        }

        void disconnect() {
            this.conn.disconnect();
        }

        void setSessionId() {
            String newSessionId = this.getCookieId(this.conn.getHeaderField("Set-Cookie"));
            if (newSessionId != null && !newSessionId.equals(HttpClient.this.sessionId)) {
                HttpClient.this.sessionId = newSessionId;
                this.conn.setRequestProperty("Cookie", Strings.cat("ssnid=", HttpClient.this.sessionId));
            }
        }

        String getCookieId(String cookie) {
            if (cookie == null) {
                return null;
            }
            int len = cookie.indexOf("ssnid=");
            if (len >= 0) {
                int len2 = cookie.indexOf(";", len + 1);
                return cookie.substring(len + 6, len2);
            }
            return null;
        }
    }

    class Pinger
    extends Thread {
        long timeout;

        public Pinger() {
            this(20000L);
        }

        public Pinger(long timeout) {
            super("HttpClient:Pinger");
            this.timeout = timeout;
        }

        public void run() {
            try {
                while (true) {
                    Pinger.sleep(this.timeout);
                    HttpClient.this.pingServer();
                    HttpClient.this.setNeedPing(true);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

