/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.app.b2b.client.AccessException;
import com.wm.app.b2b.client.BaseContext;
import com.wm.app.b2b.client.InvokeThread;
import com.wm.app.b2b.client.Query;
import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.resources.AccessExceptionBundle;
import com.wm.app.b2b.client.resources.ServiceExceptionBundle;
import com.wm.app.b2b.util.KeyInfo;
import com.wm.app.log.JournalLogFactory;
import com.wm.app.log.JournalLogManager;
import com.wm.app.log.util.DailyFileMsgHandler;
import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.data.ValuesEmulator;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.Namespace;
import com.wm.net.NetURLConnection;
import com.wm.security.TrustManager;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.Coder;
import com.wm.util.coder.IDataCoder;
import java.applet.Applet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class Context
extends BaseContext {
    private static final boolean debug = false;
    public static final int PING_FAILED_MSG = 9;
    public static final int PING_SERVER_MSG = 10;
    public static final int UNKNOWN_HOST_MSG = 11;
    public static final int UNNOWN_PARTNER_MSG = 12;
    public static final int DISCONNECT_MSG = 13;
    public static final int TIME_OUT_MSG = 14;
    public static final int TRY_PING_MSG = 15;
    public static final int CHK_PARTNER_LICENSE_TYPE_MSG = 16;
    public static final int CHK_PARTNER_SERVER_PARTNER = 17;
    public static final int CHK_PARTNER_FOUND_IN_CLUSTER = 18;
    public static final int CONTXT0003 = 9;
    public static final int CONTXT0004 = 10;
    public static final int CONTXT0005 = 11;
    public static final int CONTXT0006 = 12;
    public static final int CONTXT0007 = 13;
    public static final int CONTXT0008 = 14;
    public static final int CONTXT0009 = 15;
    static final int MAX_BIND_FAILURES = 3;
    protected Pinger pinger;
    protected boolean isApplet;
    protected boolean needPing;
    protected String sessionId;
    protected Query query;
    private String partner;
    private double serverVersion;

    public Context(Values context) {
        this(1, context);
    }

    public Context(int rpcType, Values context) {
        super(rpcType, context);
        this.initVars();
    }

    public Context() {
        this(1);
    }

    public Context(int rpcType) {
        super(rpcType);
        this.initVars();
    }

    private void initVars() {
        this.needPing = true;
        this.partner = System.getProperty("watt.server.partner", "");
        int colon = this.partner.indexOf(":");
        if (colon != -1) {
            this.partner = this.partner.substring(0, colon);
        }
        boolean enabled = Boolean.getBoolean("watt.client.logging.enabled");
        if (!JournalLogger.isInitialized() && enabled) {
            String sLogLevel = System.getProperty("watt.client.loglevel", "4");
            String sLogDir = System.getProperty("watt.client.logdir", "logs");
            System.getProperties().setProperty("watt.debug2.facList", new Integer(36).toString());
            int logLevel = 4;
            try {
                logLevel = Integer.parseInt(sLogLevel);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            File logDir = new File(sLogDir);
            JournalLogManager manager = null;
            DailyFileMsgHandler handler = null;
            try {
                if (!logDir.isDirectory()) {
                    logDir.mkdirs();
                }
                manager = JournalLogFactory.createManager(new Properties());
                handler = new DailyFileMsgHandler(manager, sLogDir + "/client-.log", true);
                handler.setFilterLevel(logLevel);
                JournalLogger.init(manager.createProducer(), handler, null);
            }
            catch (Exception e) {
                System.err.println("Though client side logging is enabled, it is turned off because: " + e.getMessage());
            }
        }
    }

    public Context(Applet a) throws ServiceException {
        this();
        this.appletSetup(a);
    }

    public void appletSetup(Applet a) throws ServiceException {
        this.isApplet = true;
        handlerSet = true;
        this.setFixedUri(a.getParameter("FIXEDURI"));
        String secure = a.getParameter("SECURE");
        if (secure != null) {
            this.setSecure(secure.equalsIgnoreCase("true") || secure.equals("1"));
        }
        String server = a.getParameter("SERVER");
        String suser = a.getParameter("SERVERUSER");
        String spass = a.getParameter("SERVERPASS");
        if (server != null) {
            this.connect(server, suser, spass);
        }
    }

    public Namespace getNamespace() {
        return this.getQuery().getNamespace();
    }

    public Query getQuery() {
        if (this.query == null) {
            this.query = new Query(this);
        }
        return this.query;
    }

    public void fakeConnect() {
        this.connected = true;
    }

    private synchronized void setNeedPing(boolean ping) {
        this.needPing = ping;
    }

    private synchronized void pingServer() {
        if (!this.needPing) {
            return;
        }
        if (!this.connected) {
            this.setNeedPing(false);
            this.pinger.interrupt();
        }
        try {
            JournalLogger.logDebugPlus(3, 15, 36, new Date().toString());
            if (this.isClusteredEnv() && this.gAllowRedir != 0) {
                Values data = this.invoke("wm.server", "getServerNodes", null);
                if (data != null) {
                    this.setServers((Values)data.get("$members"));
                }
            } else {
                Values data = this.invoke("wm.server", "ping", null);
            }
        }
        catch (Exception e) {
            JournalLogger.logError(9, 36, this.server);
        }
        this.setNeedPing(true);
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InvokeThread invokeThreaded(NSName svcName, Values data) {
        InvokeThread it = new InvokeThread(this, svcName.getInterfaceName().toString(), svcName.getNodeName().toString(), data);
        it.start();
        return it;
    }

    public InvokeThread invokeThreaded(String ifc, String svc, Values data) {
        InvokeThread it = new InvokeThread(this, ifc, svc, data);
        it.start();
        return it;
    }

    public Values invoke(NSName svcName, Values data) throws ServiceException {
        return this.invoke(svcName.getInterfaceName().toString(), svcName.getNodeName().toString(), data);
    }

    public IData invoke(NSName svcName, IData data) throws ServiceException {
        return this.invoke(svcName.getInterfaceName().toString(), svcName.getNodeName().toString(), data);
    }

    public Values invoke(String ifc, String svc, Values data) throws ServiceException {
        IData id = null;
        if (data != null) {
            id = data.getIData();
        }
        IData res = this.invoke(ifc, svc, id);
        Values v = null;
        v = res == null || res instanceof Values ? (Values)res : Values.use(res);
        return v;
    }

    public IData invoke(String ifc, String svc, IData data) throws ServiceException {
        if (this.isClusteredEnv() && this.gAllowRedir != 0) {
            try {
                return this.clusterInvoke(this.getServers(), this.sessionId, this.server, 6, ifc, svc, data);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
        return this.invoke(ifc, svc, data, false);
    }

    protected Values clusterSvcInvoke(String ifc, String svc, Values in) throws Exception {
        IData res;
        IData id = null;
        if (in != null) {
            id = in.getIData();
        }
        return (res = this.clusterSvcInvoke(ifc, svc, id)) == null || res instanceof Values ? (Values)res : Values.use(res);
    }

    protected IData clusterSvcInvoke(String ifc, String svc, IData in) throws Exception {
        IData result2;
        String redirSrv = null;
        try {
            result2 = this.invoke(ifc, svc, in, false);
        }
        catch (ServiceException e) {
            int index;
            IData result2 = IDataFactory.create(2);
            if (e.getMessage() == null) {
                throw e;
            }
            String exactError = e.getMessage().toLowerCase();
            String exactErrorType = e.getErrorType();
            if (exactError.indexOf("server unreachable") != -1 || exactError.indexOf("connection reset") != -1 || exactError.indexOf("connection closed") != -1 || exactError.indexOf("java.net.connectionexception") != -1 || exactError.indexOf("java.net.socketexception") != -1 || exactError.indexOf("BAC.0006.0023") != -1 || exactError.indexOf("connection refused") != -1) {
                ValuesEmulator.put(result2, "cmresult", (Object)Integer.toString(3));
                return result2;
            }
            if (exactErrorType != null) {
                index = exactErrorType.indexOf("java.net.ConnectException");
                int Index = exactErrorType.indexOf("java.net.SocketException");
                if (index != -1 || Index != -1) {
                    ValuesEmulator.put(result2, "cmresult", (Object)Integer.toString(3));
                    return result2;
                }
            }
            if ((index = exactError.indexOf("Redirected")) != -1) {
                redirSrv = e.getRedir();
                if (redirSrv == null) {
                    ValuesEmulator.put(result2, "cmresult", (Object)Integer.toString(3));
                    return result2;
                }
                ValuesEmulator.put(result2, "cmresult", (Object)Integer.toString(4));
                ValuesEmulator.put(result2, "cmresultStr", (Object)redirSrv);
                return result2;
            }
            throw e;
        }
        return result2;
    }

    public void connect(String server, String user, String pass) throws ServiceException {
        this.setAuthentication(user, pass);
        try {
            this.connect(server);
        }
        catch (ServiceException se) {
            if (this.gRetryServer != null) {
                String connectServer = this.gRetryServer;
                this.gRetryServer = server;
                this.connect(connectServer);
            }
            throw se;
        }
    }

    public void connect(String server) throws ServiceException {
        this.serverVersion = 2.0;
        if (this.connected) {
            throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_ALREADY_CONED, "");
        }
        if (server == null) {
            throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_INVALID_SVR_SETTING, "");
        }
        this.server = server;
        Values send = new Values();
        if (this.gAllowRedir == 0) {
            send.put("noRedir", "noRedir");
        } else if (this.gAllowRedir == 1) {
            send.put("oneRedir", "oneRedir");
        }
        this.setRpc2Ver(4);
        Values data = this.invoke("wm.server", "connect", send, true);
        if (data == null) {
            throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_TRANSPORT_ERROR, "");
        }
        this.checkError(data);
        String auth = data.getString("$result");
        if (auth == null || !auth.equals("ok")) {
            throw new AccessException(AccessExceptionBundle.class, AccessExceptionBundle.NOT_AUTH_USE_SERVER, "");
        }
        String s = data.getString("$version");
        if (s != null) {
            try {
                this.serverVersion = Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((s = data.getString("$rpc2ver")) != null) {
            int i;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                i = -1;
            }
            this.setRpc2Ver(i);
        } else if (this.serverVersion == 3.0) {
            this.setRpc2Ver(6);
        }
        if (this.serverVersion >= 3.5 && this.rpc_type == 1) {
            this.rpc_type = 3;
        } else if (this.serverVersion < 3.5 && this.rpc_type == 3) {
            this.rpc_type = 1;
        }
        if (this.serverVersion >= 4.0) {
            this.setBinVer(2);
        } else {
            this.setBinVer(1);
        }
        this.setServers((Values)data.get("$members"));
        if (!this.checkPartnerConnection(server)) {
            throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_SVR_NOT_PARTNER, "");
        }
        if (this.pinger != null) {
            this.pinger.interrupt();
        }
        try {
            this.pinger = new Pinger(Long.parseLong(data.getString("$timeout")) / 3L);
        }
        catch (Exception e) {
            this.pinger = new Pinger();
        }
        this.pinger.setDaemon(true);
        this.pinger.start();
        this.connected = true;
    }

    private boolean checkPartnerConnection(String server) {
        int colon = server.indexOf(":");
        if (colon != -1) {
            server = server.substring(0, colon);
        }
        boolean found = false;
        if (!KeyInfo.isPartner()) {
            JournalLogger.logDebugPlus(3, 16, 36);
            found = true;
        } else if (server.equals(this.partner)) {
            JournalLogger.logDebugPlus(3, 17, 36);
            found = true;
        } else {
            try {
                InetAddress partnerI = InetAddress.getByName(this.partner);
                try {
                    InetAddress serverI = InetAddress.getByName(server);
                    if (serverI.equals(partnerI)) {
                        JournalLogger.logDebugPlus(3, 17, 36);
                        found = true;
                    }
                }
                catch (UnknownHostException e) {
                    JournalLogger.logError(11, 36, server);
                }
                if (!found && this.gServers != null) {
                    Values[] hosts = (Values[])this.gServers.get("hosts");
                    for (int i = 0; !found && i < hosts.length; ++i) {
                        try {
                            String h = (String)hosts[i].get("host");
                            if (!partnerI.equals(InetAddress.getByName(h))) continue;
                            JournalLogger.logDebugPlus(3, 18, 36);
                            found = true;
                            continue;
                        }
                        catch (UnknownHostException e) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (UnknownHostException e) {
                JournalLogger.logError(12, 36, this.partner);
            }
        }
        return found;
    }

    private void connect(String server, String certificate) throws ServiceException {
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_NOT_IMPL, "");
    }

    protected int clusterConnect(String server, byte[] certAuth, String basicAuth, String sessionID) {
        int result = 1;
        this.sessionId = sessionID;
        this.basicAuth = basicAuth;
        try {
            this.connect(server);
        }
        catch (ServiceException e) {
            result = 2;
        }
        catch (Exception e) {
            result = 2;
        }
        return result;
    }

    public void connect(String server, byte[] certificate) throws ServiceException {
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_NOT_IMPL, "");
    }

    public void disconnect(Values in) {
        if (this.connected) {
            block3: {
                try {
                    this.invoke("wm.server", "disconnect", in, false);
                }
                catch (ServiceException e) {
                    if (e.getOriginalException() instanceof ConnectException) break block3;
                    JournalLogger.logError(13, 36, e);
                }
            }
            this.cleanUpConnection();
            this.disableHttp1_1();
        }
    }

    public synchronized void disconnect() {
        this.disconnect(null);
    }

    protected void clusterDisconnect() {
        Values in = new Values();
        in.put("persist", "persist");
        this.disconnect(in);
    }

    public synchronized void cleanUpConnection() {
        if (this.connected) {
            this.cleanupSession();
            this.sessionId = null;
            if (this.pinger != null) {
                this.pinger.interrupt();
            }
            this.pinger = null;
        }
    }

    protected void clusterCleanupConnection() {
        this.cleanUpConnection();
    }

    protected void clusterAbort() throws Exception {
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_FAILED_CLUSTER_INVOKE, "");
    }

    private String getCookieId(String cookie) {
        if (cookie == null) {
            return null;
        }
        int len = cookie.indexOf("ssnid=");
        if (len >= 0) {
            int len2 = cookie.indexOf(";", len + 1);
            return cookie.substring(len + 6, len2);
        }
        return null;
    }

    public Values invoke(String ifc, String svc, Values data, boolean isConnect) throws ServiceException {
        IData res;
        IData id = null;
        if (data != null) {
            id = data.getIData();
        }
        return (res = this.invoke(ifc, svc, id, isConnect)) == null || res instanceof Values ? (Values)res : Values.use(res);
    }

    public IData invoke(String ifc, String svc, IData data, boolean isConnect) throws ServiceException {
        if (!isConnect) {
            this.checkConnection();
        }
        IData result = null;
        URLConnection uc = null;
        Coder valCoder = null;
        IDataCoder idataCoder = null;
        if (!handlerSet) {
            this.loadWmHandler();
        }
        Object savedCredentials = TrustManager.getKeyAndChain();
        boolean retry = false;
        int bindFailures = 0;
        InputStream ipStream = null;
        OutputStream opStream = null;
        do {
            retry = false;
            Object coder = this.getCoder();
            if (coder instanceof Coder) {
                valCoder = (Coder)coder;
            } else {
                idataCoder = (IDataCoder)coder;
            }
            try {
                String respMessage;
                TrustManager.setKeyAndChain(this.gSSLCredentials);
                uc = this.getURLConnection(ifc, svc);
                if (this.basicAuth != null && this.fixedUri == null) {
                    uc.setRequestProperty("Authorization", Strings.cat("Basic", " ", this.basicAuth));
                }
                if (this.sessionId != null) {
                    uc.setRequestProperty("Cookie", Strings.cat("ssnid", "=", this.sessionId));
                }
                if (this.enableHttp1_1) {
                    uc.setRequestProperty("Transfer-Encoding", "chunked");
                }
                opStream = uc.getOutputStream();
                if (valCoder != null) {
                    uc.setRequestProperty("Content-Type", valCoder.getContentType());
                    valCoder.encode(opStream, Values.use(data));
                } else {
                    uc.setRequestProperty("Content-Type", idataCoder.getContentType());
                    idataCoder.encode(opStream, data);
                }
                if (this.locale != null) {
                    uc.setRequestProperty("Accept-Language", this.locale);
                } else {
                    uc.setRequestProperty("Accept-Language", Locale.getDefault().toString());
                }
                if (this.locale != null) {
                    uc.setRequestProperty("Accept-Language", this.locale);
                } else {
                    uc.setRequestProperty("Accept-Language", Locale.getDefault().toString());
                }
                ipStream = uc.getInputStream();
                if (this.server.indexOf(new Integer(uc.getURL().getPort()).toString()) == -1) {
                    this.server = uc.getURL().getHost() + ":" + uc.getURL().getPort();
                }
                if ((respMessage = ((NetURLConnection)uc).getResponseMessage()).indexOf("Unsupported RPC") >= 0) {
                    throw new AccessException(((NetURLConnection)uc).getResponseMessage());
                }
                result = valCoder != null ? valCoder.decode(ipStream) : idataCoder.decode(ipStream);
                if (result == null && this.isClusteredEnv()) {
                    throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_SVR_UNREACHABLE, "");
                }
            }
            catch (FileNotFoundException e) {
                throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_SESSION_EXPIRED, "");
            }
            catch (BindException be) {
                retry = true;
                if (++bindFailures < 3) continue;
                throw new ServiceException(be);
            }
            catch (ConnectException ce) {
                throw new ServiceException(ce);
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg != null) {
                    if (msg.indexOf("Invalid Session") >= 0) {
                        this.cleanupSession();
                        if (this.pinger != null) {
                            this.setNeedPing(false);
                            this.pinger.interrupt();
                            this.pinger = null;
                        }
                        throw new AccessException(e);
                    }
                    if (msg.indexOf("Authorization Required") >= 0) {
                        throw new AccessException(e);
                    }
                    if (e instanceof UnknownHostException) {
                        ServiceException ex = new ServiceException(e);
                        ex.message = e.toString();
                        throw ex;
                    }
                }
                throw new ServiceException(e);
            }
            catch (RuntimeException re) {
                if (this.isClusteredEnv() && this.isPipeBroken(ifc, svc)) {
                    throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_SVR_UNREACHABLE, "");
                }
                throw re;
            }
            finally {
                TrustManager.setKeyAndChain(savedCredentials);
                if (ipStream != null) {
                    try {
                        ipStream.close();
                    }
                    catch (IOException ioe) {}
                }
                if (opStream != null) {
                    try {
                        opStream.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        } while (retry && bindFailures < 3);
        String newSessionId = this.getCookieId(uc.getHeaderField("Set-Cookie"));
        if (newSessionId != null && !newSessionId.equals(this.sessionId)) {
            this.sessionId = newSessionId;
        }
        this.setNeedPing(false);
        this.checkError(result);
        if (uc instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)uc;
            huc.disconnect();
        }
        return result;
    }

    private synchronized void checkError(Values data) throws ServiceException {
        if (data == null) {
            return;
        }
        Context.throwIfError(data);
    }

    private synchronized void checkError(IData data) throws ServiceException {
        if (data == null) {
            return;
        }
        Context.throwIfError(data);
    }

    double getServerVersion() throws ServiceException {
        if (this.isConnected()) {
            return this.serverVersion;
        }
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_CON_FIRST, "");
    }

    class Pinger
    extends Thread {
        long timeout;

        public Pinger() {
            this(120000L);
        }

        public Pinger(long timeout) {
            this.timeout = timeout;
            JournalLogger.logDebugPlus(1, 14, 36, Context.this.fixedUri, String.valueOf(timeout));
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Pinger.sleep(this.timeout);
                    Context.this.pingServer();
                    Context.this.setNeedPing(true);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

