/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.client;

import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.resources.ServiceExceptionBundle;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.ValuesEmulator;
import com.wm.net.HttpHeader;
import com.wm.net.HttpURLConnection;
import com.wm.security.Config;
import com.wm.security.TrustManager;
import com.wm.util.Base64;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.coder.RPCBinCoder2;
import com.wm.util.coder.XMLCoder;
import iaik.security.ssl.KeyAndCert;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseContext {
    public static final int CONTXT0001 = 1;
    public static final int CONTXT0002 = 2;
    public static final int RPC_BIN = 1;
    public static final int RPC_XML = 2;
    public static final int RPC_IDAT = 3;
    public static final int NO_SSL = 0;
    public static final int SSL_128 = 1;
    public static final int SSL_40 = 2;
    public static final int NO_REDIR = 0;
    public static final int ONE_REDIR = 1;
    public static final int ALLOW_REDIR = 2;
    protected static int gSSLSupport;
    protected static boolean handlerSet;
    protected int rpc_type;
    protected int rpc2Ver;
    protected int binVer;
    protected boolean secure;
    protected boolean connected;
    protected String server;
    protected String basicAuth;
    protected String fixedUri;
    protected Values gServers;
    protected int gMaxTries;
    protected int gNumHosts;
    protected String[] gHosts;
    protected Values gErrorVal;
    protected int gAllowRedir;
    protected String gRetryServer;
    protected int gCurrentSvrIndex;
    protected Object gSSLCredentials;
    protected String locale;
    protected int gStickyWait;
    protected int maxKeepAliveConns;
    protected int keepAliveTimeout;
    protected boolean enableHttp1_1 = false;
    protected Values context;
    private ClassLoader classloader;
    private ReentrantLock mutex = new ReentrantLock();
    public final int CLUSTER_INVOKE_SUCCESS = 1;
    public final int CLUSTER_INVOKE_FAILED = 2;
    public final int CLUSTER_INVOKE_RETRY = 3;
    public final int CLUSTER_INVOKE_REDIRECT = 4;
    public final int CLUSTER_CONNECT_SUCCESS = 1;
    public final int CLUSTER_CONNECT_FAILED = 2;
    public final String RESULT_KEY = "cmresult";
    public final String RESULT_MSG_KEY = "cmresultStr";

    public BaseContext(Values context) {
        this(1, context);
    }

    protected BaseContext(int rpcType, Values context) {
        this.setRPCType(rpcType);
        this.initVars(context);
    }

    public BaseContext() {
        this(1);
    }

    protected BaseContext(int rpcType) {
        this.setRPCType(rpcType);
        this.initVars(new Values());
    }

    private void initVars(Values context) {
        this.gCurrentSvrIndex = 0;
        this.gMaxTries = 10;
        this.gNumHosts = -1;
        this.gHosts = null;
        this.gServers = null;
        this.gAllowRedir = 2;
        this.gRetryServer = null;
        this.rpc2Ver = RPCBinCoder2.getHighestVersionSupported();
        this.binVer = IDataBinCoder.getHighestVersionSupported();
        this.context = context;
        this.gStickyWait = Integer.parseInt(com.wm.util.Config.getProperty("10000", "watt.server.cluster.stickyWait"));
        this.enableHttp1_1 = false;
    }

    public void setMaxKeepaliveConns(int maxConns) {
        this.maxKeepAliveConns = maxConns;
    }

    public void setKeepAliveTimeout(int keepalive) {
        this.keepAliveTimeout = keepalive;
    }

    protected void enableHttp1_1() {
        this.enableHttp1_1 = true;
    }

    protected void disableHttp1_1() {
        this.enableHttp1_1 = false;
    }

    protected boolean isHttp1_1Enabled() {
        return this.enableHttp1_1;
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public void setRpc2Ver(int v) {
        int highest = RPCBinCoder2.getHighestVersionSupported();
        this.rpc2Ver = v > highest ? highest : v;
    }

    public void setBinVer(int v) {
        int highest = IDataBinCoder.getHighestVersionSupported();
        this.binVer = v > highest ? highest : v;
    }

    public synchronized void setServers(Values servers) {
        this.gServers = servers;
        if (this.gServers == null) {
            this.gNumHosts = 0;
            return;
        }
        try {
            Values[] hosts = (Values[])servers.get("hosts");
            this.gNumHosts = hosts.length > this.gMaxTries ? this.gMaxTries : hosts.length;
            this.gHosts = new String[this.gNumHosts];
            for (int j = 0; j < this.gNumHosts; ++j) {
                this.gHosts[j] = (String)hosts[j].get("server");
            }
        }
        catch (Exception e) {
            this.gNumHosts = 0;
        }
    }

    public synchronized Values getServers() {
        return this.gServers;
    }

    public String getConnectedServer() {
        return this.server;
    }

    public synchronized int getNumHosts() {
        return this.gNumHosts;
    }

    public boolean isClusteredEnv() {
        return this.getNumHosts() > 0;
    }

    public void setAllowRedir(boolean val) {
        this.gAllowRedir = val ? 2 : 0;
    }

    public void setRetryServer(String retryServer) {
        this.gRetryServer = retryServer;
    }

    public void setAllowRedir(int level) {
        this.gAllowRedir = level;
    }

    protected void loadWmHandler() {
        if (com.wm.util.Config.getProperty("false", "watt.net.useURLFactory").equalsIgnoreCase("true")) {
            try {
                Class<?> c = Class.forName("com.wm.net.URLStreamHandlerFactory");
                if (c != null) {
                    URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)c.newInstance());
                    handlerSet = true;
                }
            }
            catch (Throwable throwable) {}
        } else {
            com.wm.util.Config.setProtocolPath();
            handlerSet = true;
        }
    }

    protected synchronized void checkConnection() throws ServiceException {
        if (!this.connected) {
            throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_NOT_CON_TO_SERVER, "");
        }
    }

    protected boolean isProxyValid(String hostport) {
        if (hostport == null || hostport.length() == 0) {
            return true;
        }
        int pos = hostport.indexOf(58);
        if (pos < 0 || pos == hostport.length() - 1) {
            return true;
        }
        try {
            Integer.parseInt(hostport.substring(pos + 1, hostport.length()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String getHost(String hostport) {
        if (hostport == null || hostport.length() == 0) {
            return null;
        }
        int pos = hostport.indexOf(58);
        if (pos < 0) {
            return hostport;
        }
        return hostport.substring(0, pos);
    }

    protected String getPort(String hostport, String defPort) {
        if (hostport == null) {
            return "";
        }
        int pos = hostport.indexOf(58);
        if (pos < 0 || pos == hostport.length() - 1) {
            return defPort;
        }
        try {
            return hostport.substring(pos + 1);
        }
        catch (NumberFormatException e) {
            return defPort;
        }
    }

    protected void cleanupSession() {
        this.lock();
        this.connected = false;
        this.fixedUri = null;
        this.unlock();
    }

    protected Object getCoder() {
        switch (this.rpc_type) {
            case 2: {
                return new XMLCoder(true);
            }
            case 3: {
                IDataBinCoder idb = new IDataBinCoder();
                idb.setVersion(this.binVer);
                if (this.classloader != null) {
                    idb.setPriorityClassLoader(this.classloader);
                }
                return idb;
            }
        }
        return new RPCBinCoder2(this.rpc2Ver);
    }

    public void setClassLoader(ClassLoader cl) {
        this.classloader = cl;
    }

    protected URLConnection getURLConnection(String ifc, String svc) throws ServiceException, IOException {
        String directive = com.wm.util.Config.getProperty("invoke", "watt.server.invokeDirective");
        try {
            URL url = new URL(Strings.cat(this.secure ? "https://" : "http://", this.getHost(this.server), ":", this.getPort(this.server, "5555"), this.fixedUri == null ? Strings.cat("/" + directive + "/", ifc, "/", svc) : Strings.cat(this.fixedUri, "?ifc=", ifc, "&svc=", svc, this.basicAuth != null ? "&auth=" + this.basicAuth : "")));
            JournalLogger.logDebugPlus(1, 1, 36, url.toString());
            HttpURLConnection uc = HttpURLConnection.getHttpURLConnection(url);
            if (uc instanceof HttpURLConnection) {
                HttpHeader resp = uc.getResponseHeader();
                this.enableHttp1_1 = resp != null && resp.getVersion().equals("HTTP/1.1");
            }
            ((URLConnection)uc).setDoOutput(true);
            return uc;
        }
        catch (MalformedURLException e) {
            JournalLogger.logError(2, 36, e);
            throw new ServiceException(e);
        }
    }

    public void setSecure(boolean sec) {
        this.secure = sec;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setFixedUri(String uri) {
        this.fixedUri = uri;
    }

    public void setRPCType(int type) {
        this.rpc_type = type;
    }

    public void setProxy(String host, String user, String pass) {
        if (!this.isProxyValid(host)) {
            return;
        }
        if (host == null || host.length() == 0 || host.equals(":")) {
            System.getProperties().put("watt.net.proxyHost", "");
            System.getProperties().put("watt.net.proxyPort", "");
            System.getProperties().put("watt.net.proxyUser", "");
            System.getProperties().put("watt.net.proxyPass", "");
        } else {
            System.getProperties().put("watt.net.proxyHost", this.getHost(host));
            System.getProperties().put("watt.net.proxyPort", this.getPort(host, "80"));
            if (user != null) {
                System.getProperties().put("watt.net.proxyUser", user);
            }
            if (pass != null) {
                System.getProperties().put("watt.net.proxyPass", pass);
            }
        }
    }

    public void setSecureProxy(String host, String user, String pass) {
        if (host == null || host.length() == 0 || host.equals(":")) {
            System.getProperties().remove("watt.net.secureProxyHost");
            System.getProperties().remove("watt.net.secureProxyPort");
            System.getProperties().remove("watt.net.secureProxyUser");
            System.getProperties().remove("watt.net.secureProxyPass");
        } else {
            System.getProperties().put("watt.net.secureProxyHost", this.getHost(host));
            System.getProperties().put("watt.net.secureProxyPort", this.getPort(host, "80"));
            if (user != null) {
                System.getProperties().put("watt.net.secureProxyUser", user);
            }
            if (pass != null) {
                System.getProperties().put("watt.net.secureProxyPass", pass);
            }
        }
    }

    public void setAuthentication(String user, String pass) {
        this.basicAuth = user != null && user.length() > 0 ? (pass != null ? Base64.encode(Strings.cat(user, ":", pass), false) : Base64.encode(Strings.cat(user, ":"), false)) : null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale.toString();
    }

    public byte[] getCertificate(String certPath) throws ServiceException {
        throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_NOT_IMPL, "");
    }

    public void setSSLCertificates(String cert, String privKey, String cacert) {
        try {
            String[] certChain = new String[]{cert, cacert};
            this.setSSLCertificates(privKey, certChain);
        }
        catch (Exception e) {
            JournalLogger.logDebugPlus(1, 2, 36, e.getMessage());
        }
    }

    public void setSSLCertificates(String privKey, String[] certChain) throws CertificateException, IOException, InvalidKeyException {
        Object kac = TrustManager.loadKeyAndChain(privKey, certChain);
        this._setSSLCertificates(kac);
    }

    public void setSSLCertificates(KeyAndCert kac) {
        this._setSSLCertificates(kac);
    }

    private void _setSSLCertificates(Object kac) {
        if (kac != null) {
            this.gSSLCredentials = kac;
            TrustManager.setKeyAndChain(kac);
        }
    }

    public void setInvokeDirective(String directive) {
        if (directive == null || directive.length() == 0) {
            com.wm.util.Config.setProperty("watt.server.invokeDirective", null);
        } else {
            com.wm.util.Config.setProperty("watt.server.invokeDirective", directive);
        }
    }

    protected boolean isPipeBroken(String ifc, String svc) {
        try {
            URLConnection uc = this.getURLConnection(ifc, svc);
            uc.connect();
            if (uc instanceof java.net.HttpURLConnection) {
                java.net.HttpURLConnection huc = (java.net.HttpURLConnection)uc;
                huc.disconnect();
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getServerToInvoke() {
        Values host;
        Values[] hosts;
        int index;
        if (this.gAllowRedir == 0 || this.isSecure() || this.gNumHosts <= 0 || this.gServers == null) {
            return null;
        }
        Values values = this.gServers;
        synchronized (values) {
            index = this.gCurrentSvrIndex++;
            if (index >= this.gNumHosts) {
                this.gCurrentSvrIndex = 0;
                index = 0;
            }
            hosts = (Values[])this.gServers.get("hosts");
        }
        if (hosts != null && (host = hosts[index]) != null) {
            String svr = (String)host.get("host");
            Integer port = this.isSecure() ? (Integer)host.get("sport") : (Integer)host.get("port");
            StringBuffer sb = new StringBuffer(svr);
            return sb.append(":").append(this.getPort(this.server, port.toString())).toString();
        }
        return null;
    }

    protected abstract Values clusterSvcInvoke(String var1, String var2, Values var3) throws Exception;

    protected abstract IData clusterSvcInvoke(String var1, String var2, IData var3) throws Exception;

    protected abstract int clusterConnect(String var1, byte[] var2, String var3, String var4);

    protected abstract void clusterCleanupConnection();

    protected abstract void clusterDisconnect();

    protected abstract void clusterAbort() throws Exception;

    protected final Values clusterInvoke(Values clusterServers, String curSessionID, String curServer, int maxTries, String IFC, String SVC, Values inData) throws Exception {
        IData res;
        IData id = null;
        if (inData != null) {
            id = inData.getIData();
        }
        if ((res = this.clusterInvoke(clusterServers, curSessionID, curServer, maxTries, IFC, SVC, id)) == null || res instanceof Values) {
            return (Values)res;
        }
        return Values.use(res);
    }

    protected final IData clusterInvoke(Values clusterServers, String curSessionID, String curServer, int maxTries, String IFC, String SVC, IData inData) throws Exception {
        Hashtable<String, String> hRedirected = new Hashtable<String, String>(10);
        String redirectedServer = null;
        boolean redirected = false;
        String curSrv = curServer;
        String curPort = null;
        String redirectingServer = null;
        boolean succeeded = false;
        IData outVal = null;
        String cbasicAuth = this.basicAuth;
        String host = null;
        int numHosts = this.gNumHosts;
        if (curServer == null) {
            curSrv = curServer = this.server;
        }
        curPort = curServer.substring(1 + curServer.indexOf(":"));
        String[] hosts = null;
        if (this.gHosts != null) {
            hosts = (String[])this.gHosts.clone();
        }
        hRedirected.clear();
        if (curSrv != null && curSrv.length() > 0) {
            hRedirected.put(curSrv, curSrv);
        }
        for (int i = 0; i <= numHosts; ++i) {
            if (i != 0 || redirected) {
                if (hRedirected.size() > maxTries) break;
                if (!redirected) {
                    this.clusterCleanupConnection();
                    String hostPort = hosts[i - 1];
                    if (hostPort != null && hostPort.indexOf(":") != -1) {
                        host = hostPort.substring(0, hostPort.indexOf(":"));
                        curPort = hostPort.substring(hostPort.indexOf(":") + 1, hostPort.length());
                    }
                    if (host == null || curPort == null) continue;
                    curSrv = Strings.cat(host, ":", curPort);
                } else {
                    if (this.isSecure() || !this.isConnected()) {
                        this.clusterCleanupConnection();
                    }
                    redirectingServer = curSrv;
                    curSrv = redirectedServer;
                    redirected = false;
                }
                if (hRedirected.get(curSrv) != null && redirectingServer != null && i == numHosts) {
                    curSrv = redirectingServer;
                    redirectingServer = null;
                    this.setAllowRedir(1);
                }
                hRedirected.put(curSrv, curSrv);
                this.basicAuth = cbasicAuth;
                if (this.isSecure() || !this.isConnected()) {
                    int result = this.clusterConnect(curSrv, null, this.basicAuth, curSessionID);
                    if (result == 2) {
                        continue;
                    }
                } else {
                    this.server = curSrv;
                }
            }
            if ((outVal = this.clusterSvcInvoke(IFC, SVC, inData)) == null) {
                throw new ServiceException(ServiceExceptionBundle.class, ServiceExceptionBundle.SVC_FAILED_INVOKE, "");
            }
            IDataCursor dc = outVal.getCursor();
            if (dc.first("cmresult")) {
                int result = Integer.parseInt((String)dc.getValue());
                if (result == 2) {
                    throw new ServiceException(ValuesEmulator.getString(outVal, "cmresultStr"));
                }
                if (result == 3) {
                    if (this.gStickyWait <= 0) continue;
                    Thread.sleep(this.gStickyWait);
                    continue;
                }
                if (result != 4) continue;
                redirectedServer = ValuesEmulator.getString(outVal, "cmresultStr");
                redirected = true;
                this.setAllowRedir(1);
                --i;
                continue;
            }
            succeeded = true;
            break;
        }
        if (!succeeded) {
            this.clusterAbort();
        }
        return outVal;
    }

    protected final Values clusterInvoke(Values clusterServers, int maxTries, String IFC, String SVC, Values inData) throws Exception {
        return this.clusterInvoke(clusterServers, null, null, maxTries, IFC, SVC, inData);
    }

    protected final IData clusterInvoke(Values clusterServers, int maxTries, String IFC, String SVC, IData inData) throws Exception {
        return this.clusterInvoke(clusterServers, null, null, maxTries, IFC, SVC, inData);
    }

    public static void throwIfError(Values data) throws ServiceException {
        BaseContext.throwIfError(data.getIData());
    }

    public static void throwIfError(IData data) throws ServiceException {
        if (data == null) {
            return;
        }
        IDataCursor dc = data.getCursor();
        if (dc.first("$errorInfo")) {
            dc.destroy();
            throw new ServiceException(Values.use(data));
        }
        if (dc.first("$errorType")) {
            String errorType = (String)dc.getValue();
            String error = null;
            if (dc.first("$error")) {
                error = (String)dc.getValue();
            }
            String locError = null;
            if (dc.first("$localizedError")) {
                locError = (String)dc.getValue();
            }
            String dump = null;
            if (dc.first("$errorDump")) {
                dump = (String)dc.getValue();
            }
            String redir = null;
            if (dc.first("$redirected")) {
                redir = (String)dc.getValue();
            }
            dc.destroy();
            throw new ServiceException(error, locError, errorType, dump, redir);
        }
        dc.destroy();
    }

    public static int getSSLSupport() {
        return gSSLSupport;
    }

    static {
        Config.setupProviders();
        boolean b = Config.isSSLPresent();
        gSSLSupport = b ? 1 : 0;
    }
}

