/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.store;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.store.UFOStoreMgmtDAO;
import com.ufo.store.entity.StoreInfomationEntity;

public class UFOStoreMgmtWB
extends UFOBaseWB {
    public UFOStoreMgmtWB() {
    }

    public UFOStoreMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchShopList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("shopNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ADDR)) {
                        info.put("shopAddr", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("note1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("note2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchShopListPaging(info));
                    result.put("TOTCNT", dao.getShopListCnt(info));
                } else {
                    result.put("LIST", dao.searchShopList(info));
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectStore(info));
                result.put("BRAND", dao.searchBrandinStore(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                info.put("shopCd", dao.getNewShopCd());
                this.startTransaction();
                resCnt = dao.insertStore(info);
                String[] splitAttr = new String[]{"brandCd", "status"};
                String[] keepAttr = new String[]{"shopCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            resCnt2 += dao.insertBrandinStore(arrInfo[i]);
                        } else if (!CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            resCnt2 += dao.deleteBrandinStore(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateStore(info);
                String[] splitAttr = new String[]{"brandCd", "status"};
                String[] keepAttr = new String[]{"shopCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            resCnt2 += dao.insertBrandinStore(arrInfo[i]);
                        } else if (!CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            resCnt2 += dao.deleteBrandinStore(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("shopCd", info.getString("shopCd"));
                resCnt1 = dao.deleteBrandinStore(temp);
                resCnt2 = dao.deleteSiteStoreInfo(temp);
                resCnt = dao.deleteStore(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSiteShopList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("shopNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ADDR)) {
                        info.put("shopAddr", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("note1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("note2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchSiteStoreListPaging(info));
                    result.put("TOTCNT", dao.getSiteStoreListCnt(info));
                } else {
                    result.put("LIST", dao.searchSiteStoreList(info));
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSiteShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                StoreInfomationEntity entity = new StoreInfomationEntity();
                entity = dao.selectSiteStoreInfo(info);
                if (entity != null) {
                    entity.attachFile = dao.searchAttachList(info);
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SITEINFO_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertSiteShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                if (info.isSpace("shopCd")) {
                    info.put("shopCd", dao.getNewShopCd());
                    resCnt = dao.insertStore(info);
                } else {
                    resCnt = dao.updateStore(info);
                }
                resCnt1 = dao.insertSiteStoreInfo(info);
                if (resCnt > 0 && resCnt1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SITEINFO_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateSiteShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                if (info.isSpace("shopCd")) {
                    info.put("shopCd", dao.getNewShopCd());
                    resCnt = dao.insertStore(info);
                } else {
                    resCnt = dao.updateStore(info);
                }
                resCnt1 = dao.updateSiteStoreInfo(info);
                if (resCnt > 0 && resCnt1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SITEINFO_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteSiteShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt2 = dao.deleteFile(info);
                resCnt1 = dao.deleteAttachInfo(info);
                resCnt = dao.deleteSiteStoreInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SHOP_SITEINFO_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAttachFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertAttachInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]STORE_ATTACH_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAttachFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                dao.deleteFile(info);
                resCnt = dao.deleteAttachInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]STORE_ATTACH_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchOnlieShopList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchOnlineShopList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ONLINE_SHOP_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectOnlineShopInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectOnlineStore(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ONLINE_SHOP_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult onLineStoreProc(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                if ("NEW".equals(info.getString("flag"))) {
                    info.put("shopSeq", dao.getMaxSeq(info));
                    resCnt = dao.insertOnlineStore(info);
                } else {
                    resCnt = dao.updateOnlineStore(info);
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ONLIE_SHOP_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult onlineShopDtlList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchOnlineStoreDtlList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ONLINE_SHOP_DTL_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult onLineStoreDtlProc(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt2 = 0;
        try {
            try {
                UFOStoreMgmtDAO dao = new UFOStoreMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteOnlineStoreDtl(info);
                String[] splitAttr = info.getArray("el_chk");
                UFORequest reqSub = new UFORequest();
                int i = 0;
                while (i < splitAttr.length) {
                    if (splitAttr[i].endsWith("")) {
                        reqSub.put("shopSeq", splitAttr[i]);
                        reqSub.put("siteCd", info.getString("siteCd"));
                        reqSub.put("brandShopUrl", info.getString("bsu" + splitAttr[i]));
                        System.out.println(reqSub);
                        resCnt2 += dao.insertOnlineStoreDtl(reqSub);
                    }
                    ++i;
                }
                if (resCnt2 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ONLIE_SHOP_DTL_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

