/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.product;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.product.entity.ProductAddInfoEntity;
import com.ufo.product.entity.ProductOptionInfoEntity;
import com.ufo.product.entity.ProductSiteDtlInfoEntity;
import com.ufo.product.entity.ProductSiteMstInfoEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOProductServiceDAO
extends UFOBaseDAO {
    public UFOProductServiceDAO(Connection con) {
        super(con);
    }

    public Vector searchAddItemList(UFORequest info) throws UFOException {
        Vector result;
        block7: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT DISTINCT /* PRODUCT_ADDITEM_SEARCH */\t\t");
            strSql.append("\n").append(" \t\t\t\t\tPrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G033', Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD02DT\t\t \t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE PrdtCd = ?\t \t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tORDER BY Nm\t\t \t\t\t\t\t\t\t\t\t\t\t\t");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDITEM_SEARCH", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block7;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public Vector searchAddList(UFORequest info) throws UFOException {
        Vector result;
        block22: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_ADDINFO_SEARCH */\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\tPrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G033', Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G034', Value ) AS ValueNm\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, PrdtFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
            strSql.append("\n").append("                    , ModId                                                     ");
            strSql.append("\n").append(" \t\t\t  FROM UPRD02DT\tD\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t \t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.isEquals("cd", "REPD")) {
                strSql.append("\n").append("\t\t\t   AND EXISTS (SELECT 'X' FROM UPRD02MT WHERE PRDTCD = D.VALUE AND USEFL = 'Y') ");
            }
            if (info.isExist("value")) {
                strSql.append("\n").append("\t\t\t   AND Value LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append("\t\t\t   AND UseFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append("\t\t\t   AND UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            strSql.append("\n").append("\t\t\t\tORDER BY PrdtCd, Cd,  OrderBy\t\t\t\t\t\t\t");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_SEARCH", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block22;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public Vector searchAddListPaging(UFORequest info) throws UFOException {
        Vector result;
        block24: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_ADDINFO_SEARCH_PAGE */\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\tPrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G033', Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G034', Value ) AS ValueNm\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, PrdtFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
            strSql.append("\n").append("                    , ModId                                                     ");
            strSql.append("\n").append(" \t\t\t  FROM UPRD02DT D\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t \t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.isEquals("cd", "REPD")) {
                strSql.append("\n").append("\t\t\t   AND EXISTS (SELECT 'X' FROM UPRD02MT WHERE PRDTCD = D.VALUE AND USEFL = 'Y') ");
            }
            if (info.isExist("value")) {
                strSql.append("\n").append("\t\t\t   AND Value LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append("\t\t\t   AND UseFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append("\t\t\t   AND UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            strSql.append("\n").append("\t\t\t\tORDER BY PrdtCd, Cd, OrderBy\t\t\t\t\t\t\t");
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_SEARCH_PAGE", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block24;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public int getAddListCnt(UFORequest info) throws UFOException {
        int result;
        block22: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = 0;
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_ADDINFO_SEARCH_COUNT */\t\t");
            strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD02DT\tD\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t \t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.isEquals("cd", "REPD")) {
                strSql.append("\n").append("\t\t\t   AND EXISTS (SELECT 'X' FROM UPRD02MT WHERE PRDTCD = D.VALUE AND USEFL = 'Y') ");
            }
            if (info.isExist("value")) {
                strSql.append("\n").append("\t\t\t   AND Value LIKE '%' || ? || '%'\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append("\t\t\t   AND UseFl = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append("\t\t\t   AND UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_SEARCH_COUNT", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block22;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public ProductAddInfoEntity selectAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductAddInfoEntity result = new ProductAddInfoEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\tSELECT /* PRODUCT_ADDINFO_SELECT */ \t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tPrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PrdtFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t\t");
        strSql.append("\n").append("                    , ModId        ");
        strSql.append("\n").append(" \t\t\t  FROM UPRD02DT\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\tWHERE PrdtCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setLong(index++, info.getLong("seq"));
                rs = pstmt.executeQuery();
                result = (ProductAddInfoEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* PRODUCT_ADDINFO_INSERT */ INTO UPRD02DT (\t");
        strSql.append("\n").append(" \t\t\t\t\tPrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PrdtFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM UPRD02DT WHERE PrdtCd = ? AND Cd = ? )\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("value"));
                pstmt.setString(index++, info.getString("relImg1"));
                pstmt.setString(index++, info.getString("relImg2"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, info.getString("prdtFl"));
                pstmt.setString(index++, info.getString("dispFl"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* PRODUCT_ADDINFO_UPDATE */ UPRD02DT SET\t");
        strSql.append("\n").append(" \t\t\t\t\tPrdtCd\t\t\t= PrdtCd\t\t\t\t\t");
        if (info.isExist("value")) {
            strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relImg1")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relImg2")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("notes1")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("notes2")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("prdtFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, PrdtFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("dispFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("orderBy")) {
            strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\tWHERE PrdtCd = ? \t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (info.isExist("relImg1")) {
                    pstmt.setString(index++, info.getString("relImg1"));
                }
                if (info.isExist("relImg2")) {
                    pstmt.setString(index++, info.getString("relImg2"));
                }
                if (info.isExist("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (info.isExist("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (info.isExist("prdtFl")) {
                    pstmt.setString(index++, info.getString("prdtFl"));
                }
                if (info.isExist("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("orderBy")) {
                    pstmt.setInt(index++, info.getInt("orderBy"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setLong(index++, info.getLong("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteAddInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* PRODUCT_ADDINFO_DELETE */ FROM UPRD02DT\t\t\t");
        strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("prdtCd")) {
            strSql.append("\n").append("\t\t\t   AND PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cd")) {
            strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_ADDINFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchRelList(UFORequest info) throws UFOException {
        Vector result;
        block27: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO_SEARCH */\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', A.Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.PrdtNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.SiteCd As PrdtSiteCd\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.PrdtDesc\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Usage\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelInfo\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Value\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.lPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.MPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.SPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.lTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.MTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.STxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.DescImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.BrandCd\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD03DT A, UPRD02MT B\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE A.PrdtCd = B.PrdtCd(+)\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("siteCd")) {
                strSql.append("\n").append("\t\t\t   AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND A.Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND A.PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.isExist("value")) {
                strSql.append("\n").append("\t\t\t   AND A.Value LIKE '%' || ? || '%'\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append("\t\t\t   AND A.UseFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append("\t\t\t   AND A.UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("catCd")) {
                strSql.append("\n").append("\t\t\t   AND A.CatCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.getString("orderByStr").equals("CATCD")) {
                strSql.append("\n").append("\t\t\t\tORDER BY A.CatCd, A.OrderBy, A.Seq DESC\t\t\t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t\tORDER BY A.OrderBy, A.Seq DESC\t\t\t\t\t\t\t\t");
            }
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("catCd")) {
                    pstmt.setString(index++, info.getString("catCd"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_SEARCH", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block27;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public Vector searchRelListPaging(UFORequest info) throws UFOException {
        Vector result;
        block29: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO_SEARCH_PAGE */\t");
            strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', A.Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.PrdtNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.SiteCd As PrdtSiteCd\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.PrdtDesc\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Usage\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelInfo\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Value\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.lPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.MPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.SPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.lTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.MTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.STxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.DescImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.BrandCd\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD03DT A, UPRD02MT B\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE A.PrdtCd = B.PrdtCd(+)\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("siteCd")) {
                strSql.append("\n").append("\t\t\t   AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND A.Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND A.PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.isExist("value")) {
                strSql.append("\n").append("\t\t\t   AND A.Value LIKE '%' || ? || '%'\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append("\t\t\t   AND A.UseFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append("\t\t\t   AND A.UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("catCd")) {
                strSql.append("\n").append("\t\t\t   AND A.CatCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.getString("orderByStr").equals("CATCD")) {
                strSql.append("\n").append("\t\t\t\tORDER BY A.CatCd, A.OrderBy, A.Seq DESC\t\t\t\t\t\t\t\t");
            } else {
                strSql.append("\n").append("\t\t\t\tORDER BY A.OrderBy, A.Seq DESC\t\t\t\t\t\t\t\t");
            }
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("catCd")) {
                    pstmt.setString(index++, info.getString("catCd"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_SEARCH_PAGE", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block29;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public int getRelListCnt(UFORequest info) throws UFOException {
        int result;
        block25: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = 0;
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO_SEARCH_COUNT */\t");
            strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD03DT A\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("siteCd")) {
                strSql.append("\n").append("\t\t\t   AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND A.Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND A.PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (info.isExist("value")) {
                strSql.append("\n").append("\t\t\t   AND A.Value LIKE '%' || ? || '%'\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append("\t\t\t   AND A.UseFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append("\t\t\t   AND A.UseFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("catCd")) {
                strSql.append("\n").append("\t\t\t   AND A.CatCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("catCd")) {
                    pstmt.setString(index++, info.getString("catCd"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_SEARCH_COUNT", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block25;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public ProductAddInfoEntity selectRelInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductAddInfoEntity result = new ProductAddInfoEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\tSELECT /* PRODUCT_SITE_RELINFO_SELECT */ \t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', A.Cd ) AS Nm\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SiteCd As PrdtSiteCd\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.PrdtNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.PrdtDesc\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Usage\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RelInfo\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Value\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.lPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.lTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.STxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.DescImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t");
        strSql.append("\n").append(" \t\t\t  FROM UPRD03DT A, UPRD02MT B\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\tWHERE A.PrdtCd = B.PrdtCd(+)\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.SiteCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setLong(index++, info.getLong("seq"));
                rs = pstmt.executeQuery();
                result = (ProductAddInfoEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertRelInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* PRODUCT_SITE_RELINFO_INSERT */ INTO UPRD03DT (\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PrdtDesc\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Usage\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelInfo\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CatCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM UPRD03DT WHERE SiteCd = ? AND Cd = ? )\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("prdtDesc"));
                pstmt.setString(index++, info.getString("usage"));
                pstmt.setString(index++, info.getString("relInfo"));
                pstmt.setString(index++, info.getString("value"));
                pstmt.setString(index++, info.getString("relImg1"));
                pstmt.setString(index++, info.getString("relImg2"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, info.getString("dispFl"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, info.getString("catCd"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateRelInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* PRODUCT_SITE_RELINFO_UPDATE */ UPRD03DT SET\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t= SiteCd\t\t\t\t\t");
        if (info.isExist("prdtCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, PrdtCd\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("prdtDesc")) {
            strSql.append("\n").append(" \t\t\t\t\t, PrdtDesc\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("usage")) {
            strSql.append("\n").append(" \t\t\t\t\t, Usage\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relInfo")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelInfo\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("value")) {
            strSql.append("\n").append(" \t\t\t\t\t, Value\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relImg1")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relImg2")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("notes1")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes1\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("notes2")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes2\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("dispFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, UseFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("orderBy")) {
            strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("catCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, CatCd\t\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\tWHERE SiteCd = ? \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (info.isExist("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtDesc"));
                }
                if (info.isExist("prdtDesc")) {
                    pstmt.setString(index++, info.getString("usage"));
                }
                if (info.isExist("usage")) {
                    pstmt.setString(index++, info.getString("relInfo"));
                }
                if (info.isExist("value")) {
                    pstmt.setString(index++, info.getString("value"));
                }
                if (info.isExist("relImg1")) {
                    pstmt.setString(index++, info.getString("relImg1"));
                }
                if (info.isExist("relImg2")) {
                    pstmt.setString(index++, info.getString("relImg2"));
                }
                if (info.isExist("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                if (info.isExist("notes2")) {
                    pstmt.setString(index++, info.getString("notes2"));
                }
                if (info.isExist("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("orderBy")) {
                    pstmt.setInt(index++, info.getInt("orderBy"));
                }
                if (info.isExist("catCd")) {
                    pstmt.setString(index++, info.getString("catCd"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setLong(index++, info.getLong("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteRelInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* PRODUCT_SITE_RELINFO_DELETE */ FROM UPRD03DT\t");
        strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("siteCd")) {
            strSql.append("\n").append("\t\t\t   AND SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("cd")) {
            strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (!info.isSpace("siteCd")) {
                    pstmt.setString(index++, info.getString("siteCd"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchRel2MstList(UFORequest info) throws UFOException {
        Vector result;
        block17: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO2_M_SEARCH */\t\t");
            strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Year\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Month\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Title\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ContentsURL\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ThumbnailImg\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, MainImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD05MT\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t   WHERE SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("year")) {
                strSql.append("\n").append("\t\t\t   AND Year = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("month")) {
                strSql.append("\n").append("\t\t\t   AND Month = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            strSql.append("\n").append("\t\t\t\tORDER BY Seq DESC\t\t\t\t\t\t\t\t\t\t\t");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("year")) {
                    pstmt.setString(index++, info.getString("year"));
                }
                if (!info.isSpace("month")) {
                    pstmt.setString(index++, info.getString("month"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductSiteMstInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_SEARCH", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block17;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public Vector searchRel2MstListPaging(UFORequest info) throws UFOException {
        Vector result;
        block19: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO2_M_SEARCH_PAGE */\t");
            strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Year\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Month\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Title\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ContentsURL\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ThumbnailImg\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, MainImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD05MT\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t   WHERE SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("year")) {
                strSql.append("\n").append("\t\t\t   AND Year = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("month")) {
                strSql.append("\n").append("\t\t\t   AND Month = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            strSql.append("\n").append("\t\t\t\tORDER BY Seq DESC\t\t\t\t\t\t\t\t\t\t\t");
            try {
                int pageSize = 10;
                int pageNo = 1;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("year")) {
                    pstmt.setString(index++, info.getString("year"));
                }
                if (!info.isSpace("month")) {
                    pstmt.setString(index++, info.getString("month"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductSiteMstInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_SEARCH_PAGE", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block19;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public int getRel2MstListCnt(UFORequest info) throws UFOException {
        int result;
        block17: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = 0;
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO2_M_SEARCH_COUNT */\t");
            strSql.append("\n").append(" \t\t\t\t\tCOUNT(*) CNT\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD05MT\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t   WHERE SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("year")) {
                strSql.append("\n").append("\t\t\t   AND Year = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("month")) {
                strSql.append("\n").append("\t\t\t   AND Month = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("year")) {
                    pstmt.setString(index++, info.getString("year"));
                }
                if (!info.isSpace("month")) {
                    pstmt.setString(index++, info.getString("month"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_SEARCH_COUNT", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block17;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public ProductSiteMstInfoEntity selectRel2MstInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductSiteMstInfoEntity result = new ProductSiteMstInfoEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO2_M_SELECT */\t\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', Cd ) AS Nm\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Year\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Month\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Title\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ContentsURL\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ThumbnailImg\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RegId\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(FstRegDate,'YYYYMMDD') RegDate\t");
        strSql.append("\n").append(" \t\t\t  FROM UPRD05MT\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   WHERE SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                rs = pstmt.executeQuery();
                result = (ProductSiteMstInfoEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.ProductSiteMstInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertRel2MstInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* PRODUCT_SITE_RELINFO2_M_INSERT */ INTO UPRD05MT (\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Year\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Month\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Title\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ContentsURL\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ThumbnailImg\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MainImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM UPRD05MT WHERE SiteCd = ? AND Cd = ? )\t");
        strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("year"));
                pstmt.setString(index++, info.getString("month"));
                pstmt.setString(index++, info.getString("title"));
                pstmt.setString(index++, info.getString("contents"));
                pstmt.setString(index++, info.getString("contentsURL"));
                pstmt.setString(index++, info.getString("thumbnailImg"));
                pstmt.setString(index++, info.getString("mainImg"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, info.getString("dispFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateRel2MstInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* PRODUCT_SITE_RELINFO2_M_UPDATE */ UPRD05MT SET\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t= SiteCd\t\t\t\t\t");
        if (info.isExist("year")) {
            strSql.append("\n").append(" \t\t\t\t\t, Year\t\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("month")) {
            strSql.append("\n").append(" \t\t\t\t\t, Month\t\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("title")) {
            strSql.append("\n").append(" \t\t\t\t\t, Title\t\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("contents")) {
            strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("contentsURL")) {
            strSql.append("\n").append(" \t\t\t\t\t, ContentsURL\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("thumbnailImg")) {
            strSql.append("\n").append(" \t\t\t\t\t, ThumbnailImg\t= ?\t\t\t\t\t");
        }
        if (info.isExist("mainImg")) {
            strSql.append("\n").append(" \t\t\t\t\t, MainImg\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("notes")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t= ?\t\t\t\t\t");
        }
        if (info.isExist("dispFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t= ?\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\tWHERE SiteCd = ? \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("year")) {
                    pstmt.setString(index++, info.getString("year"));
                }
                if (info.isExist("month")) {
                    pstmt.setString(index++, info.getString("month"));
                }
                if (info.isExist("title")) {
                    pstmt.setString(index++, info.getString("title"));
                }
                if (info.isExist("contents")) {
                    pstmt.setString(index++, info.getString("contents"));
                }
                if (info.isExist("contentsURL")) {
                    pstmt.setString(index++, info.getString("contentsURL"));
                }
                if (info.isExist("thumbnailImg")) {
                    pstmt.setString(index++, info.getString("thumbnailImg"));
                }
                if (info.isExist("mainImg")) {
                    pstmt.setString(index++, info.getString("mainImg"));
                }
                if (info.isExist("notes")) {
                    pstmt.setString(index++, info.getString("notes"));
                }
                if (info.isExist("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteRel2MstInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* PRODUCT_SITE_RELINFO2_M_DELETE */ FROM UPRD05MT\t");
        strSql.append("\n").append("\t\t\t\tWHERE 1 = 1\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_M_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchRel2DtlList(UFORequest info) throws UFOException {
        Vector result;
        block16: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO2_D_SEARCH */\t\t");
            strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', A.Cd ) AS Nm\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.PrdtNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.SiteCd As PrdtSiteCd\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.lPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.MPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.SPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.lTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.MTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.STxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.DescImg\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, B.BrandCd\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Contents\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.Notes\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t");
            strSql.append("\n").append(" \t\t\t  FROM UPRD05DT A, UPRD02MT B\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t\tWHERE A.PrdtCd = B.PrdtCd(+)\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append("\t\t\t   AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            if (!info.isSpace("cd")) {
                strSql.append("\n").append("\t\t\t   AND A.Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("prdtCd")) {
                strSql.append("\n").append("\t\t\t   AND A.PrdtCd = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("seq")) {
                strSql.append("\n").append("\t\t\t   AND A.Seq = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = ?\t\t\t\t\t\t\t\t\t\t\t\t");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append("\t\t\t   AND A.DispFl = 'Y'\t\t\t\t\t\t\t\t\t\t\t\t");
            }
            strSql.append("\n").append("\t\t\t\tORDER BY A.OrderBy, A.PrdtCd\t\t\t\t\t\t\t\t\t");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                if (!info.isSpace("seq")) {
                    pstmt.setInt(index++, info.getInt("seq"));
                }
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductSiteDtlInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_D_SEARCH", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block16;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public ProductSiteDtlInfoEntity selectRel2DtlInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductSiteDtlInfoEntity result = new ProductSiteDtlInfoEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t\t SELECT /* PRODUCT_SITE_RELINFO2_D_SELECT */\t\t");
        strSql.append("\n").append(" \t\t\t\t\tA.SiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, ufo_getCdNm('G035', A.Cd ) AS Nm\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.PrdtNm\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SiteCd As PrdtSiteCd\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.lPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.SPrdtImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.lTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.MTxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.STxtImg\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.DescImg\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, B.BrandCd\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Contents\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.Notes\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, A.RegId\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, TO_CHAR(A.FstRegDate,'YYYYMMDD') RegDate\t");
        strSql.append("\n").append(" \t\t\t  FROM UPRD05DT A, UPRD02MT B\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\tWHERE A.PrdtCd = B.PrdtCd(+)\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND A.PrdtCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                pstmt.setString(index++, info.getString("prdtCd"));
                rs = pstmt.executeQuery();
                result = (ProductSiteDtlInfoEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.ProductSiteDtlInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_D_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertRel2DtlInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* PRODUCT_SITE_RELINFO2_D_INSERT */ INTO UPRD05DT (\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Cd\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Seq\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PrdtCd\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FstRegDate, RegId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate, ModId\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t , SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("contents"));
                pstmt.setString(index++, info.getString("relImg1"));
                pstmt.setString(index++, info.getString("relImg2"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, info.getString("dispFl"));
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_D_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateRel2DtlInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* PRODUCT_SITE_RELINFO2_D_UPDATE */ UPRD05DT SET\t");
        strSql.append("\n").append(" \t\t\t\t\tSiteCd\t\t\t= SiteCd\t\t\t\t\t");
        if (info.isExist("contents")) {
            strSql.append("\n").append(" \t\t\t\t\t, Contents\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relImg1")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelImg1\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("relImg2")) {
            strSql.append("\n").append(" \t\t\t\t\t, RelImg2\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("notes")) {
            strSql.append("\n").append(" \t\t\t\t\t, Notes\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("dispFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, DispFl\t\t\t= ?\t\t\t\t\t\t");
        }
        if (info.isExist("orderBy")) {
            strSql.append("\n").append(" \t\t\t\t\t, OrderBy\t\t= ?\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, FnlModDate\t= SYSDATE\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, ModId\t\t\t= ?\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\tWHERE SiteCd = ? \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND PrdtCd = ?\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("contents")) {
                    pstmt.setString(index++, info.getString("contents"));
                }
                if (info.isExist("relImg1")) {
                    pstmt.setString(index++, info.getString("relImg1"));
                }
                if (info.isExist("relImg2")) {
                    pstmt.setString(index++, info.getString("relImg2"));
                }
                if (info.isExist("notes")) {
                    pstmt.setString(index++, info.getString("notes"));
                }
                if (info.isExist("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (info.isExist("orderBy")) {
                    pstmt.setInt(index++, info.getInt("orderBy"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                pstmt.setString(index++, info.getString("prdtCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_D_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteRel2DtlInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* PRODUCT_SITE_RELINFO2_D_DELETE */ FROM UPRD05DT\t");
        strSql.append("\n").append("\t\t\t WHERE SiteCd = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Cd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t   AND Seq = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        if (!info.isSpace("prdtCd")) {
            strSql.append("\n").append("\t\t\t   AND PrdtCd = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setInt(index++, info.getInt("seq"));
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO2_D_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int insertPrdtOption(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("  INSERT /* PRODUCT_OPTION_INFO_INSERT */ INTO UPRD06DT ( ");
                strSql.append("\n").append("         Seq ");
                strSql.append("\n").append("         , PrdtCd ");
                strSql.append("\n").append("         , Cd ");
                strSql.append("\n").append("         , RelPrdtCd ");
                strSql.append("\n").append("         , OptNm1 ");
                strSql.append("\n").append("         , OptNm2 ");
                strSql.append("\n").append("         , SelPrc ");
                strSql.append("\n").append("         , PurPrc ");
                strSql.append("\n").append("         , SrcPlace ");
                strSql.append("\n").append("         , OptLImg ");
                strSql.append("\n").append("         , OptSImg ");
                strSql.append("\n").append("         , Notes1 ");
                strSql.append("\n").append("         , Notes2 ");
                strSql.append("\n").append("         , OrderBy ");
                strSql.append("\n").append("         , FstRegDate, RegId ");
                strSql.append("\n").append("         , FnlModDate, ModId ");
                strSql.append("\n").append("         , DispFl, UseFl ");
                strSql.append("\n").append("  ) VALUES ( ");
                strSql.append("\n").append("      (SELECT NVL(MAX(Seq),0)+1 AS Seq FROM UPRD06DT WHERE PrdtCd = ? AND Cd = ? ) ");
                strSql.append("\n").append("      ,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, SYSDATE,?, SYSDATE, ?,?,? ");
                strSql.append("\n").append("  ) ");
                int index = 1;
                pstmt = this.con.prepareStatement(strSql.toString());
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                pstmt.setString(index++, info.getString("relPrdtCd"));
                pstmt.setString(index++, info.getString("OptNm1"));
                pstmt.setString(index++, info.getString("OptNm2"));
                pstmt.setLong(index++, info.getLong("SelPrc"));
                pstmt.setString(index++, info.getString("PurPrc"));
                pstmt.setString(index++, info.getString("SrcPlace"));
                pstmt.setString(index++, info.getString("OptLImg"));
                pstmt.setString(index++, info.getString("OptSImg"));
                pstmt.setString(index++, info.getString("Notes1"));
                pstmt.setString(index++, info.getString("Notes2"));
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("DispFl"));
                pstmt.setString(index++, info.getString("UseFl"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_OPTION_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchProductOptionList(UFORequest info) throws UFOException {
        Vector result;
        block15: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append("  SELECT ");
            strSql.append("\n").append("        A.SEQ ");
            strSql.append("\n").append("       ,A.PRDTCD ");
            strSql.append("\n").append("       ,A.CD ");
            strSql.append("\n").append("       ,ufo_getcdnm('G088',A.CD) AS CDNM ");
            strSql.append("\n").append("       ,A.RELPRDTCD ");
            strSql.append("\n").append("       ,A.OPTNM1 ");
            strSql.append("\n").append("       ,A.OPTNM2 ");
            strSql.append("\n").append("       ,A.SELPRC ");
            strSql.append("\n").append("       ,A.PURPRC ");
            strSql.append("\n").append("       ,A.SRCPLACE ");
            strSql.append("\n").append("       ,A.QTY ");
            strSql.append("\n").append("       ,A.OPTLIMG ");
            strSql.append("\n").append("       ,A.OPTSIMG ");
            strSql.append("\n").append("       ,A.NOTES1 ");
            strSql.append("\n").append("       ,A.NOTES2 ");
            strSql.append("\n").append("       ,A.FSTREGDATE ");
            strSql.append("\n").append("       ,A.REGID ");
            strSql.append("\n").append("       ,A.FNLMODDATE ");
            strSql.append("\n").append("       ,A.MODID ");
            strSql.append("\n").append("       ,A.ORDERBY ");
            strSql.append("\n").append("       ,A.DISPFL ");
            strSql.append("\n").append("       ,A.USEFL ");
            strSql.append("\n").append("  FROM UPRD06DT A ");
            strSql.append("\n").append("  WHERE 1=1 ");
            strSql.append("\n").append("  AND A.PRDTCD = ? ");
            if (!info.isSpace("dispFl")) {
                strSql.append("\n").append(" AND A.DispFl = ? ");
            } else if (!info.isExist("dispFl")) {
                strSql.append("\n").append(" AND A.DispFl = 'Y' ");
            }
            if (!info.isSpace("useFl")) {
                strSql.append("\n").append(" AND A.UseFl = ? ");
            } else if (!info.isExist("useFl")) {
                strSql.append("\n").append(" AND A.UseFl = 'Y' ");
            }
            strSql.append("\n").append("  ORDER BY A.ORDERBY ASC ");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                if (!info.isSpace("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (!info.isSpace("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductOptionInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_OPTION_LIST_SELECT", sqlEx);
            }
            catch (ArrayIndexOutOfBoundsException abEx) {
                abEx.printStackTrace();
                this.closePreparedStatement(pstmt);
                this.closeResultSet(rs);
                break block15;
            }
            catch (Exception etcEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
        }
        return result;
    }

    public ProductOptionInfoEntity selectProductOption(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductOptionInfoEntity result = new ProductOptionInfoEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" SELECT A.*, ufo_getcdnm('G088',A.CD) AS CDNM ");
        strSql.append("\n").append(" FROM UPRD06dt A ");
        strSql.append("\n").append(" WHERE 1=1 ");
        strSql.append("\n").append("     AND A.PRDTCD = ? ");
        strSql.append("\n").append("     AND A.SEQ = ? ");
        strSql.append("\n").append("     AND A.CD = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("seq"));
                pstmt.setString(index++, info.getString("cd"));
                rs = pstmt.executeQuery();
                result = (ProductOptionInfoEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.ProductOptionInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_OPTION_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateProductOption(UFORequest info) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  UPDATE UPRD06DT /* PRODUCT_OPTION_INFO_UPDATE */ ");
        strSql.append("\n").append("  SET ");
        strSql.append("\n").append("     FnlModDate = SYSDATE ");
        if (info.isExist("relPrdtCd")) {
            strSql.append("\n").append("     ,RelPrdtCd = ? ");
        }
        if (info.isExist("optNm1")) {
            strSql.append("\n").append("     ,OptNm1 = ? ");
        }
        if (info.isExist("optNm2")) {
            strSql.append("\n").append("     ,OptNm2 = ? ");
        }
        if (info.isExist("selPrc")) {
            strSql.append("\n").append("     ,SelPrc = ? ");
        }
        if (info.isExist("purPrc")) {
            strSql.append("\n").append("     ,PurPrc = ? ");
        }
        if (info.isExist("srcPlace")) {
            strSql.append("\n").append("     ,SrcPlace = ? ");
        }
        if (info.isExist("optLImg")) {
            strSql.append("\n").append("     ,OptLImg = ? ");
        }
        if (info.isExist("optSImg")) {
            strSql.append("\n").append("     ,OptSImg = ? ");
        }
        if (info.isExist("note1")) {
            strSql.append("\n").append("     ,Note1 =? ");
        }
        if (info.isExist("note2")) {
            strSql.append("\n").append("     ,Note2 =? ");
        }
        if (info.isExist("orderBy")) {
            strSql.append("\n").append("     ,OrderBy = ? ");
        }
        strSql.append("\n").append("     ,ModId = ? ");
        if (info.isExist("dispFl")) {
            strSql.append("\n").append("     ,DispFl = ? ");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append("     ,UseFl =? ");
        }
        strSql.append("\n").append("  WHERE 1=1 ");
        strSql.append("\n").append("  AND Seq = ? ");
        strSql.append("\n").append("  AND PrdtCd = ? ");
        strSql.append("\n").append("  AND Cd = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("relPrdtCd")) {
                    pstmt.setString(index++, info.getString("relPrdtCd"));
                }
                if (info.isExist("optNm1")) {
                    pstmt.setString(index++, info.getString("optNm1"));
                }
                if (info.isExist("optNm2")) {
                    pstmt.setString(index++, info.getString("optNm2"));
                }
                if (info.isExist("selPrc")) {
                    pstmt.setLong(index++, info.getLong("selPrc"));
                }
                if (info.isExist("purPrc")) {
                    pstmt.setString(index++, info.getString("purPrc"));
                }
                if (info.isExist("srcPlace")) {
                    pstmt.setString(index++, info.getString("srcPlace"));
                }
                if (info.isExist("optLImg")) {
                    pstmt.setString(index++, info.getString("optLImg"));
                }
                if (info.isExist("optSImg")) {
                    pstmt.setString(index++, info.getString("optSImg"));
                }
                if (info.isExist("note1")) {
                    pstmt.setString(index++, info.getString("note1"));
                }
                if (info.isExist("note2")) {
                    pstmt.setString(index++, info.getString("note2"));
                }
                if (info.isExist("orderBy")) {
                    pstmt.setString(index++, info.getString("orderBy"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                if (info.isExist("dispFl")) {
                    pstmt.setString(index++, info.getString("dispFl"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                pstmt.setLong(index++, info.getLong("seq"));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("cd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_OPTION_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteProductOption(UFORequest info) throws Exception {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("         DELETE /* PRODUCT_OPTION_INFO_DELETE */ FROM UPRD06DT  ");
        strSql.append("\n").append("                WHERE 1 = 1  ");
        if (!info.isSpace("prdtCd")) {
            strSql.append("\n").append("               AND PrdtCd = ? ");
        }
        if (!info.isSpace("seq")) {
            strSql.append("\n").append("               AND Seq = ? ");
        }
        if (!info.isSpace("cd")) {
            strSql.append("\n").append("               AND Cd = ? ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (!info.isSpace("prdtCd")) {
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                if (!info.isSpace("seq")) {
                    pstmt.setLong(index++, info.getLong("seq"));
                }
                if (!info.isSpace("cd")) {
                    pstmt.setString(index++, info.getString("cd"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_OPTION_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector selectExceptOnLineShopList(UFORequest model) throws UFOException {
        PreparedStatement pstmst = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer sql = new StringBuffer();
        sql.append("\n  SELECT TRIM(PRDTDESC) AS PRDTDESC, TRIM(NOTES2) AS NOTES2 ");
        sql.append("\n    FROM UPRD03DT         ");
        sql.append("\n   WHERE SITECD = ?       ");
        sql.append("\n     AND CD = 'ONSP'      ");
        sql.append("\n     AND DISPFL = 'Y'     ");
        sql.append("\n     AND USEFL = 'Y'      ");
        sql.append("\n   ORDER BY ORDERBY       ");
        try {
            try {
                pstmst = this.con.prepareStatement(sql.toString(), 1004, 1007);
                int idx = 1;
                if (!model.isSpace("siteCd")) {
                    pstmst.setString(idx++, model.getString("siteCd"));
                }
                rs = pstmst.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductAddInfoEntity");
            }
            catch (SQLException e) {
                throw new UFOException(super.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_SITE_RELINFO_ONLINESHOP_LIST ", e);
            }
            catch (Exception e) {
                throw new UFOException(super.getClass().getName(), "ETC-0100", "", e);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmst);
            throw throwable;
        }
        this.closePreparedStatement(pstmst);
        return result;
    }
}

