/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.product;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOProductFromErpMgmtDAO
extends UFOBaseDAO {
    public UFOProductFromErpMgmtDAO(Connection con) {
        super(con);
    }

    public Vector selectProductFromErpListPaging(UFORequest info) throws UFOException {
        Vector result = new Vector();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT /*PRODUCT_LIST_ERP_SELECT_LIST*/ ");
        strSql.append("\n").append("         A.PrdCd, ");
        strSql.append("\n").append("         A.BrandNm, ");
        strSql.append("\n").append("         A.PrdNm, ");
        strSql.append("\n").append("         A.PrdEngNm, ");
        strSql.append("\n").append("         A.PrdStatCd, ");
        strSql.append("\n").append("         A.PrdVol, ");
        strSql.append("\n").append("         A.VolUnit, ");
        strSql.append("\n").append("         B.StdUnitPrc, ");
        strSql.append("\n").append("         B.SuppPrc, ");
        strSql.append("\n").append("         A.RegDate, ");
        strSql.append("\n").append("         A.UpdDate, ");
        strSql.append("\n").append("         A.ORIGIN ");
        strSql.append("\n").append("  FROM WEBDBA.WPRD11MT A, WEBDBA.WPRD12MT B ");
        strSql.append("\n").append("  WHERE  A.PrdCd = B.PrdCd ");
        strSql.append("\n").append("     AND A.PrdGradeCd IS NOT NULL ");
        strSql.append("\n").append("     AND B.TRNSCTPRCLISTTP = 'Z' ");
        if (info.isExist("prdCd") && !info.isSpace("prdCd")) {
            strSql.append("\n").append("     AND A.PRDCD LIKE ? || '%' ");
        }
        if (info.isExist("prdNm") && !info.isSpace("prdNm")) {
            strSql.append("\n").append("     AND A.PrdNm LIKE '%'|| ? ||'%' ");
        }
        try {
            try {
                int pageSize = 20;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                int pageNo = 1;
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                if (info.isExist("prdCd") && !info.isSpace("prdCd")) {
                    pstmt.setString(index++, info.getString("prdCd"));
                }
                if (info.isExist("prdNm") && !info.isSpace("prdNm")) {
                    pstmt.setString(index++, info.getString("prdNm"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.ProductFromErpEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_LIST_ERP_SELECT_LIST", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int selectProductFromErpListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT /*PRODUCT_LIST_ERP_SELECT_LIST_COUNT*/ ");
        strSql.append("\n").append("         COUNT(1) CNT ");
        strSql.append("\n").append("  FROM WEBDBA.WPRD11MT A, WEBDBA.WPRD12MT B ");
        strSql.append("\n").append("  WHERE  A.PrdCd = B.PrdCd ");
        strSql.append("\n").append("     AND A.PrdGradeCd IS NOT NULL ");
        strSql.append("\n").append("     AND B.TRNSCTPRCLISTTP = 'Z' ");
        if (info.isExist("prdCd") && !info.isSpace("prdCd")) {
            strSql.append("\n").append("     AND A.PRDCD LIKE ? || '%' ");
        }
        if (info.isExist("prdNm") && !info.isSpace("prdNm")) {
            strSql.append("\n").append("     AND A.PrdNm LIKE '%'|| ? ||'%' ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                if (info.isExist("prdCd") && !info.isSpace("prdCd")) {
                    pstmt.setString(index++, info.getString("prdCd"));
                }
                if (info.isExist("prdNm") && !info.isSpace("prdNm")) {
                    pstmt.setString(index++, info.getString("prdNm"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_LIST_ERP_SELECT_LIST_COUNT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]PRODUCT_LIST_ERP_SELECT_LIST_COUNT", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

