/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.product;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.product.entity.BrandTabDtlEntity;
import com.ufo.product.entity.BrandTabMstEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOBrandTabMgmtDAO
extends UFOBaseDAO {
    public UFOBrandTabMgmtDAO(Connection con) {
        super(con);
    }

    public String getNewTabCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT /* NEW_TAB_CODE */ ");
        strSql.append("\n").append("      ? || 't' || ? ||  LPAD(NVL(MAX(SUBSTR(TABCD,-3)),0) + 1, 3, '0') ");
        strSql.append("\n").append("  FROM UPRD07DT ");
        strSql.append("\n").append("  WHERE TabCd LIKE (  ? ||'t'|| ? ||'%' )   ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("brandCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]NEW_TAB_CODE SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertBrandTabGroupInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  INSERT INTO /* BRAND_TAB_GROUP_INF0_INSERT */ UPRD07MT( ");
        strSql.append("\n").append("      BRANDCD, ");
        strSql.append("\n").append("      TABGROUPSEQ, ");
        strSql.append("\n").append("      NOTES, ");
        strSql.append("\n").append("      POSTSCPTDSPFL, ");
        strSql.append("\n").append("      FSTREGDATE, ");
        strSql.append("\n").append("      REGID, ");
        strSql.append("\n").append("      FNLMODDATE, ");
        strSql.append("\n").append("      MODID, ");
        strSql.append("\n").append("      SITECD, ");
        strSql.append("\n").append("      CDTP ");
        strSql.append("\n").append("  ) VALUES (?, (SELECT NVL(MAX(TABGROUPSEQ),0)+1 AS TABGROUPSEQ FROM UPRD07MT), ?, ?, SYSDATE, ?, SYSDATE, ?,?,?) ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, info.getString("postScptDspFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cdTp"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO] BRAND_TAB_GROUP_INF0_INSERT ", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateBrandTabGroupInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" UPDATE UPRD07MT /* BRAND_TAB_INFO_UPDATE */ ");
        strSql.append("\n").append(" SET    Notes = ?, ");
        strSql.append("\n").append("        PostScptDspFl = ?, ");
        strSql.append("\n").append("        FnlModDate = SYSDATE, ");
        strSql.append("\n").append("        ModId = ?, ");
        strSql.append("\n").append("        cdTp = ? ");
        strSql.append("\n").append(" WHERE  BrandCd = ? ");
        strSql.append("\n").append("        AND TabGroupSeq = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("notes"));
                pstmt.setString(index++, info.getString("postScptDspFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("cdTp"));
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("tabGroupSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO] BRAND_TAB_GROUP_INFO_UPDATE ", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public BrandTabMstEntity selectBrandTabGroupInfo(UFORequest info) throws UFOException {
        BrandTabMstEntity result = new BrandTabMstEntity();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT A.*, B.BrandNm, B.BrandLevel ");
        strSql.append("\n").append("  FROM UPRD07MT A, UPRD01MT B ");
        strSql.append("\n").append("  WHERE B.BrandCd = A.BrandCd ");
        strSql.append("\n").append("  AND   A.BrandCd = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                rs = pstmt.executeQuery();
                if (rs != null) {
                    result = (BrandTabMstEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.BrandTabMstEntity");
                }
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_TAB_GROUP_INF0_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public BrandTabMstEntity selectProductLineTabGroupInfo(UFORequest info) throws UFOException {
        BrandTabMstEntity result = new BrandTabMstEntity();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT A.*, B.LineNm AS BrandNm , B.LineLev AS BrandLevel ");
        strSql.append("\n").append("  FROM UPRD07MT A, UPRD04MT B ");
        strSql.append("\n").append("  WHERE B.LineCd = A.BrandCd ");
        strSql.append("\n").append("  AND   A.BrandCd = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                rs = pstmt.executeQuery();
                if (rs != null) {
                    result = (BrandTabMstEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.BrandTabMstEntity");
                }
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]PRODUCT_LINE_TAB_GROUP_INFO_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public BrandTabDtlEntity selectBrandTabCodeInfo(UFORequest info) throws UFOException {
        BrandTabDtlEntity result = new BrandTabDtlEntity();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" SELECT *  /* BRAND_TAB_CODE_INF0_SELECT */ ");
        strSql.append("\n").append(" FROM UPRD07DT ");
        strSql.append("\n").append(" WHERE BrandCd = ?  ");
        strSql.append("\n").append(" AND TabCd = ?  ");
        strSql.append("\n").append(" AND TabGroupSeq = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("tabCd"));
                pstmt.setString(index++, info.getString("tabGroupSeq"));
                rs = pstmt.executeQuery();
                if (rs != null) {
                    result = (BrandTabDtlEntity)DAOHelper.makeEntity(rs, "com.ufo.product.entity.BrandTabDtlEntity");
                }
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_TAB_CODE_INF0_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector selectBrandTabDtlList(UFORequest info) throws UFOException {
        Vector result = new Vector();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("  SELECT ");
        strSql.append("\n").append("       B.SiteCd, ");
        strSql.append("\n").append("       B.BrandCd, ");
        strSql.append("\n").append("       B.TabCd, ");
        strSql.append("\n").append("       B.TabGroupSeq, ");
        strSql.append("\n").append("       B.TabNm, ");
        strSql.append("\n").append("       B.OrderBy, ");
        strSql.append("\n").append("       B.UseFl, ");
        strSql.append("\n").append("       B.PostScptFl, ");
        strSql.append("\n").append("       B.Url, ");
        strSql.append("\n").append("       B.FstRegDate, ");
        strSql.append("\n").append("       B.RegId, ");
        strSql.append("\n").append("       B.FnlModDate, ");
        strSql.append("\n").append("       B.ModId ");
        strSql.append("\n").append("  FROM UPRD07MT A, ");
        strSql.append("\n").append("  \t   UPRD07DT B ");
        strSql.append("\n").append("  WHERE A.BrandCd = B.BrandCd ");
        strSql.append("\n").append("        AND A.TabGroupSeq = B.TabGroupSeq ");
        strSql.append("\n").append("        AND B.BrandCd = ? ");
        strSql.append("\n").append("        AND B.TabGroupSeq = ? ");
        strSql.append("\n").append("  ORDER BY  B.OrderBy ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("tabGroupSeq"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.product.entity.BrandTabDtlEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_TAB_GROUP_INF0_SELECT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertBrandTabDetailInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        String newTabCd = this.getNewTabCd(info);
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" INSERT /* BRAND_TAB_DETAIL_INFO_INSERT */  INTO  UPRD07DT ");
        strSql.append("\n").append(" ( ");
        strSql.append("\n").append("          BrandCd, ");
        strSql.append("\n").append("          TabCd, ");
        strSql.append("\n").append("          TabGroupSeq, ");
        strSql.append("\n").append("          TabNm, ");
        strSql.append("\n").append("          OrderBy, ");
        strSql.append("\n").append("          UseFl, ");
        strSql.append("\n").append("          PostScptFl, ");
        strSql.append("\n").append("          Url, ");
        strSql.append("\n").append("          FstRegDate, ");
        strSql.append("\n").append("          RegId, ");
        strSql.append("\n").append("          FnlModDate, ");
        strSql.append("\n").append("          ModId, ");
        strSql.append("\n").append("          SiteCd ");
        strSql.append("\n").append(" ) ");
        strSql.append("\n").append(" VALUES ");
        strSql.append("\n").append(" ( ?,?,?,?,?,?,?,?,SYSDATE,?,SYSDATE,?,?) ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, newTabCd);
                pstmt.setLong(index++, info.getLong("tabGroupSeq"));
                pstmt.setString(index++, info.getString("tabNm"));
                pstmt.setInt(index++, 0);
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, info.getString("postScptFl"));
                pstmt.setString(index++, info.getString("url"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_TAB_DETAIL_INFO_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteBrandTabDetailInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" DELETE UPRD07DT /* BRAND_TAB_DETAIL_INFO_DELETE */ ");
        strSql.append("\n").append(" where BRANDCD = ? AND TabCd = ? And TABGROUPSEQ = ?  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("tabCd"));
                pstmt.setString(index++, info.getString("tabGroupSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_TAB_DETAIL_INFO_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateBrandTabDetailInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" UPDATE UPRD07DT /* BRAND_TAB_DETAIL_INFO_UPDATE */ ");
        strSql.append("\n").append(" SET    ");
        if (info.isExist("tabNm")) {
            strSql.append("\n").append("TabNm = ?, ");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append("        UseFl = ?, ");
        }
        if (info.isExist("postScptFl")) {
            strSql.append("\n").append("        PostScptFl = ?, ");
        }
        if (info.isExist("url")) {
            strSql.append("\n").append("        Url = ?, ");
        }
        if (info.isExist("orderBy")) {
            strSql.append("\n").append("        OrderBy = ?, ");
        }
        strSql.append("\n").append("        FnlModDate = SYSDATE, ");
        strSql.append("\n").append("        ModId = ? ");
        strSql.append("\n").append(" WHERE  1=1 ");
        strSql.append("\n").append("        AND BrandCd = ? ");
        strSql.append("\n").append("        AND TabCd = ? ");
        strSql.append("\n").append("        AND TabGroupSeq = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("tabNm")) {
                    pstmt.setString(index++, info.getString("tabNm"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("postScptFl"));
                }
                if (info.isExist("url")) {
                    pstmt.setString(index++, info.getString("url"));
                }
                if (info.isExist("orderBy")) {
                    pstmt.setString(index++, info.getString("orderBy"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("brandCd"));
                pstmt.setString(index++, info.getString("tabCd"));
                pstmt.setString(index++, info.getString("tabGroupSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]BRAND_TAB_DETAIL_INFO_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

