/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.product;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class OLDProductMgmtDAO
extends UFOBaseDAO {
    private String[] tblNm_CT = new String[]{"", "WPRD03CT", "WPRD05CT", "WPRD06CT", "WPRD07CT", "WPRD10CT"};
    private String[] tblNm_MT = new String[]{"", "WPRD03MT", "WPRD05MT", "WPRD06MT", "WPRD07MT", "WPRD10MT"};
    private String[] prdtPath = new String[]{"", "/apbrand/web/pacific/upload_file/product/", "/apbrand/web/pacific/upload_file/product_eng/", "", "", ""};
    private String[] ufoPath = new String[]{"", "/apbrand/web/ufo/upload_files/product/KO/", "/apbrand/web/ufo/upload_files/product/EN/", "", "", ""};

    public OLDProductMgmtDAO(Connection con) {
        super(con);
    }

    public String getMappingCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t/* SEARCH_MAPPING_INFO */\t\t\t\t");
        strSql.append("\n").append(" \t\tSELECT OrgCd FROM UPRD01CT\t\t\t");
        strSql.append("\n").append("\t\t\t\tWHERE CdTp = ? AND NewCd = ?\t\t");
        strSql.append("\n").append("\t\t\t\tAND UseFl = 'Y'\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (CmUtil.nullTrim(info.getString("cdTp")).equals("B")) {
                    pstmt.setString(index++, info.getString("cdTp"));
                    pstmt.setString(index++, info.getString("brandCd"));
                } else {
                    pstmt.setString(index++, info.getString("cdTp"));
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]SEARCH_MAPPING_INFO", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertMappingCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t/* INSERT_MAPPING_INFO */\t\t\t\t");
        strSql.append("\n").append(" \t\tINSERT INTO UPRD01CT (\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\tCdTp, NewCd, OrgCd, UseFl\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t?, ?, ?, 'Y'\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (CmUtil.nullTrim(info.getString("cdTp")).equals("B")) {
                    pstmt.setString(index++, info.getString("cdTp"));
                    pstmt.setString(index++, info.getString("brandCd"));
                    pstmt.setString(index++, info.getString("wBrandCd"));
                } else {
                    pstmt.setString(index++, info.getString("cdTp"));
                    pstmt.setString(index++, info.getString("prdtCd"));
                    pstmt.setString(index++, info.getString("wPrdtCd"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]INSERT_MAPPING_INFO", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteMappingCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t/* DELETE_MAPPING_INFO */\t\t\t");
        strSql.append("\n").append(" \t\t DELETE FROM UPRD01CT\t\t\t\t");
        strSql.append("\n").append("\t\t\t\tWHERE CdTp = ? AND NewCd = ?\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (CmUtil.nullTrim(info.getString("cdTp")).equals("B")) {
                    pstmt.setString(index++, info.getString("cdTp"));
                    pstmt.setString(index++, info.getString("brandCd"));
                } else {
                    pstmt.setString(index++, info.getString("cdTp"));
                    pstmt.setString(index++, info.getString("prdtCd"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]DELETE_MAPPING_INFO", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean availableBrandCd(String brandCd) throws UFOException {
        ResultSet rs;
        PreparedStatement pstmt;
        block5: {
            pstmt = null;
            rs = null;
            Vector result = new Vector();
            int tblIdx = Integer.parseInt(brandCd.substring(0, 1));
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append("\t\t\t\t/* AVAIL_BRAND_CD */\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t SELECT \t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\tBRAND_CD\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t  FROM " + this.tblNm_CT[tblIdx]);
            strSql.append("\n").append("\t\t\t\tWHERE BRAND_CD = SUBSTR(?,2,5)\t\t");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, brandCd);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
            }
            catch (SQLException sqlEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]AVAIL_BRAND_CD", sqlEx);
                    catch (Exception etcEx) {
                        throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                    }
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            return false;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return true;
    }

    public int insertBrandInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        int tblIdx = Integer.parseInt(CmUtil.nullTrim(info.getString("brandCd")).substring(0, 1));
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t /* OLD_BRAND_INSERT */ \t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t INSERT INTO " + this.tblNm_CT[tblIdx] + " (\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tBRAND_CD\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BRAND_NAME\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, P_BRAND_CD\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, APPLY_FL\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, REG_DTE, REG_ID\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("wBrandCd"));
                pstmt.setString(index++, info.getString("brandNm"));
                pstmt.setString(index++, info.getString("wUppBrandCd"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]OLD_BRAND_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateBrandInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        int tblIdx = Integer.parseInt(CmUtil.nullTrim(info.getString("brandCd")).substring(0, 1));
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t /* OLD_BRAND_UPDATE */\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t UPDATE " + this.tblNm_CT[tblIdx] + " SET\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\tBRAND_CD\t\t\t= BRAND_CD\t");
        if (info.isExist("brandNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, BRAND_NAME\t= ?\t\t\t\t\t");
        }
        if (info.isExist("useFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, APPLY_FL\t\t= ?\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\tWHERE BRAND_CD = ? \t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("brandNm")) {
                    pstmt.setString(index++, info.getString("brandNm"));
                }
                if (info.isExist("useFl")) {
                    pstmt.setString(index++, info.getString("useFl"));
                }
                pstmt.setString(index++, info.getString("wBrandCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]OLD_BRAND_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteBrandInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        int tblIdx = Integer.parseInt(CmUtil.nullTrim(info.getString("brandCd")).substring(0, 1));
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t /* OLD_BRAND_DELETE */\t\t\t\t\t");
        strSql.append("\n").append(" \t\t DELETE FROM " + this.tblNm_CT[tblIdx]);
        strSql.append("\n").append("\t\t\tWHERE BRAND_CD = ? \t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("wBrandCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]OLD_BRAND_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean availablePrdtCd(String prdtCd, int tblIdx) throws UFOException {
        ResultSet rs;
        PreparedStatement pstmt;
        block5: {
            pstmt = null;
            rs = null;
            Vector result = new Vector();
            StringBuffer strSql = new StringBuffer();
            strSql.append("\n").append(" \t\t\t /* AVAIL_PRDT_CD */\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t SELECT\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\tPRDT_CD\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t  FROM " + this.tblNm_MT[tblIdx]);
            strSql.append("\n").append("\t\t\t\tWHERE PRDT_CD = SUBSTR(?,2,8)\t\t\t");
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, prdtCd);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
            }
            catch (SQLException sqlEx) {
                try {
                    throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]AVAIL_PRDT_CD", sqlEx);
                    catch (Exception etcEx) {
                        throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
                    }
                }
                catch (Throwable throwable) {
                    this.closePreparedStatement(pstmt);
                    this.closeResultSet(rs);
                    throw throwable;
                }
            }
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            return false;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return true;
    }

    public String getNewPrdtCd(String brandCd, int tblIdx) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("\t/* NEW_PRODUCT_CODE */\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\tSELECT /* NEW_PRODUCT_CODE */\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\tNVL(MAX(PRDT_CD), ?||'000')+1 AS PRDT_CD\t\t\t");
        strSql.append("\n").append("\tFROM " + this.tblNm_MT[tblIdx]);
        strSql.append("\n").append("\tWHERE PRDT_CD LIKE ( ?||'%' )\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, brandCd);
                pstmt.setString(index++, brandCd);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]NEW_PRODUCT_CODE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPrdtInfo(UFORequest info, int tblIdx) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t INSERT /* OLD_PRODUCT_INSERT */ INTO " + this.tblNm_MT[tblIdx] + " (\t");
        strSql.append("\n").append(" \t\t\t\t\tPRDT_CD\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, BRAND_CD\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PRDT_NAME\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PRDT_NAME_ENG\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PRDT_CAPA\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PRDT_DESC\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, USAGE\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, PRDT_INFORM\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, CSTMR_AMT\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, LPICTURE\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, MPICTURE\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, SPICTURE\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, WEB_DIS_FL\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t\t\t, RMK\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, REG_DTE, REG_ID\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, CHG_DTE, CHG_ID\t\t\t\t\t\t\t\t\t\t");
        if (tblIdx == 1) {
            strSql.append("\n").append(" \t\t\t\t\t, AP_PRDT_CD\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, CSTMR_PRICE\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, REFILL_FL\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, PRODUCT_FL\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, PRODUCT_DATE\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, PROBLUM\t\t\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_1\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_2\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_3\t\t\t\t\t\t\t\t\t\t\t");
            strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_4\t\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append(" \t\t) VALUES (\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql.append("\n").append(" \t\t\t ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t, SYSDATE, ?, SYSDATE, ?\t\t\t\t\t\t\t\t\t\t");
        if (tblIdx == 1) {
            strSql.append("\n").append(" \t\t\t , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?\t\t\t\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("wPrdtCd"));
                pstmt.setString(index++, info.getString("wBrandCd"));
                pstmt.setString(index++, info.getString("prdtNm"));
                pstmt.setString(index++, info.getString("prdtNmEng"));
                pstmt.setString(index++, info.getString("prdtVol"));
                pstmt.setString(index++, info.getString("prdtDesc"));
                pstmt.setString(index++, info.getString("usage"));
                pstmt.setString(index++, info.getString("relInfo"));
                pstmt.setLong(index++, info.getLong("selPrc"));
                if (!info.isSpace("lPrdtImg")) {
                    if (!this.prdtPath[tblIdx].equals("")) {
                        pstmt.setString(index++, CmUtil.copyFile(String.valueOf(this.ufoPath[tblIdx]) + info.getString("lPrdtImg"), this.prdtPath[tblIdx], false));
                    } else {
                        pstmt.setString(index++, info.getString("lPrdtImg"));
                    }
                } else {
                    pstmt.setString(index++, "");
                }
                if (!info.isSpace("MPrdtImg")) {
                    if (!this.prdtPath[tblIdx].equals("")) {
                        pstmt.setString(index++, CmUtil.copyFile(String.valueOf(this.ufoPath[tblIdx]) + info.getString("MPrdtImg"), this.prdtPath[tblIdx], false));
                    } else {
                        pstmt.setString(index++, info.getString("MPrdtImg"));
                    }
                } else {
                    pstmt.setString(index++, "");
                }
                if (!info.isSpace("SPrdtImg")) {
                    if (!this.prdtPath[tblIdx].equals("")) {
                        pstmt.setString(index++, CmUtil.copyFile(String.valueOf(this.ufoPath[tblIdx]) + info.getString("SPrdtImg"), this.prdtPath[tblIdx], false));
                    } else {
                        pstmt.setString(index++, info.getString("SPrdtImg"));
                    }
                } else {
                    pstmt.setString(index++, "");
                }
                pstmt.setString(index++, info.getString("webDispFl"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                if (tblIdx == 1) {
                    pstmt.setString(index++, info.getString("mgtPrdtCd"));
                    pstmt.setString(index++, info.getString("purPrc"));
                    pstmt.setString(index++, info.getString("refllFl"));
                    pstmt.setString(index++, info.getString("pdtFl"));
                    pstmt.setString(index++, info.getString("fstPdtDate"));
                    pstmt.setString(index++, info.getString("prblItem"));
                    pstmt.setString(index++, info.getString("lTxtImg"));
                    pstmt.setString(index++, info.getString("mTxtImg"));
                    pstmt.setString(index++, info.getString("sTxtImg"));
                    pstmt.setString(index++, info.getString("descImg"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]OLD_PRODUCT_INSERT", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updatePrdtInfo(UFORequest info, int tblIdx) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t UPDATE /* OLD_PRODUCT_UPDATE */ " + this.tblNm_MT[tblIdx] + " SET\t");
        strSql.append("\n").append(" \t\t\t\t\tPRDT_CD\t\t\t= PRDT_CD\t\t\t\t\t");
        if (info.isExist("wBrandCd")) {
            strSql.append("\n").append(" \t\t\t\t\t, BRAND_CD\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("prdtNm")) {
            strSql.append("\n").append(" \t\t\t\t\t, PRDT_NAME\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("prdtNmEng")) {
            strSql.append("\n").append(" \t\t\t\t\t, PRDT_NAME_ENG\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("prdtVol")) {
            strSql.append("\n").append(" \t\t\t\t\t, PRDT_CAPA\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("prdtDesc")) {
            strSql.append("\n").append(" \t\t\t\t\t, PRDT_DESC\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("usage")) {
            strSql.append("\n").append(" \t\t\t\t\t, USAGE\t\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("relInfo")) {
            strSql.append("\n").append(" \t\t\t\t\t, PRDT_INFORM\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("selPrc")) {
            strSql.append("\n").append(" \t\t\t\t\t, CSTMR_AMT\t\t= ?\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("f_lPrdtImg") && info.isExist("lPrdtImg")) {
            strSql.append("\n").append(" \t\t\t\t\t, LPICTURE\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("f_mPrdtImg") && info.isExist("mPrdtImg")) {
            strSql.append("\n").append(" \t\t\t\t\t, MPICTURE\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (!info.isSpace("f_sPrdtImg") && info.isExist("sPrdtImg")) {
            strSql.append("\n").append(" \t\t\t\t\t, SPICTURE\t\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("webDispFl")) {
            strSql.append("\n").append(" \t\t\t\t\t, WEB_DIS_FL\t\t= ?\t\t\t\t\t\t\t");
        }
        if (info.isExist("notes1")) {
            strSql.append("\n").append(" \t\t\t\t\t, RMK\t\t\t\t\t= ?\t\t\t\t\t\t\t");
        }
        strSql.append("\n").append("\t\t\t\t\t\t, CHG_DTE\t\t\t= SYSDATE\t\t\t\t\t");
        strSql.append("\n").append("\t\t\t\t\t\t, CHG_ID\t\t\t\t= ?\t\t\t\t\t\t\t");
        if (tblIdx == 1) {
            if (info.isExist("mgtPrdtCd")) {
                strSql.append("\n").append(" \t\t\t\t\t, AP_PRDT_CD\t\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("purPrc")) {
                strSql.append("\n").append(" \t\t\t\t\t, CSTMR_PRICE\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("refllFl")) {
                strSql.append("\n").append(" \t\t\t\t\t, REFILL_FL\t\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("pdtFl")) {
                strSql.append("\n").append(" \t\t\t\t\t, PRODUCT_FL\t\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("fstPdtDate")) {
                strSql.append("\n").append(" \t\t\t\t\t, PRODUCT_DATE\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("prblItem")) {
                strSql.append("\n").append(" \t\t\t\t\t, PROBLUM\t\t\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("lTxtImg")) {
                strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_1\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("mTxtImg")) {
                strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_2\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("sTxtImg")) {
                strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_3\t= ?\t\t\t\t\t\t\t");
            }
            if (info.isExist("descImg")) {
                strSql.append("\n").append(" \t\t\t\t\t, ATTACH_FILE_4\t= ?\t\t\t\t\t\t\t");
            }
        }
        strSql.append("\n").append("\t\t\t\t\tWHERE PRDT_CD = ? \t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                if (info.isExist("wBrandCd")) {
                    pstmt.setString(index++, info.getString("wBrandCd"));
                }
                if (info.isExist("prdtNm")) {
                    pstmt.setString(index++, info.getString("prdtNm"));
                }
                if (info.isExist("prdtNmEng")) {
                    pstmt.setString(index++, info.getString("prdtNmEng"));
                }
                if (info.isExist("prdtVol")) {
                    pstmt.setString(index++, info.getString("prdtVol"));
                }
                if (info.isExist("prdtDesc")) {
                    pstmt.setString(index++, info.getString("prdtDesc"));
                }
                if (info.isExist("usage")) {
                    pstmt.setString(index++, info.getString("usage"));
                }
                if (info.isExist("relInfo")) {
                    pstmt.setString(index++, info.getString("relInfo"));
                }
                if (info.isExist("selPrc")) {
                    pstmt.setLong(index++, info.getLong("selPrc"));
                }
                if (!info.isSpace("f_lPrdtImg") && info.isExist("lPrdtImg")) {
                    if (!this.prdtPath[tblIdx].equals("")) {
                        pstmt.setString(index++, CmUtil.copyFile(String.valueOf(this.ufoPath[tblIdx]) + info.getString("lPrdtImg"), this.prdtPath[tblIdx], false));
                    } else {
                        pstmt.setString(index++, info.getString("lPrdtImg"));
                    }
                }
                if (!info.isSpace("f_mPrdtImg") && info.isExist("mPrdtImg")) {
                    if (!this.prdtPath[tblIdx].equals("")) {
                        pstmt.setString(index++, CmUtil.copyFile(String.valueOf(this.ufoPath[tblIdx]) + info.getString("mPrdtImg"), this.prdtPath[tblIdx], false));
                    } else {
                        pstmt.setString(index++, info.getString("mPrdtImg"));
                    }
                }
                if (!info.isSpace("f_sPrdtImg") && info.isExist("sPrdtImg")) {
                    if (!this.prdtPath[tblIdx].equals("")) {
                        pstmt.setString(index++, CmUtil.copyFile(String.valueOf(this.ufoPath[tblIdx]) + info.getString("sPrdtImg"), this.prdtPath[tblIdx], false));
                    } else {
                        pstmt.setString(index++, info.getString("sPrdtImg"));
                    }
                }
                if (info.isExist("webDispFl")) {
                    pstmt.setString(index++, info.getString("webDispFl"));
                }
                if (info.isExist("notes1")) {
                    pstmt.setString(index++, info.getString("notes1"));
                }
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                if (tblIdx == 1) {
                    if (info.isExist("mgtPrdtCd")) {
                        pstmt.setString(index++, info.getString("mgtPrdtCd"));
                    }
                    if (info.isExist("purPrc")) {
                        pstmt.setString(index++, info.getString("purPrc"));
                    }
                    if (info.isExist("refllFl")) {
                        pstmt.setString(index++, info.getString("refllFl"));
                    }
                    if (info.isExist("pdtFl")) {
                        pstmt.setString(index++, info.getString("pdtFl"));
                    }
                    if (info.isExist("fstPdtDate")) {
                        pstmt.setString(index++, info.getString("fstPdtDate"));
                    }
                    if (info.isExist("prblItem")) {
                        pstmt.setString(index++, info.getString("prblItem"));
                    }
                    if (info.isExist("lTxtImg")) {
                        pstmt.setString(index++, info.getString("lTxtImg"));
                    }
                    if (info.isExist("mTxtImg")) {
                        pstmt.setString(index++, info.getString("mTxtImg"));
                    }
                    if (info.isExist("sTxtImg")) {
                        pstmt.setString(index++, info.getString("sTxtImg"));
                    }
                    if (info.isExist("descImg")) {
                        pstmt.setString(index++, info.getString("descImg"));
                    }
                }
                pstmt.setString(index++, info.getString("wPrdtCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]OLD_PRODUCT_UPDATE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deletePrdtInfo(UFORequest info, int tblIdx) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        PreparedStatement pstmt0 = null;
        ResultSet rs0 = null;
        StringBuffer strSql0 = new StringBuffer();
        strSql0.append("\n").append(" \t\t SELECT  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql0.append("\n").append(" \t\t\t\t\tPRDT_CD\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql0.append("\n").append(" \t\t\t\t\t, LPICTURE\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql0.append("\n").append(" \t\t\t\t\t, MPICTURE\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql0.append("\n").append(" \t\t\t\t\t, SPICTURE\t\t\t\t\t\t\t\t\t\t\t\t");
        strSql0.append("\n").append(" \t\t\tFROM " + this.tblNm_MT[tblIdx]);
        strSql0.append("\n").append("\t\t\tWHERE PRDT_CD = ? \t\t\t\t\t\t\t\t\t\t\t");
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append(" \t\t DELETE /* OLD_PRODUCT_DELETE */ FROM " + this.tblNm_MT[tblIdx]);
        strSql.append("\n").append("\t\t\tWHERE PRDT_CD = ? \t\t\t\t\t\t\t\t\t\t\t");
        try {
            try {
                pstmt0 = this.con.prepareStatement(strSql0.toString(), 1004, 1007);
                pstmt0.setString(1, info.getString("wPrdtCd"));
                rs0 = pstmt0.executeQuery();
                if (rs0.next()) {
                    CmUtil.deleteFile(String.valueOf(this.prdtPath[tblIdx]) + rs0.getString("LPICTURE"));
                    CmUtil.deleteFile(String.valueOf(this.prdtPath[tblIdx]) + rs0.getString("MPICTURE"));
                    CmUtil.deleteFile(String.valueOf(this.prdtPath[tblIdx]) + rs0.getString("SPICTURE"));
                }
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("wPrdtCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]OLD_PRODUCT_DELETE", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt0);
            this.closeResultSet(rs0);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt0);
        this.closeResultSet(rs0);
        return result;
    }
}

