/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.ppg.template;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.ppg.entity.TabTemplateEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;

public class UFOTabTemplateMngDAO
extends UFOBaseDAO {
    public UFOTabTemplateMngDAO(Connection con) {
        super(con);
    }

    public int getNewSeq(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        String column = info.getString("column");
        String tableNm = info.getString("tableNm");
        StringBuffer strSql = new StringBuffer();
        strSql.append("/* \ufffd\ufffd\ufffd\u03bf\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\u0223\ufffd\ufffd \ufffd\ufffd\u022f\ufffd\u0474\ufffd. */");
        strSql.append("\n").append("    SELECT NVL(MAX(" + column + "),0)+1 AS SEQ FROM " + tableNm);
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getNewSeq", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertTabTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT /* TAB_TEMPLATES_INSERT */ INTO UPPG03DT( ");
        strSql.append("\n").append("    SITECD,                                     ");
        strSql.append("\n").append("    TABTEMPSEQ,                                     ");
        strSql.append("\n").append("    FILESAVEPATH,                                       ");
        strSql.append("\n").append("    TEMPCNT,                                        ");
        strSql.append("\n").append("    ICONIMGSEQ,                                     ");
        strSql.append("\n").append("    REGID,                                      ");
        strSql.append("\n").append("    MODID,                                      ");
        strSql.append("\n").append("    FSTREGDATE,                                     ");
        strSql.append("\n").append("    FNLMODDATE,                                      ");
        strSql.append("\n").append("    TEMPDESC ");
        strSql.append("\n").append(") VALUES(?, ?, ?, EMPTY_CLOB(), ?, ?, ?, SYSDATE, SYSDATE,? ) ");
        StringBuffer clobSql = new StringBuffer();
        clobSql.append("\n").append("        SELECT /* TAB_TEMPLATES_INSERT_CONTENTS */    ");
        clobSql.append("\n").append("               TEMPCNT FROM UPPG03DT                  ");
        clobSql.append("\n").append("           WHERE TABTEMPSEQ  = ?                      ");
        clobSql.append("\n").append("          FOR UPDATE                                  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("tabTempSeq"));
                pstmt.setString(index++, info.getString("fileSavePath"));
                pstmt.setString(index++, info.getString("attchSeq"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("tempDesc"));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(clobSql.toString());
                index = 1;
                pstmt2.setString(index++, info.getString("tabTempSeq"));
                rs = pstmt2.executeQuery();
                String[] arrVal = new String[]{info.getString("tempCnt")};
                DAOHelper.putClobData(rs, arrVal);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertTabTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int insertTabTemplateIcon(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT /* TEMPLATE_ICON_INSERT */ INTO UPPG02FT (           ");
        strSql.append("\n").append("        ATTCHSEQ,                                           ");
        strSql.append("\n").append("        FILEEXT,                                            ");
        strSql.append("\n").append("        FILESIZE,                                           ");
        strSql.append("\n").append("        FILEPATH,                                           ");
        strSql.append("\n").append("        FILENM,                                             ");
        strSql.append("\n").append("        FSTREGDATE,                                         ");
        strSql.append("\n").append("        REGID                                              ");
        strSql.append("\n").append(") VALUES (?, ?, ?, ?, ?, SYSDATE, ?)              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                Map iconInfo = (Map)info.get("file_icon_info");
                pstmt.setInt(index++, info.getInt("attchSeq"));
                pstmt.setString(index++, (String)iconInfo.get("fileExt"));
                pstmt.setInt(index++, Integer.parseInt((String)iconInfo.get("fileSize")));
                pstmt.setString(index++, (String)iconInfo.get("filePath"));
                pstmt.setString(index++, (String)iconInfo.get("fileNm"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPPGTemplateIcon", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchTemplateList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT D.*, F.FILENM  /* TEB_TEMPLATE_SEARCH */ ");
        strSql.append("\n").append("FROM UPPG03DT D INNER JOIN UPPG02FT F      ");
        strSql.append("\n").append("ON D.ICONIMGSEQ = F.ATTCHSEQ      ");
        strSql.append("\n").append("WHERE D.SITECD = ?                  ");
        strSql.append("\n").append("ORDER BY D.TABTEMPSEQ DESC      ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.TabTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchTemplateList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchTemplateList", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public TabTemplateEntity searchTemplateInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        TabTemplateEntity result = new TabTemplateEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT D.*, F.FILENM, F.FILEPATH  /* TEB_TEMPLATE_SEARCH */ ");
        strSql.append("\n").append("FROM UPPG03DT D INNER JOIN UPPG02FT F      ");
        strSql.append("\n").append("ON D.ICONIMGSEQ = F.ATTCHSEQ      ");
        strSql.append("\n").append("WHERE TABTEMPSEQ = ?      ");
        strSql.append("\n").append("AND D.SITECD = ?                  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("tabTempSeq"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = (TabTemplateEntity)DAOHelper.makeEntity(rs, "com.ufo.ppg.entity.TabTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchTemplateInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchTemplateInfo", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchBuilderTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *                        ");
        strSql.append("\n").append("FROM UPPG03MT M INNER JOIN UPPG03DT D    ");
        strSql.append("\n").append("ON M.TABTEMPSEQ = D.TABTEMPSEQ    ");
        strSql.append("\n").append("WHERE M.PPGCD = ? ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("ppgCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.TabTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchBuilderTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchBuilderTemplate", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updateTabTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE /* TAB_TEMPLATES_UPDATE */ UPPG03DT SET   ");
        strSql.append("\n").append("TEMPCNT = EMPTY_CLOB(),         ");
        strSql.append("\n").append("TEMPDESC = ?,                   ");
        strSql.append("\n").append("FNLMODDATE = SYSDATE,           ");
        strSql.append("\n").append("MODID = ?                       ");
        strSql.append("\n").append("WHERE TABTEMPSEQ = ?            ");
        StringBuffer clobSql = new StringBuffer();
        clobSql.append("\n").append("        SELECT /* TAB_TEMPLATES_UPDATE_CONTENTS */    ");
        clobSql.append("\n").append("               TEMPCNT FROM UPPG03DT                  ");
        clobSql.append("\n").append("           WHERE TABTEMPSEQ  = ?                      ");
        clobSql.append("\n").append("          FOR UPDATE                                  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("tempDesc"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setInt(index++, info.getInt("tabTempSeq"));
                result = pstmt.executeUpdate();
                if (result > 0 && info.isExist("tempCnt")) {
                    pstmt2 = this.con.prepareStatement(clobSql.toString());
                    index = 1;
                    pstmt2.setString(index++, info.getString("tabTempSeq"));
                    rs = pstmt2.executeQuery();
                    String[] arrVal = new String[]{info.getString("tempCnt")};
                    DAOHelper.putClobData(rs, arrVal);
                }
                pstmt.setString(index++, info.getString(""));
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int updateTabTemplateIcon(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE /* TEMPLATE_ICON_UPDATE */ UPPG02FT SET            ");
        strSql.append("\n").append("        FILEEXT = ?,                                            ");
        strSql.append("\n").append("        FILESIZE = ?,                                           ");
        strSql.append("\n").append("        FILEPATH = ?,                                           ");
        strSql.append("\n").append("        FILENM = ?                                             ");
        strSql.append("\n").append("WHERE ATTCHSEQ = ?                                           ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                Map fileInfo = (Map)info.get("file_icon_info");
                pstmt.setString(index++, (String)fileInfo.get("fileExt"));
                pstmt.setInt(index++, Integer.parseInt((String)fileInfo.get("fileSize")));
                pstmt.setString(index++, (String)fileInfo.get("filePath"));
                pstmt.setString(index++, (String)fileInfo.get("fileNm"));
                pstmt.setString(index++, info.getString("iconImgSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updatePPGTemplateIcon", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE FROM /* TAB_TEMPLATES_DELETE */ UPPG03DT   ");
        strSql.append("\n").append("WHERE TABTEMPSEQ = ?  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setInt(index++, info.getInt("tabTempSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deleteTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deleteTabTemplateIcon(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE FROM /* TAB_TEMPLATES_DELETE */ UPPG02FT   ");
        strSql.append("\n").append("WHERE ATTCHSEQ = ?  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setInt(index++, info.getInt("iconImgSeq"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deleteTabTemplateIcon", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public TabTemplateEntity existTabTemplate(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        TabTemplateEntity result = new TabTemplateEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *                            ");
        strSql.append("\n").append("    FROM UPPG03MT                   ");
        strSql.append("\n").append("    WHERE TABTEMPSEQ = ?            ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("tabTempSeq"));
                rs = pstmt.executeQuery();
                result = (TabTemplateEntity)DAOHelper.makeEntity(rs, "com.ufo.ppg.entity.TabTemplateEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]existTabTemplate", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

