/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.ppg.builder;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.ppg.entity.PPGBuilderEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOPPGBuilderMngDAO
extends UFOBaseDAO {
    public UFOPPGBuilderMngDAO(Connection con) {
        super(con);
    }

    public Vector searchBuilderListPaging(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT  PPGCd,              ");
        strSql.append("\n").append("    M.SITECD,                                     ");
        strSql.append("\n").append("    M.CDTP,                                       ");
        strSql.append("\n").append("    M.BRANDLINECD,                                ");
        strSql.append("\n").append("    M.BRANDNM,                                    ");
        strSql.append("\n").append("    M.PPGTEMPSEQ,                                 ");
        strSql.append("\n").append("    M.LANGCD,                                     ");
        strSql.append("\n").append("    M.PPGDESC,                                    ");
        strSql.append("\n").append("    M.PPGCNT,                                     ");
        strSql.append("\n").append("    M.FILECREATEPATH,                             ");
        strSql.append("\n").append("    M.EXPOREFL,                                   ");
        strSql.append("\n").append("    M.REGID,                                      ");
        strSql.append("\n").append("    M.MODID,                                      ");
        strSql.append("\n").append("    TO_CHAR(M.FSTREGDATE, 'YYYY/MM/DD') FSTREGDATE,");
        strSql.append("\n").append("    TO_CHAR(M.FNLMODDATE, 'YYYY/MM/DD') FNLMODDATE,");
        strSql.append("\n").append("    T.PPGTPCD,                                  ");
        strSql.append("\n").append("    T.PPGCLCD                                  ");
        strSql.append("\n").append("FROM UPPG01MT M INNER JOIN UPPG02MT T             ");
        strSql.append("\n").append("ON M.PPGTEMPSEQ = T.PPGTEMPSEQ              ");
        strSql.append("\n").append("WHERE 1 = 1                 ");
        strSql.append("\n").append("AND M.siteCd = ?         ");
        strSql.append("\n").append("AND T.siteCd = ?         ");
        if (!info.isSpace("langCd")) {
            strSql.append("\n").append("               AND M.langCd = ?         ");
        }
        if (!info.isSpace("cdTp")) {
            strSql.append("\n").append("               AND M.CDTP = ?         ");
        }
        if (!info.isSpace("brandLineCd")) {
            strSql.append("\n").append("               AND M.brandLineCd = ?         ");
        }
        if (!info.isSpace("ppgTpCd")) {
            strSql.append("\n").append("               AND T.ppgTpCd = ?         ");
        }
        if (!info.isSpace("searchKey")) {
            strSql.append("\n").append("        AND " + info.getString("searchType") + " LIKE '%' || ? || '%'         ");
        }
        strSql.append("\n").append("    ORDER BY M.PPGCD DESC                                  ");
        try {
            try {
                int pageSize = 20;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                int pageNo = 1;
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("langCd")) {
                    pstmt.setString(index++, info.getString("langCd"));
                }
                if (!info.isSpace("cdTp")) {
                    pstmt.setString(index++, info.getString("cdTp"));
                }
                if (!info.isSpace("brandLineCd")) {
                    pstmt.setString(index++, info.getString("brandLineCd"));
                }
                if (!info.isSpace("ppgTpCd")) {
                    pstmt.setString(index++, info.getString("ppgTpCd"));
                }
                if (!info.isSpace("searchKey")) {
                    pstmt.setString(index++, info.getString("searchKey"));
                }
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.PPGBuilderEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchBuilderListPaging", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchBuilderList", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchBuilderListCnt(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT COUNT(1) CNT              ");
        strSql.append("\n").append("FROM UPPG01MT M INNER JOIN UPPG02MT T             ");
        strSql.append("\n").append("ON M.PPGTEMPSEQ = T.PPGTEMPSEQ              ");
        strSql.append("\n").append("    WHERE 1 = 1                 ");
        strSql.append("\n").append("    AND M.siteCd = ?         ");
        if (!info.isSpace("langCd")) {
            strSql.append("\n").append("               AND M.langCd = ?         ");
        }
        if (!info.isSpace("cdTp")) {
            strSql.append("\n").append("               AND M.CDTP = ?         ");
        }
        if (!info.isSpace("brandLineCd")) {
            strSql.append("\n").append("               AND brandLineCd = ?         ");
        }
        if (!info.isSpace("ppgTpCd")) {
            strSql.append("\n").append("               AND T.ppgTpCd = ?         ");
        }
        if (!info.isSpace("searchKey")) {
            strSql.append("\n").append("        AND " + info.getString("searchType") + " LIKE '%' || ? || '%'         ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("langCd")) {
                    pstmt.setString(index++, info.getString("langCd"));
                }
                if (!info.isSpace("cdTp")) {
                    pstmt.setString(index++, info.getString("cdTp"));
                }
                if (!info.isSpace("brandLineCd")) {
                    pstmt.setString(index++, info.getString("brandLineCd"));
                }
                if (!info.isSpace("ppgTpCd")) {
                    pstmt.setString(index++, info.getString("ppgTpCd"));
                }
                if (!info.isSpace("searchKey")) {
                    pstmt.setString(index++, info.getString("searchKey"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchBuilderListCnt", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchBuilderListCnt", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector searchBuilderTabList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT M.*, F.FILENM, F.FILEPATH, U.POSTSCPTFL, U.TABNM, U.URL, U.ORDERBY            ");
        strSql.append("\n").append("FROM UPPG03MT M                         ");
        strSql.append("\n").append("    INNER JOIN UPPG03DT D                       ");
        strSql.append("\n").append("        ON M.TABTEMPSEQ = D.TABTEMPSEQ AND M.SITECD = D.SITECD                     ");
        strSql.append("\n").append("    INNER JOIN UPPG02FT F                       ");
        strSql.append("\n").append("        ON D.ICONIMGSEQ = F.ATTCHSEQ                                ");
        strSql.append("\n").append("    INNER JOIN UPRD07DT U                       ");
        strSql.append("\n").append("        ON M.TABCD = U.TABCD                                ");
        strSql.append("\n").append("WHERE PPGCD = ?                     ");
        strSql.append("\n").append("ORDER BY TABPPGCD                     ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("ppgCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.TabBuilderEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchBuilderTabList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchBuilderTabList", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public PPGBuilderEntity searchBuilderInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PPGBuilderEntity result = new PPGBuilderEntity();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT  PPGCd,              ");
        strSql.append("\n").append("    M.SITECD,                                     ");
        strSql.append("\n").append("    M.CDTP,                                       ");
        strSql.append("\n").append("    M.BRANDLINECD,                                ");
        strSql.append("\n").append("    M.BRANDLEVEL,                                ");
        strSql.append("\n").append("    M.BRANDNM,                                    ");
        strSql.append("\n").append("    M.PPGTEMPSEQ,                                 ");
        strSql.append("\n").append("    M.LANGCD,                                     ");
        strSql.append("\n").append("    M.PPGDESC,                                    ");
        strSql.append("\n").append("    M.PPGTEMPSEQ,                                    ");
        strSql.append("\n").append("    M.PPGCNT,                                     ");
        strSql.append("\n").append("    M.FILECREATEPATH,                             ");
        strSql.append("\n").append("    M.EXPOREFL,                                   ");
        strSql.append("\n").append("    M.REGID,                                      ");
        strSql.append("\n").append("    M.MODID,                                      ");
        strSql.append("\n").append("    TO_CHAR(M.FSTREGDATE, 'YYYY/MM/DD') FSTREGDATE,");
        strSql.append("\n").append("    TO_CHAR(M.FNLMODDATE, 'YYYY/MM/DD') FNLMODDATE, ");
        strSql.append("\n").append("    T.PPGTPCD,                                      ");
        strSql.append("\n").append("    T.PPGCLCD                                      ");
        strSql.append("\n").append("FROM UPPG01MT M INNER JOIN UPPG02MT T ");
        strSql.append("\n").append("ON M.PPGTEMPSEQ = T.PPGTEMPSEQ \t");
        strSql.append("\n").append("AND M.SITECD = T.SITECD \t\t\t");
        strSql.append("\n").append("WHERE PPGCD = ?                 \t");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("ppgCd"));
                rs = pstmt.executeQuery();
                result = (PPGBuilderEntity)DAOHelper.makeEntity(rs, "com.ufo.ppg.entity.PPGBuilderEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchBuilderInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getPpgSeq(String ppgCd) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT ? || LPAD(NVL(MAX(SUBSTR(PPGCD, -3)), 0) + 1, 3, '0') ");
        strSql.append("\n").append("FROM UPPG01MT                                        ");
        strSql.append("\n").append("WHERE PPGCD LIKE '%'|| ? ||'%'                       ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, ppgCd);
                pstmt.setString(index++, ppgCd);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getPpgSeq", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int getTabSeq(String tabCd) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT SUBSTR(NVL(MAX(TABPPGCD), '0000000000'), 9) ");
        strSql.append("\n").append("FROM UPPG03MT ");
        strSql.append("\n").append("WHERE TABPPGCD LIKE ? || '%'");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, tabCd);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getTabSeq", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPPG(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT INTO /* PPG_INSERT */ UPPG01MT(          ");
        strSql.append("\n").append("    SITECD,                                     ");
        strSql.append("\n").append("    CDTP,                                       ");
        strSql.append("\n").append("    BRANDLINECD,                                ");
        strSql.append("\n").append("    BRANDLEVEL,                                ");
        strSql.append("\n").append("    PPGCD,                                      ");
        strSql.append("\n").append("    BRANDNM,                                    ");
        strSql.append("\n").append("    PPGTEMPSEQ,                                 ");
        strSql.append("\n").append("    LANGCD,                                     ");
        strSql.append("\n").append("    PPGDESC,                                    ");
        strSql.append("\n").append("    PPGCNT,                                     ");
        strSql.append("\n").append("    FILECREATEPATH,                             ");
        strSql.append("\n").append("    EXPOREFL,                                   ");
        strSql.append("\n").append("    REGID,                                      ");
        strSql.append("\n").append("    MODID,                                      ");
        strSql.append("\n").append("    FSTREGDATE,                                 ");
        strSql.append("\n").append("    FNLMODDATE                                  ");
        strSql.append("\n").append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_CLOB(), ?, 'N', ?, ?, SYSDATE, SYSDATE)");
        StringBuffer clobSql = new StringBuffer();
        clobSql.append("\n").append("        SELECT /* PPG_INSERT_CONTENTS */               ");
        clobSql.append("\n").append("               PPGCNT FROM UPPG01MT                    ");
        clobSql.append("\n").append("           WHERE PPGCD  = ?                            ");
        clobSql.append("\n").append("          FOR UPDATE                                   ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cdTp"));
                pstmt.setString(index++, info.getString("brandLineCd"));
                pstmt.setString(index++, info.getString("brandLevel"));
                pstmt.setString(index++, info.getString("ppgCd"));
                pstmt.setString(index++, info.getString("brandNm"));
                pstmt.setString(index++, info.getString("ppgTempSeq"));
                pstmt.setString(index++, info.getString("langCd"));
                pstmt.setString(index++, info.getString("ppgDesc"));
                pstmt.setString(index++, info.getString("fileCreatePath"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(clobSql.toString());
                index = 1;
                pstmt2.setString(index++, info.getString("ppgCd"));
                rs = pstmt2.executeQuery();
                String[] arrVal = new String[]{info.getString("ppgCnt")};
                DAOHelper.putClobData(rs, arrVal);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPPG", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPPGTab(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT INTO UPPG03MT(                       ");
        strSql.append("\n").append("    SITECD,                     ");
        strSql.append("\n").append("    CDTP,                       ");
        strSql.append("\n").append("    PPGCD,                      ");
        strSql.append("\n").append("    BRANDLINECD,                        ");
        strSql.append("\n").append("    TABPPGCD,                       ");
        strSql.append("\n").append("    TABTEMPSEQ,                     ");
        strSql.append("\n").append("    TABCD,                      ");
        strSql.append("\n").append("    TABCNT,                     ");
        strSql.append("\n").append("    TABDESC,                        ");
        strSql.append("\n").append("    REGID,                      ");
        strSql.append("\n").append("    MODID,                      ");
        strSql.append("\n").append("    FSTREGDATE,                     ");
        strSql.append("\n").append("    FNLMODDATE                      ");
        strSql.append("\n").append(") VALUES(?, ?, ?, ?, ?, ?, ?, EMPTY_CLOB(), ?, ?, ?, SYSDATE, SYSDATE) ");
        StringBuffer clobSql = new StringBuffer();
        clobSql.append("\n").append("        SELECT /* TAB_INSERT_CONTENTS */               ");
        clobSql.append("\n").append("               TABCNT FROM UPPG03MT                    ");
        clobSql.append("\n").append("           WHERE TABPPGCD  = ?                         ");
        clobSql.append("\n").append("          FOR UPDATE                                   ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cdTp"));
                pstmt.setString(index++, info.getString("ppgCd"));
                pstmt.setString(index++, info.getString("brandLineCd"));
                pstmt.setString(index++, info.getString("tabPpgCd"));
                pstmt.setString(index++, info.getString("tabTempSeq"));
                pstmt.setString(index++, info.getString("tabCd"));
                pstmt.setString(index++, info.getString("tabDesc"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
                pstmt2 = this.con.prepareStatement(clobSql.toString());
                index = 1;
                pstmt2.setString(index++, info.getString("tabPpgCd"));
                rs = pstmt2.executeQuery();
                String[] arrVal = new String[]{info.getString("tabCnt")};
                DAOHelper.putClobData(rs, arrVal);
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPPGTab", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }

    public int updateBuilderExpore(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE UPPG01MT        ");
        strSql.append("\n").append("SET EXPOREFL = ?        ");
        strSql.append("\n").append("WHERE SITECD = ?        ");
        strSql.append("\n").append("AND CDTP = ?        ");
        strSql.append("\n").append("AND BRANDLINECD = ?     ");
        strSql.append("\n").append("AND SUBSTR(SUBSTR(PPGCD, -10), 1, 1) = ?");
        if (!info.isSpace("ppgCd")) {
            strSql.append("\n").append("               AND PPGCD = ?         ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("exporeFl"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("cdTp"));
                pstmt.setString(index++, info.getString("brandLineCd"));
                pstmt.setString(index++, info.getString("ppgTpCd"));
                if (!info.isSpace("ppgCd")) {
                    pstmt.setString(index++, info.getString("ppgCd"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updateBuilderExpore", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public Vector searchLineTabInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *               ");
        strSql.append("\n").append("FROM UPRD07DT          ");
        strSql.append("\n").append("WHERE BRANDCD = ?      ");
        strSql.append("\n").append("ORDER BY ORDERBY ASC   ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("brandCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.ppg.entity.TabInfoEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchLineTabInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "[DAO]searchLineTabInfo", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deletePPG(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        ResultSet rs = null;
        StringBuffer strSql = new StringBuffer();
        StringBuffer strSql2 = new StringBuffer();
        int result = 0;
        strSql.append("\n").append("DELETE FROM UPPG01MT           ");
        strSql.append("\n").append("WHERE PPGCD = ?                ");
        strSql.append("\n").append("    AND BRANDLINECD = ?        ");
        strSql2.append("\n").append("DELETE FROM UPPG03MT           ");
        strSql2.append("\n").append("WHERE PPGCD = ?                ");
        strSql2.append("\n").append("    AND BRANDLINECD = ?        ");
        try {
            try {
                int index = 1;
                pstmt2 = this.con.prepareStatement(strSql2.toString());
                pstmt2.setString(index++, info.getString("ppgCd"));
                pstmt2.setString(index++, info.getString("brandCd"));
                result += pstmt2.executeUpdate();
                index = 1;
                pstmt = this.con.prepareStatement(strSql.toString());
                pstmt.setString(index++, info.getString("ppgCd"));
                pstmt.setString(index++, info.getString("brandCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deletePPG", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closePreparedStatement(pstmt2);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closePreparedStatement(pstmt2);
        this.closeResultSet(rs);
        return result;
    }
}

