/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.paperweight;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.paperweight.entity.PaperPrdtEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOPrdtConnMgmtDAO
extends UFOBaseDAO {
    public UFOPrdtConnMgmtDAO(Connection con) {
        super(con);
    }

    public Vector searchPrdtList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT                      ");
        strSql.append("\n").append("    PRDTCD                  ");
        strSql.append("\n").append("    , PRDTNM                ");
        strSql.append("\n").append("    , ITEMCD                ");
        strSql.append("\n").append("    , SITECD                ");
        strSql.append("\n").append("    , TPCD                  ");
        strSql.append("\n").append("    , NOTES1                ");
        strSql.append("\n").append("    , NOTES2                ");
        strSql.append("\n").append("    , USEFL                 ");
        strSql.append("\n").append("    , TO_CHAR(FSTREGDATE, 'YYYY/MM/DD') AS FSTREGDATE               ");
        strSql.append("\n").append("    , TO_CHAR(FNLMODDATE, 'YYYY/MM/DD') AS FNLMODDATE               ");
        strSql.append("\n").append("    , REGID                 ");
        strSql.append("\n").append("    , MODID                 ");
        strSql.append("\n").append("    FROM KCNT04DT     ");
        strSql.append("\n").append("WHERE 1 = 1           ");
        strSql.append("\n").append("    AND ITEMCD = ?    ");
        try {
            try {
                int pageSize = 20;
                if (info.isExist("pageSize")) {
                    pageSize = info.getInt("pageSize");
                }
                int pageNo = 1;
                if (info.isExist("curPage")) {
                    pageNo = info.getInt("curPage");
                }
                pstmt = this.con.prepareStatement(DAOHelper.createPageStatement(strSql.toString()), 1004, 1007);
                int index = 1;
                pstmt.setInt(index++, pageSize);
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setInt(index++, pageSize * pageNo);
                pstmt.setInt(index++, pageNo);
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.ProductEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchPrdtList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchPrdtCount(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT COUNT(1)       ");
        strSql.append("\n").append("    FROM KCNT04DT     ");
        strSql.append("\n").append("WHERE 1 = 1           ");
        strSql.append("\n").append("    AND ITEMCD = ?    ");
        strSql.append("\n").append("    AND SITECD = ?    ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchPrdtCount", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int searchPrdtItemExist(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT COUNT(1) CNT             ");
        strSql.append("\n").append("    FROM KCNT04DT               ");
        strSql.append("\n").append("WHERE 1 = 1                     ");
        strSql.append("\n").append("    AND PRDTCD = ?              ");
        strSql.append("\n").append("    AND ITEMCD = ?              ");
        strSql.append("\n").append("    AND SITECD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchPrdtItemExist", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPrdtItem(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT INTO KCNT04DT (              ");
        strSql.append("\n").append("    prdtCd                          ");
        strSql.append("\n").append("    , itemCd                        ");
        strSql.append("\n").append("    , siteCd                        ");
        strSql.append("\n").append("    , prdtNm                        ");
        strSql.append("\n").append("    , tpCd                          ");
        strSql.append("\n").append("    , notes1                        ");
        strSql.append("\n").append("    , notes2                        ");
        strSql.append("\n").append("    , useFl                         ");
        strSql.append("\n").append("    , fstRegDate                    ");
        strSql.append("\n").append("    , fnlModDate                    ");
        strSql.append("\n").append("    , regId                         ");
        strSql.append("\n").append("    , modId )                       ");
        strSql.append("\n").append("VALUES( ?, ?, ?, ?, ?, ?, ?, 'Y'    ");
        strSql.append("\n").append("            ,SYSDATE, SYSDATE, ?, ?)");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("prdtnm"));
                pstmt.setString(index++, info.getString("tpCd"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPrdtItem", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updatePrdtUseFl(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE KCNT04DT SET             ");
        strSql.append("\n").append("    USEFL = ?                  ");
        strSql.append("\n").append("WHERE 1 = 1                     ");
        strSql.append("\n").append("    AND PRDTCD = ?              ");
        strSql.append("\n").append("    AND ITEMCD = ?              ");
        strSql.append("\n").append("    AND SITECD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updatePrdtUseFl", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deletePrdtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE                              ");
        strSql.append("\n").append("        FROM KCNT04DT               ");
        strSql.append("\n").append("    WHERE 1 = 1                     ");
        strSql.append("\n").append("        AND PRDTCD = ?              ");
        strSql.append("\n").append("        AND ITEMCD = ?              ");
        strSql.append("\n").append("        AND SITECD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deletePrdtInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public PaperPrdtEntity selectPaperPrdtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PaperPrdtEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT                      ");
        strSql.append("\n").append("      PRDTCD                ");
        strSql.append("\n").append("    , SEX                   ");
        strSql.append("\n").append("    , AGE1                  ");
        strSql.append("\n").append("    , AGE2                  ");
        strSql.append("\n").append("    , ORDERS                ");
        strSql.append("\n").append("    , LAUNCHDATE            ");
        strSql.append("\n").append("    , FSTREGDATE            ");
        strSql.append("\n").append("    , DAYTIME               ");
        strSql.append("\n").append("    , NOTES1                ");
        strSql.append("\n").append("    , NOTES2                ");
        strSql.append("\n").append("FROM KCNT04MT               ");
        strSql.append("\n").append("WHERE 1 = 1                 ");
        strSql.append("\n").append("    AND PRDTCD = ?          ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                rs = pstmt.executeQuery();
                result = (PaperPrdtEntity)DAOHelper.makeEntity(rs, "com.ufo.paperweight.entity.PaperPrdtEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]selectPaperPrdtInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int updatePaperPrdtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE KCNT04MT SET                 ");
        strSql.append("\n").append("      SEX = ?                       ");
        strSql.append("\n").append("    , AGE1 = ?                      ");
        strSql.append("\n").append("    , AGE2 = ?                      ");
        strSql.append("\n").append("    , ORDERS = ?                    ");
        strSql.append("\n").append("    , LAUNCHDATE = ?                ");
        strSql.append("\n").append("    , DAYTIME = ?                   ");
        strSql.append("\n").append("    , NOTES1 = ?                    ");
        strSql.append("\n").append("    , NOTES2 = ?                    ");
        strSql.append("\n").append("WHERE 1 = 1                         ");
        strSql.append("\n").append("    AND PRDTCD = ?                  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("sex"));
                pstmt.setString(index++, info.getString("age1"));
                pstmt.setString(index++, info.getString("age2"));
                pstmt.setString(index++, info.getString("orders"));
                pstmt.setString(index++, info.getString("launchDate"));
                pstmt.setString(index++, info.getString("dayTime"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, info.getString("prdtCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updatePaperPrdtInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int insertPaperPrdtInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT INTO KCNT04MT (                  ");
        strSql.append("\n").append("      PRDTCD                            ");
        strSql.append("\n").append("    , SEX                               ");
        strSql.append("\n").append("    , AGE1                              ");
        strSql.append("\n").append("    , AGE2                              ");
        strSql.append("\n").append("    , ORDERS                            ");
        strSql.append("\n").append("    , LAUNCHDATE                        ");
        strSql.append("\n").append("    , FSTREGDATE                        ");
        strSql.append("\n").append("    , DAYTIME                           ");
        strSql.append("\n").append("    , NOTES1                            ");
        strSql.append("\n").append("    , NOTES2                            ");
        strSql.append("\n").append(") VALUES(?, ?, ?, ?, ?, ?, SYSDATE, ?, ?, ?)  ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("prdtCd"));
                pstmt.setString(index++, info.getString("sex"));
                pstmt.setString(index++, info.getString("age1"));
                pstmt.setString(index++, info.getString("age2"));
                pstmt.setString(index++, info.getString("orders"));
                pstmt.setString(index++, info.getString("launchDate"));
                pstmt.setString(index++, info.getString("dayTime"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPaperPrdtInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

