/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.paperweight;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.base.UFOBaseDAO;
import com.ufo.common.utility.DAOHelper;
import com.ufo.common.utility.LoginHelper;
import com.ufo.paperweight.entity.PaperEntity;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class UFOPaperMgmtDAO
extends UFOBaseDAO {
    public UFOPaperMgmtDAO(Connection con) {
        super(con);
    }

    public Vector searchPaperList(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT PAPERCD                  ");
        strSql.append("\n").append("    , TYPECD                    ");
        strSql.append("\n").append("    , SITECD                    ");
        strSql.append("\n").append("    , TITLE                     ");
        strSql.append("\n").append("    , PAPERDESC                 ");
        strSql.append("\n").append("    , SUBCONTENTS               ");
        strSql.append("\n").append("    , NOTES1                    ");
        strSql.append("\n").append("    , NOTES2                    ");
        strSql.append("\n").append("    , USEFL                     ");
        strSql.append("\n").append("    , TO_CHAR(FSTREGDATE, 'YYYY/MM/DD') AS FSTREGDATE               ");
        strSql.append("\n").append("    , REGID                     ");
        strSql.append("\n").append("    , TO_CHAR(FNLMODDATE, 'YYYY/MM/DD') AS FNLMODDATE               ");
        strSql.append("\n").append("    , MODID                     ");
        strSql.append("\n").append("    FROM KCNT01MT               ");
        strSql.append("\n").append("WHERE 1 = 1                     ");
        strSql.append("\n").append("    AND SITECD = ?              ");
        if (!info.isSpace("paperDesc")) {
            strSql.append("\n").append("    AND PAPERDESC LIKE '%' || ? || '%'  ");
        }
        strSql.append("\n").append("    ORDER BY PAPERCD DESC       ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                if (!info.isSpace("paperDesc")) {
                    pstmt.setString(index++, info.getString("paperDesc"));
                }
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.PaperEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchPaperList", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public PaperEntity selectPaperInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PaperEntity result = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT *                ");
        strSql.append("\n").append("    FROM KCNT01MT       ");
        strSql.append("\n").append("WHERE 1 = 1             ");
        strSql.append("\n").append("    AND PAPERCD = ?     ");
        strSql.append("\n").append("    AND SITECD = ?      ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("paperCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                rs = pstmt.executeQuery();
                result = (PaperEntity)DAOHelper.makeEntity(rs, "com.ufo.paperweight.entity.PaperEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]selectPaperInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public Vector selectPaperStepInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector result = new Vector();
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("SELECT D.STEPSEQ                                        ");
        strSql.append("\n").append("                , D.PAPERCD                             ");
        strSql.append("\n").append("                , D.ITEMCD                              ");
        strSql.append("\n").append("                , D.ITEMORDERBY                              ");
        strSql.append("\n").append("                , D.STEPLEVEL                           ");
        strSql.append("\n").append("                , D.STEPTITLE                           ");
        strSql.append("\n").append("                , D.STEPDESC                            ");
        strSql.append("\n").append("                , D.STEPIMG                             ");
        strSql.append("\n").append("                , D.STEPDESCUSEFL                       ");
        strSql.append("\n").append("                , D.STEPIMGUSEFL                        ");
        strSql.append("\n").append("                , TO_CHAR(D.FSTREGDATE, 'YYYY/MM/DD') AS FSTREGDATE                             ");
        strSql.append("\n").append("                , TO_CHAR(D.FNLMODDATE, 'YYYY/MM/DD') AS FNLMODDATE                             ");
        strSql.append("\n").append("                , D.REGID                               ");
        strSql.append("\n").append("                , D.MODID                               ");
        strSql.append("\n").append("                , M.CONTENTS                            ");
        strSql.append("\n").append("            FROM KCNT03DT D INNER JOIN KCNT02MT M       ");
        strSql.append("\n").append("                ON D.ITEMCD = M.ITEMCD                  ");
        strSql.append("\n").append("        WHERE 1 = 1                                     ");
        strSql.append("\n").append("            AND PAPERCD = ?                             ");
        strSql.append("\n").append("            AND STEPLEVEL = ?                           ");
        strSql.append("\n").append("            ORDER BY ITEMORDERBY ASC                       ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("paperCd"));
                pstmt.setInt(index++, info.getInt("stepLevel"));
                rs = pstmt.executeQuery();
                result = DAOHelper.makeVector(rs, "com.ufo.paperweight.entity.PaperStepEntity");
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]selectPaperStepInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public String getNewPaperCd(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            try {
                String siteCd = String.valueOf(info.getString("siteCd")) + "M";
                int emptyCol = 9 - siteCd.length();
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("SELECT ? || LPAD(NVL(MAX(SUBSTR(PAPERCD, -" + emptyCol + ")), 0) + 1, " + emptyCol + ", '0')               ");
                strSql.append("\n").append("    FROM KCNT01MT               ");
                strSql.append("\n").append("WHERE 1 = 1                     ");
                strSql.append("\n").append("    AND SITECD = ?              ");
                strSql.append("\n").append("    AND PAPERCD LIKE ? || '%'   ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, siteCd);
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, siteCd);
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarString(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]getNewPaperCd", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPaperInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT INTO KCNT01MT (              ");
        strSql.append("\n").append("    PAPERCD                         ");
        strSql.append("\n").append("    , SITECD                        ");
        strSql.append("\n").append("    , TITLE                         ");
        strSql.append("\n").append("    , PAPERDESC                     ");
        strSql.append("\n").append("    , TYPECD                       ");
        strSql.append("\n").append("    , SUBCONTENTS                   ");
        strSql.append("\n").append("    , SELECTEDCNT                   ");
        strSql.append("\n").append("    , NOTES1                        ");
        strSql.append("\n").append("    , NOTES2                        ");
        strSql.append("\n").append("    , USEFL                         ");
        strSql.append("\n").append("    , FSTREGDATE                    ");
        strSql.append("\n").append("    , FNLMODDATE                    ");
        strSql.append("\n").append("    , REGID                         ");
        strSql.append("\n").append("    , MODID                         ");
        strSql.append("\n").append(") VALUES( ?, ?, ?, ?, ?, ?, 0, ?, ?, ? ");
        strSql.append("\n").append("    , SYSDATE, SYSDATE, ?, ? )   ");
        System.out.println(strSql.toString());
        System.out.println(info);
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("paperCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("title"));
                pstmt.setString(index++, info.getString("paperDesc"));
                pstmt.setInt(index++, info.getInt("typeCd"));
                pstmt.setString(index++, info.getString("subContents"));
                pstmt.setString(index++, info.getString("notes1"));
                pstmt.setString(index++, info.getString("notes2"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPaperInfo", sqlEx);
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int insertPaperStepInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("INSERT INTO KCNT03DT (              ");
        strSql.append("\n").append("    STEPSEQ                         ");
        strSql.append("\n").append("    , PAPERCD                       ");
        strSql.append("\n").append("    , ITEMCD                        ");
        strSql.append("\n").append("    , ITEMORDERBY                        ");
        strSql.append("\n").append("    , STEPLEVEL                     ");
        strSql.append("\n").append("    , STEPTITLE                     ");
        strSql.append("\n").append("    , STEPDESC                      ");
        strSql.append("\n").append("    , STEPIMG                       ");
        strSql.append("\n").append("    , STEPDESCUSEFL                 ");
        strSql.append("\n").append("    , STEPIMGUSEFL                  ");
        strSql.append("\n").append("    , FSTREGDATE                    ");
        strSql.append("\n").append("    , FNLMODDATE                    ");
        strSql.append("\n").append("    , REGID                         ");
        strSql.append("\n").append("    , MODID                         ");
        strSql.append("\n").append(") VALUES ( (SELECT NVL(MAX(STEPSEQ),0)+1 AS STEPSEQ FROM KCNT03DT), ?, ?, ?, ?, ?, ?, ?, ?, ?  ");
        strSql.append("\n").append("    , SYSDATE, SYSDATE, ?, ? )      ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("paperCd"));
                pstmt.setString(index++, info.getString("itemCd"));
                pstmt.setString(index++, info.getString("itemOrderBy"));
                pstmt.setInt(index++, info.getInt("StepLevel"));
                pstmt.setString(index++, info.getString("stepTitle"));
                pstmt.setString(index++, info.getString("stepDesc"));
                pstmt.setString(index++, info.getString("stepImg"));
                pstmt.setString(index++, info.getString("stepDescUseFl"));
                pstmt.setString(index++, info.getString("stepImgUseFl"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]insertPaperStepInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }

    public int deletePaperStepInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE                  ");
        strSql.append("\n").append("    FROM KCNT03DT       ");
        strSql.append("\n").append("WHERE 1 = 1             ");
        strSql.append("\n").append("    AND PAPERCD = ?     ");
        if (!info.isSpace("stepLevel")) {
            strSql.append("\n").append("    AND STEPLEVEL = ?   ");
        }
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("paperCd"));
                if (!info.isSpace("stepLevel")) {
                    pstmt.setString(index++, info.getString("stepLevel"));
                }
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deletePaperStepInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int updatePaperInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("UPDATE KCNT01MT SET             ");
        strSql.append("\n").append("    TITLE = ?                   ");
        strSql.append("\n").append("    , SUBCONTENTS = ?           ");
        strSql.append("\n").append("    , USEFL = ?                 ");
        strSql.append("\n").append("    , TYPECD = ?               ");
        strSql.append("\n").append("    , PAPERDESC = ?             ");
        strSql.append("\n").append("    , FNLMODDATE = SYSDATE      ");
        strSql.append("\n").append("    , MODID = ?                 ");
        strSql.append("\n").append("WHERE 1 = 1                     ");
        strSql.append("\n").append("    AND PAPERCD = ?             ");
        strSql.append("\n").append("    AND SITECD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("title"));
                pstmt.setString(index++, info.getString("subContents"));
                pstmt.setString(index++, info.getString("useFl"));
                pstmt.setInt(index++, info.getInt("typeCd"));
                pstmt.setString(index++, info.getString("paperDesc"));
                pstmt.setString(index++, LoginHelper.getCurLoginId(info.getRequest()));
                pstmt.setString(index++, info.getString("paperCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]updatePaperInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int deletePaperInfo(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        int result = 0;
        StringBuffer strSql = new StringBuffer();
        strSql.append("\n").append("DELETE                              ");
        strSql.append("\n").append("        FROM KCNT01MT               ");
        strSql.append("\n").append("    WHERE 1 = 1                     ");
        strSql.append("\n").append("        AND PAPERCD = ?             ");
        strSql.append("\n").append("        AND SITECD = ?              ");
        try {
            try {
                pstmt = this.con.prepareStatement(strSql.toString());
                int index = 1;
                pstmt.setString(index++, info.getString("paperCd"));
                pstmt.setString(index++, info.getString("siteCd"));
                result = pstmt.executeUpdate();
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]deletePaperInfo", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        return result;
    }

    public int searchOrderByCompare(UFORequest info) throws UFOException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                StringBuffer strSql = new StringBuffer();
                strSql.append("\n").append("SELECT COUNT(1) CNT                 ");
                strSql.append("\n").append("    FROM KCNT01MT                   ");
                strSql.append("\n").append("WHERE 1 = 1                         ");
                strSql.append("\n").append("    AND SITECD = ?                  ");
                strSql.append("\n").append("    AND TYPECD = ?                 ");
                pstmt = this.con.prepareStatement(strSql.toString(), 1004, 1007);
                int index = 1;
                pstmt.setString(index++, info.getString("siteCd"));
                pstmt.setString(index++, info.getString("typeCd"));
                rs = pstmt.executeQuery();
                result = DAOHelper.getScalarInt(rs);
            }
            catch (SQLException sqlEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[DAO]searchOrderByCompare", sqlEx);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "ETC-0100", "", etcEx);
            }
        }
        catch (Throwable throwable) {
            this.closePreparedStatement(pstmt);
            this.closeResultSet(rs);
            throw throwable;
        }
        this.closePreparedStatement(pstmt);
        this.closeResultSet(rs);
        return result;
    }
}

