/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.news_event;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.member.UFOMemberMgmtDAO;
import com.ufo.member.entity.MemberMgmtEntity;
import com.ufo.news_event.UFOQuizPollMgmtDAO;
import com.ufo.news_event.entity.QuizPollEntity;
import com.ufo.news_event.entity.QuizPollItemEntity;

public class UFOQuizPollMgmtWB
extends UFOBaseWB {
    public UFOQuizPollMgmtWB() {
    }

    public UFOQuizPollMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchQuizPollList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                if (info.isExist("keygubn") && info.isExist("keyword") && info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                    info.put("subject", CmUtil.nullTrim(info.getString("keyword")));
                }
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                if (info.isPage()) {
                    result.put("LIST", dao.searchQuizPollListPaging(info));
                    result.put("TOTCNT", dao.getQuizPollListCnt(info));
                } else {
                    result.put("LIST", dao.searchQuizPollList(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_LIST_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchQuizPollListPaging(UFORequest info) throws UFOException {
        info.setPage(true);
        return this.searchQuizPollList(info);
    }

    public UFOResult selectQuizPollInfoBasic(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                QuizPollEntity entity = dao.selectQuizPollInfo(info);
                if (entity != null) {
                    entity.itemList = dao.searchSubItemList(info);
                    entity.comtList = dao.searchQuizPollComtList(info);
                    entity.acesList = dao.searchQuizPollAcesList(info);
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_SEL_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectQuizPollInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                QuizPollEntity entity;
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword") && info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                    info.put("subject", CmUtil.nullTrim(info.getString("keyword")));
                }
                if ((entity = dao.selectQuizPollInfo(info)) != null) {
                    entity.itemList = dao.searchSubItemList(info);
                    entity.comtList = dao.searchQuizPollComtList(info);
                    entity.acesList = dao.searchQuizPollAcesList(info);
                }
                result.put("VIEW", entity);
                result.put("PREV", dao.selectQuizPollInfo(info, "P"));
                result.put("NEXT", dao.selectQuizPollInfo(info, "N"));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_SEL_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertQuizPollInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                String[] splitAttr2;
                UFORequest[] arrAcesInfo;
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                info.put("seq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertQuizPollInfo(info);
                String[] splitAttr = new String[]{"itemSeq", "contents", "answerFl", "status"};
                String[] keepAttr = new String[]{"siteCd", "cd", "seq"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            arrInfo[i].put("dispFl", "Y");
                            resCnt1 += dao.insertSubItemInfo(arrInfo[i]);
                        } else if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            resCnt1 += dao.updateSubItemInfo(arrInfo[i]);
                        } else {
                            resCnt1 += dao.deleteJoinHistInfo(arrInfo[i]);
                            resCnt1 += dao.deleteSubItemInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (info.getString("acesFl").equals("N") && (arrAcesInfo = info.toArray(info, splitAttr2 = new String[]{"cstmId"}, keepAttr)) != null) {
                    int i = 0;
                    while (i < arrAcesInfo.length) {
                        resCnt2 += dao.insertQuizPollAces(arrAcesInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_REG_WB]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateQuizPollInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                String[] splitAttr2;
                UFORequest[] arrAcesInfo;
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateQuizPollInfo(info);
                String[] splitAttr = new String[]{"itemSeq", "contents", "answerFl", "status"};
                String[] keepAttr = new String[]{"siteCd", "cd", "seq"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            arrInfo[i].put("dispFl", "Y");
                            resCnt1 += dao.insertSubItemInfo(arrInfo[i]);
                        } else if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            resCnt1 += dao.updateSubItemInfo(arrInfo[i]);
                        } else if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("D")) {
                            resCnt1 += dao.deleteJoinHistInfo(arrInfo[i]);
                            resCnt1 += dao.deleteSubItemInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                dao.deleteQuizPollAces(info);
                if (info.getString("acesFl").equals("N") && (arrAcesInfo = info.toArray(info, splitAttr2 = new String[]{"cstmId"}, keepAttr)) != null) {
                    int i = 0;
                    while (i < arrAcesInfo.length) {
                        resCnt2 += dao.insertQuizPollAces(arrAcesInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_MOD_WB]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteQuizPollInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        int resCnt3 = 0;
        int resCnt4 = 0;
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.remove("itemSeq");
                resCnt4 = dao.deleteQuizPollComt(info);
                resCnt3 = dao.deleteQuizPollAces(info);
                resCnt2 = dao.deleteJoinHistInfo(info);
                resCnt1 = dao.deleteSubItemInfo(info);
                resCnt = dao.deleteQuizPollInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_DEL_WB]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchQuizPollJoinedList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberMgmtDAO memDao = new UFOMemberMgmtDAO(this.getConnection(this));
                MemberMgmtEntity memInfo = memDao.selectMemMgmtInfo(info);
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                if (info.isPage()) {
                    result.put("LIST", dao.searchJoinHistListPaging(info, memInfo));
                    result.put("TOTCNT", dao.getJoinHistCnt(info, memInfo));
                } else {
                    result.put("LIST", dao.searchJoinHistList(info, memInfo));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_JOIN_HIST_LIST_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult joinQuiz(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        if (info.isSpace("cd")) {
            info.put("cd", "QZ");
        }
        try {
            UFOMemberMgmtDAO memDao = new UFOMemberMgmtDAO(this.getConnection(this));
            MemberMgmtEntity memInfo = memDao.selectMemMgmtInfo(info);
            UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
            UFORequest temp = info.cloneReq("temp");
            temp.remove("itemSeq");
            if (dao.getJoinHistCnt(temp, memInfo) > 0) {
                result.put("FLAG", "false");
                result.put("MESG", "\ufffd\u0339\ufffd \ufffd\ufffd \ufffd\u03fc\u033d\ufffd\ufffd\u03f4\ufffd.");
                UFOResult uFOResult = result;
                return uFOResult;
            }
            QuizPollItemEntity itemInfo = dao.selectSubItemInfo(info);
            if (CmUtil.nullTrim(itemInfo.answerFl).equals("N")) {
                result.put("FLAG", "false");
                result.put("MESG", "\u01b2\ufffd\u023d\ufffd\ufffd\u03f4\ufffd.");
                UFOResult uFOResult = result;
                return uFOResult;
            }
            try {
                this.startTransaction();
                resCnt = dao.insertJoinHistInfo(info);
                resCnt1 = dao.hitItemCount(info);
                resCnt2 = dao.hitTotalCount(info);
                if (resCnt > 0 && resCnt1 > 0 && resCnt2 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL : [resCnt:" + resCnt + "][resCnt1:" + resCnt1 + "][resCnt2:" + resCnt2 + "]");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[JOIN_QUIZ_WB]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult joinPoll(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        if (info.isSpace("cd")) {
            info.put("cd", "PL");
        }
        try {
            UFOMemberMgmtDAO memDao = new UFOMemberMgmtDAO(this.getConnection(this));
            MemberMgmtEntity memInfo = memDao.selectMemMgmtInfo(info);
            UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
            UFORequest temp = info.cloneReq("temp");
            temp.remove("itemSeq");
            if (dao.getJoinHistCnt(temp, memInfo) > 0) {
                result.put("FLAG", "false");
                result.put("MESG", "\ufffd\u0339\ufffd \ufffd\ufffd \ufffd\u03fc\u033d\ufffd\ufffd\u03f4\ufffd.");
                UFOResult uFOResult = result;
                return uFOResult;
            }
            try {
                this.startTransaction();
                resCnt = dao.insertJoinHistInfo(info);
                resCnt1 = dao.hitItemCount(info);
                resCnt2 = dao.hitTotalCount(info);
                if (resCnt > 0 && resCnt1 > 0 && resCnt2 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL : [resCnt:" + resCnt + "][resCnt1:" + resCnt1 + "][resCnt2:" + resCnt2 + "]");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[JOIN_QUIZ_WB]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertQuizPollComt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertQuizPollComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]QUIZ_COMT_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteQuizPollComt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteQuizPollComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ADMEDIA_COMT_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult joinPoll2(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        if (info.isSpace("cd")) {
            info.put("cd", "PL");
        }
        try {
            UFOMemberMgmtDAO memDao = new UFOMemberMgmtDAO(this.getConnection(this));
            MemberMgmtEntity memInfo = memDao.selectMemMgmtInfo(info);
            UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
            UFORequest temp = info.cloneReq("temp");
            temp.remove("itemSeq");
            if (dao.getJoinHistCnt(temp, memInfo) > 0) {
                result.put("FLAG", "false");
                result.put("MESG", "\ufffd\u0339\ufffd \ufffd\ufffd \ufffd\u03fc\u033d\ufffd\ufffd\u03f4\ufffd.");
                UFOResult uFOResult = result;
                return uFOResult;
            }
            try {
                this.startTransaction();
                String[] splitAttr = new String[]{"itemSeq"};
                String[] keepAttr = new String[]{"siteCd", "cd", "seq", "cstmId"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        resCnt += dao.insertJoinHistInfo(arrInfo[i]);
                        resCnt1 += dao.hitItemCount(arrInfo[i]);
                        resCnt2 += dao.hitTotalCount(arrInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0 && resCnt1 > 0 && resCnt2 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL : [resCnt:" + resCnt + "][resCnt1:" + resCnt1 + "][resCnt2:" + resCnt2 + "]");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[JOIN_QUIZ_WB]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchQuizPollAcesList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchQuizPollAcesList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_ACCESS_LIST_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectQuizPollAcesInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectQuizPollAcesInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_ACCESS_SELECT_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertQuizPollAces(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertQuizPollAces(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]QUIZ_ACCESS_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteQuizPollAces(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteQuizPollAces(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]QUIZ_ACCESS_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectQuizPollComtList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOQuizPollMgmtDAO dao = new UFOQuizPollMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectQuizPollComtList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[QUIZ_COMT_SELECT_WB]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

