/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.news_event;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.news_event.UFONewsMgmtDAO;
import com.ufo.news_event.entity.NewsEventEntity;
import java.util.Vector;

public class UFONewsMgmtWB
extends UFOBaseWB {
    public UFONewsMgmtWB() {
    }

    public UFONewsMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchNewsList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector newsList = null;
        Vector fstNewsList = null;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_MOBILE_CONTENTS)) {
                        info.put("mobileConts", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    newsList = dao.searchNewsListPaging(info);
                    result.put("TOTCNT", dao.getNewsListCnt(info));
                } else {
                    newsList = dao.searchNewsList(info);
                }
                if (newsList != null) {
                    int i = 0;
                    while (i < newsList.size()) {
                        NewsEventEntity entity = (NewsEventEntity)newsList.get(i);
                        UFORequest cReq = entity.toRequest();
                        entity.attachFile = dao.searchAttachList(cReq);
                        entity.comtVt = dao.searchNewsEventComtList(cReq);
                        entity.comtCnt = dao.searchNewsEventComtCnt(cReq);
                        ++i;
                    }
                    fstNewsList = dao.searchFstNewsList(info);
                }
                result.put("LIST", newsList);
                result.put("FST_LIST", fstNewsList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchNewsListPaging(UFORequest info) throws Exception {
        info.setPage(true);
        return this.searchNewsList(info);
    }

    public UFOResult selectSeq(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                result.put("SEQ", dao.selectSeq(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SEQ_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectNewsInfoBasic(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                dao.hitReadCount(info);
                NewsEventEntity entity = new NewsEventEntity();
                entity = dao.selectNewsInfo(info);
                if (entity != null) {
                    entity.attachFile = dao.searchAttachList(info);
                }
                if (entity != null) {
                    entity.comtVt = dao.searchNewsEventComtList(info);
                    entity.comtCnt = dao.searchNewsEventComtCnt(info);
                }
                result.put("VIEW", entity);
                result.put("ATTACH", entity.attachFile);
                this.commit();
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_SELECT_BASIC", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectNewsInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_MOBILE_CONTENTS)) {
                        info.put("mobileConts", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                this.startTransaction();
                dao.hitReadCount(info);
                NewsEventEntity entity = new NewsEventEntity();
                entity = dao.selectNewsInfo(info);
                if (entity != null) {
                    entity.attachFile = dao.searchAttachList(info);
                }
                if (entity != null) {
                    entity.comtVt = dao.searchNewsEventComtList(info);
                    entity.comtCnt = dao.searchNewsEventComtCnt(info);
                }
                result.put("VIEW", entity);
                result.put("PREV", dao.selectNewsInfo(info, "P"));
                result.put("NEXT", dao.selectNewsInfo(info, "N"));
                result.put("ATTACH", entity.attachFile);
                this.commit();
                if (entity != null) {
                    UFORequest cReq = entity.toRequest();
                    if (info.isExist("comtPage") && info.isExist("comtSize")) {
                        cReq.put("comtPage", info.getInt("comtPage"));
                        cReq.put("comtSize", info.getInt("comtSize"));
                        entity.comtVt = dao.searchNewsEventComtList(cReq);
                        entity.comtCnt = dao.searchNewsEventComtCnt(cReq);
                    } else {
                        entity.comtVt = dao.searchNewsEventComtList(cReq);
                        entity.comtCnt = dao.searchNewsEventComtCnt(cReq);
                    }
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertNewsInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                info.put("seq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertNewsInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertHeraNewsInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                if ("NT".equals(info.getString("cd")) || "HNT".equals(info.getString("cd"))) {
                    info.put("seq", dao.getHeraMaxSeq(info));
                    this.startTransaction();
                    resCnt = dao.insertNewsInfo(info);
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateNewsInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateNewsInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteNewsInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int resCnt2 = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt2 = dao.deleteFile(info);
                resCnt1 = dao.deleteAttachInfo(info);
                resCnt = dao.deleteNewsInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAttachFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertAttachInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_ATTACH_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAttachFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                dao.deleteFile(info);
                resCnt = dao.deleteAttachInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_ATTACH_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertNewsEventComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertNewsEventComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]COMMENT_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteNewsEventComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteNewsEventComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]COMMENT_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectNewsEventComtList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFONewsMgmtDAO dao = new UFONewsMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectNewsEventComtList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[NEWS_COMT_SELECT]", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

