/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.news_event;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.news_event.UFOBeautyMgmtDAO;
import com.ufo.news_event.entity.BeautyEntity;
import java.util.Vector;

public class UFOBeautyMgmtWB
extends UFOBaseWB {
    public UFOBeautyMgmtWB() {
    }

    public UFOBeautyMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchBeautyList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector beautyList = null;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword") && info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                    info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                }
                if (info.isPage()) {
                    beautyList = dao.searchBeautyListPaging(info);
                    result.put("TOTCNT", dao.getBeautyListCnt(info));
                } else {
                    beautyList = dao.searchBeautyList(info);
                }
                result.put("LIST", beautyList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]searchBeautyList", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchReservationList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector reservationList = null;
        Vector classNameList = null;
        Vector dateTimeList = null;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword") && info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                    info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                }
                if (info.isPage()) {
                    reservationList = dao.searchReservationListPaging(info);
                    result.put("TOTCNT", dao.getReservationListCnt(info));
                } else {
                    reservationList = dao.searchReservationList(info);
                }
                classNameList = dao.getClassNameList(info);
                dateTimeList = dao.getDateTimeListList(info);
                result.put("LIST", reservationList);
                result.put("CLASS_NAME_LIST", classNameList);
                result.put("DATE_TIME_LIST", dateTimeList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]NEWS_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult getDateTimeListList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector dateTimeList = null;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                dateTimeList = dao.getDateTimeListList(info);
                result.put("DATE_TIME_LIST", dateTimeList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]getDateTimeListList", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectNricView(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector classList = null;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                BeautyEntity entity = dao.selectNricView(info);
                classList = dao.selectNricClassList(info);
                result.put("VIEW", entity);
                result.put("CLASS_LIST", classList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]selectNricView", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateRevClassInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                resCnt = dao.updateRevClassInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]REVERSATION_CLASS_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteRevClassInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                resCnt = dao.deleteRevClassInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]REVERSATION_CLASS_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertClassInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                String[] splitAttr;
                UFORequest[] arrInfo;
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                info.put("seq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertClassInfo(info);
                if (info.isExist("className") && (arrInfo = info.toArray(info, splitAttr = new String[]{"classDate", "fromHh", "fromMm", "toHh", "toMm", "fee", "maxSlot", "status"})) != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        resCnt1 += dao.insertDetailClassInfo(arrInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0 && resCnt1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]insertClassInfo", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectClassDetailView(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector classDetailList = null;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                BeautyEntity entity = dao.selectClassDetailView(info);
                classDetailList = dao.selectClassDetailList(info);
                result.put("VIEW", entity);
                result.put("CLASS_DETAIL_LIST", classDetailList);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]selectClassDetailView", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateClassInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        int arrLen = 0;
        try {
            try {
                String[] splitAttr;
                UFORequest[] arrInfo;
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                resCnt = dao.updateClassInfo(info);
                this.startTransaction();
                if (info.isExist("className") && (arrInfo = info.toArray(info, splitAttr = new String[]{"classNo", "classDate", "fromHh", "fromMm", "toHh", "toMm", "fee", "maxSlot", "status"})) != null) {
                    arrLen = arrInfo.length;
                    int i = 0;
                    while (i < arrInfo.length) {
                        resCnt1 = CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I") ? (resCnt1 += dao.insertDetailClassInfo(arrInfo[i])) : (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U") ? (resCnt1 += dao.updateDetailClassInfo(arrInfo[i])) : (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("D") ? (resCnt1 += dao.deleteDetailClassInfo(arrInfo[i])) : ++resCnt1));
                        ++i;
                    }
                }
                if (resCnt > 0 && arrLen == resCnt1) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]updateClassInfo", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteDtClassInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteDtClassInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]deleteDtClassInfo", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteClassInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteDtClassInfo(info);
                resCnt1 = dao.deleteClassInfo(info);
                if (resCnt > 0 && resCnt1 > 0) {
                    result.put("FLAG", "true");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]deleteClassInfo", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult checkDupDate(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        Vector checkList = null;
        boolean dateExist = false;
        try {
            try {
                UFOBeautyMgmtDAO dao = new UFOBeautyMgmtDAO(this.getConnection(this));
                this.startTransaction();
                checkList = dao.checkDupList(info);
                String fromDate = info.getString("fromDate");
                String endDate = info.getString("fromDate");
                int i = 0;
                while (i < checkList.size()) {
                    BeautyEntity entity = (BeautyEntity)checkList.get(i);
                    String fromDateDb = entity.fromDate;
                    String endDateDb = entity.endDate;
                    if (Long.parseLong(fromDate) >= Long.parseLong(fromDateDb) && Long.parseLong(fromDate) <= Long.parseLong(endDateDb) || Long.parseLong(endDate) >= Long.parseLong(fromDateDb) && Long.parseLong(endDate) <= Long.parseLong(endDateDb) || Long.parseLong(fromDate) <= Long.parseLong(fromDateDb) && Long.parseLong(endDate) >= Long.parseLong(endDateDb)) {
                        dateExist = true;
                    }
                    ++i;
                }
                if (dateExist) {
                    result.put("FLAG", "true");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]checkDupDate", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

