/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.member;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.member.UFOMemberMgmtDAO;
import com.ufo.member.UFOMemberServiceDAO;
import com.ufo.member.entity.MemberMgmtEntity;
import com.ufo.member.entity.MemberPointEntity;
import com.ufo.member.entity.PointInfoEntity;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class UFOMemberServiceWB
extends UFOBaseWB {
    public UFOMemberServiceWB() {
    }

    public UFOMemberServiceWB(String siteCd) {
        super(siteCd);
    }

    public UFOMemberServiceWB(UFORequest info) throws UFOException {
        super(info.getString("siteCd"));
        MemberMgmtEntity memInfo = null;
        HttpSession session = info.getRequest().getSession();
        memInfo = (MemberMgmtEntity)session.getAttribute("__ufo_mem_info");
        try {
            try {
                if (memInfo == null || !memInfo.siteCd.equals(info.getString("siteCd"))) {
                    session.removeAttribute("__ufo_mem_info");
                    UFORequest req = new UFORequest();
                    UFOMemberMgmtDAO dao = new UFOMemberMgmtDAO(this.getConnection(this));
                    memInfo = dao.selectMemMgmtInfo(info);
                    session.setAttribute("__ufo_mem_info", (Object)memInfo);
                }
                info.put("__ufo_mem_info", memInfo);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONSTRUCTOR", ex);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public UFOResult searchSitePointList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                result.put("LIST", dao.searchSitePointList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_POINT_CATEGORY_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSitePointInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                result.put("VIEW", dao.selectSitePointInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_POINT_CATEGORY_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertSitePointInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                info.put("pointCd", dao.getNewCd(info));
                this.startTransaction();
                resCnt = dao.insertSitePointInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_POINT_CATEGORY_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateSitePointInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                resCnt = dao.updateSitePointInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_POINT_CATEGORY_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteSitePointInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                resCnt = dao.deleteSitePointInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_POINT_CATEGORY_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchMemPointList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                if (info.isPage()) {
                    result.put("LIST", dao.searchMemPointListPaging(info));
                    result.put("TOTCNT", dao.getMemPointListCnt(info));
                    result.put("TOTPOINT", dao.getMemTotalPoint(info));
                    if (info.isEquals("isToday", "Y")) {
                        info.put("_today", "Y");
                        result.put("TODAYPOINT", dao.getMemTotalPoint(info));
                    }
                } else {
                    result.put("LIST", dao.searchMemPointList(info));
                    result.put("TOTPOINT", dao.getMemTotalPoint(info));
                    if (info.isEquals("isToday", "Y")) {
                        info.put("_today", "Y");
                        result.put("TODAYPOINT", dao.getMemTotalPoint(info));
                    }
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_POINT_INFO_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectMemPointInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                result.put("VIEW", dao.selectMemPointInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_POINT_INFO_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSitePointStat(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                result.put("STAT", dao.searchSitePointStat(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_POINT_STATISTICS", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult accumulatePoint(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        boolean flag = true;
        String mesg = "";
        long newSeq = 0L;
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                PointInfoEntity pointEntity = dao.selectSitePointInfo(info);
                if (pointEntity == null || CmUtil.nullTrim(pointEntity.useFl).equals("N")) {
                    flag = false;
                    mesg = "\ufffd\ufffd\ufffd \ufffd\u04b0\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                } else {
                    if (CmUtil.nullTrim(pointEntity.catCd).equals("ITM")) {
                        if (CmUtil.nullTrim(pointEntity.subCd).equals("F")) {
                            if (dao.getMemPointCnt(info) > 0) {
                                flag = false;
                                mesg = "\ufffd\u0339\ufffd \ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                            } else {
                                newSeq = dao.getNewSeq(info);
                                info.put("seq", newSeq);
                                info.put("point", pointEntity.point);
                                info.put("retnFl", pointEntity.retnFl);
                                resCnt = dao.insertMemPointInfo(info);
                                if (resCnt > 0) {
                                    flag = true;
                                    mesg = "\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                                }
                            }
                        } else if (CmUtil.nullTrim(pointEntity.subCd).equals("E")) {
                            newSeq = dao.getNewSeq(info);
                            info.put("seq", newSeq);
                            info.put("point", pointEntity.point);
                            info.put("retnFl", pointEntity.retnFl);
                            resCnt = dao.insertMemPointInfo(info);
                            if (resCnt > 0) {
                                flag = true;
                                mesg = "\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                            }
                        }
                    } else if (CmUtil.nullTrim(pointEntity.catCd).equals("TRM")) {
                        info.put("__termCd", CmUtil.nullTrim(pointEntity.subCd));
                        if (pointEntity.count < 2) {
                            MemberPointEntity pEntity = dao.selectMemPointInfo(info);
                            if (pEntity != null) {
                                newSeq = pEntity.seq;
                                String[] arrAttr = new String[]{"siteCd", "cstmId", "seq", "pointCd"};
                                UFORequest temp = pEntity.toRequest(info.getRequest(), arrAttr);
                                temp.put("addCnt", 1);
                                temp.put("cnclFl", "N");
                                temp.put("cnclDate", "");
                                resCnt = dao.updateMemPointInfo(temp);
                                if (resCnt > 0) {
                                    flag = true;
                                    mesg = "\ufffd\ufffd\u2c23\ufffd\ufffd\ufffd\ufffd \ufffd\u0339\ufffd \ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                                }
                            } else {
                                newSeq = dao.getNewSeq(info);
                                info.put("seq", newSeq);
                                info.put("point", pointEntity.point);
                                info.put("retnFl", pointEntity.retnFl);
                                resCnt = dao.insertMemPointInfo(info);
                                if (resCnt > 0) {
                                    flag = true;
                                    mesg = "\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                                }
                            }
                        } else if (pointEntity.count > dao.getMemPointSaveCnt(info)) {
                            newSeq = dao.getNewSeq(info);
                            info.put("seq", newSeq);
                            info.put("point", pointEntity.point);
                            info.put("retnFl", pointEntity.retnFl);
                            resCnt = dao.insertMemPointInfo(info);
                            if (resCnt > 0) {
                                flag = true;
                                mesg = "\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                            }
                        } else {
                            flag = true;
                            mesg = "\ufffd\ufffd\u2c23\ufffd\ufffd\ufffd\ufffd \ufffd\u0339\ufffd \ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                        }
                    } else {
                        flag = false;
                        mesg = "\ufffd\ufffd\ufffd\u01f5\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                    }
                    if (flag && resCnt > 0) {
                        result.put("FLAG", flag);
                        result.put("MESG", mesg);
                        result.put("POINTSEQ", newSeq);
                        this.commit();
                    } else {
                        result.put("FLAG", flag);
                        result.put("MESG", mesg);
                        this.rollback();
                    }
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]ACCUMULATE_POINT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deductPoint(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        boolean flag = true;
        String mesg = "";
        boolean newSeq = false;
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                PointInfoEntity pointEntity = dao.selectSitePointInfo(info);
                this.startTransaction();
                if (CmUtil.nullTrim(pointEntity.catCd).equals("ITM")) {
                    if (CmUtil.nullTrim(pointEntity.subCd).equals("F")) {
                        flag = false;
                        mesg = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                    } else if (CmUtil.nullTrim(pointEntity.subCd).equals("E")) {
                        info.put("seq", info.getString("pointSeq"));
                        MemberPointEntity pEntity = dao.selectMemPointInfo(info);
                        if (pEntity != null) {
                            if (CmUtil.nullTrim(pEntity.cnclFl).equals("Y")) {
                                flag = false;
                                mesg = "\ufffd\u0339\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                            } else {
                                info.put("cnclFl", "Y");
                                resCnt = dao.updateMemPointInfo(info);
                                if (resCnt > 0) {
                                    flag = true;
                                    mesg = "\ufffd\ufffd\ufffd\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                                }
                            }
                        }
                    }
                } else if (CmUtil.nullTrim(pointEntity.catCd).equals("TRM")) {
                    info.put("__termCd", CmUtil.nullTrim(pointEntity.subCd));
                    info.put("__pointDate", info.getString("pointDate"));
                    MemberPointEntity pEntity = dao.selectMemPointInfo(info);
                    if (pEntity != null) {
                        if (pEntity.addCnt < 1) {
                            flag = false;
                            mesg = "\ufffd\u0339\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                        } else {
                            String[] arrAttr = new String[]{"siteCd", "cstmId", "seq", "pointCd"};
                            UFORequest temp = pEntity.toRequest(info.getRequest(), arrAttr);
                            temp.put("addCnt", -1);
                            if (pEntity.addCnt == 1) {
                                temp.put("cnclFl", "Y");
                            }
                            if ((resCnt = dao.updateMemPointInfo(temp)) > 0) {
                                flag = true;
                                mesg = "\ufffd\ufffd\ufffd\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd";
                            }
                        }
                    } else {
                        flag = false;
                        mesg = "\ufffd\ufffd\u2c23\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.";
                    }
                } else {
                    flag = false;
                    mesg = "\ufffd\ufffd\ufffd\u01f5\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                }
                if (flag && resCnt > 0) {
                    result.put("FLAG", flag);
                    result.put("MESG", mesg);
                    this.commit();
                } else {
                    result.put("FLAG", flag);
                    result.put("MESG", mesg);
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]DUDECT_POINT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult usePoint(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        boolean flag = true;
        String mesg = "";
        long newSeq = 0L;
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                PointInfoEntity pointEntity = dao.selectSitePointInfo(info);
                if (pointEntity == null || CmUtil.nullTrim(pointEntity.useFl).equals("N")) {
                    flag = false;
                    mesg = "\ufffd\ufffd\ufffd \ufffd\u04b0\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                } else {
                    if (CmUtil.nullTrim(pointEntity.catCd).equals("USE")) {
                        long total = Long.parseLong(dao.getMemTotalPoint(info));
                        if (total < (long)pointEntity.point) {
                            flag = false;
                            mesg = "\ufffd\ufffd\ufffd\ufffd\u01ae\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\u0574\u03f4\ufffd.";
                        } else {
                            newSeq = dao.getNewSeq(info);
                            info.put("seq", newSeq);
                            info.put("point", pointEntity.point);
                            info.put("retnFl", pointEntity.retnFl);
                            resCnt = dao.insertMemPointInfo(info);
                            if (resCnt > 0) {
                                flag = true;
                                mesg = "\ufffd\ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.";
                            }
                        }
                    } else {
                        flag = false;
                        mesg = "\ufffd\ufffd\ufffd\u01f5\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.";
                    }
                    if (flag && resCnt > 0) {
                        result.put("FLAG", flag);
                        result.put("MESG", mesg);
                        result.put("POINTSEQ", newSeq);
                        this.commit();
                    } else {
                        result.put("FLAG", flag);
                        result.put("MESG", mesg);
                        this.rollback();
                    }
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]USE_POINT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult checkMemInterest(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                Vector infoList = dao.searchMemInterestList(info);
                if (infoList != null && infoList.size() > 0) {
                    result.put("FLAG", "falge");
                    result.put("MESG", "\ufffd\u0339\ufffd \ufffd\ufffd\u03f5\ufffd \ufffd\u05f8\ufffd\ufffd\u0534\u03f4\ufffd.");
                    this.commit();
                } else {
                    result.put("FLAG", "true");
                    result.put("MESG", "");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CHECK_INTEREST_INFO", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchMemInterestList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        if (info.isExist("keygubn") && info.isExist("keyword")) {
            if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
            }
            if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
            }
            if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
            }
            if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
            }
        }
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                if (info.isPage()) {
                    result.put("LIST", dao.searchMemInterestListPaging(info));
                    result.put("TOTCNT", dao.getMemInterestListCnt(info));
                } else {
                    result.put("LIST", dao.searchMemInterestList(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_INTEREST_INFO_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectMemInterestInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                result.put("VIEW", dao.selectMemInterestInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_INTEREST_INFO_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertMemInterestInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                if (info.isArray("notes1") || info.isArray("notes2") || info.isArray("notes3") || info.isArray("notes4") || info.isArray("pointFl") || info.isArray("pointSeq")) {
                    String[] splitAttr = null;
                    if (info.isExist("splitAttr")) {
                        splitAttr = info.getArray("splitAttr");
                    } else {
                        Vector<String> vecAttr = new Vector<String>();
                        if (info.isArray("notes1")) {
                            vecAttr.add("notes1");
                        }
                        if (info.isArray("notes2")) {
                            vecAttr.add("notes2");
                        }
                        if (info.isArray("notes3")) {
                            vecAttr.add("notes3");
                        }
                        if (info.isArray("notes4")) {
                            vecAttr.add("notes4");
                        }
                        if (info.isArray("pointFl")) {
                            vecAttr.add("pointFl");
                        }
                        if (info.isArray("pointSeq")) {
                            vecAttr.add("pointSeq");
                        }
                        splitAttr = CmUtil.toStrArray(vecAttr);
                    }
                    String[] keepAttr = new String[]{"siteCd", "cstmId", "baseCd"};
                    UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                    if (arrInfo != null) {
                        int i = 0;
                        while (i < arrInfo.length) {
                            resCnt += dao.insertMemInterestInfo(arrInfo[i]);
                            ++i;
                        }
                    }
                } else {
                    resCnt = dao.insertMemInterestInfo(info);
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_INTEREST_INFO_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateMemInterestInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                resCnt = dao.updateMemInterestInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_INTEREST_INFO_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteMemInterestInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOMemberServiceDAO dao = new UFOMemberServiceDAO(this.getConnection(this), (MemberMgmtEntity)info.get("__ufo_mem_info"));
                this.startTransaction();
                if (info.isArray("seq")) {
                    String[] splitAttr = new String[]{"seq"};
                    String[] keepAttr = new String[]{"siteCd", "cstmId", "baseCd"};
                    UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                    if (arrInfo != null) {
                        int i = 0;
                        while (i < arrInfo.length) {
                            resCnt += dao.deleteMemInterestInfo(arrInfo[i]);
                            ++i;
                        }
                    }
                } else {
                    resCnt = dao.deleteMemInterestInfo(info);
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MEMBER_INTEREST_INFO_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

