/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.email;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.email.UFOEmailMgmtDAO;
import com.ufo.email.UFOEmailServiceWB;
import com.ufo.email.entity.MailTemplateEntity;
import java.sql.Connection;

public class UFOEmailMgmtWB
extends UFOBaseWB {
    public UFOEmailMgmtWB() {
    }

    public UFOEmailMgmtWB(String name) {
        super(name);
    }

    public UFOEmailMgmtWB(Connection con) {
        super(con);
    }

    public UFOResult searchEmailList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchEmailTemp(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_TEMPLATE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectEmailTemp(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                MailTemplateEntity entity = dao.selectEmailTemp(info);
                if (entity != null) {
                    entity.markList = dao.searchTempInfo(entity.toRequest());
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_TEMPLATE_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertEmailTemp(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                info.put("emailCd", dao.getNewCd());
                this.startTransaction();
                resCnt = dao.insertEmailTemp(info);
                String[] splitAttr = new String[]{"seq", "replaceKey", "replaceMark"};
                String[] keepAttr = new String[]{"emailCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        resCnt1 += dao.insertTempInfo(arrInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_TEMPLATE_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateEmailTemp(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateEmailTemp(info);
                String[] splitAttr = new String[]{"seq", "replaceKey", "replaceMark", "status"};
                String[] keepAttr = new String[]{"emailCd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (arrInfo[i].getString("status").equals("I")) {
                            resCnt1 += dao.insertTempInfo(arrInfo[i]);
                        } else if (arrInfo[i].getString("status").equals("D")) {
                            resCnt1 += dao.deleteTempInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_TEMPLATE_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteEmailTemp(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                this.startTransaction();
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("emailCd", info.getString("emailCd"));
                resCnt1 = dao.deleteTempInfo(temp);
                resCnt = dao.deleteEmailTemp(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_TEMPLATE_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchEmailHistory(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                if (info.isPage()) {
                    result.put("LIST", dao.searchEmailHistoryPaging(info));
                    result.put("TOTCNT", dao.getEmailHistoryCnt(info));
                } else {
                    result.put("LIST", dao.searchEmailHistory(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_HISTORY_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectEmailHistory(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectEmailHistory(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_HISTORY_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertEMailHistory(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.put("seq", dao.getMaxSeq());
                resCnt = dao.insertEmailHistory(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_HISTORY_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteEmailHistory(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOEmailMgmtDAO dao = new UFOEmailMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteEmailHistory(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_HISTORY_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult sendEMail(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOEmailServiceWB wb = new UFOEmailServiceWB();
                result = wb.sendEMail(info);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]EMAIL_SEND", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

