/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.counsel;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.counsel.UFOSiteUseInfoDAO;
import com.ufo.counsel.entity.SiteMailInfoEntity;
import com.ufo.counsel.entity.SiteMailRecvInfoEntity;
import com.ufo.counsel.entity.SiteUseInfoEntity;
import com.ufo.email.UFOEmailMgmtWB;
import com.ufo.email.UFOEmailServiceWB;
import java.util.Vector;

public class UFOSiteUseInfoWB
extends UFOBaseWB {
    public UFOSiteUseInfoWB() {
    }

    public UFOSiteUseInfoWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchSiteUseInfo(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.searchSiteUseInfoEx(info);
    }

    public UFOResult searchSiteUseInfoEx(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("regNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchSiteUseInfoPaging(info));
                    result.put("TOTCNT", dao.getSiteUseInfoCnt(info));
                } else {
                    result.put("LIST", dao.searchSiteUseInfo(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSiteUseInfoPaging(UFORequest info) throws UFOException {
        info.setPage(true);
        return this.searchSiteUseInfo(info);
    }

    public UFOResult selectSiteUseInfo(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.selectSiteUseInfoEx(info);
    }

    public UFOResult selectSiteUseInfoEx(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                result.put("VIEW", dao.selectSiteUseInfo(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertSiteUseInfo(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.insertSiteUseInfoEx(info);
    }

    public UFOResult insertSiteUseInfoEx(UFORequest info) throws UFOException {
        UFOSiteUseInfoDAO dao;
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertSiteUseInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        try {
            try {
                dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                SiteMailInfoEntity entity = dao.selectAdmMailInfo(info);
                Vector recvList = dao.searchRecvList(info);
                if (entity != null && CmUtil.nullTrim(entity.useFl).equals("Y")) {
                    String[] recvNm = null;
                    String[] recvEmail = null;
                    if (recvList != null) {
                        recvNm = new String[recvList.size()];
                        recvEmail = new String[recvList.size()];
                        int i = 0;
                        while (i < recvList.size()) {
                            SiteMailRecvInfoEntity rEntity = (SiteMailRecvInfoEntity)recvList.get(i);
                            recvNm[i] = rEntity.recvNm;
                            recvEmail[i] = rEntity.recvEmail;
                            ++i;
                        }
                    }
                    UFORequest mailReq = new UFORequest(info.getRequest());
                    Object mailRes = null;
                    mailReq.put("tempFl", "N");
                    mailReq.put("multiFl", "Y");
                    String[] splitAttr = new String[]{"recvNm", "recvEmail"};
                    mailReq.put("splitAttr", splitAttr);
                    mailReq.put("sendNm", entity.sendNm);
                    mailReq.put("sendEmail", entity.sendEmail);
                    mailReq.put("recvNm", recvNm);
                    mailReq.put("recvEmail", recvEmail);
                    mailReq.put("subject", CmUtil.replace(entity.title, "[##_TITLE_##]", info.getString("title")));
                    String contents = entity.contents;
                    contents = CmUtil.replace(contents, "[##_TITLE_##]", info.getString("title"));
                    contents = CmUtil.replace(contents, "[##_REGNM_##]", info.getString("regNm"));
                    contents = CmUtil.replace(contents, "[##_REGEMAIL_##]", info.getString("regEmail"));
                    contents = CmUtil.replace(contents, "[##_CONTENTS_##]", info.getString("contents"));
                    mailReq.put("contents", CmUtil.n2br(contents));
                    UFOEmailServiceWB mailWb = new UFOEmailServiceWB();
                    mailWb.sendEMailThread(mailReq);
                }
            }
            catch (Exception exception) {
                this.closeConnection();
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateSiteUseInfo(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.updateSiteUseInfoEx(info);
    }

    public UFOResult updateSiteUseInfoEx(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateSiteUseInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteSiteUseInfo(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.deleteSiteUseInfoEx(info);
    }

    public UFOResult deleteSiteUseInfoEx(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteSiteUseInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult replySiteUseInfo(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.replySiteUseInfoEx(info);
    }

    public UFOResult replySiteUseInfoEx(UFORequest info) throws UFOException {
        String emailReFl;
        int resCnt;
        UFOResult result;
        block16: {
            result = new UFOResult();
            resCnt = 0;
            emailReFl = "N";
            try {
                try {
                    if (info.isEquals("emailFl", "Y")) {
                        UFORequest emailReq = info.cloneReq("EMAIL");
                        UFOResult emailRes = null;
                        UFOEmailMgmtWB emailWb = new UFOEmailMgmtWB();
                        emailRes = emailWb.sendEMail(emailReq);
                        boolean emailFlag = emailRes.getBoolean("FLAG");
                        if (emailFlag) {
                            result.put("MAILFLAG", "true");
                            result.put("MAILMESG", emailRes.getString("MESG"));
                            emailReFl = "Y";
                        } else {
                            result.put("MAILFLAG", "false");
                            result.put("MAILMESG", emailRes.getString("MESG"));
                            emailReFl = "N";
                        }
                    } else {
                        result.put("MAILFLAG", "false");
                        result.put("MAILMESG", "Not Send.");
                    }
                }
                catch (Exception emailReq) {
                    this.closeConnection();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.closeConnection();
                throw throwable;
            }
            this.closeConnection();
        }
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("siteCd", info.getString("siteCd"));
                temp.put("cd", info.getString("cd"));
                temp.put("seq", info.getInt("seq"));
                temp.put("replyId", info.getString("replyId"));
                temp.put("reply", info.getString("reply"));
                temp.put("replyFl", "Y");
                temp.put("emailReFl", emailReFl);
                temp.put("reasonCd", info.getString("reasonCd"));
                temp.put("causeCd", info.getString("causeCd"));
                this.startTransaction();
                resCnt = dao.updateSiteUseInfo(temp);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "Fail");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_REPLY", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult sendReplyMail(UFORequest info) throws UFOException {
        UFOResult result;
        block8: {
            result = new UFOResult();
            boolean resCnt = false;
            try {
                try {
                    if (info.isEquals("emailFl", "Y")) {
                        UFORequest emailReq = info.cloneReq("EMAIL");
                        UFOResult emailRes = null;
                        UFOEmailMgmtWB emailWb = new UFOEmailMgmtWB(this.getConnection(this));
                        emailRes = emailWb.sendEMail(emailReq);
                        boolean emailFlag = emailRes.getBoolean("FLAG");
                        if (emailFlag) {
                            result.put("MAILFLAG", "true");
                            result.put("MAILMESG", emailRes.getString("MESG"));
                        } else {
                            result.put("MAILFLAG", "false");
                            result.put("MAILMESG", emailRes.getString("MESG"));
                        }
                        break block8;
                    }
                    result.put("MAILFLAG", "false");
                    result.put("MAILMESG", "Not Send.");
                }
                catch (Exception exception) {
                    this.closeConnection();
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return result;
    }

    public void sendAdminMail(UFORequest info) throws UFOException {
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                SiteMailInfoEntity entity = dao.selectAdmMailInfo(info);
                Vector recvList = dao.searchRecvList(info);
                if (entity != null && CmUtil.nullTrim(entity.useFl).equals("Y")) {
                    String[] recvNm = null;
                    String[] recvEmail = null;
                    if (recvList != null) {
                        recvNm = new String[recvList.size()];
                        recvEmail = new String[recvList.size()];
                        int i = 0;
                        while (i < recvList.size()) {
                            SiteMailRecvInfoEntity rEntity = (SiteMailRecvInfoEntity)recvList.get(i);
                            recvNm[i] = rEntity.recvNm;
                            recvEmail[i] = rEntity.recvEmail;
                            ++i;
                        }
                    }
                    UFORequest mailReq = new UFORequest(info.getRequest());
                    Object mailRes = null;
                    mailReq.put("tempFl", "N");
                    mailReq.put("multiFl", "Y");
                    String[] splitAttr = new String[]{"recvNm", "recvEmail"};
                    mailReq.put("splitAttr", splitAttr);
                    mailReq.put("sendNm", entity.sendNm);
                    mailReq.put("sendEmail", entity.sendEmail);
                    mailReq.put("recvNm", recvNm);
                    mailReq.put("recvEmail", recvEmail);
                    mailReq.put("subject", CmUtil.replace(entity.title, "[##_TITLE_##]", info.getString("title")));
                    String contents = entity.contents;
                    contents = CmUtil.replace(contents, "[##_TITLE_##]", info.getString("title"));
                    contents = CmUtil.replace(contents, "[##_REGNM_##]", info.getString("regNm"));
                    contents = CmUtil.replace(contents, "[##_REGEMAIL_##]", info.getString("regEmail"));
                    contents = CmUtil.replace(contents, "[##_CONTENTS_##]", info.getString("contents"));
                    mailReq.put("contents", CmUtil.n2br(contents));
                    UFOEmailServiceWB mailWb = new UFOEmailServiceWB();
                    mailWb.sendEMailThread(mailReq);
                }
            }
            catch (Exception exception) {
                this.closeConnection();
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public UFOResult recvConfirmReply(UFORequest info) throws UFOException {
        info.put("cd", "USE");
        return this.recvConfirmReplyEx(info);
    }

    public UFOResult recvConfirmReplyEx(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
            UFORequest temp = new UFORequest(info.getRequest());
            temp.put("siteCd", info.getString("siteCd"));
            temp.put("cd", info.getString("cd"));
            temp.put("seq", info.getInt("seq"));
            SiteUseInfoEntity entity = dao.selectSiteUseInfo(temp);
            if (entity == null) {
                result.put("FLAG", "false");
                result.put("MESG", "Not Found Date.");
                UFOResult uFOResult = result;
                return uFOResult;
            }
            if (CmUtil.nullTrim(entity.recvFl).equals("Y")) {
                result.put("FLAG", "true");
                result.put("MESG", " ");
                UFOResult uFOResult = result;
                return uFOResult;
            }
            try {
                temp.put("recvFl", "Y");
                this.startTransaction();
                resCnt = dao.updateSiteUseInfo(temp);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "Fail");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_RECV_CONFIRM", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchAdmMailList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                result.put("LIST", dao.searchAdmMailList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_ADMIN_ALERT_MAIL_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectAdmMailInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                result.put("VIEW", dao.selectAdmMailInfo(info));
                result.put("RECV", dao.searchRecvList(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_ADMIN_ALERT_MAIL_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAdmMailInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        int result2 = 0;
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.insertAdmMailInfo(info);
                String[] splitAttr = new String[]{"seq", "recvNm", "recvEmail", "status"};
                String[] keepAttr = new String[]{"siteCd", "cd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            result2 += dao.insertRecvInfo(arrInfo[i]);
                        } else if (!CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            result2 += dao.deleteRecvInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_ADMIN_ALERT_MAIL_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateAdmMailInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        int result2 = 0;
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.updateAdmMailInfo(info);
                String[] splitAttr = new String[]{"seq", "recvNm", "recvEmail", "status"};
                String[] keepAttr = new String[]{"siteCd", "cd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                            result2 += dao.insertRecvInfo(arrInfo[i]);
                        } else if (!CmUtil.nullTrim(arrInfo[i].getString("status")).equals("U")) {
                            result2 += dao.deleteRecvInfo(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                System.out.println(String.valueOf(result1) + "::" + result2);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_ADMIN_ALERT_MAIL_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAdmMailInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        int result2 = 0;
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                this.startTransaction();
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("siteCd", info.getString("siteCd"));
                temp.put("cd", info.getString("cd"));
                result2 = dao.deleteRecvInfo(temp);
                result1 = dao.deleteAdmMailInfo(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITEUSEINFO_ALERT_MAIL_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSiteCenterInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOSiteUseInfoDAO dao = new UFOSiteUseInfoDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("regNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchSiteCenterInfoPaging(info));
                    result.put("TOTCNT", dao.getSiteCenterInfoCnt(info));
                } else {
                    result.put("LIST", dao.searchSiteCenterInfo(info));
                }
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITECENTERINFO_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

